/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.ExtJFrame;
import org.appwork.swing.action.BasicAction;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.locator.Locator;
import org.appwork.utils.swing.locator.RememberAbsoluteLocator;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.UpdaterIcon;
import org.jdownloader.update.gui.GuiCorePanelImpl;
import org.jdownloader.update.gui.UpdFrameSettings;
import org.jdownloader.update.locale.T;

public class UpdateGui
extends ExtJFrame
implements WindowListener {
    private UpdFrameSettings updFrameSettings = JsonConfig.create(UpdFrameSettings.class);
    private Locator locator;
    private GuiCorePanelImpl core;
    private JButton button;
    private BasicAction closeAction;
    private UpdateManager manager;
    private Timer timer;

    public UpdateGui(UpdateManager manager, BasicAction closeAction) {
        super(T.T.installframe_frametitle());
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.manager = manager;
        this.setMinimumSize(new Dimension(100, 60));
        this.locator = manager.getHandler().getGuiLocator();
        if (this.locator == null) {
            this.locator = this.createLocator();
        }
        manager.getLogger().info("Locator: " + this.locator);
        manager.getLogger().info(this.locator.getLocationOnScreen(this) + "");
        this.setLocation(this.locator.getLocationOnScreen(this));
        this.core = new GuiCorePanelImpl();
        this.layoutContents(this.core);
        this.closeAction = closeAction;
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(UpdaterIcon.updatericon.image(64));
        list.add(UpdaterIcon.updatericon.image(48));
        list.add(UpdaterIcon.updatericon.image(32));
        list.add(UpdaterIcon.updatericon.image(16));
        if (Application.getJavaVersion() >= 16000000L) {
            this.setIconImages(list);
        } else {
            this.setIconImage((Image)list.get(0));
        }
        if (closeAction != null) {
            this.setButtonAction(closeAction);
        }
        this.setResizable(false);
        this.pack();
    }

    public RememberAbsoluteLocator createLocator() {
        return new RememberAbsoluteLocator("UpdaterFrame");
    }

    private void layoutContents(GuiCorePanelImpl guiCorePanelImpl) {
        this.setLayout(new MigLayout("ins 5,wrap 1", "[500!]", "[grow,fill][]"));
        this.add((Component)guiCorePanelImpl, "growx,pushx");
        this.button = new JButton();
        this.add((Component)this.button, "alignx right,height 24!");
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.locator.onClose(this, arg0);
        if (!(this.locator instanceof RememberAbsoluteLocator)) {
            this.createLocator().onClose(this, arg0);
        }
        if (this.button.getAction() != null) {
            this.button.getAction().actionPerformed(null);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        if (b == this.isVisible()) {
            return;
        }
        if (b) {
            Locator l = this.manager.getHandler().getGuiLocator();
            if (l != null) {
                this.locator = l;
            }
            this.setLocation(this.locator.getLocationOnScreen(this));
            this.manager.getLogger().info("Locator: " + this.locator);
            this.manager.getLogger().info(this.locator.getLocationOnScreen(this) + "");
        }
        if (!b) {
            this.locator.onClose(this, null);
            if (!(this.locator instanceof RememberAbsoluteLocator)) {
                this.createLocator().onClose(this, null);
            }
        }
        super.setVisible(b);
    }

    public void setText(final String dialog_update_prepare) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                UpdateGui.this.core.setText(dialog_update_prepare);
            }
        };
    }

    public void setProgress(final double d) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (d < 0.0) {
            this.core.setProgress(-1.0);
        } else {
            this.timer = new Timer(50, new ActionListener(){
                private double steps = (d - UpdateGui.access$000(UpdateGui.this).getProgress()) / (double)this.count;
                private int count = 20;

                @Override
                public void actionPerformed(ActionEvent e) {
                    --this.count;
                    double newValue = UpdateGui.this.core.getProgress() + this.steps;
                    if (this.count <= 0) {
                        newValue = d;
                    }
                    UpdateGui.this.core.setProgress(newValue);
                    if (newValue == d) {
                        if (UpdateGui.this.timer != null) {
                            UpdateGui.this.timer.stop();
                        }
                        UpdateGui.this.timer = null;
                    }
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    public void setIcon(ImageIcon icon) {
        this.core.setIcon(icon);
    }

    public void setButtonAction(BasicAction basicAction) {
        this.button.setAction(basicAction);
    }

    public void setCancelText(final String cancelText) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (cancelText == null) {
                    UpdateGui.this.button.setVisible(false);
                } else {
                    UpdateGui.this.button.setVisible(true);
                    UpdateGui.this.button.setText(cancelText);
                }
            }
        };
    }
}

