/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.debug;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtSpinner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.update.JDUpdateClient;
import org.jdownloader.update.SelfUpdateClient;
import org.jdownloader.update.UpdateManager;

public class DebugDialog
extends AbstractDialog<Object> {
    private ExtSpinner reset;
    private ExtSpinner resetJDU;
    private ExtSpinner dest;
    private ExtSpinner destJDU;
    private UpdateManager updateManager;
    private JDUpdateClient client;
    private SelfUpdateClient selfUpdateClient;

    public DebugDialog(UpdateManager updateManager, JDUpdateClient client, SelfUpdateClient selfUpdateClient) {
        super(0, "JDownloader Update Debug Dialog", null, null, null);
        this.updateManager = updateManager;
        this.client = client;
        this.selfUpdateClient = selfUpdateClient;
    }

    @Override
    protected Object createReturnValue() {
        return null;
    }

    @Override
    public JComponent layoutDialogContent() {
        MigPanel ret = new MigPanel("ins 0,wrap 2", "[][grow,fill]", "[]");
        ret.add(new JLabel("Current JD Revision"));
        ret.add(new JLabel(this.client.readRevision() + "/" + this.client.readSuperRevision()));
        ret.add(new JLabel("Current JDU Revision"));
        ret.add(new JLabel(this.selfUpdateClient.readRevision() + "/" + this.selfUpdateClient.superReadRevision()));
        ret.add((Component)SwingUtils.toBold(new JLabel("Data Repo (JD)")), "spanx,gapbottom 10");
        this.reset = new ExtSpinner(new SpinnerNumberModel(this.client.readSuperRevision().getId(), -1, Integer.MAX_VALUE, 1));
        ret.add(new JLabel("Reset Revision to: "));
        ret.add(this.reset);
        this.dest = new ExtSpinner(new SpinnerNumberModel(this.client.getForcedDestRevision(), -1, Integer.MAX_VALUE, 1));
        ret.add(new JLabel("Dest Revision to: "));
        ret.add(this.dest);
        ret.add((Component)SwingUtils.toBold(new JLabel("Updater Repo (JDU)")), "spanx,gapbottom 10");
        this.resetJDU = new ExtSpinner(new SpinnerNumberModel(this.selfUpdateClient.superReadRevision().getId(), -1, Integer.MAX_VALUE, 1));
        ret.add(new JLabel("Reset Revision to: "));
        ret.add(this.resetJDU);
        this.destJDU = new ExtSpinner(new SpinnerNumberModel(this.selfUpdateClient.getForcedDestRevision(), -1, Integer.MAX_VALUE, 1));
        ret.add(new JLabel("Dest Revision to: "));
        ret.add(this.destJDU);
        return ret;
    }

    public int getJDUResetRevision() {
        return ((Number)this.resetJDU.getValue()).intValue();
    }

    public int getJDResetRevision() {
        return ((Number)this.reset.getValue()).intValue();
    }

    public int getJDUDestRevision() {
        return ((Number)this.destJDU.getValue()).intValue();
    }

    public int getJDDestRevision() {
        return ((Number)this.dest.getValue()).intValue();
    }
}

