/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.NoSuchPaddingException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.client.DisabledHIDProvider;
import org.appwork.updatesys.client.DownloadPackageInfo;
import org.appwork.updatesys.client.FailedActionException;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.ImplBuilder;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.RandomAnonymousUIDProvider;
import org.appwork.updatesys.client.Setup;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.UpdateClientSetupInterface;
import org.appwork.updatesys.client.extensions.ExtensionManager;
import org.appwork.updatesys.client.iid.HIDProviderInterface;
import org.appwork.updatesys.client.iid.UIDProviderInterface;
import org.appwork.updatesys.client.install.AbstractBackupFileWriter;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.tracker.Tracker;
import org.appwork.updatesys.transport.Pkg;
import org.appwork.updatesys.transport.exchange.DeduplicationMode;
import org.appwork.updatesys.transport.exchange.PackageInstallationHistory;
import org.appwork.updatesys.transport.exchange.Revision;
import org.appwork.updatesys.transport.exchange.SessionInitData;
import org.appwork.updatesys.transport.exchange.interfaces.PackageResponseInterface;
import org.appwork.updatesys.transport.exchange.track.DiscardReason;
import org.appwork.updatesys.transport.exchange.track.TrafficLog;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.NonInterruptibleRunnableSimple;
import org.appwork.utils.StringUtils;
import org.appwork.utils.awfc.AWFCInputStream;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.update.AWFUpdatePackage;
import org.jdownloader.update.Info;
import org.jdownloader.update.LaunchState;
import org.jdownloader.updatev2.InstallLog;

public class JDUpdateClient
extends UpdateClient {
    private boolean updaterCheckEnabled = false;
    private InstallLog installLog;
    protected final Tracker tracker;

    @Override
    protected void fixPathesToToUniqueSetupIDChange(UpdateClientSetupInterface setup) throws InterruptedException {
        super.fixPathesToToUniqueSetupIDChange(setup);
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            File repoConfig = this.getPathBuilder().getRepoStorageResource(this, "");
            String oldID = setup.getApplicationIdentifier();
            File oldRepoConfig = new File(repoConfig.getAbsolutePath().replaceAll(Pattern.quote(setup.getNamespace()), oldID).replace("\\repos\\", "\\versioninfo\\"));
            File revisionFile = this.getPathBuilder().getRevisionFile(this);
            File backupFile = this.getPathBuilder().getBackupFile(this);
            File failedCleanUps = this.getPathBuilder().getFailedCleanupsFile(this);
            File filelist = this.getPathBuilder().getFilelist(this);
            File serverOptions = this.getPathBuilder().getServerOptionsFilePath(this);
            File tmpFolder = this.getPathBuilder().getTmpFolder(this);
            File uid = this.getPathBuilder().getUIDFile(this);
            String string = this.getPathBuilder().getOptionalConfigPath(this);
        }
    }

    public InstallLog getInstallLog() {
        return this.installLog;
    }

    public void setUpdaterCheckEnabled(boolean updaterCheckEnabled) {
        this.updaterCheckEnabled = updaterCheckEnabled;
    }

    public JDUpdateClient(Setup setup, ImplBuilder builder) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, InterruptedException {
        super(setup, builder);
        this.reset();
        this.tracker = new Tracker(this){

            @Override
            public boolean isEnabled() {
                return DebugMode.TRUE_IN_IDE_ELSE_FALSE;
            }
        };
    }

    public static String[] getUpdateServers(UpdateClient client, String[] updateServers) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        try {
            long minimumJVMVersion = JVMVersion.parseJavaVersionString("1.8_31");
            if (JVMVersion.isMinimum(minimumJVMVersion) || DebugMode.TRUE_IN_IDE_ELSE_FALSE || "true".equals(System.getProperty("force_update_https"))) {
                ret.add("https://update.jdownloader.org/jcgi/");
                ret.add("http://update.jdownloader.org/jcgi/");
            }
        }
        catch (Exception e) {
            client.getLogger().log(e);
        }
        try {
            String[] clientUpdateServers;
            if (updateServers != null && updateServers.length > 0) {
                ret.addAll(Arrays.asList(updateServers));
            }
            if ((clientUpdateServers = client.getSetup().getUpdateServers()) != null && clientUpdateServers.length > 0) {
                ret.addAll(Arrays.asList(clientUpdateServers));
            }
        }
        catch (Exception e) {
            client.getLogger().log(e);
        }
        if (ret.size() == 0) {
            ret.add("http://update.appwork.org/jcgi/");
        }
        return ret.toArray(new String[0]);
    }

    @Override
    protected String[] getUpdateServers() {
        return JDUpdateClient.getUpdateServers(this, super.getUpdateServers());
    }

    @Override
    protected void trackDownloadTraffic(TrafficLog item, TrafficLog.STATUS status, Throwable throwable) {
    }

    @Override
    protected void trackDiscardedPackage(PackageResponseInterface pkg, long fileSize, DiscardReason reason) {
    }

    @Override
    public void trackException(Throwable e) {
        this.getLogger().log(e);
        try {
            Tracker tracker = this.getTracker();
            if (tracker != null && tracker.isEnabled()) {
                tracker.pushItem(tracker.wrap(e));
            }
        }
        catch (Throwable e1) {
            this.getLogger().log(e1);
        }
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    @Override
    protected ExtensionManager createExtensionManager() throws IOException {
        return new JDExtensionManager(this);
    }

    @Override
    public JDExtensionManager getExtensionManager() {
        return (JDExtensionManager)super.getExtensionManager();
    }

    @Override
    protected DeduplicationMode getMaxSupportedDeduplicationMode() {
        return DeduplicationMode.INTRA;
    }

    @Override
    public AWFCInputStream openAWFCInputStream(File file, PackageResponseInterface pkg, boolean rawUncryptedAWFC) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InterruptedException {
        try {
            AWFCInputStream ret = super.openAWFCInputStream(file, pkg, rawUncryptedAWFC);
            try {
                ret.readAWFCHeader();
            }
            catch (IOException e) {
                ret.close();
                throw e;
            }
            return ret;
        }
        catch (IOException e) {
            this.logger.log(e);
            if (StringUtils.contains(e.getMessage(), "Wrong pubkey") && !rawUncryptedAWFC) {
                return super.openAWFCInputStream(file, pkg, true);
            }
            if (StringUtils.contains(e.getMessage(), "Unknown AWFC") && rawUncryptedAWFC) {
                return super.openAWFCInputStream(file, pkg, false);
            }
            throw e;
        }
    }

    @Override
    public void runPackageInstallation(File file, boolean awfFormat) throws InterruptedException, InstallException {
        Info info = null;
        try {
            File infoFile = new File(file.getAbsolutePath() + ".info");
            if (!infoFile.exists()) {
                throw new InstallException((UpdateClient)this, "InfoFile is missing: " + infoFile);
            }
            info = JSonStorage.restoreFromString(this.getFileSystem().readFileToString(infoFile), new TypeRef<Info>(){});
        }
        catch (ExtIOException e) {
            throw InstallException.wrap(this, e);
        }
        this.reset();
        super.runPackageInstallation(file, awfFormat);
        this.getExtensionManager().setInstalled(info.getInstallExtensions());
        this.getExtensionManager().setUninstalled(info.getUninstallExtensions());
    }

    public void reset() {
        this.installLog = new InstallLog();
    }

    @Override
    protected Revision internalWriteRevision() throws ExtIOException {
        Revision rev = this.getDestRevision();
        File dummyFile = Application.getTempResource("update/id=" + this.getSetup().getApplicationIdentifier() + "_jm=false_dr=" + rev.getId() + "_sr=" + this.readRevision().getId() + "_ct=" + System.currentTimeMillis() + ".awf");
        if (!dummyFile.exists()) {
            try {
                if (!dummyFile.createNewFile()) {
                    throw new ExtIOException("Could not create File", ExtIOException.IOExceptionType.LOCAL, dummyFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
            }
        }
        return rev;
    }

    @Override
    protected boolean isLocalPackageSupportEnabled() {
        return false;
    }

    @Override
    protected Pkg createPkgRequest() throws ExtIOException {
        return new Pkg(this){
            private final HashMap<String, Integer> installExtensionsInAWF;
            private final HashMap<String, Integer> uninstallExtensionsInAWF;
            {
                this.installExtensionsInAWF = new HashMap();
                this.uninstallExtensionsInAWF = new HashMap();
                List<AWFUpdatePackage> readyToInstall = JDUpdateClient.this.getAWFFilesToInstall();
                if (readyToInstall != null) {
                    for (AWFUpdatePackage pkg : readyToInstall) {
                        Integer old;
                        try {
                            for (String id : pkg.getInfo().getInstallExtensions()) {
                                old = this.installExtensionsInAWF.get(id);
                                if (old != null && old >= pkg.getInfo().getDestRevision()) continue;
                                this.installExtensionsInAWF.put(id, pkg.getInfo().getDestRevision());
                            }
                        }
                        catch (Exception e) {
                            JDUpdateClient.this.getLogger().log(e);
                        }
                        try {
                            for (String id : pkg.getInfo().getUninstallExtensions()) {
                                old = this.uninstallExtensionsInAWF.get(id);
                                if (old != null && old >= pkg.getInfo().getDestRevision()) continue;
                                this.uninstallExtensionsInAWF.put(id, pkg.getInfo().getDestRevision());
                            }
                        }
                        catch (Exception e) {
                            JDUpdateClient.this.getLogger().log(e);
                        }
                    }
                }
            }

            @Override
            public List<String> getEidList() {
                Integer installRev;
                Integer uninstallRev;
                ArrayList<String> ret = new ArrayList<String>();
                for (String s : JDUpdateClient.this.getExtensionManager().getInstalled()) {
                    if (JDUpdateClient.this.getExtensionManager().getRequestedUninstalls().contains(s)) continue;
                    uninstallRev = this.uninstallExtensionsInAWF.get(s);
                    installRev = this.installExtensionsInAWF.get(s);
                    if (uninstallRev != null && (installRev == null || uninstallRev > installRev)) continue;
                    ret.add(s);
                }
                for (String s : JDUpdateClient.this.getExtensionManager().getRequestedInstalls()) {
                    if (JDUpdateClient.this.getExtensionManager().getRequestedUninstalls().contains(s)) continue;
                    uninstallRev = this.uninstallExtensionsInAWF.get(s);
                    installRev = this.installExtensionsInAWF.get(s);
                    if (uninstallRev != null && (installRev == null || uninstallRev > installRev)) continue;
                    ret.add(s);
                }
                return ret;
            }

            @Override
            protected DownloadPackageInfo getDownloadPackageInfo() {
                return null;
            }

            @Override
            public String getResumeUrlParameter() {
                return null;
            }

            @Override
            public List<String> getEipList() {
                ArrayList<String> ret = new ArrayList<String>();
                for (String s : super.getEipList()) {
                    Integer uninstallRev = this.uninstallExtensionsInAWF.get(s);
                    Integer installRev = this.installExtensionsInAWF.get(s);
                    if (installRev != null && (uninstallRev == null || uninstallRev <= installRev)) continue;
                    ret.add(s);
                }
                return ret;
            }

            @Override
            public List<String> getEirList() {
                ArrayList<String> ret = new ArrayList<String>();
                for (String s : super.getEirList()) {
                    Integer uninstallRev = this.uninstallExtensionsInAWF.get(s);
                    Integer installRev = this.installExtensionsInAWF.get(s);
                    if (uninstallRev != null && (installRev == null || installRev <= uninstallRev)) continue;
                    ret.add(s);
                }
                ret.removeAll(this.getEipList());
                return ret;
            }
        };
    }

    public List<AWFUpdatePackage> getAWFFilesToInstall() {
        AWFUpdatePackage pkg;
        File[] awfs = Application.getTempResource("update").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".awf") && new File(dir, name).isFile() && new File(dir, name + ".info").exists();
            }
        });
        final FileAccessHandler fileSystem = this.getFileSystem();
        ArrayList<AWFUpdatePackage> list = new ArrayList<AWFUpdatePackage>();
        if (awfs != null) {
            for (final File awf : awfs) {
                final File infoFile = new File(awf.getAbsolutePath() + ".info");
                try {
                    Info info = JSonStorage.restoreFromString(fileSystem.secureReadFileToString(infoFile), new TypeRef<Info>(){});
                    if (info.getSourceRevision() < -1 || info.getDestRevision() < -1 || info.getTimestamp() < 0L) {
                        throw new Exception("Invalid Naming: " + awf.getName());
                    }
                    if (!info.getFile().equals(awf.getName())) {
                        throw new Exception("Invalid Naming: " + awf.getName());
                    }
                    AWFUpdatePackage awfp = new AWFUpdatePackage(awf, info);
                    list.add(awfp);
                }
                catch (Exception e) {
                    this.getLogger().log(e);
                    new NonInterruptibleRunnableSimple(){

                        @Override
                        protected void execute() throws InterruptedException {
                            try {
                                fileSystem.deleteFileIfExists(infoFile);
                            }
                            catch (ExtIOException extIOException) {
                                // empty catch block
                            }
                            try {
                                fileSystem.deleteFileIfExists(awf);
                            }
                            catch (ExtIOException extIOException) {
                                // empty catch block
                            }
                        }
                    }.startAndWait();
                }
            }
        }
        Collections.sort(list, new Comparator<AWFUpdatePackage>(){

            @Override
            public int compare(AWFUpdatePackage o1, AWFUpdatePackage o2) {
                return CompareUtils.compare(o1.getInfo().getTimestamp(), o2.getInfo().getTimestamp());
            }
        });
        ArrayList<AWFUpdatePackage> ret = new ArrayList<AWFUpdatePackage>();
        int rev = -1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && ((pkg = (AWFUpdatePackage)iterator.next()).getsRev() <= rev || rev < 0)) {
            rev = pkg.getdRev();
            ret.add(pkg);
        }
        return ret;
    }

    @Override
    protected SessionInitData createSessionInitData() {
        return null;
    }

    public Revision readSuperRevision() {
        return super.readRevision();
    }

    @Override
    public Revision readRevision() {
        Revision revision = this.readSuperRevision();
        List<AWFUpdatePackage> lst = this.getAWFFilesToInstall();
        if (lst == null || lst.size() == 0) {
            return revision;
        }
        if (lst.get(0).getsRev() > revision.getId()) {
            return revision;
        }
        return new Revision(Math.max(lst.get(lst.size() - 1).getdRev(), revision.getId()));
    }

    @Override
    protected ArrayList<InstallerAction> installFile(AbstractBackupFileWriter backuplist, InputStream input, String relPath, String signature) throws FailedActionException, InterruptedException {
        if (this.installLog != null) {
            this.installLog.add(relPath);
        }
        return super.installFile(backuplist, input, relPath, signature);
    }

    @Override
    protected void removeFile(AbstractBackupFileWriter backuplist, InputStream input, String relPath) throws FailedActionException {
        if (this.installLog != null) {
            this.installLog.add(relPath);
        }
        super.removeFile(backuplist, input, relPath);
    }

    @Override
    protected void installJarDif(String relPath, String filename) {
        if (this.installLog != null) {
            this.installLog.add("JD: " + relPath + "/" + filename);
        }
    }

    @Override
    protected void installFolder(AbstractBackupFileWriter backuplist, String relPath, String signature, boolean validateSignature) throws FailedActionException {
        super.installFolder(backuplist, relPath, signature, validateSignature);
    }

    @Override
    protected void installJar(AbstractBackupFileWriter backuplist, InputStream input, String relPath, String signature, String jarSignature) throws FailedActionException, InterruptedException {
        if (this.installLog != null) {
            this.installLog.add(relPath);
        }
        super.installJar(backuplist, input, relPath, signature, jarSignature);
    }

    public void setLaunchState(LaunchState state) {
    }

    public boolean isUpdaterCheckEnabled() {
        return this.updaterCheckEnabled;
    }

    @Override
    protected void addPackageInstallationHistory(File file, PackageInstallationHistory marker) {
    }

    @Override
    protected UIDProviderInterface initUIDProvider() throws ExtIOException {
        return new RandomAnonymousUIDProvider(this);
    }

    @Override
    public HIDProviderInterface getHIDProvider() {
        if (this.hidProvider == null) {
            this.hidProvider = new DisabledHIDProvider(this);
        }
        return this.hidProvider;
    }

    public void writeSuperRevision(int getdRev) throws ExtIOException {
        File dest = this.getRevisionFile();
        FileAccessHandler fileSystem = this.getFileSystem();
        fileSystem.secureWrite(dest, String.valueOf(getdRev).getBytes(UpdateClient.UTF8), true);
    }

    public static final class JDExtensionManager
    extends ExtensionManager {
        public JDExtensionManager(UpdateClient updateClient) throws IOException {
            super(updateClient);
        }

        @Override
        public void init() throws IOException {
            super.init();
            if (Application.getResource("extensions/JDChat.jar").isFile()) {
                this.markInstalled("chat");
            } else {
                this.markUninstalled("chat");
            }
            if (Application.getResource("extensions/translator.jar").isFile()) {
                this.markInstalled("translator");
            } else {
                this.markUninstalled("translator");
            }
            if (Application.getResource("extensions/FolderWatch.jar").isFile()) {
                this.markInstalled("folderwatch");
            } else {
                this.markUninstalled("folderwatch");
            }
            if (Application.getResource("extensions/EventScripter.jar").isFile()) {
                this.markInstalled("eventscripter");
            } else {
                this.markUninstalled("eventscripter");
            }
            if (Application.getResource("extensions/Scheduler.jar").isFile()) {
                this.markInstalled("scheduler");
            } else {
                this.markUninstalled("scheduler");
            }
            if (Application.getResource("extensions/JDShutdown.jar").isFile()) {
                this.markInstalled("shutdown");
            } else {
                this.markUninstalled("shutdown");
            }
            if (CrossSystem.isWindows() || CrossSystem.isMac()) {
                if (Application.getResource("extensions/AntiShutdown.jar").isFile()) {
                    this.markInstalled("antishutdown");
                } else {
                    this.markUninstalled("antishutdown");
                }
            }
            if (Application.getResource("extensions/infobar.jar").isFile()) {
                this.markInstalled("infobar");
            } else {
                this.markUninstalled("infobar");
            }
            this.logger.info("Installed Extensions: " + this.getInstalled());
        }

        @Override
        public void setRequestsDone() {
        }

        public synchronized void setInstalled(ArrayList<String> installExtensions) {
            if (installExtensions != null) {
                for (String extension : installExtensions) {
                    this.markInstalled(extension);
                }
            }
        }

        public synchronized void setUninstalled(ArrayList<String> uninstallExtensions) {
            if (uninstallExtensions != null) {
                for (String extension : uninstallExtensions) {
                    this.markUninstalled(extension);
                }
            }
        }

        public synchronized void requestFullExtensionUpdate(String ... ids) {
            if (ids != null) {
                for (String id : ids) {
                    this.requestFreshInstall(id);
                }
            }
        }
    }
}

