/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Files;
import org.appwork.utils.zip.ZipIOException;
import org.appwork.utils.zip.ZipIOFile;

public class ZipIOReader {
    private File zipFile = null;
    private ZipFile zip = null;
    private ZipIOFile rootFS = null;
    private boolean autoCreateExtractPath = true;
    private boolean overwrite = false;
    private boolean autoCreateSubDirs = true;
    private byte[] byteArray = null;
    private int zipEntriesSize = -1;
    private ZipEntry[] zipEntries = null;
    private boolean breakOnError = true;

    public ZipIOReader(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public ZipIOReader(File zipFile) throws ZipIOException, ZipException, IOException {
        this.zipFile = zipFile;
        this.openZip();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.zip != null) {
                this.zip.close();
            }
        }
        finally {
            this.byteArray = null;
            this.zip = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<File> extract(ZipEntry entry, File output) throws ZipIOException, IOException {
        ArrayList<File> ret = new ArrayList<File>();
        if (output.exists() && output.isDirectory()) {
            if (this.isOverwrite()) {
                Files.deleteRecursiv(output);
                if (output.exists()) {
                    if (this.isBreakOnError()) {
                        throw new IOException("Cannot extract File to Directory " + output);
                    }
                    LogV3.severe("Cannot extract File to Directory " + output);
                }
            }
            if (output.exists() && output.isDirectory()) {
                LogV3.finer("Skipped extraction: directory exists: " + output);
                return ret;
            }
        }
        if (output.exists()) {
            if (this.isOverwrite()) {
                output.delete();
                if (output.exists()) {
                    if (this.isBreakOnError()) {
                        throw new IOException("Cannot overwrite File " + output);
                    }
                    LogV3.severe("Cannot overwrite File " + output);
                }
            }
            if (output.exists()) {
                LogV3.finer("Skipped extraction: file exists: " + output);
                return ret;
            }
        }
        if (!output.getParentFile().exists()) {
            if (this.isAutoCreateSubDirs()) {
                output.getParentFile().mkdirs();
                ret.add(output.getParentFile());
                if (!output.getParentFile().exists()) {
                    if (this.isBreakOnError()) {
                        throw new IOException("Cannot create folder for File " + output);
                    }
                    LogV3.severe("Cannot create folder for File " + output);
                }
            }
            if (!output.getParentFile().exists()) {
                LogV3.finer("Skipped extraction: cannot create dir: " + output);
                return ret;
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(output);
            this.extract(entry, os);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        ret.add(output);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(ZipEntry entry, OutputStream stream) throws ZipIOException, IOException {
        if (entry.isDirectory()) {
            if (this.isBreakOnError()) {
                throw new ZipIOException("Cannot extract a directory", entry);
            }
            LogV3.severe("Cannot extract a directory " + entry.getName());
        }
        FilterInputStream in = null;
        try {
            InputStream is = this.getInputStream(entry);
            in = new CheckedInputStream(is, new CRC32());
            byte[] buffer = new byte[Short.MAX_VALUE];
            int len = 0;
            long total = 0L;
            while ((len = in.read(buffer)) != -1) {
                stream.write(buffer, 0, len);
                this.notify(entry, len, total += (long)len);
            }
            if (entry.getCrc() != -1L && entry.getCrc() != ((CheckedInputStream)in).getChecksum().getValue()) {
                if (this.isBreakOnError()) {
                    throw new ZipIOException("CRC32 Failed", entry);
                }
                LogV3.severe("CRC32 Failed " + entry);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
            try {
                stream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    protected void notify(ZipEntry entry, long bytesWrite, long bytesProcessed) {
    }

    public synchronized List<File> extractTo(File outputDirectory) throws ZipIOException, IOException {
        if (outputDirectory.exists() && outputDirectory.isFile()) {
            if (this.isBreakOnError()) {
                throw new IOException("cannot extract to a file " + outputDirectory);
            }
            LogV3.severe("cannot extract to a file " + outputDirectory);
        }
        if (!(outputDirectory.exists() || this.autoCreateExtractPath && outputDirectory.mkdirs())) {
            if (this.isBreakOnError()) {
                throw new IOException("could not create outputDirectory " + outputDirectory);
            }
            LogV3.severe("could not create outputDirectory " + outputDirectory);
        }
        ArrayList<File> ret = new ArrayList<File>();
        for (ZipEntry entry : this.getZipFiles()) {
            File out = new File(outputDirectory, entry.getName());
            if (entry.isDirectory()) {
                if (out.exists()) continue;
                if (this.isAutoCreateSubDirs()) {
                    if (!out.mkdir()) {
                        if (this.isBreakOnError()) {
                            throw new IOException("could not create outputDirectory " + out);
                        }
                        LogV3.severe("could not create outputDirectory " + out);
                    }
                    ret.add(out);
                    continue;
                }
                LogV3.finer("SKipped creatzion of: " + out);
                continue;
            }
            ret.addAll(this.extract(entry, out));
        }
        return ret;
    }

    private ZipIOFile getFolder(String path, ZipIOFile currentRoot) {
        if (path == null || currentRoot == null || !currentRoot.isDirectory()) {
            return null;
        }
        if (currentRoot.getAbsolutePath().equalsIgnoreCase(path)) {
            return currentRoot;
        }
        for (ZipIOFile tmp : currentRoot.getFiles()) {
            ZipIOFile ret;
            if (tmp.isDirectory() && tmp.getAbsolutePath().equalsIgnoreCase(path)) {
                return tmp;
            }
            if (!tmp.isDirectory() || (ret = this.getFolder(path, tmp)) == null) continue;
            return ret;
        }
        return null;
    }

    public synchronized InputStream getInputStream(ZipEntry entry) throws ZipIOException, IOException {
        if (entry == null) {
            throw new ZipIOException("invalid zipEntry");
        }
        if (this.zip != null) {
            return this.zip.getInputStream(entry);
        }
        ZipInputStream zis = null;
        boolean close = true;
        try {
            zis = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
            ZipEntry ze = null;
            while (true) {
                if ((ze = zis.getNextEntry()) != null) {
                    String name = ze.getName();
                    if (!name.equals(entry.getName())) continue;
                    final ZipInputStream zis2 = zis;
                    close = false;
                    InputStream inputStream = new InputStream(){

                        @Override
                        public int available() throws IOException {
                            return zis2.available();
                        }

                        @Override
                        public void close() throws IOException {
                            zis2.close();
                        }

                        @Override
                        public synchronized void mark(int readlimit) {
                            zis2.mark(readlimit);
                        }

                        @Override
                        public boolean markSupported() {
                            return zis2.markSupported();
                        }

                        @Override
                        public int read() throws IOException {
                            return zis2.read();
                        }

                        @Override
                        public int read(byte[] b) throws IOException {
                            return zis2.read(b);
                        }

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            return zis2.read(b, off, len);
                        }

                        @Override
                        public synchronized void reset() throws IOException {
                            zis2.reset();
                        }

                        @Override
                        public long skip(long n) throws IOException {
                            return zis2.skip(n);
                        }
                    };
                    return inputStream;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new ZipIOException(e.getMessage(), e);
        }
        finally {
            try {
                if (close) {
                    zis.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public synchronized ZipEntry getZipFile(String fileName) throws ZipIOException {
        if (fileName == null) {
            throw new ZipIOException("invalid fileName");
        }
        if (this.zip != null) {
            return this.zip.getEntry(fileName);
        }
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals(fileName)) continue;
                ZipEntry zipEntry = ze;
                return zipEntry;
            }
            ZipEntry zipEntry = null;
            return zipEntry;
        }
        catch (IOException e) {
            throw new ZipIOException(e.getMessage(), e);
        }
        finally {
            try {
                zis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized ZipEntry[] getZipFiles() throws ZipIOException {
        if (this.zipEntries != null) {
            return this.zipEntries;
        }
        ArrayList<ZipEntry> ret = new ArrayList<ZipEntry>();
        if (this.zip != null) {
            Enumeration<? extends ZipEntry> zipIter = this.zip.entries();
            while (zipIter.hasMoreElements()) {
                ret.add(zipIter.nextElement());
            }
        } else {
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    ret.add(ze);
                }
            }
            catch (IOException e) {
                throw new ZipIOException(e.getMessage(), e);
            }
            finally {
                try {
                    zis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.zipEntries = ret.toArray(new ZipEntry[ret.size()]);
        return this.zipEntries;
    }

    public synchronized ZipIOFile getZipIOFileSystem() throws ZipIOException {
        if (this.rootFS != null) {
            return this.rootFS;
        }
        ZipEntry[] content = this.getZipFiles();
        ArrayList<ZipIOFile> root = new ArrayList<ZipIOFile>();
        for (ZipEntry file : content) {
            if (!file.isDirectory() && !file.getName().contains("/")) {
                ZipIOFile tmp = new ZipIOFile(file.getName(), file, this, null);
                root.add(tmp);
                continue;
            }
            if (file.isDirectory()) continue;
            String[] parts = file.getName().split("/");
            ZipIOFile currentParent = null;
            String path = "";
            for (int i = 0; i < parts.length; ++i) {
                ZipIOFile tmp;
                if (i == parts.length - 1) {
                    ZipIOFile tmp2 = new ZipIOFile(parts[i], file, this, currentParent);
                    currentParent.getFilesInternal().add(tmp2);
                    continue;
                }
                path = path + parts[i] + "/";
                ZipIOFile found = null;
                Iterator iterator = root.iterator();
                while (iterator.hasNext() && (found = this.getFolder(path, tmp = (ZipIOFile)iterator.next())) == null) {
                }
                if (found != null) {
                    currentParent = found;
                    continue;
                }
                ZipIOFile newFolder = new ZipIOFile(parts[i], null, this, currentParent);
                if (currentParent != null) {
                    currentParent.getFilesInternal().add(newFolder);
                } else {
                    root.add(newFolder);
                }
                currentParent = newFolder;
            }
        }
        this.rootFS = new ZipIOFile("", null, this, null);
        this.rootFS.getFilesInternal().addAll(root);
        this.rootFS.getFilesInternal().trimToSize();
        this.trimZipIOFiles(this.rootFS);
        return this.rootFS;
    }

    public boolean isAutoCreateExtractPath() {
        return this.autoCreateExtractPath;
    }

    protected boolean isAutoCreateSubDirs() {
        return this.autoCreateSubDirs;
    }

    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    protected boolean isOverwrite() {
        return this.overwrite;
    }

    private synchronized void openZip() throws ZipIOException, ZipException, IOException {
        if (this.zip != null) {
            return;
        }
        if (this.zipFile == null || this.zipFile.isDirectory() || !this.zipFile.exists()) {
            throw new ZipIOException("invalid zipFile");
        }
        this.zip = new ZipFile(this.zipFile);
    }

    public void setAutoCreateExtractPath(boolean autoCreateExtractPath) {
        this.autoCreateExtractPath = autoCreateExtractPath;
    }

    public void setAutoCreateSubDirs(boolean autoCreateSubDirs) {
        this.autoCreateSubDirs = autoCreateSubDirs;
    }

    public void setBreakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public synchronized int size() throws ZipIOException {
        if (this.zipEntriesSize != -1) {
            return this.zipEntriesSize;
        }
        if (this.zip != null) {
            this.zipEntriesSize = this.zip.size();
        } else {
            ZipInputStream zis = null;
            try {
                this.zipEntriesSize = 0;
                zis = new ZipInputStream(new ByteArrayInputStream(this.byteArray));
                while (zis.getNextEntry() != null) {
                    ++this.zipEntriesSize;
                }
            }
            catch (IOException e) {
                throw new ZipIOException(e.getMessage(), e);
            }
            finally {
                try {
                    zis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return this.zipEntriesSize;
    }

    private void trimZipIOFiles(ZipIOFile root) {
        if (root == null) {
            return;
        }
        for (ZipIOFile tmp : root.getFiles()) {
            if (!tmp.isDirectory()) continue;
            this.trimZipIOFiles(tmp);
        }
        root.getFilesInternal().trimToSize();
    }
}

