/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.locator;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.locator.AbstractLocator;

public class CenterOfScreenLocator
extends AbstractLocator {
    public CenterOfScreenLocator() {
        super(null);
    }

    @Override
    public Point getLocationOnScreen(Window dialog) {
        PointerInfo mouse = MouseInfo.getPointerInfo();
        if (dialog.getParent() == null || !dialog.getParent().isDisplayable() || !dialog.getParent().isVisible()) {
            Rectangle windowBounds = dialog.getBounds();
            return this.getCenterLocationByWindowBounds(windowBounds);
        }
        if (dialog.getParent() instanceof Frame && ((Frame)dialog.getParent()).getExtendedState() == 1 && mouse != null) {
            GraphicsDevice[] screens;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice screen : screens = ge.getScreenDevices()) {
                Rectangle bounds = screen.getDefaultConfiguration().getBounds();
                screen.getDefaultConfiguration().getDevice();
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(screen.getDefaultConfiguration());
                if (!bounds.contains(mouse.getLocation())) continue;
                return CenterOfScreenLocator.correct(new Point((int)((double)bounds.x + bounds.getWidth() - (double)dialog.getWidth() - 20.0 - (double)insets.right), (int)((double)bounds.y + bounds.getHeight() - (double)dialog.getHeight() - 20.0 - (double)insets.bottom)), dialog);
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            return CenterOfScreenLocator.correct(new Point((int)(screenSize.getWidth() - (double)dialog.getWidth() - 20.0), (int)(screenSize.getHeight() - (double)dialog.getHeight() - 60.0)), dialog);
        }
        Point ret = SwingUtils.getCenter(dialog.getParent(), dialog);
        return CenterOfScreenLocator.correct(ret, dialog);
    }

    public Point getCenterLocationByWindowBounds(Rectangle windowBounds) {
        GraphicsDevice screen = SwingUtils.getScreenByBounds(windowBounds);
        if (screen != null) {
            Rectangle bounds = SwingUtils.getUsableScreenBounds(screen);
            return CenterOfScreenLocator.correct(new Point((int)(bounds.getWidth() - windowBounds.getWidth()) / 2 + bounds.x, (int)(bounds.getHeight() - windowBounds.getHeight()) / 2 + bounds.y), new Dimension(windowBounds.width, windowBounds.height));
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return CenterOfScreenLocator.correct(new Point((int)(screenSize.getWidth() - windowBounds.getWidth()) / 2, (int)(screenSize.getHeight() - windowBounds.getHeight()) / 2), new Dimension(windowBounds.width, windowBounds.height));
    }

    @Override
    public void onClose(Window window, ComponentEvent event) {
    }
}

