/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.locationstore;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import org.appwork.loggingv3.LogV3;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.StorageException;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.locationstore.LocationStorage;
import org.appwork.utils.swing.locationstore.LocationStorageContainer;

public class LocationStorageManager
extends ShutdownEvent {
    protected LocationStorageContainer data;
    protected boolean write = false;
    protected final DelayedRunnable saver;
    protected final Object fileLock = new Object();
    protected volatile Dimension difference = null;
    public static final LocationStorageManager INSTANCE = new LocationStorageManager();

    private LocationStorageManager() {
        this.saver = System.getProperty("LocationStorageManager.safe-delayer") != null ? new DelayedRunnable(5000L, 30000L){

            @Override
            public void delayedrun() {
                LocationStorageManager.this.save(false);
            }
        } : null;
        ShutdownController.getInstance().addShutdownEvent(this);
    }

    protected File getStorageFile() {
        return Application.getResource("cfg/locations.json");
    }

    public LocationStorage get(Window window, String storageID) {
        this.ensureStorage();
        LocationStorage ret = this.data.getData().get(storageID);
        if (ret == null) {
            ret = new LocationStorage();
            this.data.getData().put(storageID, ret);
        }
        ret.setLastAccess(System.currentTimeMillis());
        this.onUpdate(ret);
        return ret;
    }

    public boolean reset(String storageID) {
        boolean reset;
        this.ensureStorage();
        if (this.data.getData().size() > 0) {
            if (storageID == null) {
                this.data.getData().clear();
                reset = true;
            } else {
                reset = this.data.getData().remove(storageID) != null;
            }
        } else {
            reset = false;
        }
        if (reset) {
            this.onUpdate(null);
        }
        return reset;
    }

    public boolean reset() {
        return this.reset(null);
    }

    private void ensureStorage() {
        if (this.data == null) {
            File file = this.getStorageFile();
            if (file.isFile()) {
                try {
                    this.data = JSonStorage.restoreFromString(IO.readFileToString(file), LocationStorageContainer.TYPE);
                }
                catch (Throwable e) {
                    LogV3.log(e);
                }
            }
            if (this.data == null) {
                this.data = new LocationStorageContainer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(boolean onShutDown) {
        block6: {
            try {
                if (!this.write) {
                    return;
                }
                byte[] json = (byte[])new EDTHelper<byte[]>(){

                    @Override
                    public byte[] edtRun() {
                        try {
                            return JSonStorage.serializeToJsonByteArray(LocationStorageManager.this.data);
                        }
                        catch (StorageException e) {
                            LogV3.log(e);
                            return null;
                        }
                    }
                }.getReturnValue();
                if (json == null) break block6;
                Object object = this.fileLock;
                synchronized (object) {
                    IO.secureWrite(this.getStorageFile(), json, onShutDown ? IO.SYNC.META_AND_DATA : IO.SYNC.NONE);
                }
                this.write = false;
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
    }

    public void onUpdate(final Window window, final Point locationOnScreen, final Dimension windowSize, final LocationStorage cfg, final String type) {
        if (cfg != null) {
            new EDTRunner(false){

                @Override
                protected void runInEDT() {
                    boolean write = false;
                    if (locationOnScreen != null) {
                        write |= cfg.update(true, type, locationOnScreen.x, locationOnScreen.y);
                    } else if (windowSize != null) {
                        write |= cfg.update(true, type, windowSize.width, windowSize.height);
                    } else if (window != null) {
                        write |= cfg.update(true, type, window.getWidth(), window.getHeight());
                    }
                    if (write && LocationStorageManager.this.saver != null) {
                        LocationStorageManager.this.saver.resetAndStart();
                    }
                }
            };
        }
    }

    protected void onUpdate(LocationStorage cfg) {
        this.write = true;
        if (this.saver != null) {
            this.saver.resetAndStart();
        }
    }

    @Override
    public void onShutdown(ShutdownRequest shutdownRequest) {
        this.save(true);
    }
}

