/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import org.appwork.storage.JSonStorage;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.searchcombo.SearchComboBox;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.net.Base64OutputStream;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.IconComboBoxDialogInterface;

public class SearchComboBoxDialog<Type>
extends AbstractDialog<Type>
implements IconComboBoxDialogInterface {
    private final String message;
    private JTextPane textpane;
    private final Type defaultAnswer;
    private final Type[] options;
    private SearchComboBox<Type> box;

    @Override
    public boolean isRemoteAPIEnabled() {
        return true;
    }

    public SearchComboBoxDialog(int flag, String title, String question, Type[] options, Type defaultSelection, ImageIcon icon, String okText, String cancelText) {
        super(flag, title, icon, okText, cancelText);
        this.getLogger().fine("Dialog    [" + okText + "][" + cancelText + "]\r\nflag:  " + Integer.toBinaryString(flag) + "\r\ntitle: " + title + "\r\nmsg:   \r\n" + question + "\r\noptions:   \r\n" + Arrays.toString(options) + "\r\ndef:" + defaultSelection);
        this.message = question;
        this.defaultAnswer = defaultSelection;
        this.options = options;
    }

    @Override
    protected Type createReturnValue() {
        return this.getSelectedItem();
    }

    protected SearchComboBox<Type> getComboBox(Type[] options2) {
        ArrayList<Type> ret = new ArrayList<Type>();
        for (Type t : options2) {
            ret.add(t);
        }
        SearchComboBox box = new SearchComboBox<Type>(ret){

            @Override
            protected Icon getIconForValue(Type value) {
                if (value == null) {
                    return null;
                }
                return SearchComboBoxDialog.this.getIconByValue(value);
            }

            @Override
            public void onChanged() {
                super.onChanged();
                SearchComboBoxDialog.this.onChanged();
            }

            @Override
            protected String getTextForValue(Type value) {
                if (value == null) {
                    return "";
                }
                return SearchComboBoxDialog.this.getStringByValue(value);
            }
        };
        if (this.defaultAnswer != null) {
            box.setSelectedItem(this.defaultAnswer);
        }
        return box;
    }

    protected String getStringByValue(Type value) {
        return value + "";
    }

    protected void onChanged() {
    }

    protected Icon getIconByValue(Type value) {
        return null;
    }

    public Type getSelectedItem() {
        if ((this.getReturnmask() & 2) == 0) {
            return null;
        }
        return this.box == null ? this.defaultAnswer : this.box.getSelectedItem();
    }

    @Override
    public JComponent layoutDialogContent() {
        MigPanel contentpane = new MigPanel("ins 0,wrap 1", "[fill,grow]", "[][]");
        this.textpane = new JTextPane();
        this.textpane.setBorder(null);
        this.textpane.setBackground(null);
        this.textpane.setOpaque(false);
        this.textpane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.textpane.setText(this.message);
        this.textpane.setEditable(false);
        contentpane.add(this.textpane);
        this.box = this.getComboBox(this.options);
        contentpane.add(this.box, "pushy,growy,height 24!");
        this.getDialog().addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent windowevent) {
            }

            @Override
            public void windowGainedFocus(WindowEvent windowevent) {
                Component focusOwner = SearchComboBoxDialog.this.getDialog().getFocusOwner();
                if (focusOwner != null) {
                    return;
                }
                SearchComboBoxDialog.this.getDialog().removeWindowFocusListener(this);
                SearchComboBoxDialog.this.box.requestFocus();
            }
        });
        return contentpane;
    }

    @Override
    public int getSelectedIndex() {
        if ((this.getReturnmask() & 2) == 0) {
            return -1;
        }
        if (this.box != null) {
            return this.box.getSelectedIndex();
        }
        if (this.defaultAnswer == null) {
            return -1;
        }
        return Arrays.binarySearch(this.options, this.defaultAnswer);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String[] getLabels() {
        String[] ret = new String[this.options.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = JSonStorage.toString(this.getStringByValue(this.options[i]));
        }
        return ret;
    }

    @Override
    public int getPreSelectedIndex() {
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(this.defaultAnswer)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getIconDataUrls() {
        String[] ret = new String[this.options.length];
        for (int i = 0; i < ret.length; ++i) {
            Icon ic = this.getIconByValue(this.options[i]);
            if (ic == null) {
                ret[i] = null;
                continue;
            }
            Base64OutputStream b64os = null;
            ByteArrayOutputStream bos = null;
            try {
                bos = new ByteArrayOutputStream();
                b64os = new Base64OutputStream(bos);
                ImageProvider.writeImage((RenderedImage)IconIO.convertIconToBufferedImage(ic), "png", b64os);
                b64os.flush(true);
                ret[i] = "png;base64," + bos.toString("UTF-8");
                continue;
            }
            catch (Exception e) {
                this.getLogger().log(e);
                String[] stringArray = null;
                return stringArray;
            }
            finally {
                try {
                    b64os.close();
                }
                catch (Throwable throwable) {}
                try {
                    bos.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return ret;
    }
}

