/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.appwork.resources.AWUTheme;
import org.appwork.storage.config.JsonConfig;
import org.appwork.sunwrapper.sun.awt.shell.ShellFolderWrapper;
import org.appwork.swing.components.searchcombo.SearchComboBox;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ExtFileChooserDialogIcon;
import org.appwork.utils.swing.dialog.ExtFileChooserIdConfig;
import org.appwork.utils.swing.dialog.ExtFileSystemView;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.appwork.utils.swing.dialog.FilePreview;
import org.appwork.utils.swing.dialog.HomeFolder;
import org.appwork.utils.swing.dialog.ModdedJFileChooser;
import org.appwork.utils.swing.dialog.NetWorkFolder;
import org.appwork.utils.swing.dialog.View;
import org.appwork.utils.swing.dialog.VirtualRoot;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import sun.swing.FilePane;

public class ExtFileChooserDialog
extends AbstractDialog<File[]> {
    public static final String LASTSELECTION = "LASTSELECTION_";
    private static final Cursor BUSY_CURSOR;
    private static final Cursor DEFAULT_CURSOR;
    public static final String FILECHOOSER = "FILECHOOSER";
    public static String FILE_SYSTEM_VIEW_CLASS;
    private FileChooserSelectionMode fileSelectionMode = FileChooserSelectionMode.FILES_AND_DIRECTORIES;
    private FileFilter[] fileFilter;
    private boolean multiSelection = false;
    private File preSelection;
    protected ModdedJFileChooser fc;
    private BasicFileChooserUI fcUI;
    private List<String> quickSelectionList;
    protected boolean selecting;
    private SearchComboBox<String> destination;
    private ExtFileSystemView fileSystemView;
    private Component parentGlassPane;
    protected View view = View.DETAILS;
    private FileChooserType type = FileChooserType.SAVE_DIALOG;
    private String storageID;
    private boolean duringInit;
    protected PropertyChangeListener directoryModel;
    private File[] selection = null;
    private boolean busy;
    private ExtFileChooserIdConfig configCache = null;
    final AtomicReference<TableColumnModel> previousTableColumnModelReference = new AtomicReference();

    public ExtFileChooserDialog(int flag, String title, String okOption, String cancelOption) {
        super(flag | 0x100, title, null, okOption, cancelOption);
        this.setDimensor(new RememberLastDialogDimension("ExtFileChooserDialog"));
    }

    @Override
    protected void _init() {
        super._init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.getLogger().fine("Answer: Button<OK:" + this.okButton.getText() + ">");
            if (this.fcUI != null) {
                this.fcUI.getApproveSelectionAction().actionPerformed(e);
            } else {
                this.setReturnmask(true);
            }
        } else if (e.getSource() == this.cancelButton) {
            this.getLogger().fine("Answer: Button<CANCEL:" + this.cancelButton.getText() + ">");
            this.setReturnmask(false);
        }
        this.dispose();
    }

    @Override
    public void dispose() {
        this.previousTableColumnModelReference.set(null);
        super.dispose();
    }

    protected void auto(JTextField oldTextField) {
        String txt = oldTextField.getText();
        int selstart = oldTextField.getSelectionStart();
        int selend = oldTextField.getSelectionEnd();
        if (selend != txt.length()) {
            return;
        }
        String sel = txt.substring(selstart, selend);
        String bef = txt.substring(0, selstart);
        String name = bef.endsWith("/") || bef.endsWith("\\") ? "" : new File(bef).getName();
        String findName = txt.endsWith("/") || txt.endsWith("\\") ? "" : new File(txt).getName();
        boolean found = sel.length() == 0;
        for (File f : this.fc.getCurrentDirectory().listFiles()) {
            if (this.fc.getFileFilter() != null && !this.fc.getFileFilter().accept(f) || this.fc.getFileSelectionMode() == 0 && f.isDirectory() || this.fc.getFileSelectionMode() == 1 && !f.isDirectory() || f.isHidden() && this.fc.isFileHidingEnabled()) continue;
            if (this.equals(f.getName(), findName)) {
                found = true;
                continue;
            }
            if (!found || !this.startsWith(f.getName(), name)) continue;
            boolean oldSelecting = this.selecting;
            this.selecting = true;
            oldTextField.setText(f.getAbsolutePath());
            oldTextField.setSelectionStart(selstart);
            oldTextField.setSelectionEnd(oldTextField.getText().length());
            this.selecting = oldSelecting;
            return;
        }
        boolean oldSelecting = this.selecting;
        this.selecting = true;
        oldTextField.setText(bef);
        this.selecting = oldSelecting;
    }

    @Override
    protected File[] createReturnValue() {
        if (this.isMultiSelection()) {
            File[] files = this.fc.getSelectedFiles();
            return files;
        }
        File f = this.fc.getSelectedFile();
        if (f == null) {
            String path = this.getText();
            if (path != null && this.isAllowedPath(path)) {
                f = new File(path);
            } else {
                switch (this.getFileSelectionMode()) {
                    case DIRECTORIES_ONLY: 
                    case FILES_AND_DIRECTORIES: {
                        f = this.fc.getCurrentDirectory();
                        if (f == null) break;
                        return new File[]{f};
                    }
                }
                return null;
            }
        }
        return new File[]{f};
    }

    @Override
    protected void setDisposed(boolean b) {
        if (b) {
            try {
                File[] files = this.createReturnValue();
                if (files != null && files.length > 0) {
                    File file = files[0];
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    this.getIDConfig().setLastSelection(file.getAbsolutePath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.setDisposed(b);
    }

    protected boolean isAllowedPath(String path) {
        if (path.equals("::{208D2C60-3AEA-1069-A2D7-08002B30309D}")) {
            return false;
        }
        if (path.equals("::{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}")) {
            return false;
        }
        return !path.equals(_AWU.T.DIALOG_FILECHOOSER_networkfolder());
    }

    private boolean equals(String name, String findName) {
        if (CrossSystem.isWindows()) {
            return name.equalsIgnoreCase(findName);
        }
        return name.equals(findName);
    }

    protected boolean exists(File f) {
        if (f.exists()) {
            return true;
        }
        return this.isSambaFolder(f);
    }

    protected Icon getDirectoryIcon(File f) {
        Icon ret;
        if (this.isFile(f)) {
            try {
                String ext = Files.getExtension(f.getName(), true);
                if (ext == null) {
                    return null;
                }
                return CrossSystem.getMime().getFileIcon(ext, 16, 16);
            }
            catch (Exception e) {
                return null;
            }
        }
        f = this.fileSystemView.mapSpecialFolders(f);
        String key = ExtFileChooserDialogIcon.FILECHOOSER_FOLDER.path();
        if (f.getName().equals("Desktop")) {
            key = ExtFileChooserDialogIcon.FILECHOOSER_DESKTOP.path();
        } else if (f.getPath().equals("::{208D2C60-3AEA-1069-A2D7-08002B30309D}") || f.getPath().equals("::{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}") || f.getPath().startsWith("\\") && f.getPath().indexOf("\\", 2) < 0) {
            key = ExtFileChooserDialogIcon.FILECHOOSER_NETWORK.path();
        } else if (f.getPath().length() == 3 && f.getPath().charAt(1) == ':' && (f.getPath().charAt(0) + "").matches("[a-zA-Z]{1}")) {
            key = ExtFileChooserDialogIcon.FILECHOOSER_HARDDRIVE.path();
        } else if (f instanceof HomeFolder) {
            key = ((HomeFolder)f).getIconKey();
        } else if (f instanceof VirtualRoot && (ret = ((VirtualRoot)f).getIcon(18)) != null) {
            return ret;
        }
        if (AWUTheme.I().hasIcon(key)) {
            return AWUTheme.I().getIcon(key, 18);
        }
        return null;
    }

    private boolean isFile(File f) {
        if (CrossSystem.isWindows()) {
            if (f instanceof NetWorkFolder) {
                return false;
            }
            if (StringUtils.isEmpty(f.getName())) {
                return false;
            }
        }
        return f.isFile();
    }

    public FileFilter[] getFileFilter() {
        return this.fileFilter;
    }

    public FileChooserSelectionMode getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    protected ExtFileChooserIdConfig getIDConfig() {
        File path = Application.getResource("cfg/FileChooser/" + this.getStorageID());
        ExtFileChooserIdConfig configCache = this.configCache;
        if (configCache != null && path.equals(configCache._getStorageHandler().getPath())) {
            return configCache;
        }
        path.getParentFile().mkdirs();
        this.configCache = configCache = JsonConfig.create(path, ExtFileChooserIdConfig.class);
        return configCache;
    }

    public File getPreSelection() {
        return this.preSelection;
    }

    public List<String> getQuickSelectionList() {
        return this.quickSelectionList;
    }

    public File getSelectedFile() {
        if (this.isMultiSelection()) {
            throw new IllegalStateException("Not available if multiselection is active. use #getSelection() instead");
        }
        File[] sel = this.getSelection();
        return sel == null || sel.length == 0 ? null : sel[0];
    }

    public File[] getSelection() {
        if (this.selection != null) {
            return this.selection;
        }
        return this.createReturnValue();
    }

    public String getStorageID() {
        return this.storageID;
    }

    public String getText() {
        try {
            return this.destination != null ? this.destination.getText() : this.fc.getSelectedFile().getAbsolutePath();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public FileChooserType getType() {
        return this.type;
    }

    public View getView() {
        return this.view;
    }

    protected boolean isFilePreviewEnabled() {
        return this.getFileSelectionMode() != FileChooserSelectionMode.DIRECTORIES_ONLY;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    private void setBusy(boolean newValue) {
        if (this.busy == newValue) {
            return;
        }
        if (newValue) {
            if (this.parentGlassPane != null) {
                this.parentGlassPane.setCursor(BUSY_CURSOR);
                this.parentGlassPane.setVisible(true);
            }
        } else if (this.parentGlassPane != null) {
            this.parentGlassPane.setCursor(null);
            this.parentGlassPane.setVisible(false);
        }
        this.busy = newValue;
    }

    protected boolean isSambaFolder(File f) {
        if (this.fileSystemView.getNetworkFolder() != null) {
            return this.fileSystemView.getNetworkFolder().get(f.getAbsolutePath()) != null;
        }
        return false;
    }

    @Override
    public JComponent layoutDialogContent() {
        long t = System.currentTimeMillis();
        System.out.println("Duration 0  " + (System.currentTimeMillis() - t));
        if (SwingUtilities.getRootPane(this.getDialog().getParent()) != null) {
            JRootPane root2 = SwingUtilities.getRootPane(this.getDialog());
            this.parentGlassPane = root2.getGlassPane();
        }
        if (this.parentGlassPane != null) {
            this.parentGlassPane.setCursor(BUSY_CURSOR);
            this.parentGlassPane.setVisible(true);
        }
        this.duringInit = true;
        this.putIcons();
        System.out.println("Duration 1  " + (System.currentTimeMillis() - t));
        this.fileSystemView = this.createFileSystemView();
        this.fc = new FileChooserFileSystemView(this.fileSystemView);
        this.cleanupIcons();
        this.fc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("CancelSelection".equals(e.getActionCommand())) {
                    ExtFileChooserDialog.this.getLogger().fine("Answer: FC CANCEL>");
                    ExtFileChooserDialog.super.setReturnmask(false);
                    ExtFileChooserDialog.this.dispose();
                } else if ("ApproveSelection".equals(e.getActionCommand())) {
                    ExtFileChooserDialog.this.getLogger().fine("Answer: FC APPROVE>");
                    ExtFileChooserDialog.this.setReturnmask(true);
                    ExtFileChooserDialog.this.dispose();
                }
            }
        });
        try {
            this.fcUI = (BasicFileChooserUI)this.fc.getUI();
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        if (this.isFilePreviewEnabled()) {
            this.fc.setAccessory(new FilePreview(this.fc));
        }
        this.fc.setControlButtonsAreShown(false);
        this.fc.setDialogType(this.getType().getId());
        if (this.fileSelectionMode != null) {
            this.fc.setFileSelectionMode(this.fileSelectionMode.getId());
        }
        if (this.fileFilter != null) {
            if (this.fileFilter.length == 1) {
                this.fc.setFileFilter(this.fileFilter[0]);
            } else {
                for (FileFilter filter : this.fileFilter) {
                    if (filter == null) continue;
                    this.fc.addChoosableFileFilter(filter);
                }
            }
        }
        if (this.multiSelection) {
            this.fc.setMultiSelectionEnabled(true);
        } else {
            this.fc.setMultiSelectionEnabled(false);
        }
        File presel = this.preSelection;
        if (presel != null && StringUtils.isEmpty(presel.getName())) {
            presel = null;
        }
        this.getLogger().info("Given presel: " + presel);
        if (presel == null) {
            String path = this.getIDConfig().getLastSelection();
            presel = StringUtils.isEmpty(path) ? null : new File(path);
        } else if (presel.getParentFile() == null) {
            File preselFromStorage;
            String path = this.getIDConfig().getLastSelection();
            File file = preselFromStorage = StringUtils.isEmpty(path) ? null : new File(path);
            if (preselFromStorage != null) {
                presel = new File(preselFromStorage.getParentFile(), presel.getName());
            }
        }
        if (presel == null) {
            presel = new File(System.getProperty("user.home"), "documents");
        }
        File orgPresel = presel;
        while (presel != null) {
            if (!presel.exists()) {
                presel = presel.getParentFile();
                continue;
            }
            if (presel.isDirectory()) {
                this.fc.setCurrentDirectory(presel);
                break;
            }
            this.fc.setCurrentDirectory(presel.getParentFile());
            if (this.fileSelectionMode == null) break;
            if (this.fileSelectionMode.getId() == FileChooserSelectionMode.DIRECTORIES_ONLY.getId()) {
                this.fc.setSelectedFile(presel.getParentFile());
                break;
            }
            this.fc.setSelectedFile(presel);
            break;
        }
        if (!(orgPresel == null || orgPresel.isDirectory() || this.fc.getSelectedFile() != null && this.fc.getSelectedFile().equals(orgPresel))) {
            this.fc.setSelectedFile(new File(this.fc.getCurrentDirectory(), orgPresel.getName()));
        }
        this.updateView();
        try {
            JToggleButton detailsButton = (JToggleButton)SwingUtils.getParent(this.fc, 0, 0, 7);
            detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtFileChooserDialog.this.view = View.DETAILS;
                }
            });
        }
        catch (ArrayIndexOutOfBoundsException detailsButton) {
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        try {
            JToggleButton listButton = (JToggleButton)SwingUtils.getParent(this.fc, 0, 0, 6);
            listButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtFileChooserDialog.this.view = View.LIST;
                }
            });
        }
        catch (ArrayIndexOutOfBoundsException listButton) {
        }
        catch (Throwable e) {
            this.getLogger().log(e);
        }
        JComponent fcContainer = this.getFileChooserContainer(this.fc);
        if (fcContainer != null) {
            if (this.fileSelectionMode.getId() == FileChooserSelectionMode.DIRECTORIES_ONLY.getId() && fcContainer.getComponentCount() >= 4) {
                ((JComponent)fcContainer.getComponent(3)).getComponent(1).setVisible(false);
                ((JComponent)fcContainer.getComponent(3)).getComponent(2).setVisible(false);
            }
            if (this.quickSelectionList != null && !this.multiSelection && fcContainer.getComponentCount() >= 4) {
                try {
                    JPanel namePanel = (JPanel)((JComponent)fcContainer.getComponent(3)).getComponent(0);
                    final JTextField oldTextField = (JTextField)namePanel.getComponent(1);
                    namePanel.remove(1);
                    String text = oldTextField.getText();
                    this.destination = new SearchComboBox<String>(){

                        @Override
                        public JTextField createTextField() {
                            return oldTextField;
                        }

                        @Override
                        protected Icon getIconForValue(String value) {
                            return null;
                        }

                        @Override
                        protected String getTextForValue(String value) {
                            return value;
                        }

                        @Override
                        public boolean isAutoCompletionEnabled() {
                            return false;
                        }

                        @Override
                        public void onChanged() {
                            if (ExtFileChooserDialog.this.selecting) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        String txt = this.getText();
                                        this.updateButtonsAndText(txt);
                                    }
                                });
                                return;
                            }
                            String txt = this.getText();
                            if (CrossSystem.getOSFamily() == CrossSystem.OSFamily.WINDOWS && txt.length() <= 2 && !txt.startsWith("\\")) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                private File getFile(String txt) {
                                    if (ExtFileChooserDialog.this.fileSystemView.getNetworkFolder() != null && "\\".equals(txt)) {
                                        return ExtFileChooserDialog.this.fileSystemView.getNetworkFolder();
                                    }
                                    File ret = null;
                                    if (ExtFileChooserDialog.this.fileSystemView.getNetworkFolder() != null) {
                                        ret = ExtFileChooserDialog.this.fileSystemView.getNetworkFolder().get(new File(txt).getAbsolutePath());
                                    }
                                    return ret != null ? ret : new File(txt);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    String orgText;
                                    String curText = orgText = this.getText();
                                    try {
                                        boolean parent = false;
                                        for (File f = this.getFile(curText); f != null && f.getParentFile() != f; f = f.getParentFile()) {
                                            block10: {
                                                PropertyChangeListener listener;
                                                block8: {
                                                    curText = this.getText();
                                                    if (!ExtFileChooserDialog.this.exists(f)) break block10;
                                                    final String finalTxt = curText;
                                                    listener = new PropertyChangeListener(){

                                                        @Override
                                                        public void propertyChange(PropertyChangeEvent evt) {
                                                            if ("directoryChanged".equals(evt.getPropertyName()) || "SelectedFileChangedProperty".equals(evt.getPropertyName())) {
                                                                boolean setText;
                                                                if ("directoryChanged".equals(evt.getPropertyName())) {
                                                                    setText = evt.getOldValue() == null || evt.getNewValue().toString().length() < evt.getOldValue().toString().length();
                                                                } else {
                                                                    boolean bl = setText = !StringUtils.equals(orgText, finalTxt);
                                                                }
                                                                if (setText) {
                                                                    SwingUtilities.invokeLater(new Runnable(){

                                                                        @Override
                                                                        public void run() {
                                                                            boolean oldSelecting = ExtFileChooserDialog.this.selecting;
                                                                            ExtFileChooserDialog.this.selecting = true;
                                                                            this.setText(finalTxt);
                                                                            ExtFileChooserDialog.this.selecting = oldSelecting;
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    };
                                                    try {
                                                        ExtFileChooserDialog.this.fc.addPropertyChangeListener(listener);
                                                        if (f.isFile()) {
                                                            ExtFileChooserDialog.this.fc.setSelectedFile(f);
                                                            break block8;
                                                        }
                                                        if (f.getParentFile() != null && f.getParentFile().exists() && !parent && !f.isDirectory()) break block8;
                                                        ExtFileChooserDialog.this.fc.setCurrentDirectory(f);
                                                        ExtFileChooserDialog.this.fc.setSelectedFile(null);
                                                    }
                                                    catch (Throwable throwable) {
                                                        SwingUtilities.invokeLater(new Runnable(listener){
                                                            final /* synthetic */ PropertyChangeListener val$listener;
                                                            {
                                                                this.val$listener = propertyChangeListener;
                                                            }

                                                            @Override
                                                            public void run() {
                                                                ExtFileChooserDialog.this.fc.removePropertyChangeListener(this.val$listener);
                                                            }
                                                        });
                                                        throw throwable;
                                                    }
                                                }
                                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                                return;
                                            }
                                            parent = true;
                                        }
                                    }
                                    finally {
                                        this.updateButtonsAndText(curText);
                                    }
                                }
                            });
                        }

                        protected void updateButtonsAndText(String txt) {
                            if (txt.equals("::{208D2C60-3AEA-1069-A2D7-08002B30309D}") || txt.equals("::{F02C1A0D-BE21-4350-88B0-7367FC96EF3C}")) {
                                ExtFileChooserDialog.this.destination.getTextField().setText(_AWU.T.DIALOG_FILECHOOSER_networkfolder());
                                ExtFileChooserDialog.this.okButton.setEnabled(false);
                                return;
                            }
                            File[] ret = ExtFileChooserDialog.this.createReturnValue();
                            if (ret == null || ret.length == 0) {
                                ExtFileChooserDialog.this.okButton.setEnabled(false);
                            } else {
                                ExtFileChooserDialog.this.okButton.setEnabled(true);
                            }
                        }
                    };
                    this.destination.getTextField().getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "approveSelection");
                    this.destination.getTextField().getInputMap().put(KeyStroke.getKeyStroke("pressed TAB"), "auto");
                    this.destination.getTextField().setFocusTraversalKeysEnabled(false);
                    this.destination.setActionMap(this.fc.getActionMap());
                    this.destination.getTextField().getActionMap().put("auto", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ExtFileChooserDialog.this.auto(oldTextField);
                        }
                    });
                    this.destination.setUnkownTextInputAllowed(true);
                    this.destination.setBadColor(null);
                    this.destination.setSelectedItem(null);
                    this.destination.setList(this.quickSelectionList);
                    this.destination.setText(text);
                    if (orgPresel != null && orgPresel.exists()) {
                        if (orgPresel.isDirectory()) {
                            if (orgPresel.getAbsolutePath().endsWith(File.separatorChar + "")) {
                                this.destination.setText(orgPresel.getAbsolutePath());
                            } else {
                                this.destination.setText(orgPresel.getAbsolutePath() + File.separatorChar);
                            }
                        } else {
                            this.destination.setText(orgPresel.getAbsolutePath());
                        }
                    }
                    namePanel.add(this.destination);
                    this.modifiyNamePanel(namePanel);
                    JComponent c = (JComponent)fcContainer.getComponent(2);
                    c = (JComponent)c.getComponent(0);
                    c = (JComponent)c.getComponent(0);
                    c = (JComponent)c.getComponent(0);
                    c = (JComponent)c.getComponent(0);
                    if (c instanceof JList) {
                        final JList list = (JList)c;
                        list.addMouseListener(new MouseAdapter(){

                            public int loc2IndexFileList(JList jlist, Point point) {
                                int i = jlist.locationToIndex(point);
                                if (i != -1 && !this.pointIsInActualBounds(jlist, i, point)) {
                                    i = -1;
                                }
                                return i;
                            }

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                File dir;
                                int index = this.loc2IndexFileList(list, e.getPoint());
                                if (index < 0 && (dir = ExtFileChooserDialog.this.fc.getSelectedFile()) != null) {
                                    ExtFileChooserDialog.this.destination.setText(dir.getParent() + File.separator);
                                    ListSelectionModel listSelectionModel = list.getSelectionModel();
                                    if (listSelectionModel != null) {
                                        listSelectionModel.clearSelection();
                                        ((DefaultListSelectionModel)listSelectionModel).moveLeadSelectionIndex(0);
                                        listSelectionModel.setAnchorSelectionIndex(0);
                                    }
                                }
                            }

                            private boolean pointIsInActualBounds(JList jlist, int i, Point point) {
                                ListCellRenderer listcellrenderer = jlist.getCellRenderer();
                                ListModel listmodel = jlist.getModel();
                                Object obj = listmodel.getElementAt(i);
                                Component component = listcellrenderer.getListCellRendererComponent(jlist, obj, i, false, false);
                                Dimension dimension = component.getPreferredSize();
                                Rectangle rectangle = jlist.getCellBounds(i, i);
                                if (!component.getComponentOrientation().isLeftToRight()) {
                                    rectangle.x += rectangle.width - dimension.width;
                                }
                                rectangle.width = dimension.width;
                                return rectangle.contains(point);
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    this.getLogger().log(e);
                }
            }
        }
        if (this.directoryModel != null) {
            this.fc.addPropertyChangeListener(this.directoryModel);
            this.directoryModel.propertyChange(new PropertyChangeEvent(this, "fileFilterChanged", null, null));
        }
        this.duringInit = false;
        return this.fc;
    }

    protected JComponent getFileChooserContainer(JComponent fc) {
        Component c;
        int index;
        for (index = 0; index < fc.getComponentCount(); ++index) {
            c = fc.getComponent(index);
            if (!(c instanceof FilePane) || index != 2) continue;
            return fc;
        }
        for (index = 0; index < fc.getComponentCount(); ++index) {
            JComponent ret;
            c = fc.getComponent(index);
            if (!(c instanceof JComponent) || ((JComponent)c).getComponentCount() <= 0 || (ret = this.getFileChooserContainer((JComponent)c)) == null) continue;
            return ret;
        }
        return null;
    }

    protected ExtFileSystemView createFileSystemView() {
        try {
            if (StringUtils.isEmpty(FILE_SYSTEM_VIEW_CLASS)) {
                return new ExtFileSystemView();
            }
            Class<?> clazz = Class.forName(FILE_SYSTEM_VIEW_CLASS);
            return (ExtFileSystemView)clazz.newInstance();
        }
        catch (Exception e) {
            return new ExtFileSystemView();
        }
    }

    private void putIcons() {
        this.putIcon("FileView.directoryIcon", ExtFileChooserDialogIcon.FILECHOOSER_FOLDER.path());
        this.putIcon("FileView.fileIcon", ExtFileChooserDialogIcon.FILECHOOSER_FILE.path());
        this.putIcon("FileView.computerIcon", ExtFileChooserDialogIcon.FILECHOOSER_COMPUTER.path());
        this.putIcon("FileView.hardDriveIcon", ExtFileChooserDialogIcon.FILECHOOSER_HARDDRIVE.path());
        this.putIcon("FileView.floppyDriveIcon", ExtFileChooserDialogIcon.FILECHOOSER_FLOPPY.path());
        this.putIcon("FileChooser.newFolderIcon", ExtFileChooserDialogIcon.FILECHOOSER_NEW_FOLDER.path());
        this.putIcon("FileChooser.upFolderIcon", ExtFileChooserDialogIcon.FILECHOOSER_PARENT.path());
        this.putIcon("FileChooser.homeFolderIcon", ExtFileChooserDialogIcon.FILECHOOSER_DESKTOP.path());
        this.putIcon("FileChooser.detailsViewIcon", ExtFileChooserDialogIcon.FILECHOOSER_DETAILS_VIEW.path());
        this.putIcon("FileChooser.listViewIcon", ExtFileChooserDialogIcon.FILECHOOSER_LIST_VIEW.path());
        this.putIcon("FileChooser.viewMenuIcon", ExtFileChooserDialogIcon.FILECHOOSER_VIEW.path());
    }

    private void putIcon(String key, String iconKey) {
        if (AWUTheme.I().hasIcon(iconKey)) {
            UIManager.put(key, AWUTheme.I().getIcon(iconKey, 18));
        }
    }

    private void cleanupIcons() {
        this.cleanupIcon("FileView.directoryIcon", ExtFileChooserDialogIcon.FILECHOOSER_FOLDER.path());
        this.cleanupIcon("FileView.fileIcon", ExtFileChooserDialogIcon.FILECHOOSER_FILE.path());
        this.cleanupIcon("FileView.computerIcon", ExtFileChooserDialogIcon.FILECHOOSER_COMPUTER.path());
        this.cleanupIcon("FileView.hardDriveIcon", ExtFileChooserDialogIcon.FILECHOOSER_COMPUTER.path());
        this.cleanupIcon("FileView.floppyDriveIcon", ExtFileChooserDialogIcon.FILECHOOSER_FLOPPY.path());
        this.cleanupIcon("FileChooser.newFolderIcon", ExtFileChooserDialogIcon.FILECHOOSER_NEW_FOLDER.path());
        this.cleanupIcon("FileChooser.upFolderIcon", ExtFileChooserDialogIcon.FILECHOOSER_PARENT.path());
        this.cleanupIcon("FileChooser.homeFolderIcon", ExtFileChooserDialogIcon.FILECHOOSER_DESKTOP.path());
        this.cleanupIcon("FileChooser.detailsViewIcon", ExtFileChooserDialogIcon.FILECHOOSER_DETAILS_VIEW.path());
        this.cleanupIcon("FileChooser.listViewIcon", ExtFileChooserDialogIcon.FILECHOOSER_LIST_VIEW.path());
        this.cleanupIcon("FileChooser.viewMenuIcon", ExtFileChooserDialogIcon.FILECHOOSER_VIEW.path());
    }

    private void cleanupIcon(String key, String iconKey) {
        if (AWUTheme.I().hasIcon(iconKey)) {
            UIManager.put(key, null);
        }
    }

    protected void modifiyNamePanel(JPanel namePanel) {
    }

    @Override
    protected void packed() {
        super.packed();
        if (this.parentGlassPane != null) {
            this.parentGlassPane.setCursor(null);
            this.parentGlassPane.setVisible(false);
        }
    }

    public void setFileFilter(FileFilter ... fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void setFileSelectionMode(FileChooserSelectionMode fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public void setPreSelection(File preSelection) {
        this.preSelection = preSelection;
    }

    public void setQuickSelectionList(List<String> quickSelectionList) {
        this.quickSelectionList = quickSelectionList;
    }

    @Override
    protected void setReturnmask(boolean b) {
        if (!b) {
            this.fc.cancelSelection();
        }
        super.setReturnmask(b);
    }

    public void setSelection(File[] selection) {
        this.selection = selection;
    }

    public void setStorageID(String id) {
        this.storageID = id;
    }

    public void setType(FileChooserType type) {
        this.type = type;
    }

    public void setView(View view) {
        if (view == null) {
            view = View.DETAILS;
        }
        this.view = view;
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ExtFileChooserDialog.this.updateView();
            }
        };
    }

    protected synchronized Map<String, Object> getStorage() {
        ExtFileChooserIdConfig config = this.getIDConfig();
        ConcurrentHashMap<String, Object> storage = config.getStorage();
        if (storage == null) {
            storage = new ConcurrentHashMap();
            config.setStorage(storage);
        }
        return storage;
    }

    private boolean startsWith(String name, String name2) {
        if (CrossSystem.isWindows()) {
            return name.toLowerCase(Locale.ENGLISH).startsWith(name2.toLowerCase(Locale.ENGLISH));
        }
        return name.startsWith(name2);
    }

    private void updateView() {
        if (this.fc != null) {
            switch (this.getView()) {
                case DETAILS: {
                    JToggleButton detailsButton2;
                    try {
                        detailsButton2 = (JToggleButton)SwingUtils.getParent(this.fc, 0, 0, 7);
                        detailsButton2.doClick();
                    }
                    catch (ArrayIndexOutOfBoundsException detailsButton2) {
                    }
                    catch (Throwable t) {
                        this.getLogger().log(t);
                    }
                    break;
                }
                case LIST: {
                    JToggleButton detailsButton2;
                    try {
                        detailsButton2 = (JToggleButton)SwingUtils.getParent(this.fc, 0, 0, 6);
                        detailsButton2.doClick();
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException detailsButton) {
                        break;
                    }
                    catch (Throwable t) {
                        this.getLogger().log(t);
                    }
                }
            }
            Map<JTable, List<Integer>> jtables = SwingUtils.find(this.fc, null, JTable.class);
            if (jtables != null && jtables.size() == 1) {
                final JTable jtable = jtables.keySet().iterator().next();
                jtable.getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        if (e.getType() == 0 && e.getColumn() == -1) {
                            ExtFileChooserDialog.this.restoreTableColumnModel(jtable);
                        }
                    }
                });
                this.restoreTableColumnModel(jtable);
            }
        }
    }

    protected void restoreTableColumnModel(JTable jtable) {
        TableColumn col;
        int c;
        Map<String, Object> storage = this.getStorage();
        TableColumnModel currentTableColumnModel = jtable.getColumnModel();
        TableColumnModel previousTableColumnModel = this.previousTableColumnModelReference.getAndSet(currentTableColumnModel);
        if (previousTableColumnModel != null) {
            for (c = 0; c < previousTableColumnModel.getColumnCount(); ++c) {
                col = previousTableColumnModel.getColumn(c);
                storage.put(col.getIdentifier() + "_width", col.getWidth());
                storage.put(col.getIdentifier() + "_pos", c);
            }
        }
        for (c = 0; c < currentTableColumnModel.getColumnCount(); ++c) {
            int w;
            col = currentTableColumnModel.getColumn(c);
            Object width = storage.get(col.getIdentifier() + "_width");
            if (!(width instanceof Number) || (w = ((Number)width).intValue()) <= 0) continue;
            col.setWidth(w);
            col.setPreferredWidth(w);
        }
        for (c = 0; c < currentTableColumnModel.getColumnCount(); ++c) {
            int p;
            col = currentTableColumnModel.getColumn(c);
            Object pos = storage.get(col.getIdentifier() + "_pos");
            if (!(pos instanceof Number) || (p = ((Number)pos).intValue()) < 0) continue;
            currentTableColumnModel.moveColumn(c, p);
        }
        jtable.setAutoResizeMode(3);
    }

    static {
        UIManager.put("FileChooser.lookInLabelText", _AWU.T.DIALOG_FILECHOOSER_lookInLabelText());
        UIManager.put("FileChooser.saveInLabelText", _AWU.T.DIALOG_FILECHOOSER_saveInLabelText());
        UIManager.put("FileChooser.fileNameLabelText", _AWU.T.DIALOG_FILECHOOSER_fileNameLabelText());
        UIManager.put("FileChooser.folderNameLabelText", _AWU.T.DIALOG_FILECHOOSER_folderNameLabelText());
        UIManager.put("FileChooser.filesOfTypeLabelText", _AWU.T.DIALOG_FILECHOOSER_filesOfTypeLabelText());
        UIManager.put("FileChooser.upFolderToolTipText", _AWU.T.DIALOG_FILECHOOSER_TOOLTIP_UPFOLDER());
        UIManager.put("FileChooser.upFolderAccessibleName", _AWU.T.DIALOG_FILECHOOSER_upFolderAccessibleName());
        UIManager.put("FileChooser.homeFolderToolTipText", _AWU.T.DIALOG_FILECHOOSER_TOOLTIP_HOMEFOLDER());
        UIManager.put("FileChooser.homeFolderAccessibleName", _AWU.T.DIALOG_FILECHOOSER_homeFolderAccessibleName());
        UIManager.put("FileChooser.newFolderToolTipText", _AWU.T.DIALOG_FILECHOOSER_TOOLTIP_NEWFOLDER());
        UIManager.put("FileChooser.newFolderAccessibleName", _AWU.T.DIALOG_FILECHOOSER_newFolderAccessibleName());
        UIManager.put("FileChooser.listViewButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_TOOLTIP_LIST());
        UIManager.put("FileChooser.listViewButtonAccessibleName", _AWU.T.DIALOG_FILECHOOSER_listViewButtonAccessibleName());
        UIManager.put("FileChooser.detailsViewButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_TOOLTIP_DETAILS());
        UIManager.put("FileChooser.detailsViewButtonAccessibleName", _AWU.T.DIALOG_FILECHOOSER_detailsViewButtonAccessibleName());
        UIManager.put("FileChooser.newFolderErrorText", _AWU.T.DIALOG_FILECHOOSER_newFolderErrorText());
        UIManager.put("FileChooser.newFolderErrorSeparator", _AWU.T.DIALOG_FILECHOOSER_newFolderErrorSeparator());
        UIManager.put("FileChooser.newFolderParentDoesntExistTitleText", _AWU.T.DIALOG_FILECHOOSER_newFolderParentDoesntExistTitleText());
        UIManager.put("FileChooser.newFolderParentDoesntExistText", _AWU.T.DIALOG_FILECHOOSER_newFolderParentDoesntExistText());
        UIManager.put("FileChooser.fileDescriptionText", _AWU.T.DIALOG_FILECHOOSER_fileDescriptionText());
        UIManager.put("FileChooser.directoryDescriptionText", _AWU.T.DIALOG_FILECHOOSER_directoryDescriptionText());
        UIManager.put("FileChooser.saveButtonText", _AWU.T.DIALOG_FILECHOOSER_saveButtonText());
        UIManager.put("FileChooser.openButtonText", _AWU.T.DIALOG_FILECHOOSER_openButtonText());
        UIManager.put("FileChooser.saveDialogTitleText", _AWU.T.DIALOG_FILECHOOSER_saveDialogTitleText());
        UIManager.put("FileChooser.openDialogTitleText", _AWU.T.DIALOG_FILECHOOSER_openDialogTitleText());
        UIManager.put("FileChooser.cancelButtonText", _AWU.T.DIALOG_FILECHOOSER_cancelButtonText());
        UIManager.put("FileChooser.updateButtonText", _AWU.T.DIALOG_FILECHOOSER_updateButtonText());
        UIManager.put("FileChooser.helpButtonText", _AWU.T.DIALOG_FILECHOOSER_helpButtonText());
        UIManager.put("FileChooser.directoryOpenButtonText", _AWU.T.DIALOG_FILECHOOSER_directoryOpenButtonText());
        UIManager.put("FileChooser.saveButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_saveButtonToolTipText());
        UIManager.put("FileChooser.openButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_openButtonToolTipText());
        UIManager.put("FileChooser.cancelButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_cancelButtonToolTipText());
        UIManager.put("FileChooser.updateButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_updateButtonToolTipText());
        UIManager.put("FileChooser.helpButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_helpButtonToolTipText());
        UIManager.put("FileChooser.directoryOpenButtonToolTipText", _AWU.T.DIALOG_FILECHOOSER_directoryOpenButtonToolTipText());
        BUSY_CURSOR = Cursor.getPredefinedCursor(3);
        DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
        FILE_SYSTEM_VIEW_CLASS = "FILECHOOSER_FILE_SYSTEM_VIEW_CLASS";
    }

    private final class FileChooserFileSystemView
    extends ModdedJFileChooser {
        private Insets nullInsets;
        private boolean initComplete;

        private FileChooserFileSystemView(ExtFileSystemView extFileSystemView) {
            super(extFileSystemView);
            this.initComplete = false;
            this.initComplete = true;
            this.nullInsets = new Insets(0, 0, 0, 0);
        }

        @Override
        public File getCurrentDirectory() {
            File file = super.getCurrentDirectory();
            if (file == null) {
                return null;
            }
            return this.getShellFolder(file);
        }

        private File getShellFolder(File file) {
            try {
                return file != null ? ShellFolderWrapper.getShellFolder(file) : null;
            }
            catch (FileNotFoundException e) {
                return file;
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (listener instanceof BasicDirectoryModel && ExtFileChooserDialog.this.directoryModel == null) {
                ExtFileChooserDialog.this.directoryModel = listener;
                return;
            }
            super.addPropertyChangeListener(listener);
        }

        @Override
        public Icon getIcon(File f) {
            Icon ret = ExtFileChooserDialog.this.getDirectoryIcon(f);
            if (ret == null) {
                ret = super.getIcon(f);
            }
            return ret;
        }

        @Override
        public Insets getInsets() {
            return this.nullInsets;
        }

        private void setCurrentDirectoryInternal(File dir) {
            boolean oldSelecting = ExtFileChooserDialog.this.selecting;
            ExtFileChooserDialog.this.selecting = true;
            try {
                if (dir == ExtFileChooserDialog.this.fileSystemView.getNetworkFolder()) {
                    ExtFileChooserDialog.this.okButton.setEnabled(false);
                } else {
                    ExtFileChooserDialog.this.okButton.setEnabled(true);
                }
                this.setSelectedFile(null);
                super.setCurrentDirectory(this.getShellFolder(dir));
            }
            finally {
                ExtFileChooserDialog.this.selecting = oldSelecting;
            }
        }

        @Override
        public void setCurrentDirectory(final File dir) {
            if (!this.initComplete) {
                return;
            }
            if (ExtFileChooserDialog.this.duringInit) {
                this.setCurrentDirectoryInternal(dir);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileChooserFileSystemView.this.setCurrentDirectoryInternal(dir);
                    }
                });
            }
        }

        @Override
        public void setSelectedFile(File file) {
            boolean oldSelecting = ExtFileChooserDialog.this.selecting;
            ExtFileChooserDialog.this.selecting = true;
            try {
                super.setSelectedFile(this.getShellFolder(file));
            }
            finally {
                ExtFileChooserDialog.this.selecting = oldSelecting;
            }
        }

        @Override
        public void updateUI() {
            this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
            super.updateUI();
            FileChooserUI myUi = this.getUI();
            if (myUi instanceof BasicFileChooserUI) {
                ((BasicFileChooserUI)myUi).getModel().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("busy".equals(evt.getPropertyName())) {
                            ExtFileChooserDialog.this.setBusy((Boolean)evt.getNewValue());
                        }
                    }
                });
            }
        }
    }
}

