/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.util.logging.Level;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.logging.ExceptionDefaultLogLevel;

public class DialogNoAnswerException
extends Exception
implements ExceptionDefaultLogLevel {
    private static final long serialVersionUID = 1L;
    private final boolean causedByDontShowAgain;
    private final boolean causedByTimeout;
    private final boolean causedByESC;
    private final boolean causedByClosed;
    private final boolean causedByInterrupt;

    public boolean isCausedByInterrupt() {
        return this.causedByInterrupt;
    }

    public DialogNoAnswerException(int mask, Throwable cause) {
        super(cause);
        this.causedByDontShowAgain = BinaryLogic.containsSome(mask, 16);
        this.causedByTimeout = BinaryLogic.containsSome(mask, 32);
        this.causedByESC = BinaryLogic.containsSome(mask, 128);
        this.causedByClosed = BinaryLogic.containsSome(mask, 64);
        this.causedByInterrupt = BinaryLogic.containsSome(mask, 256);
        if (cause == null) {
            this.setStackTrace(new StackTraceElement[0]);
        }
    }

    @Override
    public Level getDefaultLogLevel() {
        return Level.WARNING;
    }

    @Override
    public String getMessage() {
        return "DontShowAgain: " + this.causedByDontShowAgain + " Timeout: " + this.causedByTimeout;
    }

    public boolean isCausedByClosed() {
        return this.causedByClosed;
    }

    public boolean isCausedByDontShowAgain() {
        return this.causedByDontShowAgain;
    }

    public boolean isCausedbyESC() {
        return this.causedByESC;
    }

    public boolean isCausedByTimeout() {
        return this.causedByTimeout;
    }
}

