/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import org.appwork.swing.MigPanel;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class ConfirmDialog
extends AbstractDialog<Integer>
implements ConfirmDialogInterface {
    public static final int STYLE_HTML = 128;
    public static final int STYLE_SCROLLPANE = 64;
    private String message;
    protected JTextComponent textComponent;

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public boolean isRemoteAPIEnabled() {
        return true;
    }

    public ConfirmDialog(int flag, String title, String message, Icon icon, String okOption, String cancelOption) {
        super(flag, title, icon, okOption, cancelOption);
        this.getLogger().fine("Dialog    [" + okOption + "][" + cancelOption + "]\r\nflag:  " + Integer.toBinaryString(flag) + "\r\ntitle: " + title + "\r\nmsg:   \r\n" + message);
        this.message = message;
    }

    public ConfirmDialog(int flag, String title, String message) {
        this(flag, title, message, null, null, null);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ConfirmDialogInterface show() {
        return UIOManager.I().show(ConfirmDialogInterface.class, this);
    }

    @Override
    protected Integer createReturnValue() {
        return this.getReturnmask();
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0", "[]", "[]");
        this.textComponent = this.addMessageComponent(p);
        return p;
    }

    protected JTextComponent addMessageComponent(MigPanel p) {
        JTextPane textField = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return !BinaryLogic.containsAll(ConfirmDialog.this.flagMask, 64);
            }
        };
        this.modifyTextPane(textField);
        Font font = textField.getFont();
        if (BinaryLogic.containsAll(this.flagMask, 128)) {
            textField.setContentType("text/html");
            textField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        CrossSystem.openURL(e.getURL());
                    }
                }
            });
        } else {
            textField.setContentType("text/plain");
        }
        textField.setFont(font);
        textField.setText(this.getMessage());
        textField.setEditable(false);
        textField.setBackground(null);
        textField.setOpaque(false);
        textField.setFocusable(false);
        textField.setForeground(new JLabel().getForeground());
        textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        textField.setCaretPosition(0);
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            p.add((Component)new JScrollPane(textField), "pushx,growx");
        } else {
            p.add(textField);
        }
        return textField;
    }

    protected void modifyTextPane(JTextPane textField) {
    }

    @Override
    public String toString() {
        if (BinaryLogic.containsAll(this.flagMask, 4096)) {
            return ("dialog-" + this.getTitle()).replaceAll("\\W", "_");
        }
        return ("dialog-" + this.getTitle() + "_" + this.getMessage()).replaceAll("\\W", "_");
    }
}

