/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.JSonStorage;
import org.appwork.swing.MigPanel;
import org.appwork.uio.CloseReason;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.Base64OutputStream;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractTimerThread;
import org.appwork.utils.swing.dialog.BasicZHandler;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogIcon;
import org.appwork.utils.swing.dialog.DisposeCallBack;
import org.appwork.utils.swing.dialog.InternDialog;
import org.appwork.utils.swing.dialog.OKCancelCloseUserIODefinition;
import org.appwork.utils.swing.dialog.OwnerFinder;
import org.appwork.utils.swing.dialog.WindowStack;
import org.appwork.utils.swing.dialog.WindowZHandler;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.locator.CenterOfScreenDialogLocator;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.windowmanager.WindowManager;

public abstract class AbstractDialog<T>
implements ActionListener,
WindowListener,
OKCancelCloseUserIODefinition,
WindowFocusListener,
ComponentListener {
    protected static int BUTTON_HEIGHT = -1;
    public static DialogLocator DEFAULT_LOCATOR = null;
    public static final DialogLocator LOCATE_CENTER_OF_SCREEN = new CenterOfScreenDialogLocator();
    private static final HashMap<String, Integer> SESSION_DONTSHOW_AGAIN = new HashMap();
    public static final OwnerFinder DEFAULT_OWNER_FINDER;
    private static OwnerFinder OWNER_FINDER;
    public static WindowZHandler ZHANDLER;
    private static final WeakHashMap<Object, WindowStack> STACK_MAP;
    private static final Object NULL_KEY;
    protected AbstractAction[] actions = null;
    protected JButton cancelButton;
    private final String cancelButtonText;
    private boolean countdownPausable = true;
    protected FocusListener defaultButtonFocusListener;
    protected DefaultButtonPanel defaultButtons;
    protected InternDialog<T> dialog;
    private DialogDimensor dimensor;
    protected boolean disposed = false;
    protected boolean doNotShowAgainSelected = false;
    protected JCheckBox dontshowagain;
    private boolean dummyInit = false;
    protected int flagMask;
    private Icon icon;
    protected JLabel iconLabel;
    private volatile boolean initialized = false;
    private DialogLocator locator;
    protected JButton okButton;
    protected final String okButtonText;
    private Point orgLocationOnScreen;
    protected JComponent panel;
    protected Dimension preferredSize;
    protected int returnBitMask = 0;
    private int timeout = 0;
    protected NullsafeAtomicReference<AbstractTimerThread> timer = new NullsafeAtomicReference<Object>(null);
    protected JLabel timerLbl;
    private String title;
    private DisposeCallBack disposeCallBack;
    private boolean callerIsEDT = false;
    protected JComponent focusButton;
    private Dialog.ModalityType modalityType = Dialog.ModalityType.DOCUMENT_MODAL;
    private int preferredHeight = -1;
    private int preferredWidth = -1;
    protected JComponent lastFocusRequestedJComponent = null;

    public static void setZHandler(WindowZHandler zHANDLER) {
        ZHANDLER = zHANDLER;
    }

    public static int getButtonHeight() {
        return BUTTON_HEIGHT;
    }

    public static DialogLocator getDefaultLocator() {
        return DEFAULT_LOCATOR;
    }

    protected LogInterface getLogger() {
        return LogV3.I().getDefaultLogger();
    }

    public static Window getDefaultRoot() {
        WindowStack stack = AbstractDialog.getWindowStackByRoot(null);
        for (Window w : stack) {
            if (!(w instanceof Frame) && !(w instanceof java.awt.Dialog)) continue;
            return w;
        }
        return null;
    }

    public static OwnerFinder getGlobalOwnerFinder() {
        return OWNER_FINDER;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        DialogDimensor dim = this.getDimensor();
        if (dim != null) {
            dim.onClose(this, e);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        DialogLocator loc = this.getLocator();
        if (loc != null) {
            loc.onClose(this, e);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getSessionDontShowAgainValue(String key) {
        HashMap<String, Integer> hashMap = SESSION_DONTSHOW_AGAIN;
        synchronized (hashMap) {
            Integer ret = SESSION_DONTSHOW_AGAIN.get(key);
            if (ret == null) {
                return -1;
            }
            return ret;
        }
    }

    @Override
    public boolean isRemoteAPIEnabled() {
        return false;
    }

    private static WindowStack getWindowStackByRoot(Window desiredRootFrame) {
        WindowStack ret;
        Object key = desiredRootFrame;
        if (key == null || !desiredRootFrame.isVisible()) {
            key = NULL_KEY;
        }
        if ((ret = STACK_MAP.get(key)) == null) {
            ret = new WindowStack(desiredRootFrame);
            STACK_MAP.put(key, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDialogInformations() {
        try {
            HashMap<String, Integer> hashMap = SESSION_DONTSHOW_AGAIN;
            synchronized (hashMap) {
                SESSION_DONTSHOW_AGAIN.clear();
            }
            JSonStorage.getPlainStorage("Dialogs").clear();
        }
        catch (Exception e) {
            LogV3.log(e);
        }
    }

    public static void setButtonHeight(int height) {
        BUTTON_HEIGHT = height;
    }

    public static void setDefaultLocator(DialogLocator dEFAULT_LOCATOR) {
        DEFAULT_LOCATOR = dEFAULT_LOCATOR;
    }

    public static final <T extends Window> T ensureFrameDialogOrNull(T owner) {
        if (owner == null) {
            return null;
        }
        if (owner instanceof Frame || owner instanceof java.awt.Dialog) {
            return owner;
        }
        LogV3.log(new Exception("Warning! Bad Owner Frame Detected - fallback to null: " + AbstractDialog.printTypeHirarchy(owner.getClass())));
        return null;
    }

    private static final String printTypeHirarchy(Class<?> class1) {
        if (class1 == null) {
            return "";
        }
        return class1.getName() + " << " + AbstractDialog.printTypeHirarchy(class1.getSuperclass());
    }

    public static void setDefaultRoot(Window root) {
        Window defaultRoot = AbstractDialog.ensureFrameDialogOrNull(root);
        if (root != null && root != defaultRoot) {
            throw new IllegalStateException(root + " is not a Frame or Dialog:" + AbstractDialog.printTypeHirarchy(root.getClass()));
        }
        AbstractDialog.getWindowStackByRoot(null).reset(defaultRoot);
    }

    public static void setGlobalOwnerFinder(OwnerFinder finder) {
        OWNER_FINDER = finder == null ? DEFAULT_OWNER_FINDER : finder;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public void setModalityType(Dialog.ModalityType modalityType) {
        this.modalityType = modalityType;
    }

    public AbstractDialog(int flag, String title, Icon icon, String okOption, String cancelOption) {
        this.title = title;
        this.flagMask = flag;
        this.icon = BinaryLogic.containsAll(flag, 256) ? null : icon;
        this.okButtonText = okOption == null ? _AWU.T.ABSTRACTDIALOG_BUTTON_OK() : okOption;
        this.cancelButtonText = cancelOption == null ? _AWU.T.ABSTRACTDIALOG_BUTTON_CANCEL() : cancelOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _init() {
        this.layoutDialog();
        if (BinaryLogic.containsAll(this.flagMask, 4)) {
            this.timerLbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AbstractDialog.this.cancel();
                    AbstractDialog.this.timerLbl.removeMouseListener(this);
                }
            });
            this.timerLbl.setToolTipText(_AWU.T.TIMERDIALOG_TOOLTIP_TIMERLABEL());
            this.timerLbl.setIcon(DialogIcon.DIALOG_CANCEL.get(16));
        }
        ArrayList windowStack = null;
        InternDialog<T> dialog = null;
        try {
            Dimension preferredSize;
            this.setTitle(this.title);
            if (this.evaluateDontShowAgainFlag()) {
                return;
            }
            this.getDialog().setDefaultCloseOperation(0);
            this.getDialog().addWindowListener(this);
            this.defaultButtonFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    JRootPane root = SwingUtilities.getRootPane(e.getComponent());
                    if (root != null && e.getComponent() instanceof JButton) {
                        root.setDefaultButton((JButton)e.getComponent());
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    JRootPane root = SwingUtilities.getRootPane(e.getComponent());
                    if (root != null) {
                        root.setDefaultButton(null);
                    }
                }
            };
            this.okButton = this.createOkButton();
            this.cancelButton = new JButton(this.cancelButtonText);
            this.cancelButton.addFocusListener(this.defaultButtonFocusListener);
            this.okButton.addFocusListener(this.defaultButtonFocusListener);
            this.defaultButtons = this.getDefaultButtonPanel();
            JButton focus = null;
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            if (this.icon != null) {
                this.getDialog().setLayout(new MigLayout("ins 5,wrap 2", "[][grow,fill]", "[grow,fill][]"));
                this.getDialog().add((Component)this.getIconComponent(), this.getIconConstraints());
            } else {
                this.getDialog().setLayout(new MigLayout("ins 5,wrap 1", "[grow,fill]", "[grow,fill][]"));
            }
            this.panel = this.layoutDialogContent();
            this.getDialog().add((Component)this.panel, "");
            MigPanel bottom = this.createBottomPanel();
            bottom.setOpaque(false);
            bottom.add(this.timerLbl);
            if (BinaryLogic.containsAll(this.flagMask, 32)) {
                this.initDoNotShowAgainCheckbox(bottom);
            } else {
                bottom.add(Box.createHorizontalGlue());
            }
            bottom.add(this.defaultButtons);
            if ((this.flagMask & 8) == 0) {
                this.getDialog().getRootPane().setDefaultButton(this.okButton);
                this.okButton.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        JButton defaultButton;
                        JRootPane root;
                        if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }
                });
                focus = this.okButton;
                this.defaultButtons.addOKButton(this.okButton);
            }
            if (!BinaryLogic.containsAll(this.flagMask, 16)) {
                this.defaultButtons.addCancelButton(this.cancelButton);
                if (BinaryLogic.containsAll(this.flagMask, 8)) {
                    this.getDialog().getRootPane().setDefaultButton(this.cancelButton);
                    focus = this.cancelButton;
                }
            }
            this.addButtons(this.defaultButtons);
            this.initTimerLabel();
            this.getDialog().add((Component)bottom, "spanx,growx,pushx");
            this.getDialog().invalidate();
            this.getDialog().setResizable(this.isResizable());
            DialogDimensor dimensor = this.getDimensor();
            if (this.preferredSize != null) {
                preferredSize = this.preferredSize;
            } else {
                Dimension dimension = preferredSize = dimensor != null ? dimensor.getDimension(this) : null;
            }
            if (preferredSize == null && CrossSystem.isWindows()) {
                this.getDialog().getContentPane().addComponentListener(new ComponentListener(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                        Dimension size = AbstractDialog.this.getDialog().getSize();
                        AbstractDialog.this.getDialog().pack();
                        Dimension after = AbstractDialog.this.getDialog().getSize();
                        if (after.equals(size)) {
                            AbstractDialog.this.getDialog().getContentPane().removeComponentListener(this);
                        }
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }
                });
            }
            if (preferredSize != null) {
                this.getDialog().setPreferredSize(preferredSize);
            }
            this.pack();
            this.focusButton = focus;
            this.registerEscape();
            this.packed();
            Point location = null;
            DialogLocator locator = this.getLocator();
            if (locator != null) {
                try {
                    location = locator.getLocationOnScreen(this);
                }
                catch (Exception e) {
                    this.getLogger().log(e);
                }
            }
            if (location == null) {
                try {
                    location = LOCATE_CENTER_OF_SCREEN.getLocationOnScreen(this);
                }
                catch (Exception e) {
                    this.getLogger().log(e);
                }
            }
            if (location != null) {
                this.getDialog().setLocation(location);
            }
            this.getDialog().addComponentListener(new ComponentAdapter(){
                private boolean workaroundInstalled = false;

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (AbstractDialog.this.orgLocationOnScreen == null) {
                        try {
                            AbstractDialog.this.orgLocationOnScreen = AbstractDialog.this.getDialog().getLocationOnScreen();
                        }
                        catch (IllegalComponentStateException illegalComponentStateException) {
                            // empty catch block
                        }
                    }
                    if (AbstractDialog.this.orgLocationOnScreen != null && this.workaroundInstalled) {
                        AbstractDialog.this.getDialog().removeComponentListener(this);
                    }
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    try {
                        AbstractDialog.this.orgLocationOnScreen = AbstractDialog.this.getDialog().getLocationOnScreen();
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        // empty catch block
                    }
                    this.workaroundInstalled = true;
                    if (CrossSystem.isUnix()) {
                        AbstractDialog.this.getDialog().getContentPane().addComponentListener(new ComponentAdapter(){

                            @Override
                            public void componentResized(ComponentEvent e) {
                                Dimension size = AbstractDialog.this.getDialog().getSize();
                                AbstractDialog.this.getDialog().pack();
                                Dimension after = AbstractDialog.this.getDialog().getSize();
                                if (after.equals(size)) {
                                    AbstractDialog.this.getDialog().getContentPane().removeComponentListener(this);
                                }
                            }
                        });
                    } else if (CrossSystem.isMac()) {
                        AbstractDialog.this.getDialog().pack();
                    }
                    if (AbstractDialog.this.orgLocationOnScreen != null && this.workaroundInstalled) {
                        AbstractDialog.this.getDialog().removeComponentListener(this);
                    }
                }
            });
            dialog = this.getDialog();
            dialog.addWindowFocusListener(this);
            windowStack = AbstractDialog.getWindowStackByRoot(this.getDesiredRootFrame());
            windowStack.add(dialog);
            for (Window w : windowStack) {
                if (w != null) continue;
            }
            this.setVisible(true);
        }
        finally {
            int i;
            if (this.getDialog().getModalityType() != Dialog.ModalityType.MODELESS) {
                this.dispose();
            } else if (windowStack != null && dialog != null && (i = windowStack.lastIndexOf(dialog)) >= 0) {
                windowStack.remove(i);
                for (Window w : windowStack) {
                    if (w != null) continue;
                }
            }
        }
    }

    protected void initTimerLabel() {
        if (BinaryLogic.containsAll(this.flagMask, 4)) {
            this.initTimer();
        } else {
            this.timerLbl.setText(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.getLogger().fine("Answer: Button<OK:" + this.okButton.getText() + ">");
            this.setReturnmask(true);
        } else if (e.getSource() == this.cancelButton) {
            this.getLogger().fine("Answer: Button<CANCEL:" + this.cancelButton.getText() + ">");
            this.setReturnmask(false);
        }
        this.dispose();
    }

    protected void addButtons(JPanel buttonBar) {
    }

    public void cancel() {
        if (!this.isCountdownPausable()) {
            return;
        }
        this.stopTimer();
    }

    public boolean closeAllowed() {
        return true;
    }

    protected DefaultButtonPanel createBottomButtonPanel() {
        if (BUTTON_HEIGHT <= 0) {
            return this.createButtonPanelImpl("ins 0", "[]", "0[grow,fill]0");
        }
        return this.createButtonPanelImpl("ins 0", "[]", "0[grow,fill," + BUTTON_HEIGHT + "!]0");
    }

    protected DefaultButtonPanel createButtonPanelImpl(String ins, String columns, String rows) {
        return new DefaultButtonPanel(ins, columns, rows);
    }

    protected MigPanel createBottomPanel() {
        return new MigPanel("ins 0", "[]20[grow,fill][]", "[]");
    }

    protected JButton createOkButton() {
        return new JButton(this.getOKButtonText());
    }

    protected abstract T createReturnValue();

    public void displayDialog() {
        if (this.initialized) {
            this.getLogger().info("Already Initialized. Tried to re-display a dialog?");
            return;
        }
        this.getLogger().info("Display Dialog: " + this.getClass().getName() + ": " + this);
        this.initialized = true;
        this._init();
    }

    public void dispose() {
        if (this.dummyInit && this.dialog == null) {
            return;
        }
        if (!this.initialized) {
            throw new IllegalStateException("Dialog has not been initialized yet. call displayDialog()");
        }
        this.stopTimer();
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                WindowStack windowStack = AbstractDialog.getWindowStackByRoot(AbstractDialog.this.getDesiredRootFrame());
                int i = windowStack.lastIndexOf(AbstractDialog.this.getDialog());
                if (i >= 0) {
                    windowStack.remove(i);
                    for (Window w : windowStack) {
                        if (w != null) continue;
                    }
                    if (windowStack.size() > 0) {
                        Window lastActive = (Window)windowStack.get(windowStack.size() - 1);
                        lastActive.requestFocus();
                    }
                }
                if (AbstractDialog.this.isDisposed()) {
                    return;
                }
                AbstractDialog.this.setDisposed(true);
                if (AbstractDialog.this.getDialog().isVisible()) {
                    DialogLocator locator = AbstractDialog.this.getLocator();
                    if (locator != null) {
                        try {
                            locator.onClose(AbstractDialog.this, new WindowEvent(AbstractDialog.this.getDialog(), 201));
                        }
                        catch (Exception e) {
                            AbstractDialog.this.getLogger().log(e);
                        }
                    }
                    try {
                        DialogDimensor dimensor = AbstractDialog.this.getDimensor();
                        if (dimensor != null) {
                            dimensor.onClose(AbstractDialog.this, new WindowEvent(AbstractDialog.this.getDialog(), 201));
                        }
                    }
                    catch (Exception e) {
                        AbstractDialog.this.getLogger().log(e);
                    }
                }
                AbstractDialog.this.getDialog().setVisible(false);
                AbstractDialog.this.getDialog().realDispose();
                AbstractDialog.this.setDisposed(true);
            }
        };
    }

    public boolean evaluateDontShowAgainFlag() {
        String key;
        if (this.isDontShowAgainFlagEabled() && (key = this.getDontShowAgainKey()) != null) {
            try {
                int i = BinaryLogic.containsAll(this.flagMask, 2048) ? AbstractDialog.getSessionDontShowAgainValue(key) : JSonStorage.getPlainStorage("Dialogs").get(key, -1);
                if (i >= 0) {
                    int ret = i & 6;
                    if (BinaryLogic.containsAll(this.flagMask, 512) && BinaryLogic.containsAll(ret |= 0x18, 4)) {
                        return false;
                    }
                    if (BinaryLogic.containsAll(this.flagMask, 1024) && BinaryLogic.containsAll(ret, 2)) {
                        return false;
                    }
                    if (this.isDeveloperMode() && this.isDisposed() && this.returnBitMask != ret) {
                        throw new IllegalStateException("Dialog already disposed");
                    }
                    this.returnBitMask = ret;
                    return true;
                }
            }
            catch (Exception e) {
                this.getLogger().log(e);
            }
        }
        return false;
    }

    public void fillReturnMask(DialogClosedException e) {
        if (this.returnBitMask < 0) {
            this.returnBitMask = 0;
        }
        if (e.isCausedByClosed()) {
            this.returnBitMask |= 0x40;
        }
        if (e.isCausedbyESC()) {
            this.returnBitMask |= 4;
        }
        if (e.isCausedByInterrupt()) {
            this.returnBitMask |= 0x100;
        }
        if (e.isCausedByTimeout()) {
            this.returnBitMask |= 0x20;
        }
    }

    public void forceDummyInit() {
        if (Application.isHeadless()) {
            this.getLogger().info("Force Dummy Init");
            this.initialized = true;
            this.dummyInit = true;
        } else {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    AbstractDialog.this.getLogger().info("Force Dummy Init");
                    AbstractDialog.this.initialized = true;
                    AbstractDialog.this.dummyInit = true;
                }
            }.waitForEDT();
        }
    }

    protected Color getBackground() {
        return this.getDialog().getBackground();
    }

    @Override
    public String getCancelButtonText() {
        return this.cancelButtonText;
    }

    @Override
    public CloseReason getCloseReason() {
        int rm = this.getReturnmask();
        if (rm == 0) {
            throw new IllegalStateException("Dialog has not been closed yet");
        }
        if (BinaryLogic.containsSome(rm, 32)) {
            return CloseReason.TIMEOUT;
        }
        if (BinaryLogic.containsSome(rm, 256)) {
            return CloseReason.INTERRUPT;
        }
        if (BinaryLogic.containsSome(rm, 64)) {
            return CloseReason.CLOSE;
        }
        if (BinaryLogic.containsSome(rm, 4)) {
            return CloseReason.CANCEL;
        }
        if (BinaryLogic.containsSome(rm, 2)) {
            return CloseReason.OK;
        }
        throw new WTFException("Returnmask:" + rm);
    }

    public long getCountdown() {
        return this.getTimeout() > 0 ? (long)this.getTimeout() : (long)Dialog.getInstance().getDefaultTimeout();
    }

    protected DefaultButtonPanel getDefaultButtonPanel() {
        DefaultButtonPanel ret = this.createBottomButtonPanel();
        if (this.actions != null) {
            for (AbstractAction a : this.actions) {
                ret.addAction(a).addFocusListener(this.defaultButtonFocusListener);
            }
        }
        return ret;
    }

    protected Window getDesiredRootFrame() {
        return null;
    }

    public InternDialog<T> getDialog() {
        if (this.dialog == null) {
            throw new NullPointerException("Call #org.appwork.utils.swing.dialog.AbstractDialog.displayDialog() first");
        }
        return this.dialog;
    }

    public DialogDimensor getDimensor() {
        return this.dimensor;
    }

    public String getDontShowAgainKey() {
        return "ABSTRACTDIALOG_DONT_SHOW_AGAIN_" + this.getClass().getSimpleName() + "_" + this.toString();
    }

    protected String getDontShowAgainLabelText() {
        return _AWU.T.ABSTRACTDIALOG_STYLE_SHOW_DO_NOT_DISPLAY_AGAIN();
    }

    @Override
    public int getFlags() {
        return this.flagMask;
    }

    public Icon getIcon() {
        return this.icon;
    }

    protected JComponent getIconComponent() {
        this.iconLabel = new JLabel(this.icon);
        return this.iconLabel;
    }

    protected String getIconConstraints() {
        return "gapright 10,gaptop 2";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIconDataUrl() {
        if (this.getIcon() == null) {
            return null;
        }
        Base64OutputStream b64os = null;
        ByteArrayOutputStream bos = null;
        try {
            String ret;
            bos = new ByteArrayOutputStream();
            b64os = new Base64OutputStream(bos);
            ImageProvider.writeImage((RenderedImage)IconIO.convertIconToBufferedImage(this.getIcon()), "png", b64os);
            b64os.flush(true);
            String string = ret = "png;base64," + bos.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                b64os.close();
            }
            catch (Throwable throwable) {}
            try {
                bos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public List<? extends Image> getIconList() {
        return null;
    }

    public DialogLocator getLocator() {
        DialogLocator ret = this.locator;
        if (ret == null) {
            ret = DEFAULT_LOCATOR;
            if (ret != null) {
                return ret;
            }
            return LOCATE_CENTER_OF_SCREEN;
        }
        return ret;
    }

    public Dialog.ModalityType getModalityType() {
        return this.modalityType;
    }

    @Override
    public String getOKButtonText() {
        return this.okButtonText;
    }

    public Window getOwner() {
        return AbstractDialog.getGlobalOwnerFinder().findDialogOwner(this, AbstractDialog.getWindowStackByRoot(this.getDesiredRootFrame()));
    }

    protected int getPreferredHeight() {
        return this.preferredHeight;
    }

    public AbstractDialog<T> setPreferredHeight(int i) {
        this.preferredHeight = i;
        return this;
    }

    public AbstractDialog<T> setPreferredWidth(int i) {
        this.preferredWidth = i;
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension rawPreferredSize = this.getRawPreferredSize();
        int width = this.getPreferredWidth();
        int height = this.getPreferredHeight();
        if (width <= 0) {
            width = rawPreferredSize.width;
        }
        if (height <= 0) {
            height = rawPreferredSize.height;
        }
        if (this.getDialog().isPreferredSizeSet()) {
            height = Math.max(rawPreferredSize.height, height);
            width = Math.max(rawPreferredSize.width, width);
        }
        try {
            Dimension ret = new Dimension(Math.min(Toolkit.getDefaultToolkit().getScreenSize().width, width), Math.min(Toolkit.getDefaultToolkit().getScreenSize().height, height));
            return ret;
        }
        catch (Throwable e) {
            return rawPreferredSize;
        }
    }

    protected int getPreferredWidth() {
        return this.preferredWidth;
    }

    public Dimension getRawPreferredSize() {
        return this.getDialog().getRawPreferredSize();
    }

    public int getReturnmask() {
        if (!this.initialized) {
            throw new IllegalStateException("Dialog has not been initialized yet. call displayDialog()");
        }
        return this.returnBitMask;
    }

    public T getReturnValue() {
        if (!this.initialized) {
            throw new IllegalStateException("Dialog has not been initialized yet. call displayDialog()");
        }
        return this.createReturnValue();
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    protected NullsafeAtomicReference<AbstractTimerThread> getTimer() {
        return this.timer;
    }

    @Override
    public String getTitle() {
        try {
            if (this.dialog == null) {
                return this.title;
            }
            return this.getDialog().getTitle();
        }
        catch (NullPointerException e) {
            return this.title;
        }
    }

    protected WindowManager.FrameState getWindowStateOnVisible() {
        return ZHANDLER.getWindowStateOnVisible(this);
    }

    public boolean hasBeenMoved() {
        try {
            return this.orgLocationOnScreen != null && this.dialog != null && !this.getDialog().getLocationOnScreen().equals(this.orgLocationOnScreen);
        }
        catch (IllegalComponentStateException e) {
            return false;
        }
    }

    protected void initDoNotShowAgainCheckbox(MigPanel bottom) {
        this.dontshowagain = new JCheckBox(this.getDontShowAgainLabelText());
        this.dontshowagain.setHorizontalAlignment(11);
        this.dontshowagain.setHorizontalTextPosition(10);
        this.dontshowagain.setSelected(this.doNotShowAgainSelected);
        bottom.add((Component)this.dontshowagain, "alignx right");
    }

    protected void initFocus(JComponent focus) {
        Component focusOwner = this.getDialog().getFocusOwner();
        if (focusOwner != null) {
            return;
        }
        JComponent lastFocusRequestedJComponent = this.lastFocusRequestedJComponent;
        if (focus == null) {
            this.lastFocusRequestedJComponent = null;
            return;
        }
        if (lastFocusRequestedJComponent == focus) {
            return;
        }
        if (focus.requestFocusInWindow()) {
            this.lastFocusRequestedJComponent = focus;
        }
    }

    protected void initTimer() {
        AbstractTimerThread thread = new AbstractTimerThread(this);
        AbstractTimerThread oldThread = this.getTimer().getAndSet(thread);
        if (oldThread != null) {
            oldThread.interrupt();
        }
        thread.start();
    }

    public void interrupt() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (!AbstractDialog.this.isInitialized()) {
                    return;
                }
                if (AbstractDialog.this.isDisposed() && AbstractDialog.this.returnBitMask != 320 && AbstractDialog.this.isDeveloperMode()) {
                    throw new IllegalStateException("Dialog already disposed");
                }
                AbstractDialog.this.dispose();
                AbstractDialog.this.returnBitMask = 320;
            }
        };
    }

    public boolean isCallerIsEDT() {
        return this.callerIsEDT;
    }

    public boolean isCountdownFlagEnabled() {
        return BinaryLogic.containsAll(this.flagMask, 4);
    }

    public boolean isCountdownPausable() {
        return this.countdownPausable;
    }

    protected boolean isDeveloperMode() {
        return !Application.isJared(AbstractDialog.class);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isDontShowAgainFlagEabled() {
        return BinaryLogic.containsAll(this.flagMask, 32);
    }

    @Override
    public boolean isDontShowAgainSelected() {
        return this.isHiddenByDontShowAgain() || this.dontshowagain != null && this.dontshowagain.isSelected() && this.dontshowagain.isEnabled();
    }

    public boolean isHiddenByDontShowAgain() {
        if (this.dontshowagain != null && this.dontshowagain.isSelected() && this.dontshowagain.isEnabled()) {
            return false;
        }
        String key = this.getDontShowAgainKey();
        if (key == null) {
            return false;
        }
        int i = BinaryLogic.containsAll(this.flagMask, 2048) ? AbstractDialog.getSessionDontShowAgainValue(this.getDontShowAgainKey()) : JSonStorage.getPlainStorage("Dialogs").get(this.getDontShowAgainKey(), -1);
        return i >= 0;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean isVisible() {
        if (this.dialog == null) {
            return false;
        }
        return this.getDialog().isVisible();
    }

    protected void layoutDialog() {
        Dialog.getInstance().initLaf();
        Dialog.ModalityType modality = this.getModalityType();
        if (this.isCallerIsEDT()) {
            if (modality != Dialog.ModalityType.APPLICATION_MODAL) {
                LogV3.warning("Modeless Dialog from EDT -> Not possible. Reset to Application_modal");
            }
            modality = Dialog.ModalityType.APPLICATION_MODAL;
        }
        this.dialog = new InternDialog<T>(this, modality){

            @Override
            public void dispose() {
                try {
                    AbstractDialog.this.setDisposed(true);
                    AbstractDialog.this.dispose();
                }
                finally {
                    super.realDispose();
                }
            }
        };
        if (this.getDimensor() != null || this.getLocator() != null) {
            this.dialog.addComponentListener(this);
        }
        if (this.preferredSize != null) {
            this.dialog.setPreferredSize(this.preferredSize);
        }
        this.timerLbl = new JLabel(TimeFormatter.formatMilliSeconds(this.getCountdown(), 0));
        this.timerLbl.setEnabled(this.isCountdownPausable());
    }

    public abstract JComponent layoutDialogContent();

    public void onSetVisible(boolean b) {
        if (!b && this.getDialog().isVisible()) {
            DialogDimensor dimensor;
            DialogLocator locator = this.getLocator();
            if (locator != null) {
                try {
                    locator.onClose(this, null);
                }
                catch (Exception e) {
                    this.getLogger().log(e);
                }
            }
            if ((dimensor = this.getDimensor()) != null) {
                try {
                    dimensor.onClose(this, null);
                }
                catch (Exception e) {
                    this.getLogger().log(e);
                }
            }
        }
    }

    public void onTimeout() {
        this.setReturnmask(false);
        if (this.isDeveloperMode() && this.isDisposed()) {
            throw new IllegalStateException("Dialog is already Disposed");
        }
        this.returnBitMask |= 0x20;
        this.dispose();
    }

    public void pack() {
        if (!this.getDialog().isMinimumSizeSet()) {
            Dimension rawPreferredSize = this.getRawPreferredSize();
            Dimension preferredSize = this.getDialog().getPreferredSize();
            if (rawPreferredSize != null && preferredSize != null && rawPreferredSize.height < preferredSize.height && rawPreferredSize.width < preferredSize.width) {
                this.getDialog().setMinimumSize(rawPreferredSize);
            }
        }
        this.getDialog().pack();
    }

    protected void packed() {
    }

    protected JComponent getFocusButton() {
        return this.focusButton;
    }

    protected void registerEscape() {
        JComponent focusButton = this.getFocusButton();
        if (focusButton != null) {
            KeyStroke ks = KeyStroke.getKeyStroke("ESCAPE");
            focusButton.getInputMap().put(ks, "ESCAPE");
            focusButton.getInputMap(1).put(ks, "ESCAPE");
            focusButton.getInputMap(2).put(ks, "ESCAPE");
            focusButton.getActionMap().put("ESCAPE", new AbstractAction(){
                private static final long serialVersionUID = -6666144330707394562L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AbstractDialog.this.isDisposed()) {
                        return;
                    }
                    AbstractDialog.this.getLogger().fine("Answer: Key<ESCAPE>");
                    AbstractDialog.this.setReturnmask(false);
                    AbstractDialog.this.returnBitMask |= 0x80;
                    AbstractDialog.this.dispose();
                }
            });
        }
    }

    protected void registerEscape(JComponent contentpane) {
        this.focusButton = contentpane;
        this.registerEscape();
    }

    public void resetDummyInit() {
        if (Application.isHeadless()) {
            this.getLogger().info("Reset Dummy Info");
            this.initialized = false;
            this.dummyInit = false;
        } else {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    AbstractDialog.this.getLogger().info("Reset Dummy Info");
                    AbstractDialog.this.initialized = false;
                    AbstractDialog.this.dummyInit = false;
                }
            }.waitForEDT();
        }
    }

    public void resetTimer() {
        AbstractTimerThread lTimer = this.getTimer().get();
        if (lTimer != null) {
            lTimer.reset();
        }
    }

    protected void setAlwaysOnTop(boolean b) {
        this.getDialog().setAlwaysOnTop(b);
    }

    public void setCallerIsEDT(boolean b) {
        this.callerIsEDT = b;
    }

    @Override
    public void setCloseReason(CloseReason closeReason) {
        throw new WTFException("Not implemented");
    }

    public void setCountdownPausable(final boolean b) {
        this.countdownPausable = b;
        Thread ltimer = this.timer.get();
        if (ltimer != null && ltimer.isAlive()) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    AbstractDialog.this.timerLbl.setEnabled(b);
                }
            };
        }
    }

    @Deprecated
    public void setCountdownTime(int countdownTimeInSeconds) {
        this.timeout = countdownTimeInSeconds * 1000;
    }

    protected void setDefaultCloseOperation(int doNothingOnClose) {
        this.getDialog().setDefaultCloseOperation(doNothingOnClose);
    }

    public void setDimensor(DialogDimensor dimensor) {
        this.dimensor = dimensor;
    }

    protected void setDisposed(boolean b) {
        try {
            if (this.disposeCallBack != null) {
                this.disposeCallBack.dialogDisposed(this);
            }
        }
        finally {
            this.disposed = b;
        }
    }

    public void setDisposedCallback(DisposeCallBack disposeCallBack) {
        this.disposeCallBack = disposeCallBack;
    }

    public void setDoNotShowAgainSelected(boolean b) {
        if (!BinaryLogic.containsAll(this.flagMask, 32)) {
            throw new IllegalStateException("You have to set the Dialog.STYLE_SHOW_DO_NOT_DISPLAY_AGAIN flag to use this method");
        }
        this.doNotShowAgainSelected = b;
    }

    public void setIcon(final Icon icon) {
        this.icon = icon;
        if (this.iconLabel != null) {
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    AbstractDialog.this.iconLabel.setIcon(icon);
                }
            };
        }
    }

    public void setInterrupted() {
        if (this.isDeveloperMode() && this.isDisposed()) {
            throw new IllegalStateException("Dialog already disposed");
        }
        this.returnBitMask |= 0x100;
    }

    public void setLeftActions(AbstractAction ... abstractActions) {
        this.actions = abstractActions;
    }

    public void setLocator(DialogLocator locator) {
        this.locator = locator;
    }

    protected void setMinimumSize(Dimension dimension) {
        this.getDialog().setMinimumSize(dimension);
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
        if (this.dialog != null) {
            this.getDialog().setPreferredSize(dimension);
        }
    }

    protected void setResizable(boolean b) {
        this.getDialog().setResizable(b);
    }

    protected void setReturnmask(boolean b) {
        int ret;
        int n = ret = b ? 2 : 4;
        if (BinaryLogic.containsAll(this.flagMask, 32)) {
            boolean isDontShowAgainSelected = this.dontshowagain != null && this.dontshowagain.isSelected() && this.dontshowagain.isEnabled();
            ret = this.writeDontShowAgainAnswer(b, isDontShowAgainSelected);
        }
        if (ret == this.returnBitMask) {
            return;
        }
        if (this.isDeveloperMode() && this.isDisposed()) {
            throw new IllegalStateException("Dialog already disposed");
        }
        this.returnBitMask = ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeDontShowAgainAnswer(boolean clickedOK, boolean isDontShowAgainSelected) {
        int ret;
        block9: {
            int n = ret = clickedOK ? 2 : 4;
            if (isDontShowAgainSelected) {
                ret |= 8;
                if (BinaryLogic.containsAll(this.flagMask, 512) && !clickedOK) {
                    return ret;
                }
                if (BinaryLogic.containsAll(this.flagMask, 1024) && clickedOK) {
                    return ret;
                }
                try {
                    String key = this.getDontShowAgainKey();
                    if (key == null) break block9;
                    if (BinaryLogic.containsAll(this.flagMask, 2048)) {
                        HashMap<String, Integer> hashMap = SESSION_DONTSHOW_AGAIN;
                        synchronized (hashMap) {
                            SESSION_DONTSHOW_AGAIN.put(this.getDontShowAgainKey(), ret);
                            break block9;
                        }
                    }
                    JSonStorage.getPlainStorage("Dialogs").put(this.getDontShowAgainKey(), ret);
                }
                catch (Exception e) {
                    this.getLogger().log(e);
                }
            }
        }
        return ret;
    }

    public void setTimeout(int countdownTimeInMs) {
        this.timeout = countdownTimeInMs;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.dialog != null) {
            this.getDialog().setTitle(title);
        }
    }

    public void setVisible(final boolean b) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                WindowManager.getInstance().setVisible(AbstractDialog.this.getDialog(), b, AbstractDialog.this.getWindowStateOnVisible());
            }
        };
    }

    public UserIODefinition show() {
        AbstractDialog ret = UIOManager.I().show(UserIODefinition.class, this);
        return ret;
    }

    public void stopTimer() {
        Thread ltimer = this.getTimer().getAndSet(null);
        if (ltimer != null) {
            ltimer.interrupt();
            new EDTRunner(){

                @Override
                protected void runInEDT() {
                    AbstractDialog.this.timerLbl.setEnabled(false);
                }
            };
        }
    }

    @Override
    public void throwCloseExceptions() throws DialogClosedException, DialogCanceledException {
        int mask = this.getReturnmask();
        if (BinaryLogic.containsSome(mask, 64)) {
            throw new DialogClosedException(mask);
        }
        if (BinaryLogic.containsSome(mask, 4)) {
            throw new DialogCanceledException(mask);
        }
    }

    public String toString() {
        return ("dialog-" + this.getTitle()).replaceAll("\\W", "_");
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this.closeAllowed()) {
            this.getLogger().fine("Answer: Button<[X]>");
            if (this.isDeveloperMode() && this.isDisposed()) {
                throw new IllegalStateException("Dialog already disposed");
            }
            this.returnBitMask |= 0x40;
            this.dispose();
        } else {
            this.getLogger().fine("(Answer: Tried [X] bot not allowed)");
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.initFocus(this.getFocusButton());
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public String formatCountdown(long currentTimeout) {
        return TimeFormatter.formatMilliSeconds(currentTimeout, 0);
    }

    public boolean isExpired(long currentTimeout) {
        return currentTimeout < 0L;
    }

    static {
        OWNER_FINDER = DEFAULT_OWNER_FINDER = new OwnerFinder(){

            @Override
            public Window findDialogOwner(AbstractDialog<?> dialogModel, WindowStack windowStack) {
                for (int i = windowStack.size() - 1; i >= 0; ++i) {
                    Window ret = (Window)windowStack.get(i);
                    if (!(ret instanceof Frame) && !(ret instanceof java.awt.Dialog)) continue;
                    return ret;
                }
                return null;
            }
        };
        ZHANDLER = new BasicZHandler();
        STACK_MAP = new WeakHashMap();
        NULL_KEY = new Object();
    }
}

