/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.singleapp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.loggingv3.LogV3;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownRunableEvent;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.net.ChunkedInputStream;
import org.appwork.utils.net.ChunkedOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.singleapp.AnotherInstanceRunningButFailedToConnectException;
import org.appwork.utils.singleapp.AnotherInstanceRunningException;
import org.appwork.utils.singleapp.ExceptionInRunningInstance;
import org.appwork.utils.singleapp.FailedToSendResponseException;
import org.appwork.utils.singleapp.IncommingMessageListener;
import org.appwork.utils.singleapp.Response;
import org.appwork.utils.singleapp.ResponseListener;
import org.appwork.utils.singleapp.ResponseSender;
import org.appwork.utils.singleapp.UncheckableInstanceException;

public class SingleAppInstance {
    public static final String MISSING_DONE_RESPONSE_SERVER_SHUT_DOWN = "Missing DONE Response. Server shut down?";
    public static final String GO_AWAY_BYE = "INTERNAL_BYE";
    public static final String GO_AWAY_INVALID_ID = "INTERNAL_INVALID_ID";
    public static final String DONE = "INTERNAL_DONE";
    public static final String KEEP_ALIVE = "INTERNAL_KEEP_ALIVE";
    public static final String EXCEPTION = "INTERNAL_EXCEPTION";
    public static final String NEWLINE = "\r\n";
    private final String appID;
    private volatile IncommingMessageListener listener = null;
    private final File lockFile;
    private FileLock fileLock = null;
    private FileChannel lockChannel = null;
    private boolean alreadyUsed = false;
    private ServerSocket serverSocket = null;
    protected final String singleApp = "SingleAppInstance";
    private final AtomicReference<Thread> daemon = new AtomicReference<Object>(null);
    private static final int DEFAULTPORT = 9665;
    private boolean forwardMessageDirectIfNoOtherInstanceIsFound = true;
    private InetSocketAddress address;
    private int port = -1;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Map<Socket, ClientConnection> connections = new HashMap<Socket, ClientConnection>();

    public boolean isForwardMessageDirectIfNoOtherInstanceIsFound() {
        return this.forwardMessageDirectIfNoOtherInstanceIsFound;
    }

    public void setForwardMessageDirectIfNoOtherInstanceIsFound(boolean forwardMessageDirectIfNoOtherInstanceIsFound) {
        this.forwardMessageDirectIfNoOtherInstanceIsFound = forwardMessageDirectIfNoOtherInstanceIsFound;
    }

    public SingleAppInstance(String appID, IncommingMessageListener listenr) {
        this(appID, new File(Application.getHome()), listenr);
    }

    public SingleAppInstance(String appID, File directory, IncommingMessageListener listenr) {
        this.appID = appID;
        directory.mkdirs();
        this.lockFile = new File(directory, appID + ".lock");
        this.listener = listenr;
    }

    public IncommingMessageListener getListener() {
        return this.listener;
    }

    public void setListener(IncommingMessageListener listener) {
        this.listener = listener;
    }

    private synchronized void cannotStart(Throwable cause) throws UncheckableInstanceException {
        this.closeLock();
        throw new UncheckableInstanceException(cause);
    }

    public synchronized Thread exit() {
        return this.exit(false);
    }

    public synchronized Thread exit(boolean closeClientConnections) {
        if (this.fileLock == null) {
            if (closeClientConnections) {
                this.closeAllConnections();
            }
            return null;
        }
        Thread daemon = this.daemon.getAndSet(null);
        if (daemon != null) {
            daemon.interrupt();
        }
        try {
            this.closeServer();
            this.closeLock();
        }
        finally {
            this.deleteLockFile(1000);
        }
        if (closeClientConnections) {
            this.closeAllConnections();
        }
        return daemon;
    }

    protected boolean deleteLockFile(int maxWaitMs) {
        File lockFile = this.lockFile;
        if (lockFile.exists() && !lockFile.delete()) {
            for (int waitLockFileDelete = maxWaitMs; lockFile.exists() && waitLockFileDelete > 0; waitLockFileDelete -= 10) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        return lockFile.exists();
    }

    public synchronized boolean isRunning() {
        return this.serverSocket != null && !this.serverSocket.isClosed();
    }

    private synchronized void closeServer() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private synchronized void closeLock() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.fileLock = null;
            }
        }
        if (this.lockChannel != null) {
            try {
                this.lockChannel.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.lockChannel = null;
            }
        }
    }

    private synchronized void foundRunningInstanceAndFailedToConnect() {
        this.closeLock();
    }

    protected InetAddress getLocalHost() throws UnknownHostException {
        return HTTPConnectionUtils.getLoopback(HTTPConnectionUtils.IPVERSION.IPV4_IPV6)[0];
    }

    protected String readLine(BufferedInputStream in) throws IOException, InterruptedException {
        int read;
        if (in == null) {
            return "";
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        in.mark(1);
        if (in.read() == -1) {
            return null;
        }
        in.reset();
        while ((read = in.read()) >= 0) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (read == 0 || read == 10 || read == 13) break;
            buf.write(read);
        }
        if (read == 13) {
            in.mark(1);
            if (in.read() != 10) {
                in.reset();
            }
        }
        return this.unescapeLine(new String(buf.toByteArray(), 0, buf.size(), UTF8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readPortFromPortFile() throws IOException {
        try {
            int retry = 10;
            while (retry-- >= 0) {
                String port;
                FileInputStream fis = new FileInputStream(this.lockFile);
                try {
                    fis.getChannel().position(1L);
                    byte[] bytes = IO.readStream(-1, fis);
                    port = new String(bytes, UTF8);
                }
                finally {
                    fis.close();
                }
                if (port.matches("(?s)^\\s*\\d+\\s+.*")) {
                    String firstPortLine = port.split(NEWLINE)[0];
                    return Integer.parseInt(String.valueOf(firstPortLine).trim());
                }
                Thread.sleep(100L);
            }
            throw new NoPortFileException("Invalid PortFile:" + this.lockFile);
        }
        catch (FileNotFoundException e) {
            throw new NoPortFileException("PortFile does not exist:" + this.lockFile, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NoPortFileException(e);
        }
        catch (NoPortFileException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NoPortFileException("Failed to parse PortFile:" + this.lockFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToRunningInstance(ResponseListener callback, String ... message) throws IOException, ErrorReadingResponseException, InvalidResponseID, NoPortFileException, InterruptedException, ExceptionInRunningInstance {
        InetSocketAddress con = this.getAddress();
        if (con != null) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(con, 5000);
                socket.setSoTimeout(this.getReadtimeoutForReadingResponses());
                ChunkedInputStream chunkedIn = new ChunkedInputStream(socket.getInputStream());
                ChunkedOutputStream chunkedOut = new ChunkedOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                BufferedInputStream bufferedIn = new BufferedInputStream(chunkedIn);
                this.writeLine(chunkedOut, this.getClientID());
                if (message == null || message.length == 0) {
                    this.writeLine(chunkedOut, "0");
                } else {
                    this.writeLine(chunkedOut, message.length + "");
                    if (callback != null) {
                        callback.onConnected(message);
                    }
                    for (String msg : message) {
                        this.writeLine(chunkedOut, msg);
                    }
                }
                try {
                    chunkedOut.sendEOF();
                    socket.shutdownOutput();
                    boolean done = this.readResponses(callback, bufferedIn);
                    if (!done) {
                        throw new ErrorReadingResponseException(MISSING_DONE_RESPONSE_SERVER_SHUT_DOWN);
                    }
                }
                catch (ErrorReadingResponseException e) {
                    throw e;
                }
                catch (InvalidResponseID e) {
                    throw e;
                }
                catch (IOException e) {
                    throw new ErrorReadingResponseException(e);
                }
                try {
                    String line = null;
                    while ((line = this.readLine(bufferedIn)) != null) {
                        this.onIncommingTrailingMessage(line);
                    }
                }
                catch (IOException ignore) {
                    ignore.printStackTrace();
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.shutdownInput();
                    }
                    catch (Throwable throwable) {}
                    try {
                        socket.shutdownOutput();
                    }
                    catch (Throwable throwable) {}
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public boolean readResponses(ResponseListener callback, BufferedInputStream in) throws InterruptedException, IOException, ExceptionInRunningInstance {
        ExceptionInRunningInstance exception = null;
        boolean done = false;
        while (true) {
            String responseMessage;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            String type = this.readLine(in);
            if (type == null || (responseMessage = this.readLine(in)) == null) break;
            Response response = new Response(type, responseMessage);
            if (GO_AWAY_BYE.equals(response.getType())) {
                done = true;
                break;
            }
            if (GO_AWAY_INVALID_ID.equals(response.getType())) {
                throw new InvalidResponseID(response.getMessage());
            }
            if (DONE.equals(response.getType())) {
                done = true;
                break;
            }
            if (KEEP_ALIVE.equals(response.getType())) continue;
            if (EXCEPTION.equals(response.getType())) {
                exception = new ExceptionInRunningInstance(response.getMessage());
                continue;
            }
            if (callback == null) continue;
            callback.onReceivedResponse(response);
        }
        if (exception != null) {
            throw exception;
        }
        return done;
    }

    protected InetSocketAddress getAddress() throws IOException {
        if (this.address == null && this.port != 0) {
            this.address = new InetSocketAddress(this.getLocalHost(), this.port);
        }
        return this.address;
    }

    protected int getReadtimeoutForReadingResponses() {
        return 5000;
    }

    protected int getReadtimeoutForReadingIncommingMessages() {
        return 5000;
    }

    protected String createID(String singleApp, String appID, String root) {
        return singleApp + "." + appID + "." + root;
    }

    public synchronized void start() throws AnotherInstanceRunningException, UncheckableInstanceException, AnotherInstanceRunningButFailedToConnectException, ErrorReadingResponseException, InterruptedException, ExceptionInRunningInstance {
        this.start(null, null);
    }

    public synchronized void start(final ResponseListener responseListener, String ... message) throws AnotherInstanceRunningException, UncheckableInstanceException, AnotherInstanceRunningButFailedToConnectException, ErrorReadingResponseException, InterruptedException, ExceptionInRunningInstance {
        if (this.fileLock != null) {
            return;
        }
        if (this.alreadyUsed) {
            this.cannotStart(new IllegalStateException("create new instance!"));
        }
        this.alreadyUsed = true;
        try {
            try {
                this.port = this.readPortFromPortFile();
                this.sendToRunningInstance(responseListener, message);
                throw new AnotherInstanceRunningException(this.appID);
            }
            catch (ErrorReadingResponseException e) {
                throw e;
            }
            catch (NoPortFileException e) {
            }
            catch (GoAwayException e) {
                throw new AnotherInstanceRunningButFailedToConnectException(this.appID, e);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.lockChannel = new RandomAccessFile(this.lockFile, "rw").getChannel();
            boolean closeLockFlag = true;
            try {
                this.fileLock = this.lockChannel.tryLock(0L, 1L, false);
                if (this.fileLock == null) {
                    throw new AnotherInstanceRunningButFailedToConnectException(this.appID);
                }
                closeLockFlag = false;
            }
            catch (OverlappingFileLockException e) {
                throw new AnotherInstanceRunningButFailedToConnectException(this.appID, e);
            }
            catch (IOException e) {
                throw new AnotherInstanceRunningButFailedToConnectException(this.appID, e);
            }
            finally {
                if (closeLockFlag) {
                    this.foundRunningInstanceAndFailedToConnect();
                }
            }
            InetAddress localHost = this.getLocalHost();
            this.serverSocket = new ServerSocket();
            InetSocketAddress socketAddress = null;
            try {
                if (this.port <= 0) {
                    this.port = 9665;
                }
                socketAddress = new InetSocketAddress(localHost, this.port);
                this.serverSocket.bind(socketAddress);
            }
            catch (IOException e) {
                try {
                    this.serverSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.serverSocket = new ServerSocket();
                socketAddress = new InetSocketAddress(localHost, 0);
                this.serverSocket.bind(socketAddress);
            }
            try {
                this.port = this.serverSocket.getLocalPort();
                this.onServerOpened(this.serverSocket);
                byte[] portStringBytes = (" " + this.port + NEWLINE).getBytes(UTF8);
                this.lockChannel.position(0L);
                this.lockChannel.write(ByteBuffer.wrap(portStringBytes));
                this.lockChannel.force(true);
                this.lockFile.deleteOnExit();
                ShutdownController.getInstance().addShutdownEvent(new ShutdownRunableEvent(new ShutdownHook(this)));
                this.startDaemon();
                IncommingMessageListener listener = this.getListener();
                if (listener != null && responseListener != null && this.isForwardMessageDirectIfNoOtherInstanceIsFound()) {
                    listener.onIncommingMessage(new ResponseSender(){

                        @Override
                        public void sendResponse(Response response) {
                            responseListener.onReceivedResponse(response);
                        }
                    }, message);
                }
                return;
            }
            catch (Throwable t) {
                this.cannotStart(t);
            }
        }
        catch (FileNotFoundException e) {
            this.cannotStart(e);
        }
        catch (ErrorReadingResponseException e) {
            throw e;
        }
        catch (IOException e) {
            try {
                this.serverSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cannotStart(e);
        }
    }

    protected void onServerOpened(ServerSocket serverSocket2) {
    }

    private synchronized void startDaemon() {
        Thread daemon = this.daemon.get();
        if (daemon != null && daemon.isAlive()) {
            return;
        }
        daemon = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (Thread.currentThread() == SingleAppInstance.this.daemon.get()) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        try {
                            final Socket client = SingleAppInstance.this.serverSocket.accept();
                            Thread thread = new Thread("SingleAppInstanceClient: " + SingleAppInstance.this.appID + " - " + client.getRemoteSocketAddress()){
                                {
                                    super(x0);
                                    this.setDaemon(true);
                                }

                                @Override
                                public void run() {
                                    try {
                                        SingleAppInstance.this.handleIncommingConnection(client);
                                    }
                                    catch (InterruptedException e) {
                                        DebugMode.breakIf(true, "It is actually not possble to reach this code");
                                        LogV3.log(e);
                                    }
                                    catch (Throwable e) {
                                        SingleAppInstance.this.onUncaughtExceptionDuringHandlingIncommingConnections(e);
                                    }
                                }
                            };
                            thread.start();
                            SingleAppInstance.this.onNewIncommingConnection(client, thread);
                        }
                        catch (IOException e) {
                            if (Thread.currentThread() == SingleAppInstance.this.daemon.get()) continue;
                        }
                    }
                    return;
                }
                finally {
                    SingleAppInstance.this.closeServer();
                    SingleAppInstance singleAppInstance = SingleAppInstance.this;
                    synchronized (singleAppInstance) {
                        SingleAppInstance.this.daemon.compareAndSet(Thread.currentThread(), null);
                    }
                }
            }
        });
        daemon.setName("SingleAppInstanceServer: " + this.appID);
        daemon.setDaemon(true);
        this.daemon.set(daemon);
        daemon.start();
    }

    protected void onNewIncommingConnection(Socket client, Thread thread) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLine(OutputStream outputStream, String line) throws IOException {
        if (outputStream != null) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                outputStream.write(this.escapeLine(line).getBytes(UTF8));
                outputStream.write(NEWLINE.getBytes(UTF8));
                outputStream.flush();
            }
        }
    }

    protected String unescapeLine(String message) {
        if (message == null || "null".equals(message)) {
            return null;
        }
        return new String(HexFormatter.hexToByteArray(message), UTF8);
    }

    protected String escapeLine(String responseMessage) {
        if (responseMessage == null) {
            return "null";
        }
        return HexFormatter.byteArrayToHex(responseMessage.getBytes(UTF8));
    }

    protected void onUncaughtExceptionDuringHandlingIncommingConnections(Throwable e) {
        LogV3.log(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(OutputStream out, Response response) throws IOException {
        if (out != null && response != null) {
            String type = response.getType();
            String responseMessage = response.getMessage();
            OutputStream outputStream = out;
            synchronized (outputStream) {
                this.writeLine(out, type);
                this.writeLine(out, responseMessage);
            }
        }
    }

    protected ClientConnection buildConnection(Socket socket) throws IOException {
        socket.setSoTimeout(this.getReadtimeoutForReadingIncommingMessages());
        return new ClientConnection(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void handleIncommingConnection(Socket socket) throws InterruptedException, IOException {
        var2_2 = this.connections;
        synchronized (var2_2) {
            this.connections.put(socket, null);
        }
        client = this.buildConnection(socket);
        var3_10 = this.connections;
        synchronized (var3_10) {
            if (this.connections.containsKey(socket)) {
                this.connections.put(socket, (ClientConnection)client);
            }
        }
        clientID = client.readLine();
        if (!StringUtils.equals(clientID, this.getServerID())) {
            client.sendResponse(new Response("INTERNAL_INVALID_ID", "Bad clientID"));
        } else {
            line = client.readLine();
            message = null;
            if (line != null && line.length() > 0) {
                if (line.matches("^\\d+$")) {
                    try {
                        lines = Integer.parseInt(line);
                        if (lines == 0) ** GOTO lbl57
                        message = new String[lines];
                        for (index = 0; index < lines; ++index) {
                            message[index] = client.readLine();
                        }
                        listener = this.getListener();
                        if (listener == null) ** GOTO lbl57
                        try {
                            keepAliveThread = new Thread("SingleInstance KeepAlive: " + this.appID, (ClientConnection)client){
                                final /* synthetic */ ClientConnection val$client;
                                {
                                    this.val$client = clientConnection;
                                    super(x0);
                                    this.setDaemon(true);
                                }

                                @Override
                                public void run() {
                                    while (!this.val$client.isOutputShutdown()) {
                                        try {
                                            Thread.sleep(SingleAppInstance.this.getReadtimeoutForReadingResponses() - 1000);
                                        }
                                        catch (InterruptedException e) {
                                            return;
                                        }
                                        try {
                                            this.val$client.sendResponse(new Response(SingleAppInstance.KEEP_ALIVE, String.valueOf(Time.now())));
                                        }
                                        catch (IOException e) {
                                            return;
                                        }
                                    }
                                }
                            };
                            keepAliveThread.start();
                            try {
                                listener.onIncommingMessage(new ResponseSender((ClientConnection)client){
                                    final /* synthetic */ ClientConnection val$client;
                                    {
                                        this.val$client = clientConnection;
                                    }

                                    @Override
                                    public void sendResponse(Response response) throws FailedToSendResponseException {
                                        if (SingleAppInstance.GO_AWAY_BYE.equals(response.getType())) {
                                            throw new InvalidParameterException("INTERNAL_BYE is reserved for internal usage");
                                        }
                                        if (SingleAppInstance.GO_AWAY_INVALID_ID.equals(response.getType())) {
                                            throw new InvalidParameterException("INTERNAL_INVALID_ID is reserved for internal usage");
                                        }
                                        if (SingleAppInstance.KEEP_ALIVE.equals(response.getType())) {
                                            throw new InvalidParameterException("INTERNAL_KEEP_ALIVE is reserved for internal usage");
                                        }
                                        if (SingleAppInstance.EXCEPTION.equals(response.getType())) {
                                            throw new InvalidParameterException("INTERNAL_EXCEPTION is reserved for internal usage");
                                        }
                                        if (SingleAppInstance.DONE.equals(response.getType())) {
                                            throw new InvalidParameterException("INTERNAL_DONE is reserved for internal usage");
                                        }
                                        try {
                                            this.val$client.sendResponse(response);
                                        }
                                        catch (IOException e) {
                                            throw new FailedToSendResponseException(response, e);
                                        }
                                    }
                                }, message);
                            }
                            finally {
                                keepAliveThread.interrupt();
                            }
                        }
                        catch (Throwable e) {
                            client.sendResponse(new Response("INTERNAL_EXCEPTION", Exceptions.getStackTrace(e)));
                        }
                    }
                    finally {
                        client.sendResponse(new Response("INTERNAL_DONE"));
                    }
                } else {
                    this.onIncommingInvalidMessage(line);
                    while ((line = client.readLine()) != null) {
                        this.onIncommingInvalidMessage(line);
                    }
                }
            }
        }
lbl57:
        // 9 sources

        client.shutdownOutput();
        line = null;
        while ((line = client.readLine()) != null) {
            this.onIncommingTrailingMessage(line);
        }
        try {
            socket.close();
        }
        catch (IOException client) {
            client = this.connections;
            synchronized (client) {
                this.connections.remove(socket);
            }
        }
        finally {
            client = this.connections;
            synchronized (client) {
                this.connections.remove(socket);
            }
        }
        catch (IOException e) {
            try {
                var3_11 = this.connections;
                synchronized (var3_11) {
                    if (this.connections.containsKey(socket)) {
                        throw e;
                    }
                }
            }
            catch (Throwable var22_34) {
                try {
                    socket.close();
                }
                catch (IOException var23_36) {
                    var23_37 = this.connections;
                    synchronized (var23_37) {
                        this.connections.remove(socket);
                    }
                }
                finally {
                    var23_35 = this.connections;
                    synchronized (var23_35) {
                        this.connections.remove(socket);
                    }
                }
                throw var22_34;
            }
            try {
                socket.close();
            }
            catch (IOException var2_7) {
                var2_8 = this.connections;
                synchronized (var2_8) {
                    this.connections.remove(socket);
                }
            }
            finally {
                var2_6 = this.connections;
                synchronized (var2_6) {
                    this.connections.remove(socket);
                }
            }
        }
    }

    protected void onIncommingInvalidMessage(String message) {
        LogV3.info("invalid SingleAppInstanceClient message:" + message);
    }

    protected void onIncommingTrailingMessage(String message) {
        LogV3.info("trailing Message:" + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections() {
        while (true) {
            ClientConnection client;
            Socket socket;
            Map<Socket, ClientConnection> map = this.connections;
            synchronized (map) {
                if (this.connections.size() == 0) {
                    break;
                }
                Iterator<Map.Entry<Socket, ClientConnection>> it = this.connections.entrySet().iterator();
                Map.Entry<Socket, ClientConnection> next = it.next();
                socket = next.getKey();
                client = next.getValue();
                it.remove();
            }
            if (socket == null) continue;
            boolean closeSocket = true;
            if (client != null) {
                try {
                    closeSocket = this.closeConnection(client);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!closeSocket) continue;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean closeConnection(ClientConnection client) throws IOException {
        client.sendResponse(new Response(GO_AWAY_BYE));
        client.shutdownOutput();
        return true;
    }

    public String getClientID() {
        return this.createID("SingleAppInstance", this.appID, Application.getRoot(SingleAppInstance.class));
    }

    public String getServerID() {
        return this.createID("SingleAppInstance", this.appID, Application.getRoot(SingleAppInstance.class));
    }

    public int getPort() {
        return this.port;
    }

    protected class ClientConnection {
        private final Socket socket;
        private final BufferedInputStream bufferedIn;
        private final ChunkedInputStream chunkedIn;
        private final ChunkedOutputStream chunkedOut;

        protected ClientConnection(Socket socket) throws IOException {
            this.socket = socket;
            this.chunkedIn = new ChunkedInputStream(socket.getInputStream());
            this.chunkedOut = new ChunkedOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.bufferedIn = new BufferedInputStream(this.chunkedIn);
        }

        public String readLine() throws IOException, InterruptedException {
            return SingleAppInstance.this.readLine(this.bufferedIn);
        }

        public void sendResponse(Response response) throws IOException {
            SingleAppInstance.this.sendResponse(this.chunkedOut, response);
        }

        public boolean isOutputShutdown() {
            return this.socket.isOutputShutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownOutput() throws IOException {
            ChunkedOutputStream chunkedOutputStream = this.chunkedOut;
            synchronized (chunkedOutputStream) {
                this.chunkedOut.sendEOF();
            }
            this.socket.shutdownOutput();
        }
    }

    public static class ErrorReadingResponseException
    extends IOException {
        public ErrorReadingResponseException(IOException e) {
            super(e);
        }

        public ErrorReadingResponseException(String string) {
            super(string);
        }
    }

    private static class ShutdownHook
    implements Runnable {
        private final SingleAppInstance instance;

        public ShutdownHook(SingleAppInstance instance) {
            this.instance = instance;
        }

        @Override
        public void run() {
            if (this.instance != null) {
                this.instance.exit();
            }
        }
    }

    public static class NoPortFileException
    extends IOException {
        public NoPortFileException(String message) {
            super(message);
        }

        public NoPortFileException(Throwable e) {
            super(e);
        }

        public NoPortFileException(String message, Throwable e) {
            super(message, e);
        }
    }

    public static class InvalidResponseID
    extends GoAwayException {
        public InvalidResponseID(String message) {
            super(message);
        }
    }

    public static class GoAwayException
    extends IOException {
        public GoAwayException(String message) {
            super(message);
        }
    }
}

