/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.parser;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.KeyValueStringEntry;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.net.URLHelper;

public class UrlQuery {
    private final List<KeyValueStringEntry> list = new ArrayList<KeyValueStringEntry>();

    public static UrlQuery parse(String query) throws MalformedURLException {
        UrlQuery ret;
        block15: {
            ret = new UrlQuery();
            if (query == null) {
                return ret;
            }
            try {
                query = URLHelper.createURL(query).getQuery();
            }
            catch (IOException e) {
                URL url2;
                if (StringUtils.startsWithCaseInsensitive(e.getMessage(), "unknown protocol")) {
                    try {
                        url2 = URLHelper.createURL(query.replaceFirst("^\\w+://", "http://"));
                        URLHelper.verifyURL(url2);
                        query = url2.getQuery();
                    }
                    catch (IOException url2) {}
                }
                if (!StringUtils.startsWithCaseInsensitive(e.getMessage(), "no protocol")) break block15;
                try {
                    url2 = URLHelper.createURL("http://" + query);
                    URLHelper.verifyURL(url2);
                    query = url2.getQuery();
                }
                catch (IOException url3) {
                    // empty catch block
                }
            }
        }
        if (query == null) {
            return ret;
        }
        query = query.trim();
        StringBuilder sb = new StringBuilder();
        String key = null;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '?' && i == 0) {
                sb.setLength(0);
                continue;
            }
            if (c == '&') {
                if (key != null || sb.length() > 0) {
                    ret.add(key, sb.toString());
                }
                sb.setLength(0);
                key = null;
                continue;
            }
            if (c == '=' && key == null) {
                key = sb.toString();
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (key != null || sb.length() > 0) {
            ret.add(key, sb.toString());
        }
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (KeyValueStringEntry s : this.list) {
            if (ret.length() > 0) {
                ret.append("&");
            }
            if (s.getKey() == null) {
                ret.append((String)s.getValue());
                continue;
            }
            ret.append((String)s.getKey()).append("=").append((String)s.getValue());
        }
        return ret.toString();
    }

    public UrlQuery add(String key, String value) {
        this.list.add(new KeyValueStringEntry(key, value));
        return this;
    }

    public String get(String key) {
        for (KeyValueStringEntry s : this.list) {
            if (!StringUtils.equals((String)s.getKey(), key)) continue;
            return (String)s.getValue();
        }
        return null;
    }

    public String getDecoded(String key) {
        try {
            return this.getDecoded(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
    }

    public String getDecoded(String key, String encoding) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty(encoding)) {
            encoding = "UTF-8";
        }
        for (KeyValueStringEntry s : this.list) {
            if (!StringUtils.equals((String)s.getKey(), key)) continue;
            return URLDecoder.decode((String)s.getValue(), encoding);
        }
        return null;
    }

    public List<KeyValueStringEntry> list() {
        return Collections.unmodifiableList(this.list);
    }

    public static UrlQuery get(Map<String, String> post) {
        UrlQuery ret = new UrlQuery();
        if (post != null) {
            for (Map.Entry<String, String> es : post.entrySet()) {
                ret.add(es.getKey(), es.getValue());
            }
        }
        return ret;
    }

    public UrlQuery addAndReplace(String key, String value) {
        KeyValueStringEntry entry = new KeyValueStringEntry(key, value);
        int index = this.remove(key);
        if (index < 0) {
            this.list.add(entry);
        } else {
            this.list.add(index, entry);
        }
        return this;
    }

    public int remove(String key) {
        int first = -1;
        int i = 0;
        Iterator<KeyValueStringEntry> it = this.list.iterator();
        while (it.hasNext()) {
            KeyValueStringEntry value = it.next();
            if (StringUtils.equals((String)value.getKey(), key)) {
                it.remove();
                if (first < 0) {
                    first = i;
                }
            }
            ++i;
        }
        return first;
    }

    public boolean containsKey(String key) {
        for (KeyValueStringEntry es : this.list) {
            if (!StringUtils.equals((String)es.getKey(), key)) continue;
            return true;
        }
        return false;
    }

    public boolean addIfNoAvailable(String key, String value) {
        if (this.containsKey(key)) {
            return false;
        }
        this.add(key, value);
        return true;
    }

    public List<UrlQuery> split() {
        ArrayList<UrlQuery> ret = new ArrayList<UrlQuery>();
        ArrayList<KeyValueStringEntry> lst = new ArrayList<KeyValueStringEntry>(this.list);
        do {
            UrlQuery map = new UrlQuery();
            Iterator<KeyValueStringEntry> it = lst.iterator();
            while (it.hasNext()) {
                KeyValueStringEntry es = it.next();
                if (map.containsKey((String)es.getKey())) continue;
                map.add((String)es.getKey(), (String)es.getValue());
                it.remove();
            }
            if (map.size() <= 0) continue;
            ret.add(map);
        } while (lst.size() != 0);
        return ret;
    }

    private int size() {
        return this.list.size();
    }

    public static UrlQuery get(List<KeyValueStringEntry> post) {
        UrlQuery ret = new UrlQuery();
        ret.addAll(post);
        return ret;
    }

    public void addAll(List<KeyValueStringEntry> post) {
        if (post != null) {
            this.list.addAll(post);
        }
    }

    public LinkedHashMap<String, String> toMap(boolean decodeValue) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        try {
            for (KeyValueStringEntry e : this.list) {
                if (decodeValue) {
                    ret.put((String)e.getKey(), URLDecoder.decode((String)e.getValue(), "UTF-8"));
                    continue;
                }
                ret.put((String)e.getKey(), (String)e.getValue());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
        return ret;
    }

    public LinkedHashMap<String, String> toMap() {
        return this.toMap(false);
    }

    public UrlQuery append(String key, String value, boolean urlencode) {
        if (value == null) {
            this.addAndReplace(key, "");
        } else {
            this.addAndReplace(key, urlencode ? URLEncode.encodeRFC2396(value) : value);
        }
        return this;
    }

    public UrlQuery appendEncoded(String key, String value) {
        return this.append(key, value, true);
    }
}

