/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;

public class ContainerRuntime {
    private static final Object[] CONTAINER = ContainerRuntime.detectContainer();

    public static TYPE getType() {
        Object containerType;
        if (CONTAINER != null && (containerType = CONTAINER[0]) instanceof TYPE) {
            return (TYPE)((Object)containerType);
        }
        return null;
    }

    @Deprecated
    public static boolean isInsideDocker() {
        TYPE containerType = ContainerRuntime.getType();
        if (containerType != null) {
            switch (containerType) {
                case DOCKER: 
                case KUBERNETES: 
                case ECS: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isInsideContainer() {
        return CONTAINER != null;
    }

    public static String getID() {
        if (CONTAINER != null) {
            Object containerID = CONTAINER[1];
            if (containerID == null) {
                return "unknownContainerID";
            }
            return String.valueOf(containerID);
        }
        return null;
    }

    private static Object[] detectContainer() {
        Object[] containerByProc = ContainerRuntime.detectContainerByProc();
        if (containerByProc != null) {
            return containerByProc;
        }
        Object[] containerByFiles = ContainerRuntime.detectContainerByFiles();
        if (containerByFiles != null) {
            return containerByFiles;
        }
        Object[] freeBSDJail = ContainerRuntime.detectFreeBSDJail();
        if (freeBSDJail != null) {
            return freeBSDJail;
        }
        return null;
    }

    private static Object[] detectFreeBSDJail() {
        if (CrossSystem.OperatingSystem.FREEBSD.isMinimum(CrossSystem.getOS()) && StringUtils.equals(System.getProperty("user.home"), "/nonexistent")) {
            String hostName = System.getenv("HOST");
            if (StringUtils.isEmpty(hostName)) {
                hostName = System.getenv("HOSTNAME");
            }
            return new Object[]{TYPE.FREEBSD_JAIL, hostName};
        }
        return null;
    }

    private static Object[] detectContainerByFiles() {
        if (CrossSystem.isUnix()) {
            HashMap<TYPE, List<String>> containerMap = new HashMap<TYPE, List<String>>();
            containerMap.put(TYPE.DOCKER, Arrays.asList("/run/.dockerenv", "/.dockerenv"));
            containerMap.put(TYPE.PODMAN, Arrays.asList("/run/.containerenv"));
            for (Map.Entry container : containerMap.entrySet()) {
                for (String checkFile : (List)container.getValue()) {
                    if (!new File(checkFile).isFile()) continue;
                    String hostName = System.getenv("HOSTNAME");
                    if (StringUtils.isEmpty(hostName)) {
                        hostName = System.getenv("HOST");
                    }
                    return new Object[]{container.getKey(), hostName};
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object[] detectContainerByProc() {
        if (!CrossSystem.isUnix()) return null;
        String[] stringArray = new String[]{"/proc/1/cgroup", "/proc/self/cgroup", "/proc/version_signature"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String procFileString = stringArray[n2];
            File procFile = new File(procFileString);
            if (procFile.isFile()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(procFile);
                    BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                    try {
                        String line = null;
                        while ((line = is.readLine()) != null) {
                            if (procFileString.endsWith("/version_signature")) {
                                if (!line.matches("(?i).*Microsoft.*")) continue;
                                Object[] objectArray = new Object[]{TYPE.WSL, System.getenv("WSL_DISTRO_NAME")};
                                return objectArray;
                            }
                            if (!procFileString.endsWith("/cgroup")) continue;
                            String[] docker = new Regex(line, ":/(docker/|system.slice/docker-)([\\p{XDigit}\\-]{1,64})(?:.scope|$)").getRow(0);
                            if (docker != null) {
                                Object[] objectArray = new Object[]{TYPE.DOCKER, docker[1]};
                                return objectArray;
                            }
                            String[] ecs = new Regex(line, ":/(ecs/|ecs/[^/]+/)([\\p{XDigit}\\-]{1,64})(?:.scope|$)").getRow(0);
                            if (ecs != null) {
                                Object[] objectArray = new Object[]{TYPE.ECS, ecs[1]};
                                return objectArray;
                            }
                            String[] kubepods = new Regex(line, ":/(kube.*?)/.*?([\\p{XDigit}\\-]{1,64})(?:.scope|$)").getRow(0);
                            if (kubepods != null) {
                                Object[] objectArray = new Object[]{TYPE.KUBERNETES, kubepods[1]};
                                return objectArray;
                            }
                            String[] podman = new Regex(line, ":/(podman/|[^/]*/libpod-)([\\p{XDigit}\\-]{1,64})(?:.scope|$)").getRow(0);
                            if (podman != null) {
                                Object[] objectArray = new Object[]{TYPE.PODMAN, podman[1]};
                                return objectArray;
                            }
                            String[] lxc = new Regex(line, ":/(lxc(?:-libvirt)?)/([^/+]+)").getRow(0);
                            if (lxc == null) continue;
                            Object[] objectArray = new Object[]{TYPE.LXC, lxc[1]};
                            return objectArray;
                        }
                    }
                    finally {
                        is.close();
                        fis = null;
                    }
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public static enum TYPE {
        DOCKER,
        KUBERNETES,
        LXC,
        ECS,
        PODMAN,
        GARDEN,
        WSL,
        FREEBSD_JAIL;

    }
}

