/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.socketconnection;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.ProxyEndpointConnectException;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.httpconnection.SocksHTTPconnection;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.net.socketconnection.SocksSocketConnection;

public class Socks4SocketConnection
extends SocksSocketConnection {
    @Override
    public SocksSocketConnection.DESTTYPE getDestType(SocketAddress endpoint) {
        InetSocketAddress inetSocketAddress;
        SocksSocketConnection.DESTTYPE destType = this.getDestType();
        if (endpoint != null && endpoint instanceof InetSocketAddress && (inetSocketAddress = (InetSocketAddress)endpoint).getAddress() != null) {
            switch (inetSocketAddress.getAddress().getAddress().length) {
                case 4: {
                    if (!this.isSupported(SocksSocketConnection.DESTTYPE.IPV4) || !SocksSocketConnection.DESTTYPE.IPV4.equals((Object)destType) && !SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType)) break;
                    return SocksSocketConnection.DESTTYPE.IPV4;
                }
                case 16: {
                    return SocksSocketConnection.DESTTYPE.DOMAIN;
                }
            }
        }
        return destType;
    }

    public Socks4SocketConnection(HTTPProxy proxy, SocksSocketConnection.DESTTYPE destType) {
        super(proxy, destType);
    }

    @Deprecated
    public Socks4SocketConnection(HTTPProxy proxy, SocksHTTPconnection.DESTTYPE destType) {
        super(proxy, SocksHTTPconnection.DESTTYPE.convert(destType));
    }

    public Socks4SocketConnection(HTTPProxy proxy) {
        this(proxy, SocksSocketConnection.DESTTYPE.AUTO);
    }

    @Override
    protected SocksSocketConnection.DESTTYPE initSocksSocketConnection(HTTPProxy proxy, SocksSocketConnection.DESTTYPE destType) {
        if (destType == null) {
            destType = SocksSocketConnection.DESTTYPE.AUTO;
        }
        this.supportedDestType.add(SocksSocketConnection.DESTTYPE.AUTO);
        this.supportedDestType.add(SocksSocketConnection.DESTTYPE.IPV4);
        if (HTTPProxy.TYPE.SOCKS4A.equals(this.getProxy().getType())) {
            this.supportedDestType.add(SocksSocketConnection.DESTTYPE.DOMAIN);
        }
        if (!this.supportedDestType.contains((Object)destType)) {
            throw new IllegalArgumentException("Unsupported dest type:" + (Object)((Object)this.getDestType()));
        }
        return destType;
    }

    @Override
    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy != null && (HTTPProxy.TYPE.SOCKS4.equals(proxy.getType()) || HTTPProxy.TYPE.SOCKS4A.equals(proxy.getType()))) {
            return proxy;
        }
        throw new IllegalArgumentException("proxy must be of type socks4/socks4a:" + proxy);
    }

    @Override
    protected SocketStreamInterface connectProxySocket(SocketStreamInterface proxySocket, SocketAddress endPoint, StringBuffer logger) throws IOException {
        HTTPProxy proxy = this.getProxy();
        try {
            return this.establishConnection(this, proxySocket, proxy.getUser(), this.setEndPointSocketAddress(endPoint), this.getDestType(endPoint), logger);
        }
        catch (ProxyConnectException e) {
            throw e;
        }
        catch (Socks4EndpointConnectException e) {
            throw new ProxyEndpointConnectException(e, proxy, endPoint);
        }
        catch (IOException e) {
            throw new ProxyConnectException(e, proxy);
        }
    }

    protected SocketStreamInterface establishConnection(Socks4SocketConnection sock4SocketConnection, SocketStreamInterface proxySocket, String userID, SocketAddress endPoint, SocksSocketConnection.DESTTYPE destType, StringBuffer logger) throws IOException {
        byte[] read;
        SocksSocketConnection.DESTTYPE usedDestType;
        InetSocketAddress endPointAddress = (InetSocketAddress)endPoint;
        OutputStream os = proxySocket.getOutputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (logger != null) {
            logger.append("->" + this.getProxy().getType() + " Hello to:" + SocketConnection.getRootEndPointSocketAddress(proxySocket) + "\r\n");
        }
        bos.write(4);
        bos.write(1);
        int port = endPointAddress.getPort();
        bos.write(port >> 8 & 0xFF);
        bos.write(port & 0xFF);
        switch (destType) {
            case AUTO: 
            case IPV4: {
                if (SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType) && this.isSupported(SocksSocketConnection.DESTTYPE.IPV4) || SocksSocketConnection.DESTTYPE.IPV4.equals((Object)destType)) {
                    InetAddress ipv4 = endPointAddress.getAddress();
                    if (ipv4 != null && ipv4.getAddress().length == 4) {
                        if (logger != null) {
                            logger.append("->SEND tcp connect request to:" + endPoint + " by ipv4:" + ipv4.getHostAddress() + "\r\n");
                        }
                        bos.write(ipv4.getAddress());
                        usedDestType = SocksSocketConnection.DESTTYPE.IPV4;
                        break;
                    }
                    if (SocksSocketConnection.DESTTYPE.IPV4.equals((Object)destType) && logger != null) {
                        if (ipv4 == null) {
                            logger.append("->Cannot connect request by ipv4 (unresolved)\r\n");
                        } else {
                            logger.append("->Cannot connect request by ipv4 (no ipv4)\r\n");
                        }
                    }
                }
            }
            case IPV6: {
                if (SocksSocketConnection.DESTTYPE.IPV6.equals((Object)destType) && logger != null) {
                    logger.append("->Skip Unsupported destType:" + (Object)((Object)destType) + "\r\n");
                }
            }
            case DOMAIN: {
                if (HTTPProxy.TYPE.SOCKS4A.equals(this.getProxy().getType()) && (SocksSocketConnection.DESTTYPE.AUTO.equals((Object)destType) && this.isSupported(SocksSocketConnection.DESTTYPE.DOMAIN) || SocksSocketConnection.DESTTYPE.DOMAIN.equals((Object)destType))) {
                    bos.write(0);
                    bos.write(0);
                    bos.write(0);
                    bos.write(1);
                    if (logger != null) {
                        logger.append("->SEND tcp connect request to:" + endPoint + " by domain:" + SocketConnection.getHostName(endPointAddress) + "\r\n");
                    }
                    usedDestType = SocksSocketConnection.DESTTYPE.DOMAIN;
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported destType:" + (Object)((Object)destType) + "|endPoint:" + endPointAddress);
            }
        }
        if (userID != null && userID.length() > 0) {
            bos.write(userID.getBytes(ISO_8859_1));
        }
        bos.write(0);
        if (SocksSocketConnection.DESTTYPE.DOMAIN.equals((Object)usedDestType)) {
            byte[] domainBytes = SocketConnection.getHostName(endPointAddress).getBytes("ISO-8859-1");
            bos.write(domainBytes);
            bos.write(0);
        }
        bos.writeTo(os);
        os.flush();
        InputStream is = proxySocket.getInputStream();
        try {
            read = SocketConnection.ensureRead(is, 2, null);
        }
        catch (IOException e) {
            throw new ProxyEndpointConnectException(e, this.getProxy(), endPoint);
        }
        int[] resp = SocketConnection.byteArrayToIntArray(read);
        if (resp[0] != 0) {
            throw new IOException("Invalid response:" + resp[0]);
        }
        switch (resp[1]) {
            case 90: {
                break;
            }
            case 91: {
                throw new Socks4EndpointConnectException(CONNECT_ERROR.REJECTED);
            }
            case 92: {
                throw new Socks4EndpointConnectException(CONNECT_ERROR.CLIENT_IDENTD_UNREACHABLE);
            }
            case 93: {
                throw new Socks4EndpointConnectException(CONNECT_ERROR.CLIENT_IDENTD_AUTH);
            }
            default: {
                throw new Socks4EndpointConnectException(CONNECT_ERROR.UNKNOWN, String.valueOf(resp[1]));
            }
        }
        byte[] connectedPort = SocketConnection.ensureRead(is, 2, null);
        byte[] connectedIP = SocketConnection.ensureRead(is, 4, null);
        if (logger != null) {
            logger.append("<-BOUND IP:" + InetAddress.getByAddress(connectedIP) + ":" + (ByteBuffer.wrap(connectedPort).getShort() & 0xFFFF) + "\r\n");
        }
        return proxySocket;
    }

    public class Socks4EndpointConnectException
    extends ConnectException {
        private static final long serialVersionUID = -1993301003920927143L;
        private final CONNECT_ERROR error;

        private Socks4EndpointConnectException(CONNECT_ERROR error) {
            super(error.msg);
            this.error = error;
        }

        private Socks4EndpointConnectException(CONNECT_ERROR error, String msg) {
            super(error.msg + ":" + msg);
            this.error = error;
        }

        public CONNECT_ERROR getError() {
            return this.error;
        }

        public HTTPProxy getProxy() {
            return Socks4SocketConnection.this.getProxy();
        }
    }

    public static enum CONNECT_ERROR {
        REJECTED("Socks4 request rejected or failed"),
        CLIENT_IDENTD_UNREACHABLE("Socks4 request failed because client is not running identd (or not reachable from the server)"),
        CLIENT_IDENTD_AUTH("Socks4 request failed because client's identd could not confirm the user ID string in the request"),
        UNKNOWN("Unknown");

        private final String msg;

        private CONNECT_ERROR(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

