/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.socketconnection;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.net.httpconnection.ProxyEndpointConnectException;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.socketconnection.SocketConnection;

public class DirectSocketConnection
extends SocketConnection {
    public DirectSocketConnection(HTTPProxy proxy) {
        super(proxy);
    }

    @Override
    protected HTTPProxy isProxySupported(HTTPProxy proxy) {
        if (proxy != null) {
            switch (proxy.getType()) {
                case DIRECT: 
                case NONE: {
                    return proxy;
                }
            }
            throw new IllegalArgumentException("proxy must be of type direct/none:" + proxy);
        }
        throw new IllegalArgumentException("proxy must be of type direct/none:" + proxy);
    }

    public DirectSocketConnection() {
        this(HTTPProxy.NONE);
    }

    @Override
    public void connect(SocketAddress endPoint, int connectTimeout, StringBuffer logger) throws IOException {
        try {
            block22: {
                try {
                    if (connectTimeout == 0) {
                        SocketStreamInterface connectSocket = this.createConnectSocket(endPoint, connectTimeout);
                        this.connect(connectSocket, endPoint, connectTimeout);
                        break block22;
                    }
                    int remainingConnectTimeout = connectTimeout;
                    while (true) {
                        long beforeConnectMS = Time.systemIndependentCurrentJVMTimeMillis();
                        try {
                            SocketStreamInterface connectSocket = this.createConnectSocket(endPoint, connectTimeout);
                            this.connect(connectSocket, endPoint, connectTimeout);
                        }
                        catch (IOException e) {
                            this.closeConnectSocket();
                            if (Exceptions.containsInstanceOf(e, ConnectException.class, SocketTimeoutException.class) && StringUtils.containsIgnoreCase(e.getMessage(), "timed out")) {
                                long timeout = Time.systemIndependentCurrentJVMTimeMillis() - beforeConnectMS;
                                if (timeout < 1000L) {
                                    int sleep = Math.max(100, (int)(2000L - timeout));
                                    System.out.println("Too Fast ConnectTimeout(Normal): " + timeout + "->Wait " + sleep);
                                    try {
                                        Thread.sleep(sleep);
                                        timeout = Time.systemIndependentCurrentJVMTimeMillis() - beforeConnectMS;
                                    }
                                    catch (InterruptedException ie) {
                                        throw Exceptions.addSuppressed(e, ie);
                                    }
                                }
                                int lastConnectTimeout = remainingConnectTimeout;
                                if ((remainingConnectTimeout = (int)Math.max(0L, (long)remainingConnectTimeout - timeout)) == 0) {
                                    throw e;
                                }
                                if (Thread.currentThread().isInterrupted()) {
                                    throw e;
                                }
                                System.out.println("Workaround for ConnectTimeout(Normal): " + lastConnectTimeout + ">" + timeout);
                                continue;
                            }
                            throw e;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    throw new ProxyEndpointConnectException(e, this.getProxy(), endPoint);
                }
            }
            SocketStreamInterface connectedSocket = this.connectProxySocket(this.getConnectSocket(), endPoint, logger);
            if (connectedSocket != null) {
                this.proxySocket = connectedSocket;
                return;
            }
            try {
                throw new ProxyEndpointConnectException(this.getProxy(), endPoint);
            }
            catch (ProxyAuthException e) {
                throw e;
            }
            catch (ProxyConnectException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ProxyConnectException(e, this.getProxy());
            }
        }
        finally {
            if (this.proxySocket == null) {
                this.closeConnectSocket();
            }
        }
    }

    protected InetAddress getBindInetAddress(InetAddress dest, HTTPProxy proxy) throws IOException {
        InetAddress[] ret;
        if (proxy != null && proxy.isDirect() && (ret = HTTPConnectionImpl.getNetworkInterfaceInetAdress(proxy)) != null && ret.length > 0) {
            for (InetAddress ia : ret) {
                if (!(dest instanceof Inet4Address ? ia instanceof Inet4Address : dest instanceof Inet6Address && ia instanceof Inet6Address)) continue;
                return ia;
            }
        }
        return null;
    }

    @Override
    protected SocketStreamInterface createConnectSocket(SocketAddress endPoint, int connectTimeout) throws IOException {
        SocketStreamInterface socket = super.createConnectSocket(endPoint, connectTimeout);
        if (this.getProxy().isDirect()) {
            try {
                InetAddress bind;
                if (socket.getSocket() != null && endPoint instanceof InetSocketAddress && (bind = this.getBindInetAddress(((InetSocketAddress)endPoint).getAddress(), this.getProxy())) != null) {
                    socket.getSocket().bind(new InetSocketAddress(bind, 0));
                }
            }
            catch (IOException e) {
                socket.close();
                throw e;
            }
        }
        return socket;
    }

    @Override
    protected SocketStreamInterface connectProxySocket(SocketStreamInterface proxySocket, SocketAddress endpoint, StringBuffer logger) throws IOException {
        return proxySocket;
    }
}

