/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Exceptions;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.HttpConnectionRunnable;
import org.appwork.utils.net.httpserver.HttpConnectionThread;
import org.appwork.utils.net.httpserver.HttpHandlerInfo;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.HTTPBridge;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;

public class HttpServer
implements Runnable,
HTTPBridge {
    private final int wishPort;
    private final AtomicReference<List<ServerSocket>> controlSockets = new AtomicReference<Object>(null);
    private volatile Thread serverThread = null;
    private boolean localhostOnly = false;
    private boolean debug = false;
    private final CopyOnWriteArrayList<HttpRequestHandler> requestHandlers = new CopyOnWriteArrayList();
    private int lastPort = -1;

    public HttpServer(int port) {
        this.wishPort = port;
    }

    @Deprecated
    protected Runnable createConnectionHandler(Socket clientSocket) throws IOException {
        return this.createPlainHttpConnection(clientSocket);
    }

    protected Runnable createConnectionHandler(ThreadPoolExecutor threadPool, Socket clientSocket) throws IOException {
        return this.createConnectionHandler(clientSocket);
    }

    protected HttpConnection createPlainHttpConnection(Socket clientSocket) throws IOException {
        return new HttpConnection(this, clientSocket);
    }

    public List<HttpRequestHandler> getHandler() {
        return this.requestHandlers;
    }

    protected InetAddress[] getLocalHost() throws UnknownHostException {
        return HTTPConnectionUtils.getLoopback(HTTPConnectionUtils.IPVERSION.IPV4_IPV6);
    }

    @Deprecated
    public int getPort() {
        try {
            return this.getActualPort();
        }
        catch (Throwable throwable) {
            return this.getWishedPort();
        }
    }

    public int getActualPort() throws IllegalStateException {
        List<ServerSocket> controlSockets = this.controlSockets.get();
        if (controlSockets != null) {
            return controlSockets.get(0).getLocalPort();
        }
        throw new IllegalStateException("Server not started yet");
    }

    public int getWishedPort() {
        return this.wishPort;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isLocalhostOnly() {
        return this.localhostOnly;
    }

    public boolean isRunning() {
        Thread serverThread = this.serverThread;
        return this.controlSockets.get() != null && serverThread != null && serverThread.isAlive();
    }

    public HttpHandlerInfo registerRequestHandler(HttpRequestHandler handler) {
        if (handler != null) {
            this.requestHandlers.addIfAbsent(handler);
        }
        return new HttpHandlerInfo(this, handler);
    }

    public List<SocketAddress> getLocalAddresses() {
        List<ServerSocket> controlSockets = this.controlSockets.get();
        if (controlSockets != null) {
            ArrayList<SocketAddress> ret = new ArrayList<SocketAddress>();
            for (ServerSocket controlSocket : controlSockets) {
                SocketAddress localAddress = controlSocket.getLocalSocketAddress();
                if (localAddress instanceof InetSocketAddress && ((InetSocketAddress)localAddress).getAddress() != null && "127.0.0.1".equals(((InetSocketAddress)localAddress).getAddress().getHostAddress())) {
                    ret.add(0, localAddress);
                    continue;
                }
                ret.add(localAddress);
            }
            return ret;
        }
        return null;
    }

    public String getServerAddress() {
        List<SocketAddress> localAddresses = this.getLocalAddresses();
        if (localAddresses != null) {
            InetSocketAddress loInetSocketAddress = null;
            for (SocketAddress localAddress : localAddresses) {
                InetSocketAddress inetSocketAddress;
                InetAddress address;
                if (!(localAddress instanceof InetSocketAddress) || !(address = (inetSocketAddress = (InetSocketAddress)localAddress).getAddress()).isLoopbackAddress()) continue;
                loInetSocketAddress = inetSocketAddress;
                if (!"127.0.0.1".equals(address.getHostAddress())) continue;
                break;
            }
            if (loInetSocketAddress != null && loInetSocketAddress.getAddress() != null) {
                InetAddress addr = loInetSocketAddress.getAddress();
                String ret = addr instanceof Inet6Address ? "[" + addr.getHostAddress() + "]:" + loInetSocketAddress.getPort() : addr.getHostAddress() + ":" + loInetSocketAddress.getPort();
                return ret;
            }
        }
        return "127.0.0.1:" + this.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final List<ServerSocket> controlSockets = this.controlSockets.get();
        ThreadPoolExecutor threadPool = null;
        try {
            if (controlSockets == null || controlSockets.size() == 0) {
                return;
            }
            final AtomicInteger threadsStarted = new AtomicInteger(0);
            threadPool = new ThreadPoolExecutor(0, 20, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(100), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    HttpConnectionThread ret = new HttpConnectionThread(HttpServer.this, r);
                    ret.setServerThreadID(threadsStarted.incrementAndGet());
                    ret.setName(HttpServer.this, null);
                    return ret;
                }
            }, new ThreadPoolExecutor.AbortPolicy()){
                final ThreadPoolExecutor threadPool;
                {
                    this.threadPool = this;
                }

                @Override
                protected void afterExecute(Runnable r, Throwable t) {
                    if (Thread.currentThread() instanceof HttpConnectionThread) {
                        ((HttpConnectionThread)Thread.currentThread()).setName(HttpServer.this, null);
                        ((HttpConnectionThread)Thread.currentThread()).setCurrentConnection(null, null);
                    }
                }

                @Override
                protected void beforeExecute(Thread t, Runnable r) {
                    int working;
                    int max;
                    int active = this.threadPool.getPoolSize();
                    if (active < (max = this.threadPool.getMaximumPoolSize()) && (working = this.threadPool.getActiveCount()) == active) {
                        this.threadPool.setCorePoolSize(Math.min(max, active + 1));
                    }
                    if (t instanceof HttpConnectionThread) {
                        HttpConnectionThread httpT = (HttpConnectionThread)t;
                        HttpConnection connection = r instanceof HttpConnection ? (HttpConnection)r : null;
                        Socket socket = r instanceof HttpConnectionRunnable ? ((HttpConnectionRunnable)r).getClientSocket() : null;
                        ((HttpConnectionThread)t).setCurrentConnection(connection, socket);
                        httpT.setName(HttpServer.this, socket);
                    }
                    super.beforeExecute(t, r);
                }
            };
            threadPool.allowCoreThreadTimeOut(true);
            final ThreadPoolExecutor finalThreadPool = threadPool;
            ArrayList<3> controlSocketThreads = new ArrayList<3>();
            for (final ServerSocket serverSocket : controlSockets) {
                Thread controlSocketThread = new Thread(Thread.currentThread().getName() + ":Listener:" + serverSocket.getLocalSocketAddress()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (HttpServer.this.controlSockets.get() == controlSockets) {
                            try {
                                Socket clientSocket = serverSocket.accept();
                                boolean closeSocket = true;
                                try {
                                    Runnable runnable;
                                    try {
                                        runnable = HttpServer.this.createConnectionHandler(finalThreadPool, clientSocket);
                                    }
                                    catch (Throwable e) {
                                        throw new IOException(e);
                                    }
                                    if (runnable == null) continue;
                                    finalThreadPool.execute(runnable);
                                    closeSocket = false;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                catch (RejectedExecutionException e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    if (!closeSocket || clientSocket == null) continue;
                                    try {
                                        clientSocket.close();
                                    }
                                    catch (Throwable e) {}
                                }
                            }
                            catch (SocketTimeoutException clientSocket) {
                            }
                            catch (IOException e) {
                                break;
                            }
                        }
                    }
                };
                controlSocketThreads.add(controlSocketThread);
                controlSocketThread.start();
            }
            for (Thread thread : controlSocketThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            List<Runnable> waiting;
            this.shutDownControlSockets(controlSockets);
            if (threadPool != null && (waiting = threadPool.shutdownNow()) != null) {
                for (Runnable runnable : waiting) {
                    try {
                        if (!(runnable instanceof HttpConnectionRunnable)) continue;
                        ((HttpConnectionRunnable)runnable).getClientSocket().close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLocalhostOnly(boolean localhostOnly) {
        this.localhostOnly = localhostOnly;
    }

    public synchronized void shutdown() {
        this.shutDownControlSockets(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws IOException {
        block16: {
            ArrayList<ServerSocket> serverSockets = new ArrayList<ServerSocket>();
            try {
                int port = this.lastPort != -1 ? this.lastPort : this.getWishedPort();
                if (this.isLocalhostOnly()) {
                    ArrayList<BindException> bindExceptions = new ArrayList<BindException>();
                    InetAddress[] localhost = this.getLocalHost();
                    int localPort = port;
                    for (InetAddress inetAddress : localhost) {
                        InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, localPort);
                        ServerSocket controlSocket = new ServerSocket();
                        try {
                            controlSocket.setReuseAddress(true);
                            controlSocket.bind(socketAddress);
                            serverSockets.add(controlSocket);
                            localPort = controlSocket.getLocalPort();
                        }
                        catch (BindException e) {
                            bindExceptions.add(Exceptions.addSuppressed(new BindException("cannot bind to:" + socketAddress), e));
                        }
                    }
                    if (serverSockets.size() == 0) {
                        throw (BindException)bindExceptions.get(0);
                    }
                    this.lastPort = ((ServerSocket)serverSockets.get(0)).getLocalPort();
                } else {
                    ServerSocket controlSocket = new ServerSocket(port);
                    this.lastPort = controlSocket.getLocalPort();
                    serverSockets.add(controlSocket);
                    controlSocket.setReuseAddress(true);
                }
                this.shutDownControlSockets(null);
                if (this.controlSockets.compareAndSet(null, serverSockets)) {
                    Thread serverThread = new Thread(this);
                    serverThread.setName("HttpServerThread|Port:" + this.getWishedPort() + "->" + this.getActualPort() + "|LocalHost:" + this.localhostOnly);
                    this.serverThread = serverThread;
                    LogV3.fine("Start HTTP Server. " + this.getWishedPort() + "->" + this.getActualPort() + "|LocalHost:" + this.localhostOnly);
                    serverThread.start();
                    serverSockets = null;
                    break block16;
                }
                throw new IOException("Failed to start HTTP Server. " + this.getWishedPort() + "|LocalHost:" + this.localhostOnly);
            }
            finally {
                if (serverSockets != null) {
                    for (ServerSocket controlSocket : serverSockets) {
                        try {
                            controlSocket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    protected List<ServerSocket> shutDownControlSockets(List<ServerSocket> compare) {
        List<ServerSocket> shutDownControlSockets = compare != null ? (this.controlSockets.compareAndSet(compare, null) ? compare : null) : (List<ServerSocket>)this.controlSockets.getAndSet(null);
        if (shutDownControlSockets != null) {
            for (ServerSocket controlSocket : shutDownControlSockets) {
                try {
                    controlSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return shutDownControlSockets;
    }

    public synchronized void stop() {
        this.shutDownControlSockets(null);
        this.lastPort = -1;
    }

    public void unregisterRequestHandler(HttpRequestHandler handler) {
        if (handler != null) {
            this.requestHandlers.remove(handler);
        }
    }

    @Override
    public boolean canHandleChunkedEncoding(HttpRequest request, HttpResponse response) {
        return true;
    }
}

