/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.appwork.utils.Exceptions;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory;
import org.appwork.utils.net.httpconnection.SSLSocketStreamFactory18;
import org.appwork.utils.net.httpconnection.SSLSocketStreamInterface;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptions;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;

public class NativeSSLSocketStreamFactory
implements SSLSocketStreamFactory {
    private static final NativeSSLSocketStreamFactory INSTANCE = new NativeSSLSocketStreamFactory();

    public static final NativeSSLSocketStreamFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory(SSLSocketStreamOptions options, String sniHostName) throws IOException {
        boolean sniEnabled = !StringUtils.isEmpty(sniHostName) && (options == null || options.isSNIEnabled());
        return this.getSSLSocketFactory(this.getSSLContext(options), options, sniEnabled ? sniHostName : null);
    }

    protected TrustManager[] getTrustCerts(SSLSocketStreamOptions options) throws SSLException {
        if (options == null || options.isTrustAll()) {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
        }
        return null;
    }

    protected SSLContext getSSLContext(SSLSocketStreamOptions options) throws IOException {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("TLS");
        protocols.add("SSL");
        SSLContext sslContext = null;
        NoSuchAlgorithmException nsae = null;
        for (String protocol : protocols) {
            try {
                sslContext = SSLContext.getInstance(protocol);
                break;
            }
            catch (NoSuchAlgorithmException e) {
                nsae = Exceptions.addSuppressed(e, nsae);
            }
        }
        if (sslContext != null) {
            try {
                sslContext.init(null, this.getTrustCerts(options), null);
                return sslContext;
            }
            catch (KeyManagementException e) {
                throw new SSLException(e);
            }
        }
        throw new SSLException(nsae);
    }

    protected SSLSocket modify(SSLSocket sslSocket, SSLSocketFactory factory, SSLContext sslContext, SSLSocketStreamOptions options, String sniHostName) {
        if (JVMVersion.isMinimum(18000000L) && options != null) {
            SSLSocketStreamFactory18.setSNIServerName(options, sslSocket, sniHostName);
        }
        return sslSocket;
    }

    protected SSLSocketFactory getSSLSocketFactory(final SSLContext sslContext, final SSLSocketStreamOptions options, final String sniHostName) throws IOException {
        final SSLSocketFactory factory = sslContext.getSocketFactory();
        return new SSLSocketFactory(){

            @Override
            public Socket createSocket(Socket arg0, String arg1, int arg2, boolean arg3) throws IOException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1, arg2, arg3);
                return NativeSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return factory.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return factory.getSupportedCipherSuites();
            }

            @Override
            public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1);
                return NativeSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1);
                return NativeSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1, arg2, arg3);
                return NativeSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }

            @Override
            public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
                SSLSocket ret = (SSLSocket)factory.createSocket(arg0, arg1, arg2, arg3);
                return NativeSSLSocketStreamFactory.this.modify(ret, factory, sslContext, options, sniHostName);
            }
        };
    }

    @Override
    public SSLSocketStreamInterface create(final SocketStreamInterface socketStream, String host, int port, boolean autoClose, final SSLSocketStreamOptions options) throws IOException {
        boolean sniEnabled = !StringUtils.isEmpty(host) && (options == null || options.isSNIEnabled());
        final SSLContext sslContext = this.getSSLContext(options);
        final SSLSocketFactory sslFactory = this.getSSLSocketFactory(sslContext, options, sniEnabled ? host : null);
        final SSLSocket sslSocket = (SSLSocket)sslFactory.createSocket(socketStream.getSocket(), sniEnabled ? host : "", port, autoClose);
        if (options != null && !options.isTrustAll()) {
            this.verifySSLHostname(null, sslSocket.getSession(), host);
        }
        return new NativeSSLSocketStreamInterface(){

            @Override
            public SSLSocket getSocket() {
                return sslSocket;
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return sslSocket.getOutputStream();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return sslSocket.getInputStream();
            }

            @Override
            public void close() throws IOException {
                sslSocket.close();
            }

            @Override
            public SocketStreamInterface getParentSocketStream() {
                return socketStream;
            }

            @Override
            public String getCipherSuite() {
                SSLSession session = sslSocket.getSession();
                return "JVM|Protocol:" + session.getProtocol() + "|CipherSuite:" + session.getCipherSuite();
            }

            @Override
            public SSLSocketStreamOptions getOptions() {
                return options;
            }

            @Override
            public SSLContext getSSLContext() {
                return sslContext;
            }

            @Override
            public SSLSocketFactory getSSLSocketFactory() {
                return sslFactory;
            }

            @Override
            public SSLSocketStreamFactory getSSLSocketStreamFactory() {
                return NativeSSLSocketStreamFactory.this;
            }

            @Override
            public SSLSession getSSLSession() {
                return sslSocket.getSession();
            }
        };
    }

    protected Boolean verifySSLHostname(HostnameVerifier hostNameVerifier, SSLSession session, String host) throws IOException {
        return HTTPConnectionUtils.verifySSLHostname(hostNameVerifier, session, host);
    }

    @Override
    public String retry(SSLSocketStreamOptions options, Exception e) {
        return null;
    }

    public static interface NativeSSLSocketStreamInterface
    extends SSLSocketStreamInterface {
        public SSLContext getSSLContext();

        public SSLSession getSSLSession();

        public SSLSocketFactory getSSLSocketFactory();
    }
}

