/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;

public class URLHelper {
    public static String createURL(String protocol, String userInfo, String host, int port, String path, String query, String ref) throws MalformedURLException {
        boolean isFileProtocol;
        StringBuilder sb = new StringBuilder();
        sb.append(protocol);
        if (protocol != null && "file".equalsIgnoreCase(protocol)) {
            isFileProtocol = true;
            sb.append(":/");
        } else {
            isFileProtocol = false;
            sb.append("://");
        }
        if (!isFileProtocol) {
            if (userInfo != null && userInfo.length() > 0) {
                sb.append(userInfo);
                sb.append("@");
            }
            sb.append(URLHelper.toLowerCase(host));
            if (port != -1) {
                sb.append(":");
                sb.append(port);
            }
        }
        if (path != null && path.length() > 0) {
            String encodedURLPath;
            try {
                encodedURLPath = URLHelper.encodeURLPathSegment(path);
            }
            catch (UnsupportedEncodingException shouldNeverHappen) {
                throw new MalformedURLException(shouldNeverHappen.getMessage());
            }
            if (isFileProtocol) {
                if (encodedURLPath.startsWith("/")) {
                    sb.append(encodedURLPath.substring(1));
                } else {
                    sb.append(encodedURLPath);
                }
            } else if (encodedURLPath.startsWith("/")) {
                sb.append(encodedURLPath);
            } else {
                sb.append("/");
                sb.append(encodedURLPath);
            }
        } else {
            sb.append("/");
        }
        if (!isFileProtocol) {
            if (query != null && query.length() > 0) {
                sb.append("?");
                sb.append(query);
            }
            if (ref != null && ref.length() > 0) {
                sb.append("#");
                sb.append(ref);
            }
        }
        return sb.toString();
    }

    public static String getUrlWithoutParams(String url) throws MalformedURLException {
        return URLHelper.getUrlWithoutParams(new URL(url));
    }

    public static String getUrlWithoutParams(URL url) throws MalformedURLException {
        return URLHelper.getURL(url, false, false, false).toString();
    }

    private static String encodeURLPathSegment(String urlPath) throws UnsupportedEncodingException {
        if (urlPath != null) {
            boolean encodeRequired = false;
            for (int index = 0; index < urlPath.length(); ++index) {
                char c = urlPath.charAt(index);
                if (c == '\"' || c == ' ' || c == '[' || c == ']' || c == '{' || c == '}') {
                    encodeRequired = true;
                    break;
                }
                if (c <= '\u007f') continue;
                encodeRequired = true;
                break;
            }
            if (encodeRequired) {
                StringBuilder encodeBuffer = new StringBuilder();
                StringBuilder output = new StringBuilder();
                for (int index = 0; index < urlPath.length(); ++index) {
                    char c = urlPath.charAt(index);
                    if (c == ' ') {
                        URLHelper.encodeURLSegment(encodeBuffer, output);
                        output.append("%20");
                        continue;
                    }
                    if (c == '\"') {
                        URLHelper.encodeURLSegment(encodeBuffer, output);
                        output.append("%22");
                        continue;
                    }
                    if (c == '[') {
                        URLHelper.encodeURLSegment(encodeBuffer, output);
                        output.append("%5B");
                        continue;
                    }
                    if (c == ']') {
                        URLHelper.encodeURLSegment(encodeBuffer, output);
                        output.append("%5D");
                        continue;
                    }
                    if (c == '{') {
                        URLHelper.encodeURLSegment(encodeBuffer, output);
                        output.append("%7B");
                        continue;
                    }
                    if (c == '}') {
                        URLHelper.encodeURLSegment(encodeBuffer, output);
                        output.append("%7D");
                        continue;
                    }
                    if (c <= '\u007f') {
                        URLHelper.encodeURLSegment(encodeBuffer, output);
                        output.append(c);
                        continue;
                    }
                    encodeBuffer.append(c);
                }
                URLHelper.encodeURLSegment(encodeBuffer, output);
                return output.toString();
            }
        }
        return urlPath;
    }

    private static boolean encodeURLSegment(StringBuilder buf, StringBuilder output) throws UnsupportedEncodingException {
        if (buf.length() > 0) {
            output.append(URLEncoder.encode(buf.toString(), "UTF-8"));
            buf.delete(0, buf.length());
            return true;
        }
        return false;
    }

    public static URL createURL(String url) throws MalformedURLException {
        URL tmp = new URL(url.trim().replaceAll(" ", "%20"));
        if (StringUtils.isEmpty(tmp.getHost()) && tmp.getProtocol() != null && tmp.getProtocol().matches("(https?|ftp)")) {
            tmp = new URL(url.trim().replaceFirst("^(?i)(https?|ftp):/+", "$1://").replaceAll(" ", "%20"));
        }
        String newURL = URLHelper.createURL(tmp.getProtocol(), tmp.getUserInfo(), tmp.getHost(), tmp.getPort(), tmp.getPath(), tmp.getQuery(), tmp.getRef());
        return new URL(newURL);
    }

    private static String toLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String parseLocation(URL url, String loc) {
        String location = loc.trim().replaceAll(" ", "%20");
        try {
            if (location.matches("^(?i)ftp:/.+") || location.matches("^(?i)file:/.+")) {
                throw new WTFException("Unsupported:location=" + location);
            }
            if (location.matches("^(?i)https?:/.+")) {
                URL dummyURL = URLHelper.createURL(location);
                return URLHelper.fixPathTraversal(dummyURL).toString();
            }
            if (location.matches("^:\\d+/.*")) {
                URL dummyURL = URLHelper.createURL(url.getProtocol() + "://" + url.getHost() + location);
                return URLHelper.fixPathTraversal(dummyURL).toString();
            }
            if (location.startsWith("//")) {
                URL dummyURL = URLHelper.createURL(url.getProtocol() + ":" + location);
                return URLHelper.fixPathTraversal(dummyURL).toString();
            }
            if (location.startsWith("/")) {
                StringBuilder sb = new StringBuilder();
                sb.append(url.getProtocol()).append("://");
                sb.append(url.getHost());
                if (url.getPort() != -1) {
                    sb.append(":").append(url.getPort());
                }
                sb.append(location);
                URL dummyURL = URLHelper.createURL(sb.toString());
                return URLHelper.fixPathTraversal(dummyURL).toString();
            }
            if (location.startsWith("?")) {
                URL dummyURL = URLHelper.getURL(url, false, false, false);
                String query = location.substring(1);
                if (StringUtils.isEmpty(query)) {
                    return URLHelper.createURL(dummyURL.toString()).toString();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(dummyURL.toString());
                if (StringUtils.isEmpty(dummyURL.getPath())) {
                    sb.append("/");
                }
                sb.append(location);
                dummyURL = URLHelper.createURL(sb.toString());
                return dummyURL.toString();
            }
            if (location.startsWith("&")) {
                String query = location.substring(1);
                if (StringUtils.isEmpty(query)) {
                    URL dummyURL = URLHelper.getURL(url, true, false, false);
                    return URLHelper.createURL(dummyURL.toString()).toString();
                }
                URL dummyURL = URLHelper.getURL(url, false, false, false);
                StringBuilder sb = new StringBuilder();
                sb.append(dummyURL.toString());
                if (StringUtils.isEmpty(dummyURL.getPath())) {
                    sb.append("/");
                }
                sb.append("?");
                if (StringUtils.isNotEmpty(url.getQuery())) {
                    sb.append(url.getQuery());
                    if (!url.getQuery().endsWith("&")) {
                        sb.append("&");
                    }
                }
                sb.append(query);
                dummyURL = URLHelper.createURL(sb.toString());
                return dummyURL.toString();
            }
            if (location.startsWith("#") || StringUtils.isEmpty(location)) {
                return url.toString();
            }
            URL dummyURL = URLHelper.createURL(URLHelper.getBaseURL(url) + location);
            return URLHelper.fixPathTraversal(dummyURL).toString();
        }
        catch (MalformedURLException e) {
            throw new WTFException("FIXME:location=" + location, e);
        }
    }

    public static void verifyURL(URL url) throws MalformedURLException {
        try {
            String host = url.getHost();
            if (host != null && host.contains("_")) {
                url = new URL(URLHelper.createURL(url.getProtocol(), url.getUserInfo(), host.replace("_", ""), url.getPort(), url.getPath(), url.getQuery(), url.getRef()));
            }
            url.toURI().parseServerAuthority();
        }
        catch (URISyntaxException e) {
            throw Exceptions.addSuppressed(new MalformedURLException(), e);
        }
    }

    public static URL fixPathTraversal(URL url) throws MalformedURLException {
        if (url != null && StringUtils.contains(url.getPath(), "./")) {
            boolean isFileProtocol;
            boolean endsWithSlash = url.getPath().endsWith("/");
            String[] pathParts = url.getPath().split("/");
            for (int i = 0; i < pathParts.length; ++i) {
                if (".".equals(pathParts[i])) {
                    pathParts[i] = null;
                    continue;
                }
                if ("..".equals(pathParts[i])) {
                    if (i > 0) {
                        for (int j = i - 1; j > 0; --j) {
                            if (pathParts[j] == null) continue;
                            pathParts[j] = null;
                            break;
                        }
                    }
                    pathParts[i] = null;
                    continue;
                }
                if (i <= 0 || pathParts[i].length() != 0) continue;
                pathParts[i] = "/";
            }
            StringBuilder sb = new StringBuilder();
            String protocol = url.getProtocol();
            sb.append(protocol);
            if (protocol != null && "file".equalsIgnoreCase(protocol)) {
                isFileProtocol = true;
                sb.append(":/");
            } else {
                isFileProtocol = false;
                sb.append("://");
            }
            if (!isFileProtocol) {
                if (url.getUserInfo() != null) {
                    sb.append(url.getUserInfo());
                    sb.append("@");
                }
                sb.append(url.getHost());
                if (url.getPort() != -1) {
                    sb.append(":");
                    sb.append(url.getPort());
                }
                sb.append("/");
            }
            for (int i = 0; i < pathParts.length; ++i) {
                String pathPart = pathParts[i];
                if (pathPart == null || pathPart.length() <= 0 || "/".equals(pathPart)) continue;
                sb.append(pathPart);
                if (i == pathParts.length - 1 || '/' == sb.charAt(sb.length() - 1)) continue;
                sb.append("/");
            }
            if (endsWithSlash && '/' != sb.charAt(sb.length() - 1)) {
                sb.append("/");
            }
            if (!isFileProtocol) {
                if (url.getQuery() != null) {
                    sb.append("?");
                    sb.append(url.getQuery());
                }
                if (url.getRef() != null) {
                    sb.append("#");
                    sb.append(url.getRef());
                }
            }
            return URLHelper.createURL(sb.toString());
        }
        return url;
    }

    public static String getBaseURL(URL url) throws MalformedURLException {
        URL baseURI = new URL(url.getProtocol(), URLHelper.toLowerCase(url.getHost()), url.getPort(), url.getPath());
        String base = baseURI.getPath() != null ? new Regex(baseURI.toString(), "(https?://.+)/").getMatch(0) : baseURI.toString();
        if (base == null) {
            return baseURI.toString() + "/";
        }
        if (base.endsWith("/")) {
            return base;
        }
        return base + "/";
    }

    public static URL getURL(URL url, boolean includeQuery, boolean includeUserInfo, boolean includeRef) throws MalformedURLException {
        boolean modifyRef;
        boolean modifyQuery = !includeQuery && url.getQuery() != null;
        boolean modifyUserInfo = !includeUserInfo && url.getUserInfo() != null;
        boolean bl = modifyRef = !includeRef && url.getRef() != null;
        if (!(modifyQuery || modifyUserInfo || modifyRef)) {
            return url;
        }
        return URLHelper.createURL(URLHelper.createURL(url.getProtocol(), includeUserInfo ? url.getUserInfo() : null, url.getHost(), url.getPort(), url.getPath(), includeQuery ? url.getQuery() : null, includeRef ? url.getRef() : null));
    }
}

