/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.event.BasicEvent;
import org.appwork.utils.event.BasicEventSender;

public class ConnectionLimiter {
    private static final Object LOCK = new Object();
    public static final int CONNECTION_OPENED = 0;
    public static final int CONNECTION_CLOSED = 1;
    public static final int WAIT_DUETO_MAXSIMULTAN_LIMIT_END = 2;
    public static final int WAIT_DUETO_MAXSIMULTAN_LIMIT_START = 3;
    public static final int WAIT_DUETO_CONNECTIONSPERMINUTE_LIMIT_START = 4;
    public static final int WAIT_DUETO_CONNECTIONSPERMINUTE_LIMIT_END = 5;
    private int connectioncount;
    private final List<Long> list = new ArrayList<Long>();
    private int maxConcurrent = -1;
    private int timeConnections = -1;
    private long timeTime = -1L;
    private final BasicEventSender<Long> eventSender = new BasicEventSender();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedConnection() {
        Object object = LOCK;
        synchronized (object) {
            --this.connectioncount;
        }
        this.eventSender.fireEvent(new BasicEvent<Object>((Object)this, 1, null, null));
    }

    public long[] getConnectionTimeLimit() {
        return new long[]{this.timeConnections, this.timeTime};
    }

    public BasicEventSender<Long> getEventSender() {
        return this.eventSender;
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void openedConnection() throws InterruptedException {
        boolean waiting;
        if (this.maxConcurrent > 0) {
            waiting = false;
            long ms = -1L;
            while (true) {
                Object object = LOCK;
                synchronized (object) {
                    if (this.connectioncount < this.maxConcurrent) {
                        if (waiting) {
                            this.eventSender.fireEvent(new BasicEvent<Long>((Object)this, 2, System.currentTimeMillis() - ms, null));
                        }
                        break;
                    }
                }
                if (ms < 0L) {
                    ms = System.currentTimeMillis();
                }
                LogV3.warning("block 250 ms for " + this.maxConcurrent + " connectionlimit");
                this.eventSender.fireEvent(new BasicEvent<Long>((Object)this, 3, System.currentTimeMillis() - ms, null));
                waiting = true;
                Thread.sleep(250L);
            }
        }
        waiting = false;
        if (this.timeConnections > 0) {
            while (true) {
                Iterator<Long> it = this.list.iterator();
                while (it.hasNext() && it.next() + this.timeTime < System.currentTimeMillis()) {
                    it.remove();
                }
                if (this.list.size() < this.timeConnections) break;
                long wait = this.timeConnections;
                if (it.hasNext()) {
                    wait = Math.max(250L, it.next() - (System.currentTimeMillis() - this.timeTime));
                }
                waiting = true;
                LogV3.warning("wait " + wait + " ms because we got " + this.list.size() + " connections the last minute");
                this.eventSender.fireEvent(new BasicEvent<Long>((Object)this, 4, wait, null));
                Thread.sleep(wait);
            }
            this.list.add(System.currentTimeMillis());
        }
        Object object = LOCK;
        synchronized (object) {
            ++this.connectioncount;
        }
        if (waiting) {
            this.eventSender.fireEvent(new BasicEvent<Object>((Object)this, 5, null, null));
        }
        this.eventSender.fireEvent(new BasicEvent<Object>((Object)this, 0, null, null));
    }

    public synchronized void setConnectionTimeLimit(int connections, long time) {
        if (connections > 0 && time > 0L) {
            this.timeConnections = connections;
            this.timeTime = time;
        } else {
            this.timeConnections = -1;
            this.timeTime = -1L;
        }
    }

    public synchronized void setMaxConcurrent(int max) {
        if (max <= 0) {
            max = -1;
        }
        this.maxConcurrent = max;
    }
}

