/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.util.HashSet;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.appwork.utils.logging.LogFormatter;

public class LogConsoleHandler
extends ConsoleHandler {
    private HashSet<String> allowedLoggerNames = new HashSet();

    public LogConsoleHandler() {
        this.setLevel(Level.ALL);
        this.setFormatter(new LogFormatter(){
            private final int lineLength = 400;

            @Override
            protected CharSequence getMessage(LogRecord record) {
                CharSequence ret = super.getMessage(record);
                if (ret != null && ret.length() > 400) {
                    int length = ret.length();
                    int position = 0;
                    block0: while (position < length) {
                        int max = Math.min(length, position + 400);
                        for (int index = position; index < max; ++index) {
                            char ch = ret.charAt(index);
                            if (ch != '\r' && ch != '\n' && index != length - 1) continue;
                            if (index + 1 - position > 400) {
                                position = 0;
                                break block0;
                            }
                            position = index + 1;
                            continue block0;
                        }
                        position = 0;
                        break;
                    }
                    if (position >= length) {
                        return ret;
                    }
                    StringBuilder sb = new StringBuilder(length + length / 400 * 12);
                    position = 0;
                    boolean wrapText = false;
                    boolean isWrapped = false;
                    boolean wrappedSb = false;
                    block2: while (position < length) {
                        char lastChar;
                        if (sb.length() > 0 && position > 0 && (lastChar = sb.charAt(sb.length() - 1)) != '\r' && lastChar != '\n') {
                            sb.append("\r\n");
                        }
                        int max = Math.min(length, position + 400);
                        for (int index = position; index < max; ++index) {
                            char ch = ret.charAt(index);
                            if (ch != '\r' && ch != '\n' && index != length - 1) continue;
                            if (position != index) {
                                if (wrapText) {
                                    isWrapped = true;
                                    if (!wrappedSb) {
                                        wrappedSb = true;
                                        if (sb.length() > 0) {
                                            StringBuilder newSb = new StringBuilder(length + length / 400 * 12);
                                            newSb.append("AUTO_WRAPPED>\r\n");
                                            newSb.append((CharSequence)sb);
                                            sb = newSb;
                                        } else {
                                            sb.append("AUTO_WRAPPED>\r\n");
                                        }
                                    }
                                    wrapText = false;
                                }
                                sb.append(ret.subSequence(position, index));
                            }
                            position = index + 1;
                            continue block2;
                        }
                        wrapText = true;
                        isWrapped = true;
                        if (!wrappedSb) {
                            wrappedSb = true;
                            if (sb.length() > 0) {
                                StringBuilder newSb = new StringBuilder(length + length / 400 * 12);
                                newSb.append("AUTO_WRAPPED>\r\n");
                                newSb.append((CharSequence)sb);
                                sb = newSb;
                            } else {
                                sb.append("AUTO_WRAPPED>\r\n");
                            }
                        }
                        sb.append(ret.subSequence(position, max));
                        position += 400;
                    }
                    return sb;
                }
                return ret;
            }
        });
    }

    public HashSet<String> getAllowedLoggerNames() {
        return this.allowedLoggerNames;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        HashSet<String> lallowedLoggerNames = this.allowedLoggerNames;
        if (lallowedLoggerNames == null) {
            return false;
        }
        if (lallowedLoggerNames.size() == 0) {
            return true;
        }
        return this.allowedLoggerNames.contains(record.getLoggerName().toLowerCase(Locale.ENGLISH));
    }

    public void setAllowedLoggerNames(String ... strings) {
        if (strings == null) {
            this.allowedLoggerNames = null;
            return;
        }
        HashSet<String> tmp = new HashSet<String>();
        for (String s : strings) {
            tmp.add(s.toLowerCase(Locale.ENGLISH));
        }
        this.allowedLoggerNames = tmp;
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
    }
}

