/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images.svg;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class SVGIO {
    public static Image getImageFromSVG(URL url, int w, int h) throws IOException {
        return SVGIO.getImageFromSVG(url, w, h, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getImageFromSVG(URL url, int w, int h, Color color) throws IOException {
        try {
            InputStream is = null;
            try {
                is = url.openStream();
                if (is == null) throw new IOException("Not found:" + url);
                Image image = SVGIO.getImageFromSVG(is, w, h, color);
                return image;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException("URL:" + url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromSVG(InputStream is, int w, int h, Color color) throws IOException {
        try {
            SVGUniverse universe = new SVGUniverse();
            URI uri = universe.loadSVG(is, "dummy.svg");
            SVGDiagram diagram = universe.getDiagram(uri);
            if (diagram == null) {
                return null;
            }
            if (color != null) {
                SVGRoot root = diagram.getRoot();
                float alpha = (float)color.getAlpha() / 255.0f;
                String hex = "#" + String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
                SVGIO.setColor((SVGElement)root, alpha, hex);
            }
            diagram.updateTime(0.0);
            diagram.setIgnoringClipHeuristic(true);
            if (w <= 0) {
                w = (int)diagram.getWidth();
            }
            if (h <= 0) {
                h = (int)diagram.getHeight();
            }
            double faktor = 1.0 / Math.max((double)diagram.getWidth() / (double)w, (double)diagram.getHeight() / (double)h);
            int width = Math.max((int)((double)diagram.getWidth() * faktor), 1);
            int height = Math.max((int)((double)diagram.getHeight() * faktor), 1);
            BufferedImage bi = new BufferedImage(width, height, 6);
            Graphics2D g = bi.createGraphics();
            try {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                int x = 0;
                int y = 0;
                g.translate(x, y);
                Rectangle2D.Double rect = new Rectangle2D.Double();
                diagram.getViewRect((Rectangle2D)rect);
                AffineTransform scaleXform = new AffineTransform();
                scaleXform.setToScale((double)width / rect.width, (double)height / rect.height);
                AffineTransform oldXform = g.getTransform();
                g.transform(scaleXform);
                diagram.render(g);
                g.setTransform(oldXform);
                g.translate(-x, -y);
            }
            finally {
                g.dispose();
            }
            return bi;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private static void setColor(SVGElement root, float alpha, String hex) throws SVGElementException {
        if (root.hasAttribute("fill", 0)) {
            root.setAttribute("fill", 0, hex);
        } else {
            root.addAttribute("fill", 0, hex);
        }
        if (root.hasAttribute("fill-opacity", 0)) {
            root.setAttribute("fill-opacity", 0, alpha + "");
        } else {
            root.addAttribute("fill-opacity", 0, alpha + "");
        }
        for (int i = 0; i < root.getNumChildren(); ++i) {
            SVGElement child = root.getChild(i);
            SVGIO.setColor(child, alpha, hex);
        }
    }
}

