/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.FilteredImageSource;
import java.awt.image.Kernel;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.swing.components.IDIcon;
import org.appwork.swing.components.IconIdentifier;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.StringUtils;
import org.appwork.utils.URLStream;
import org.appwork.utils.images.Interpolation;
import org.appwork.utils.images.svg.NoSVGSupportFactory;
import org.appwork.utils.images.svg.SVGFactory;
import org.appwork.utils.net.Base64InputStream;
import org.appwork.utils.net.Base64OutputStream;
import org.appwork.utils.net.CharSequenceInputStream;

public class IconIO {
    public static final String SVG_FACTORY_KEY = "SVG_FACTORY";
    private static final AtomicReference<SVGFactory> SVG_FACTORY = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVGFactory getSvgFactory() {
        SVGFactory factory = SVG_FACTORY.get();
        if (factory == null) {
            AtomicReference<SVGFactory> atomicReference = SVG_FACTORY;
            synchronized (atomicReference) {
                factory = SVG_FACTORY.get();
                if (factory == null) {
                    factory = IconIO.createSVGFactory();
                    if (factory == null) {
                        factory = new NoSVGSupportFactory();
                    }
                    SVG_FACTORY.set(factory);
                }
            }
        }
        if (!factory.isSupported()) {
            return null;
        }
        return factory;
    }

    public static BufferedImage blur(BufferedImage image) {
        float[] matrix = new float[400];
        for (int i = 0; i < 400; ++i) {
            matrix[i] = 0.0025f;
        }
        ConvolveOp op = new ConvolveOp(new Kernel(20, 20, matrix), 1, null);
        return op.filter(image, null);
    }

    private static SVGFactory createSVGFactory() {
        String fromSysProp = System.getProperty(SVG_FACTORY_KEY);
        if (fromSysProp != null && StringUtils.isEmpty(fromSysProp)) {
            return null;
        }
        List<String> clazzes = Arrays.asList(fromSysProp, "org.appwork.utils.images.svg.WeisjJSVGFactory", "org.appwork.utils.images.svg.KitFoxFactory");
        for (String clazz : clazzes) {
            if (!StringUtils.isNotEmpty(clazz)) continue;
            try {
                SVGFactory factory = (SVGFactory)Class.forName(clazz, false, Thread.currentThread().getContextClassLoader()).newInstance();
                if (!factory.isSupported()) continue;
                return factory;
            }
            catch (Throwable e) {
                if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) continue;
                throw new WTFException(e);
            }
        }
        return null;
    }

    public static BufferedImage colorRangeToTransparency(BufferedImage image, Color c1, Color c2) {
        final int r1 = c1.getRed();
        final int g1 = c1.getGreen();
        final int b1 = c1.getBlue();
        final int r2 = c2.getRed();
        final int g2 = c2.getGreen();
        final int b2 = c2.getBlue();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                if (r >= r1 && r <= r2 && g >= g1 && g <= g2 && b >= b1 && b <= b2) {
                    int dist = (Math.abs(r - (r1 + r2) / 2) + Math.abs(g - (g1 + g2) / 2) + Math.abs(b - (b1 + b2) / 2)) * 2;
                    return new Color(r, g, b, Math.min(255, dist)).getRGB();
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(ip);
        return IconIO.toBufferedImage(img);
    }

    public static BufferedImage convertIconToBufferedImage(Icon icon) {
        BufferedImage image;
        Image ret;
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon && (ret = ((ImageIcon)icon).getImage()) instanceof BufferedImage) {
            return (BufferedImage)ret;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (Application.isHeadless()) {
            image = new BufferedImage(w, h, 3);
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            image = gc.createCompatibleImage(w, h, 3);
        }
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static BufferedImage createEmptyImage(int w, int h) {
        if (Application.isHeadless()) {
            BufferedImage image = new BufferedImage(w, h, 2);
            return image;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h, 2);
        return image;
    }

    public static BufferedImage debug(BufferedImage img) {
        Graphics2D g2 = img.createGraphics();
        g2.setColor(Color.RED);
        g2.drawRect(0, 0, img.getWidth() - 1, img.getHeight() - 1);
        return img;
    }

    public static BufferedImage getImage(URL resource) {
        return IconIO.getImage(resource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImage(URL resource, boolean allowDummy) {
        if (resource != null) {
            InputStream is = null;
            try {
                is = URLStream.openStream(resource);
                BufferedImage ret = ImageIO.read(is);
                if (ret != null) {
                    BufferedImage bufferedImage = ret;
                    return bufferedImage;
                }
            }
            catch (IOException e) {
                LogV3.log(new IOException("URL:" + resource, e));
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        if (allowDummy) {
            return ImageProvider.createIcon("DUMMY", 48, 48);
        }
        return null;
    }

    public static BufferedImage getCroppedImage(BufferedImage source) {
        if (source != null) {
            if (source.getType() == 2) {
                try {
                    int alpha;
                    int j;
                    int i;
                    int[] pixels = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                    int width = source.getWidth();
                    int height = source.getHeight();
                    block4: for (i = 0; i < width; ++i) {
                        for (j = 0; j < height; ++j) {
                            alpha = pixels[j * width + i] >> 24 & 0xFF;
                            if (alpha != 0) break block4;
                        }
                    }
                    int x0 = i;
                    block6: for (j = 0; j < height; ++j) {
                        for (i = 0; i < width; ++i) {
                            alpha = pixels[j * width + i] >> 24 & 0xFF;
                            if (alpha != 0) break block6;
                        }
                    }
                    int y0 = j;
                    block8: for (i = width - 1; i >= 0; --i) {
                        for (j = 0; j < height; ++j) {
                            alpha = pixels[j * width + i] >> 24 & 0xFF;
                            if (alpha != 0) break block8;
                        }
                    }
                    int x1 = i + 1;
                    block10: for (j = height - 1; j >= 0; --j) {
                        for (i = 0; i < width; ++i) {
                            alpha = pixels[j * width + i] >> 24 & 0xFF;
                            if (alpha != 0) break block10;
                        }
                    }
                    int y1 = j + 1;
                    if (x0 == 0 && y0 == 0 && x1 - x0 == height && y1 - y0 == width) {
                        return source;
                    }
                    return source.getSubimage(x0, y0, x1 - x0, y1 - y0);
                }
                catch (Throwable pixels) {}
            } else if (source.getType() == 6) {
                try {
                    int j;
                    int i;
                    byte[] pixels = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                    int width = source.getWidth();
                    int height = source.getHeight();
                    block12: for (i = 0; i < width; ++i) {
                        for (j = 0; j < height; ++j) {
                            if (pixels[(j * width + i) * 4] != 0) break block12;
                        }
                    }
                    int x0 = i;
                    block14: for (j = 0; j < height; ++j) {
                        for (i = 0; i < width; ++i) {
                            if (pixels[(j * width + i) * 4] != 0) break block14;
                        }
                    }
                    int y0 = j;
                    block16: for (i = width - 1; i >= 0; --i) {
                        for (j = 0; j < height; ++j) {
                            if (pixels[(j * width + i) * 4] != 0) break block16;
                        }
                    }
                    int x1 = i + 1;
                    block18: for (j = height - 1; j >= 0; --j) {
                        for (i = 0; i < width; ++i) {
                            if (pixels[(j * width + i) * 4] != 0) break block18;
                        }
                    }
                    int y1 = j + 1;
                    if (x0 == 0 && y0 == 0 && x1 - x0 == height && y1 - y0 == width) {
                        return source;
                    }
                    return source.getSubimage(x0, y0, x1 - x0, y1 - y0);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return source;
    }

    public static ImageIcon getImageIcon(URL resource) {
        return new ImageIcon(IconIO.getImage(resource));
    }

    public static ImageIcon getImageIcon(URL resource, int size) {
        if (resource != null && StringUtils.endsWithCaseInsensitive(resource.getPath(), ".svg")) {
            if (IconIO.getSvgFactory() != null) {
                try {
                    return new ImageIcon(IconIO.getSvgFactory().getImageFromSVG(resource, size, size));
                }
                catch (IOException e) {
                    LogV3.log(e);
                    return new ImageIcon(ImageProvider.createIcon("DUMMY", size, size));
                }
            }
            LogV3.warning("SVG Factory not found!");
            return new ImageIcon(ImageProvider.createIcon("DUMMY", size, size));
        }
        if (size <= 0) {
            return new ImageIcon(IconIO.getImage(resource));
        }
        return new ImageIcon(IconIO.getScaledInstance(IconIO.getImage(resource), size, size, Interpolation.BICUBIC, true));
    }

    public static Icon getScaledInstance(Icon icon, int width, int height) {
        return IconIO.getScaledInstance(icon, width, height, Interpolation.BICUBIC);
    }

    public static Icon getScaledInstance(Icon icon, int width, int height, Interpolation bicubic) {
        ImageIcon iIcon;
        if (icon instanceof ImageIcon && (iIcon = (ImageIcon)icon).getIconHeight() == height && iIcon.getIconWidth() == width) {
            return icon;
        }
        if (icon instanceof ScaledIcon) {
            ScaledIcon sIcon = (ScaledIcon)icon;
            if (sIcon.getIconHeight() == height && sIcon.getIconWidth() == width) {
                return icon;
            }
            return new ScaledIcon(sIcon.getSource(), width, height, bicubic);
        }
        return new ScaledIcon(icon, width, height, bicubic);
    }

    public static BufferedImage getScaledInstance(Image img, int width, int height) {
        return IconIO.getScaledInstance(img, width, height, Interpolation.BICUBIC, true);
    }

    public static BufferedImage getScaledInstance(Image img, int width, int height, Interpolation interpolation, boolean higherQuality, boolean keepratio) {
        int h;
        int w;
        double faktor = Math.max((double)img.getWidth(null) / (double)width, (double)img.getHeight(null) / (double)height);
        if (keepratio) {
            width = Math.max((int)((double)img.getWidth(null) / faktor), 1);
            height = Math.max((int)((double)img.getHeight(null) / faktor), 1);
            if (faktor == 1.0 && img instanceof BufferedImage) {
                return (BufferedImage)img;
            }
        } else if (img instanceof BufferedImage && height == img.getHeight(null) && width == img.getWidth(null)) {
            return (BufferedImage)img;
        }
        Image ret = img;
        if (higherQuality) {
            w = Math.max(width, img.getWidth(null));
            h = Math.max(height, img.getHeight(null));
        } else {
            w = width;
            h = height;
        }
        do {
            if (higherQuality && w > width && (w /= 2) < width) {
                w = width;
            }
            if (higherQuality && h > height && (h /= 2) < height) {
                h = height;
            }
            int type = 6;
            if (ret instanceof BufferedImage && (type = ((BufferedImage)ret).getType()) == 0) {
                type = 6;
            }
            if (w == 0) {
                int n = 2;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolation.getHint());
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != width || h != height);
        return (BufferedImage)ret;
    }

    public static BufferedImage getScaledInstance(Image img, int width, int height, Interpolation interpolation, boolean higherQuality) {
        return IconIO.getScaledInstance(img, width, height, interpolation, higherQuality, true);
    }

    public static Image getTransparent(Image src, float f) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        BufferedImage image = new BufferedImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, f));
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return image;
    }

    public static ImageIcon getTransparentIcon(Image src, float f) {
        return new ImageIcon(IconIO.getTransparent(src, f));
    }

    public static BufferedImage paint(BufferedImage paintTo, Image image, int xoffset, int yoffset) {
        Graphics2D g2 = paintTo.createGraphics();
        g2.drawImage(image, xoffset, yoffset, null);
        g2.dispose();
        IconIO.debug(paintTo);
        return paintTo;
    }

    public static BufferedImage removeBackground(BufferedImage image, double tollerance) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int biggestValue = 0;
        int color = -1;
        for (int rgb : image.getRGB(0, 0, image.getWidth() - 1, image.getHeight() - 1, null, 0, image.getWidth())) {
            Integer v = (Integer)map.get(rgb);
            if (v == null) {
                v = 0;
            }
            Integer n = v;
            Integer n2 = v = Integer.valueOf(v + 1);
            map.put(rgb, v);
            if (v <= biggestValue) continue;
            biggestValue = v;
            color = rgb;
        }
        Color col = new Color(color);
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        int a = col.getAlpha();
        return IconIO.colorRangeToTransparency(image, new Color(Math.max((int)((double)r * (1.0 - tollerance)), 0), Math.max((int)((double)g * (1.0 - tollerance)), 0), Math.max((int)((double)b * (1.0 - tollerance)), 0), a), new Color(Math.min(255, (int)((double)r * (1.0 + tollerance))), Math.min(255, (int)((double)g * (1.0 + tollerance))), Math.min(255, (int)((double)b * (1.0 + tollerance))), a));
    }

    public static BufferedImage rotate(BufferedImage src, int degree) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        AffineTransform at = new AffineTransform();
        at.rotate((double)degree * Math.PI / 180.0);
        Point2D.Double p2din = new Point2D.Double(0.0, 0.0);
        Point2D p2dout = at.transform(p2din, null);
        double ytrans = p2dout.getY();
        double xtrans = p2dout.getX();
        p2din = new Point2D.Double(0.0, h);
        p2dout = at.transform(p2din, null);
        ytrans = Math.min(ytrans, p2dout.getY());
        xtrans = Math.min(xtrans, p2dout.getX());
        p2din = new Point2D.Double(w, h);
        p2dout = at.transform(p2din, null);
        ytrans = Math.min(ytrans, p2dout.getY());
        xtrans = Math.min(xtrans, p2dout.getX());
        p2din = new Point2D.Double(w, 0.0);
        p2dout = at.transform(p2din, null);
        ytrans = Math.min(ytrans, p2dout.getY());
        xtrans = Math.min(xtrans, p2dout.getX());
        AffineTransform tat = new AffineTransform();
        tat.translate(-xtrans, -ytrans);
        at.preConcatenate(tat);
        AffineTransformOp bio = new AffineTransformOp(at, 2);
        Rectangle r = bio.getBounds2D(src).getBounds();
        BufferedImage image = new BufferedImage(r.width, r.height, 2);
        image = bio.filter(src, image);
        return image;
    }

    public static Image toImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return IconIO.toBufferedImage(icon);
    }

    public static BufferedImage toBufferedImage(Icon icon) {
        Image img;
        if (icon instanceof ImageIcon && (img = ((ImageIcon)icon).getImage()) instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (Application.isHeadless()) {
            BufferedImage image = new BufferedImage(w, h, 3);
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            return image;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public static BufferedImage toBufferedImage(Image src) {
        if (src instanceof BufferedImage) {
            return (BufferedImage)src;
        }
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        BufferedImage image = new BufferedImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return image;
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return new ImageIcon(IconIO.toBufferedImage(icon));
    }

    public static String toDataUrl(BufferedImage image, DataURLFormat dataURLFormat) throws IOException {
        String ret;
        BufferedImage ouput;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64OutputStream b64os = new Base64OutputStream(bos);
        switch (dataURLFormat) {
            case JPG: {
                ouput = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                break;
            }
            default: {
                ouput = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            }
        }
        Graphics g = ouput.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        switch (dataURLFormat) {
            case JPG: {
                ImageProvider.writeImage((RenderedImage)ouput, "jpg", b64os);
                b64os.close();
                ret = "image/jpeg;base64," + bos.toString("UTF-8");
                break;
            }
            default: {
                ImageProvider.writeImage((RenderedImage)ouput, "png", b64os);
                b64os.close();
                ret = "image/png;base64," + bos.toString("UTF-8");
            }
        }
        return ret;
    }

    public static BufferedImage colorRangeToTransparency(BufferedImage image, Color col, double tollerance) {
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        int a = col.getAlpha();
        return IconIO.colorRangeToTransparency(image, new Color(Math.max((int)((double)r * (1.0 - tollerance)), 0), Math.max((int)((double)g * (1.0 - tollerance)), 0), Math.max((int)((double)b * (1.0 - tollerance)), 0), a), new Color(Math.min(255, (int)((double)r * (1.0 + tollerance))), Math.min(255, (int)((double)g * (1.0 + tollerance))), Math.min(255, (int)((double)b * (1.0 + tollerance))), a));
    }

    public static Icon replaceColor(Icon icon, Color search, int tollerance, Color replace, boolean keepBrightness) {
        return new ImageIcon(IconIO.replaceColor(IconIO.toBufferedImage(icon), search, tollerance, replace, keepBrightness));
    }

    public static Image replaceColor(BufferedImage image, Color search, final int tollerance, final Color replace, final boolean keepBrightness) {
        final int a1 = search.getAlpha();
        final int r1 = search.getRed();
        final int g1 = search.getGreen();
        final int b1 = search.getBlue();
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb >> 0 & 0xFF;
                if (r != 0 || b != 0 || g == 0) {
                    // empty if block
                }
                if (Math.abs(r - r1) <= tollerance && Math.abs(g - g1) <= tollerance && Math.abs(b - b1) <= tollerance && Math.abs(a - a1) <= tollerance) {
                    if (!keepBrightness) {
                        return replace.getRGB();
                    }
                    double brightness = (double)((r + g + b) / 3) / 255.0;
                    Color nc = new Color((int)((double)replace.getRed() * brightness), (int)((double)replace.getGreen() * brightness), (int)((double)replace.getBlue() * brightness), (int)((double)replace.getAlpha() * brightness));
                    return nc.getRGB();
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        Image img = Toolkit.getDefaultToolkit().createImage(ip);
        return img;
    }

    public static byte[] toJpgBytes(Image image) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedImage jpg = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics g = jpg.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        ImageProvider.writeImage((RenderedImage)jpg, "jpg", bos);
        bos.close();
        return bos.toByteArray();
    }

    public static Icon getIconFromDataUrl(String dataURL) throws IOException {
        return new ImageIcon(IconIO.getImageFromDataUrl(dataURL));
    }

    public static Image getImageFromDataUrl(String dataURL) throws IOException {
        int base64Index = dataURL.indexOf(";base64,");
        CharBuffer cb = base64Index > 0 && base64Index + 8 < dataURL.length() ? CharBuffer.wrap(dataURL, base64Index + 8, dataURL.length()) : CharBuffer.wrap(dataURL);
        Base64InputStream is = new Base64InputStream(new CharSequenceInputStream(cb, Charset.forName("UTF-8")));
        return ImageIO.read(is);
    }

    static {
        ImageIO.setUseCache(false);
    }

    public static enum DataURLFormat {
        JPG,
        PNG;

    }

    public static class ScaledIcon
    implements Icon,
    IDIcon {
        private final Icon source;
        private final int width;
        private final int height;
        private final Interpolation interpolation;
        private final double faktor;

        protected Icon getSource() {
            return this.source;
        }

        public ScaledIcon(Icon icon, int width, int height, Interpolation interpolation) {
            this.source = icon;
            this.faktor = 1.0 / Math.max((double)icon.getIconWidth() / (double)width, (double)icon.getIconHeight() / (double)height);
            this.width = Math.max((int)((double)icon.getIconWidth() * this.faktor), 1);
            this.height = Math.max((int)((double)icon.getIconHeight() * this.faktor), 1);
            this.interpolation = interpolation;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolation.getHint());
            AffineTransform old = g2.getTransform();
            g2.translate(x, y);
            g2.scale(this.faktor, this.faktor);
            this.source.paintIcon(c, g, 0, 0);
            g2.setTransform(old);
        }

        @Override
        public IconIdentifier getIdentifier() {
            if (this.source instanceof IDIcon) {
                return ((IDIcon)((Object)this.source)).getIdentifier();
            }
            return new IconIdentifier("unknown", this.source.toString());
        }
    }
}

