/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String whitespace_chars = "[\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]";
    private static String EMPTY_SPACE_STRING = "                                                                                                                                                                                                                                                             ";
    public static final Pattern NEWLINE = Pattern.compile("[\r\n]{1,2}");
    public static final Pattern DEFAULT_WRAP_BEFORE = Pattern.compile("(\\s)");
    public static final Pattern DEFAULT_WRAP_AFTER = Pattern.compile("$^");

    public static boolean contains(String input, String contains) {
        if (input == null || contains == null) {
            return false;
        }
        return input.contains(contains);
    }

    public static String[] getLines(String arg) {
        if (arg == null) {
            return new String[0];
        }
        String[] splits = arg.split("(\r\n|\r|\n)");
        ArrayList<String> ret = new ArrayList<String>(splits.length);
        for (String split : splits) {
            ret.add(split.trim());
        }
        return ret.toArray(new String[0]);
    }

    public static String formatByPadLength(int padLength, int num) {
        return String.format(Locale.US, "%0" + padLength + "d", num);
    }

    public static boolean endsWithCaseInsensitive(String name, String endsWith) {
        if (name == null || endsWith == null) {
            return false;
        }
        if (endsWith.length() > name.length()) {
            return false;
        }
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(endsWith)) {
            return false;
        }
        return name.endsWith(endsWith) || name.toLowerCase(Locale.ENGLISH).endsWith(endsWith.toLowerCase(Locale.ENGLISH));
    }

    public static boolean startsWithCaseInsensitive(String name, String startsWith) {
        if (name == null || startsWith == null) {
            return false;
        }
        if (startsWith.length() > name.length()) {
            return false;
        }
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(startsWith)) {
            return false;
        }
        return name.startsWith(startsWith) || name.toLowerCase(Locale.ENGLISH).startsWith(startsWith.toLowerCase(Locale.ENGLISH));
    }

    public static boolean containsIgnoreCase(String input, String contains) {
        if (input == null || contains == null) {
            return false;
        }
        if (contains.length() > input.length()) {
            return false;
        }
        return input.contains(contains) || input.toLowerCase(Locale.ENGLISH).contains(contains.toLowerCase(Locale.ENGLISH));
    }

    public static String trim(String input) {
        if (input != null) {
            return StringUtils.removeBOM(input.replaceAll("^[\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]+", "").replaceAll("[\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]+$", ""));
        }
        return null;
    }

    public static String removeBOM(String input) {
        if (input != null && input.startsWith("\ufeff")) {
            return input.substring(1);
        }
        return input;
    }

    public static String nullOrNonEmpty(String x) {
        if (StringUtils.isNotEmpty(x)) {
            return x;
        }
        return null;
    }

    public static String valueOrEmpty(String x) {
        if (x == null) {
            return "";
        }
        return x;
    }

    public static String nullify(String string) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        return string;
    }

    public static boolean equals(String x, String y) {
        if (x == y) {
            return true;
        }
        if (x == null && y != null) {
            return false;
        }
        if (y == null && x != null) {
            return false;
        }
        return x.equals(y);
    }

    public static boolean equals(String ... values) {
        int len = values.length;
        String first = values[0];
        for (int index = 1; index < len; ++index) {
            if (StringUtils.equals(first, values[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String x, String y) {
        if (x == y) {
            return true;
        }
        return x != null && x.equalsIgnoreCase(y);
    }

    public static boolean equalsIgnoreCase(String ... values) {
        int len = values.length;
        String first = values[0];
        for (int index = 1; index < len; ++index) {
            if (StringUtils.equalsIgnoreCase(first, values[index])) continue;
            return false;
        }
        return true;
    }

    public static String fillPre(String string, String filler, int minCount) {
        if (string.length() >= minCount) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minCount);
        int missing = minCount - string.length();
        if (" ".equals(filler) && missing <= EMPTY_SPACE_STRING.length()) {
            sb.append(EMPTY_SPACE_STRING, 0, missing);
            sb.append(string);
        } else {
            missing = missing / filler.length() + (missing % filler.length() == 0 ? 0 : 1);
            for (int i = 0; i < missing; ++i) {
                sb.append(filler);
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static String fillPost(String string, String filler, int minCount) {
        if (string.length() >= minCount) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minCount);
        int missing = minCount - string.length();
        if (" ".equals(filler) && missing <= EMPTY_SPACE_STRING.length()) {
            sb.append(string);
            sb.append(EMPTY_SPACE_STRING, 0, missing);
            return sb.toString();
        }
        sb.append(string);
        while (sb.length() < minCount) {
            sb.append(filler);
        }
        return sb.toString();
    }

    public static String getCommonalities(String a, String b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        int i = 0;
        int max = Math.min(a.length(), b.length());
        for (i = 0; i < max; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return a.substring(0, i);
    }

    public static String getCommonalities(String ... values) {
        String ret = null;
        for (String value : values) {
            if ((ret = ret == null ? value : StringUtils.getCommonalities(ret, value)).length() != 0) continue;
            return "";
        }
        return ret;
    }

    public static final boolean isEmpty(String value) {
        return value == null || value.length() == 0 || StringUtils.isEmptyAfterTrim(value);
    }

    public static final boolean isEmptyAfterTrim(String value) {
        int st;
        int len = value.length();
        if (len == 0) {
            return true;
        }
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        return st == len;
    }

    public static final boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static final boolean isAllEmpty(String ... values) {
        if (values != null) {
            for (String value : values) {
                if (value == null || StringUtils.isEmptyAfterTrim(value)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isAllNotEmpty(String ... values) {
        if (values != null) {
            for (String value : values) {
                if (!StringUtils.isEmpty(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String join(Object[] parameters, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object s : parameters) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(String.valueOf(s));
        }
        return sb.toString();
    }

    public static String join(String separator, Object ... parameters) {
        StringBuilder sb = new StringBuilder();
        for (Object s : parameters) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(String.valueOf(s));
        }
        return sb.toString();
    }

    public static String join(Collection<? extends Object> params, String separator) {
        return StringUtils.join(params.toArray(new Object[0]), separator);
    }

    public static String join(String separator, int ... ints) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = ints;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer s = nArray[i];
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(String.valueOf(s));
        }
        return sb.toString();
    }

    public static List<String> createList(String string, int length) {
        ArrayList<String> ret = new ArrayList<String>(length);
        while (length-- > 0) {
            ret.add(string);
        }
        return ret;
    }

    public static String replaceAllByRegex(String regex, String replacement, String text) {
        if (text == null) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String abr(String defaultMessage, int max, String postfox) {
        if (defaultMessage == null) {
            return null;
        }
        if (defaultMessage.length() <= max) {
            return defaultMessage;
        }
        return defaultMessage.substring(0, max) + postfox;
    }

    public static String toCamelCase(String name, boolean firstUpper) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        boolean firstFlag = true;
        for (String p : name.split("[\\_\\-\\s]+")) {
            if (p.length() <= 0) continue;
            String first = p.substring(0, 1);
            if (firstFlag) {
                if (firstUpper) {
                    sb.append(first.toUpperCase(Locale.ENGLISH));
                } else {
                    sb.append(first.toLowerCase(Locale.ENGLISH));
                }
                firstFlag = false;
            } else {
                sb.append(first.toUpperCase(Locale.ENGLISH));
            }
            sb.append(p, 1, p.length());
        }
        return sb.toString();
    }

    public static String shareAtLeastOne(String[] xArray, String[] yArray, boolean caseInsensitive) {
        if (xArray == null || yArray == null || xArray.length == 0 || yArray.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String x : xArray) {
            if (caseInsensitive) {
                set.add(x.toLowerCase(Locale.ENGLISH));
                continue;
            }
            set.add(x);
        }
        for (String y : yArray) {
            boolean contains = caseInsensitive ? set.contains(y.toLowerCase(Locale.ENGLISH)) : set.contains(y);
            if (!contains) continue;
            return y;
        }
        return null;
    }

    public static String[] splitNoEmpty(String value, String delim) {
        if (value == null) {
            return new String[0];
        }
        String[] splits = value.split(delim);
        ArrayList<String> ret = new ArrayList<String>(splits.length);
        for (String split : splits) {
            if (!StringUtils.isNotEmpty(split)) continue;
            ret.add(split);
        }
        return ret.toArray(new String[0]);
    }

    public static String firstNotEmpty(String ... entries) {
        for (String s : entries) {
            if (!StringUtils.isNotEmpty(s)) continue;
            return s;
        }
        return null;
    }

    public static int getPadLength(int num) {
        if (num >= 0) {
            return String.valueOf(num).length();
        }
        throw new IllegalArgumentException("num must be >=0!:" + num);
    }

    public static String valueOfOrNull(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static String toUpperCaseOrNull(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.toUpperCase(locale);
    }

    public static String toUpperCaseOrNull(String value) {
        return StringUtils.toUpperCaseOrNull(value, Locale.ENGLISH);
    }

    public static String toLowerCaseOrNull(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.toLowerCase(locale);
    }

    public static String toLowerCaseOrNull(String value) {
        return StringUtils.toLowerCaseOrNull(value, Locale.ENGLISH);
    }

    public static String camelCaseToUnderscore(String key, boolean uppercase) {
        StringBuilder staticKey = new StringBuilder(key.length());
        char lastc = ' ';
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (staticKey.length() > 0 && Character.isUpperCase(c) && Character.isLowerCase(lastc)) {
                staticKey.append('_');
            }
            staticKey.append(uppercase ? Character.toUpperCase(c) : Character.toLowerCase(c));
            lastc = c;
        }
        return staticKey.toString();
    }

    public static String wrapText(String trim, int size) {
        return StringUtils.wrapText(trim, size, null, null, true);
    }

    public static String wrapText(String trim, int size, String patternWrapBefore, String patternWrapAfter, boolean forceWrapLongWords) {
        if (size == 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        Pattern patBefore = patternWrapBefore == null ? DEFAULT_WRAP_BEFORE : Pattern.compile(patternWrapBefore);
        Pattern paAfter = patternWrapAfter == null ? DEFAULT_WRAP_AFTER : Pattern.compile(patternWrapAfter);
        return StringUtils.wrap(trim, size, forceWrapLongWords, patBefore, paAfter);
    }

    public static String wrap(String stringToWrap, int maxCharsPerLine, boolean forceWrapLongWords, Pattern patternBefore, Pattern patternAfter) {
        if (maxCharsPerLine == 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        StringBuilder ret = new StringBuilder();
        Pattern newLine = NEWLINE;
        while (stringToWrap.length() > 0) {
            String replaceBefore;
            int splitAfterAt;
            int splitBeforeAt;
            block20: {
                int last;
                Matcher matcherAfter;
                block19: {
                    Matcher newLineMatcher = newLine.matcher(stringToWrap);
                    if (newLineMatcher.find() && newLineMatcher.start() <= maxCharsPerLine) {
                        if (ret.length() > 0) {
                            ret.append("\r\n");
                        }
                        ret.append(stringToWrap.substring(0, newLineMatcher.start()));
                        stringToWrap = stringToWrap.substring(newLineMatcher.end());
                        continue;
                    }
                    if (stringToWrap.length() < maxCharsPerLine) {
                        if (ret.length() > 0) {
                            ret.append("\r\n");
                        }
                        ret.append(stringToWrap);
                        return ret.toString();
                    }
                    Matcher matcherBefore = patternBefore == null ? null : patternBefore.matcher(stringToWrap);
                    matcherAfter = patternAfter == null ? null : patternAfter.matcher(stringToWrap);
                    splitBeforeAt = 0;
                    splitAfterAt = 0;
                    last = 0;
                    replaceBefore = null;
                    while (matcherBefore.find()) {
                        int start = matcherBefore.start();
                        int end = matcherBefore.end();
                        if (start > maxCharsPerLine) {
                            if (last == 0 && !forceWrapLongWords) {
                                replaceBefore = null;
                                splitBeforeAt = start;
                            } else {
                                splitBeforeAt = last;
                            }
                        } else {
                            replaceBefore = null;
                            int gc = matcherBefore.groupCount();
                            for (int i = 1; i < gc + 1; ++i) {
                                String gourp = matcherBefore.group(i);
                                if (gourp == null || replaceBefore != null) continue;
                                replaceBefore = gourp;
                            }
                            last = start;
                            if (end != stringToWrap.length()) continue;
                            splitBeforeAt = start;
                        }
                        break block19;
                    }
                    splitBeforeAt = last;
                }
                last = 0;
                while (matcherAfter.find()) {
                    int end = matcherAfter.end();
                    if (end > maxCharsPerLine || end == stringToWrap.length()) {
                        splitAfterAt = last == 0 && !forceWrapLongWords ? end : last;
                        break block20;
                    }
                    last = end;
                }
                splitAfterAt = last;
            }
            int splitAT = Math.max(splitAfterAt, splitBeforeAt);
            if (splitAfterAt > maxCharsPerLine && splitBeforeAt <= maxCharsPerLine) {
                splitAT = splitBeforeAt;
            }
            if (splitBeforeAt > maxCharsPerLine && splitAfterAt <= maxCharsPerLine) {
                splitAT = splitAfterAt;
            }
            if (splitAT == 0) {
                splitAT = forceWrapLongWords ? maxCharsPerLine : stringToWrap.length();
            }
            if (ret.length() > 0) {
                ret.append("\r\n");
            }
            splitAT = Math.min(splitAT, stringToWrap.length());
            ret.append(stringToWrap.substring(0, splitAT));
            if (replaceBefore != null && splitAT == splitBeforeAt) {
                splitAT += replaceBefore.length();
            }
            stringToWrap = stringToWrap.substring(splitAT);
        }
        return ret.toString();
    }

    public static String multiLineIntend(String text, String ... intends) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = Pattern.compile("(\r\n)|(\r)|(\n)").matcher(text);
        int offset = 0;
        int lineCount = 0;
        while (matcher.find()) {
            sb.append(intends[Math.min(intends.length - 1, lineCount)]);
            sb.append(text, offset, matcher.start());
            sb.append(text, matcher.start(0), matcher.end(0));
            offset = matcher.end();
            ++lineCount;
        }
        sb.append(intends[Math.min(intends.length - 1, lineCount)]);
        sb.append(text, offset, text.length());
        return sb.toString();
    }

    public static String underscoreToCamelCase(String underscore) {
        StringBuilder staticKey = new StringBuilder(underscore.length());
        boolean nextUpper = false;
        for (int i = 0; i < underscore.length(); ++i) {
            char c = underscore.charAt(i);
            if (c == '_') {
                nextUpper = true;
                continue;
            }
            staticKey.append(nextUpper ? Character.toUpperCase(c) : Character.toLowerCase(c));
            nextUpper = false;
        }
        return staticKey.toString();
    }

    public static List<String> listWithoutEmptyStrings(String ... strings) {
        ArrayList<String> ret = new ArrayList<String>(strings.length);
        for (String s : strings) {
            if (!StringUtils.isNotEmpty(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    public static String upperLowerAfterRegex(String pattern, String string, Boolean firstUpper, Boolean restUpper) {
        String[] split = string.split("((?<=" + pattern + "))");
        StringBuilder sb = new StringBuilder(string.length());
        for (String s : split) {
            if (s.length() == 0) continue;
            if (firstUpper == Boolean.TRUE) {
                sb.append(s.substring(0, 1).toUpperCase(Locale.ROOT));
            } else if (firstUpper == Boolean.FALSE) {
                sb.append(s.substring(0, 1).toLowerCase(Locale.ROOT));
            } else {
                sb.append(s, 0, 1);
            }
            if (s.length() <= 1) continue;
            if (restUpper == Boolean.TRUE) {
                String upperCase = s.toUpperCase(Locale.ROOT);
                sb.append(upperCase, 1, upperCase.length());
                continue;
            }
            if (restUpper == Boolean.FALSE) {
                String lowerCase = s.toLowerCase(Locale.ROOT);
                sb.append(lowerCase, 1, lowerCase.length());
                continue;
            }
            sb.append(s, 1, s.length());
        }
        return sb.toString();
    }

    public static int indexOf(String input, String regex) {
        return StringUtils.indexOf(input, Pattern.compile(regex));
    }

    public static int indexOf(String input, int fromIndex, Pattern regex) {
        if (fromIndex >= input.length()) {
            return -1;
        }
        Matcher matcher = regex.matcher(input);
        if (fromIndex <= 0) {
            fromIndex = 0;
        }
        if (!matcher.find(fromIndex)) {
            return -1;
        }
        int ret = matcher.start();
        return ret;
    }

    public static int indexOf(String input, Pattern regex) {
        return StringUtils.indexOf(input, 0, regex);
    }

    public static int damerauLevenshtein(CharSequence source, CharSequence target) {
        int i;
        if (source == null || target == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        int sourceLength = source.length();
        int targetLength = target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        int[][] dist = new int[sourceLength + 1][targetLength + 1];
        for (i = 0; i < sourceLength + 1; ++i) {
            dist[i][0] = i;
        }
        for (int j = 0; j < targetLength + 1; ++j) {
            dist[0][j] = j;
        }
        for (i = 1; i < sourceLength + 1; ++i) {
            for (int j = 1; j < targetLength + 1; ++j) {
                int cost = source.charAt(i - 1) == target.charAt(j - 1) ? 0 : 1;
                dist[i][j] = Math.min(Math.min(dist[i - 1][j] + 1, dist[i][j - 1] + 1), dist[i - 1][j - 1] + cost);
                if (i <= 1 || j <= 1 || source.charAt(i - 1) != target.charAt(j - 2) || source.charAt(i - 2) != target.charAt(j - 1)) continue;
                dist[i][j] = Math.min(dist[i][j], dist[i - 2][j - 2] + cost);
            }
        }
        return dist[sourceLength][targetLength];
    }

    public static int levenshtein(String strA, String strB, boolean caseINsensitive) {
        int i;
        if (caseINsensitive) {
            strA = strA.toLowerCase(Locale.ROOT);
            strB = strB.toLowerCase(Locale.ROOT);
        }
        int[] costs = new int[strB.length() + 1];
        for (i = 0; i < costs.length; ++i) {
            costs[i] = i;
        }
        for (i = 1; i <= strA.length(); ++i) {
            int weigther = i - 1;
            costs[0] = i;
            for (int ii = 1; ii <= strB.length(); ++ii) {
                int cj = Math.min(1 + Math.min(costs[ii], costs[ii - 1]), strA.charAt(i - 1) == strB.charAt(ii - 1) ? weigther : weigther + 1);
                weigther = costs[ii];
                costs[ii] = cj;
            }
        }
        return costs[strB.length()];
    }
}

