/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.appwork.utils.JDK8BufferHelper;
import org.appwork.utils.Regex;

public class JVMVersion {
    public static final long JAVA_1_5 = 15000000L;
    @Deprecated
    public static final long JAVA15 = 15000000L;
    public static final long JAVA_1_6 = 16000000L;
    @Deprecated
    public static final long JAVA16 = 16000000L;
    public static final long JAVA_1_7 = 17000000L;
    @Deprecated
    public static final long JAVA17 = 17000000L;
    public static final long JAVA_1_8 = 18000000L;
    @Deprecated
    public static final long JAVA18 = 18000000L;
    public static final long JAVA_9 = 9000000000000L;
    @Deprecated
    public static final long JAVA19 = 9000000000000L;
    public static final long JAVA_10 = 10000000000000L;
    public static final long JAVA_11 = 11000000000000L;
    public static final long JAVA_12 = 12000000000000L;
    public static final long JAVA_13 = 13000000000000L;
    public static final long JAVA_14 = 14000000000000L;
    public static final long JAVA_15 = 15000000000000L;
    public static final long JAVA_16 = 16000000000000L;
    public static final long JAVA_17 = 17000000000000L;
    public static final long JAVA_18 = 18000000000000L;
    public static final long JAVA_19 = 19000000000000L;
    public static final long JAVA_20 = 20000000000000L;
    public static final long JAVA_21 = 21000000000000L;
    public static final long JAVA_22 = 22000000000000L;
    private static final long VERSION;

    public static final long get() {
        return VERSION;
    }

    public static final boolean isMinimum(long version) {
        return VERSION >= version;
    }

    public static String getJVMVersion() {
        String version = System.getProperty("java.runtime.version");
        if (version == null || version.trim().length() == 0) {
            return System.getProperty("java.version");
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getMinimumJVMVersionForClassFile(URL url) throws IOException {
        InputStream is = url.openStream();
        try {
            long l = JVMVersion.getMinimumJVMVersionForClassFile(is);
            return l;
        }
        finally {
            is.close();
        }
    }

    public static long getMinimumJVMVersionForClassFile(InputStream is) throws IOException {
        try {
            DataInputStream dis = new DataInputStream(is);
            byte[] magic = new byte[4];
            dis.readFully(magic);
            if (Arrays.equals(magic, new byte[]{-54, -2, -70, -66})) {
                byte[] minor = new byte[2];
                dis.readFully(minor);
                byte[] major = new byte[2];
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                byteBuffer.put(major);
                dis.readFully(major);
                byteBuffer.put(major);
                JDK8BufferHelper.flip(byteBuffer);
                int majorVersion = byteBuffer.getInt();
                switch (majorVersion) {
                    case 66: {
                        return 22000000000000L;
                    }
                    case 65: {
                        return 21000000000000L;
                    }
                    case 64: {
                        return 20000000000000L;
                    }
                    case 63: {
                        return 19000000000000L;
                    }
                    case 62: {
                        return 18000000000000L;
                    }
                    case 61: {
                        return 17000000000000L;
                    }
                    case 60: {
                        return 16000000000000L;
                    }
                    case 59: {
                        return 15000000000000L;
                    }
                    case 58: {
                        return 14000000000000L;
                    }
                    case 57: {
                        return 13000000000000L;
                    }
                    case 56: {
                        return 12000000000000L;
                    }
                    case 55: {
                        return 11000000000000L;
                    }
                    case 54: {
                        return 10000000000000L;
                    }
                    case 53: {
                        return 9000000000000L;
                    }
                    case 52: {
                        return 18000000L;
                    }
                    case 51: {
                        return 17000000L;
                    }
                    case 50: {
                        return 16000000L;
                    }
                    case 49: {
                        return 15000000L;
                    }
                }
                return -1L;
            }
            return -1L;
        }
        catch (EOFException e) {
            return -1L;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public static long parseJavaVersionString(String version) {
        String b;
        String u;
        if (version != null) {
            version = version.replaceFirst("\\s*-\\s*LTS$", "");
        }
        String majorFeature = new Regex(version, "^(\\d+)").getMatch(0);
        String minorInterim = new Regex(version, "^\\d+\\.(\\d+)").getMatch(0);
        String securityUpdate = new Regex(version, "^\\d+\\.\\d+\\.(\\d+)").getMatch(0);
        long ret = 0L;
        if ("1".equals(majorFeature) && minorInterim != null) {
            ret = Long.parseLong(minorInterim) * 1000L * 1000L + 10000000L;
            u = new Regex(version, "^.*?_(\\d+)").getMatch(0);
            b = new Regex(version, "^.*?(_|-)b(\\d+)$").getMatch(1);
        } else if (majorFeature != null) {
            long major = Long.parseLong(majorFeature);
            u = new Regex(version, "u(\\d+)").getMatch(0);
            b = new Regex(version, "\\+(\\d+)$").getMatch(0);
            if (major < 5L) {
                return 15000000L;
            }
            if (major < 9L) {
                ret = major * 1000L * 1000L + 10000000L;
            } else {
                ret = major * 1000L * 1000L * 1000L * 1000L;
                if (minorInterim != null) {
                    ret += Math.min(999L, Long.parseLong(minorInterim)) * 1000L * 1000L * 1000L;
                }
                if (securityUpdate != null) {
                    ret += Math.min(999L, Long.parseLong(securityUpdate)) * 1000L * 1000L;
                }
            }
        } else {
            return 16000000L;
        }
        if (u != null) {
            ret += Math.min(999L, Long.parseLong(u)) * 1000L;
        }
        if (b != null) {
            ret += Math.min(999L, Long.parseLong(b));
        }
        return ret;
    }

    static {
        long version = -1L;
        try {
            String versionString = JVMVersion.getJVMVersion();
            version = JVMVersion.parseJavaVersionString(versionString);
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
            version = 16000000L;
        }
        VERSION = version;
    }
}

