/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.utils.Interruptible;

public class InterruptibleThread
extends Thread {
    private final CopyOnWriteArrayList<Interruptible> interruptibles = new CopyOnWriteArrayList();

    public InterruptibleThread(String string) {
        super(string);
    }

    public InterruptibleThread() {
    }

    public InterruptibleThread startThread() {
        this.start();
        return this;
    }

    public InterruptibleThread joinThread() throws InterruptedException {
        this.join();
        return this;
    }

    public InterruptibleThread(Runnable runnable, String string) {
        super(runnable, string);
    }

    public List<Interruptible> getInterruptibles() {
        return Collections.unmodifiableList(this.interruptibles);
    }

    @Override
    public void interrupt() {
        super.interrupt();
        for (Interruptible b : this.interruptibles) {
            b.interrupt(this);
        }
    }

    public boolean addInterruptible(Interruptible interruptible) {
        return interruptible != null && this.interruptibles.addIfAbsent(interruptible);
    }

    public boolean removeInterruptible(Interruptible interruptible) {
        return interruptible != null && this.interruptibles.remove(interruptible);
    }

    public static Boolean add(Interruptible interruptible) {
        Thread ct = Thread.currentThread();
        if (ct instanceof InterruptibleThread) {
            return ((InterruptibleThread)ct).addInterruptible(interruptible);
        }
        return null;
    }

    public static Boolean remove(Interruptible interruptible) {
        Thread ct = Thread.currentThread();
        if (ct instanceof InterruptibleThread) {
            return ((InterruptibleThread)ct).removeInterruptible(interruptible);
        }
        return null;
    }
}

