/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.ImageProvider;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.storage.config.MinTimeWeakReferenceCleanup;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.URLStream;

public class ImageProvider {
    private static final long MIN_LIFETIME = 20000L;
    private static HashMap<String, MinTimeWeakReference<BufferedImage>> IMAGE_CACHE = new HashMap();
    private static MinTimeWeakReferenceCleanup IMAGE_CACHE_CLEANUP = new MinTimeWeakReferenceCleanup(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMinTimeWeakReferenceCleanup(MinTimeWeakReference<?> minTimeWeakReference) {
            Object object = LOCK;
            synchronized (object) {
                IMAGE_CACHE.remove(minTimeWeakReference.getID());
            }
        }
    };
    private static HashMap<String, MinTimeWeakReference<ImageIcon>> IMAGEICON_CACHE = new HashMap();
    private static MinTimeWeakReferenceCleanup IMAGEICON_CACHE_CLEANUP = new MinTimeWeakReferenceCleanup(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMinTimeWeakReferenceCleanup(MinTimeWeakReference<?> minTimeWeakReference) {
            Object object = LOCK;
            synchronized (object) {
                IMAGEICON_CACHE.remove(minTimeWeakReference.getID());
            }
        }
    };
    private static WeakHashMap<Icon, MinTimeWeakReference<Icon>> DISABLED_ICON_CACHE = new WeakHashMap();
    private static Object LOCK = new Object();
    private static final AtomicReference<String> FONTNAME;

    public static BufferedImage convertToGrayScale(BufferedImage bufferedImage) {
        BufferedImage dest = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        for (int y = 0; y < dest.getHeight(); ++y) {
            for (int x = 0; x < dest.getWidth(); ++x) {
                int alpha = bufferedImage.getRGB(x, y) & 0xFF000000;
                Color tmp = new Color(bufferedImage.getRGB(x, y));
                int val = (int)((double)tmp.getRed() * 0.3 + (double)tmp.getGreen() * 0.59 + (double)tmp.getBlue() * 0.11);
                dest.setRGB(x, y, alpha | val | val << 8 & 0xFF00 | val << 16 & 0xFF0000);
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDrawFontName() {
        if (FONTNAME.get() != null) {
            return FONTNAME.get();
        }
        AtomicReference<String> atomicReference = FONTNAME;
        synchronized (atomicReference) {
            if (FONTNAME.get() != null) {
                return FONTNAME.get();
            }
            try {
                String[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                if (availableFontFamilyNames != null) {
                    for (String fontFamilyName : availableFontFamilyNames) {
                        if (!"Arial".equals(fontFamilyName)) continue;
                        FONTNAME.set(fontFamilyName);
                        return fontFamilyName;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            FONTNAME.set("Dialog");
            return "Dialog";
        }
    }

    public static BufferedImage createIcon(String string, int width, int height) {
        int w = Math.max(1, width);
        int h = Math.max(1, height);
        BufferedImage image = new BufferedImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        int size = 1 + width / string.length();
        try {
            String fontName = ImageProvider.getDrawFontName();
            g.setFont(new Font(fontName, 1, size));
            FontMetrics fontMetrics = g.getFontMetrics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, w - 1, h - 1);
            g.draw3DRect(0, 0, w - 1, h - 1, true);
            g.setColor(Color.BLACK);
            int ww = 0;
            int hh = 0;
            while (size > 0) {
                g.setFont(new Font(fontName, 1, --size));
                ww = fontMetrics.stringWidth(string);
                hh = fontMetrics.getAscent();
                if (ww >= w - 4 || hh >= h - 2) continue;
            }
            g.drawString(string, (w - ww) / 2, hh + (h - hh) / 2);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Throwable e) {
            if (ImageProvider.isBuggyFontEnvironment(e)) {
                g.setColor(Color.RED);
                g.fillRect(0, 0, w - 1, h - 1);
                BufferedImage bufferedImage = image;
                return bufferedImage;
            }
            throw new RuntimeException(e);
        }
        finally {
            g.dispose();
        }
    }

    public static BufferedImage dereferenceImage(Image image) throws IOException {
        BufferedImage bu = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics g = bu.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bu;
    }

    public static BufferedImage getBufferedImage(String name, boolean createDummy) throws IOException {
        return ImageProvider.getBufferedImage(name, createDummy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getBufferedImage(String name, boolean createDummy, boolean putIntoCache) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            MinTimeWeakReference<BufferedImage> cache;
            if (IMAGE_CACHE.containsKey(name) && (cache = IMAGE_CACHE.get(name)).get() != null) {
                return cache.get();
            }
            URL absolutePath = Application.getRessourceURL("images/" + name + ".png");
            try {
                LogV3.info("Init Image: " + name + ": " + absolutePath);
                BufferedImage image = ImageProvider.read(absolutePath);
                if (putIntoCache) {
                    if (image.getHeight() * image.getWidth() > 10000) {
                        // empty if block
                    }
                    IMAGE_CACHE.put(name, new MinTimeWeakReference<BufferedImage>(image, 20000L, name, IMAGE_CACHE_CLEANUP));
                }
                return image;
            }
            catch (IOException e) {
                LogV3.severe("Could not Init Image: " + absolutePath);
                if (createDummy) {
                    LogV3.log(e);
                    return ImageProvider.createIcon(name.toUpperCase(Locale.ENGLISH), 48, 48);
                }
                throw e;
            }
            catch (Throwable e) {
                LogV3.severe("Could not Init Image: " + absolutePath);
                LogV3.log(e);
                return ImageProvider.createIcon(name.toUpperCase(Locale.ENGLISH), 48, 48);
            }
        }
    }

    public static boolean isBuggyFontEnvironment(Throwable throwable) {
        if (Application.isHeadless()) {
            if (Exceptions.getInstanceof(throwable, NoClassDefFoundError.class) != null) {
                return true;
            }
            if (Exceptions.getInstanceof(throwable, ClassCastException.class) != null) {
                return true;
            }
            return Exceptions.getInstanceof(throwable, NullPointerException.class) != null || Exceptions.getInstanceof(throwable, InvocationTargetException.class) != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon != null) {
            Object object = LOCK;
            synchronized (object) {
                Icon cachedDisabledIcon;
                MinTimeWeakReference<Icon> cache = DISABLED_ICON_CACHE.get(icon);
                Icon icon2 = cachedDisabledIcon = cache == null ? null : cache.get();
                if (cachedDisabledIcon != null) {
                    return cachedDisabledIcon;
                }
                if (!(icon instanceof ImageIcon)) {
                    icon = ImageProvider.toImageIcon(component, icon);
                }
                ImageIcon disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
                DISABLED_ICON_CACHE.put(icon, new MinTimeWeakReference<ImageIcon>(disabledIcon, 20000L, "disabled icon"));
                return disabledIcon;
            }
        }
        return null;
    }

    public static ImageIcon getImageIcon(String name, int x, int y) {
        try {
            return ImageProvider.getImageIcon(name, x, y, true);
        }
        catch (IOException e) {
            LogV3.log(e);
            return null;
        }
    }

    public static ImageIcon getImageIcon(String name, int width, int height, boolean createDummy) throws IOException {
        return ImageProvider.getImageIcon(name, width, height, createDummy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getImageIcon(String name, int width, int height, boolean createDummy, boolean putIntoCache) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            MinTimeWeakReference<ImageIcon> cache;
            StringBuilder SB = new StringBuilder();
            SB.append(name);
            SB.append('_');
            SB.append(width);
            SB.append('_');
            SB.append(height);
            String key = SB.toString();
            if (IMAGEICON_CACHE.containsKey(key) && (cache = IMAGEICON_CACHE.get(key)).get() != null) {
                return cache.get();
            }
            BufferedImage image = ImageProvider.getBufferedImage(name, createDummy, putIntoCache);
            double faktor = Math.max((double)image.getWidth(null) / (double)width, (double)image.getHeight(null) / (double)height);
            width = (int)((double)image.getWidth(null) / faktor);
            height = (int)((double)image.getHeight(null) / faktor);
            Image scaledWithFuckingReference = image.getScaledInstance(width, height, 4);
            BufferedImage referencelessVersion = ImageProvider.dereferenceImage(scaledWithFuckingReference);
            ImageIcon imageicon = new ImageIcon(referencelessVersion);
            if (putIntoCache) {
                IMAGEICON_CACHE.put(key, new MinTimeWeakReference<ImageIcon>(imageicon, 20000L, key, IMAGEICON_CACHE_CLEANUP));
            }
            return imageicon;
        }
    }

    public static void writeImage(RenderedImage im, String formatName, File file) throws IOException {
        if (!ImageIO.write(im, formatName, file)) {
            throw new IOException("no appropriate " + formatName + " writer found!");
        }
    }

    public static void writeImage(RenderedImage im, String formatName, OutputStream output) throws IOException {
        if (!ImageIO.write(im, formatName, output)) {
            throw new IOException("no appropriate " + formatName + " writer found!");
        }
    }

    public static ImageIcon getImageIconUnCached(String name, int x, int y) {
        try {
            return ImageProvider.getImageIcon(name, x, y, true, false);
        }
        catch (IOException e) {
            LogV3.log(e);
            return null;
        }
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int width, int height, Object hint, boolean higherQuality) {
        int h;
        int w;
        double faktor = Math.max((double)img.getWidth() / (double)width, (double)img.getHeight() / (double)height);
        width = (int)((double)img.getWidth() / faktor);
        height = (int)((double)img.getHeight() / faktor);
        if (faktor == 1.0) {
            return img;
        }
        BufferedImage ret = img;
        if (higherQuality) {
            w = Math.max(width, img.getWidth());
            h = Math.max(height, img.getHeight());
        } else {
            w = width;
            h = height;
        }
        do {
            if (higherQuality && w > width && (w /= 2) < width) {
                w = width;
            }
            if (higherQuality && h > height && (h /= 2) < height) {
                h = height;
            }
            BufferedImage tmp = new BufferedImage(w, h, ret.getType() == 0 ? 6 : ret.getType());
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != width || h != height);
        return ret;
    }

    public static BufferedImage merge(Image back, Image front, int xoffset, int yoffset) {
        int yoffsetBottom;
        int yoffsetTop;
        int xoffsetBottom;
        int xoffsetTop;
        if (xoffset >= 0) {
            xoffsetTop = 0;
            xoffsetBottom = xoffset;
        } else {
            xoffsetTop = -xoffset;
            xoffsetBottom = 0;
        }
        if (yoffset >= 0) {
            yoffsetTop = 0;
            yoffsetBottom = yoffset;
        } else {
            yoffsetTop = -yoffset;
            yoffsetBottom = 0;
        }
        return ImageProvider.merge(back, front, xoffsetTop, yoffsetTop, xoffsetBottom, yoffsetBottom);
    }

    public static BufferedImage merge(Icon back, Icon front, int xoffsetBack, int yoffsetBack, int xoffsetFront, int yoffsetFront, Composite backComposite, Composite frontComposite) {
        Composite old;
        int width = Math.max(xoffsetBack + back.getIconWidth(), xoffsetFront + front.getIconWidth());
        int height = Math.max(yoffsetBack + back.getIconHeight(), yoffsetFront + front.getIconHeight());
        BufferedImage dest = new BufferedImage(width, height, 3);
        Graphics2D g2 = dest.createGraphics();
        if (backComposite != null) {
            old = g2.getComposite();
            g2.setComposite(backComposite);
            back.paintIcon(null, g2, xoffsetBack, yoffsetBack);
            g2.setComposite(old);
        } else {
            back.paintIcon(null, g2, xoffsetBack, yoffsetBack);
        }
        if (frontComposite != null) {
            old = g2.getComposite();
            g2.setComposite(frontComposite);
            front.paintIcon(null, g2, xoffsetFront, yoffsetFront);
            g2.setComposite(old);
        } else {
            front.paintIcon(null, g2, xoffsetFront, yoffsetFront);
        }
        g2.dispose();
        return dest;
    }

    public static BufferedImage merge(Icon back, Icon front, int xoffsetBack, int yoffsetBack, int xoffsetFront, int yoffsetFront) {
        return ImageProvider.merge(back, front, xoffsetBack, yoffsetBack, xoffsetFront, yoffsetFront, null, null);
    }

    public static BufferedImage merge(Image back, Image front, int xoffsetBack, int yoffsetBack, int xoffsetFront, int yoffsetFront) {
        return ImageProvider.merge(new ImageIcon(back), new ImageIcon(front), xoffsetBack, yoffsetBack, xoffsetFront, yoffsetFront);
    }

    public static BufferedImage read(File input) throws IOException {
        if (!input.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        FileInputStream is = new FileInputStream(input);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage read(URL absolutePath) throws IOException {
        if (absolutePath == null) {
            throw new IllegalArgumentException("input == null!");
        }
        InputStream is = null;
        BufferedImage bi = null;
        try {
            is = URLStream.openStream(absolutePath);
            if (is == null) {
                throw new IIOException("Can't create an ImageInputStream!");
            }
            bi = ImageIO.read(is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return bi;
    }

    public static BufferedImage resizeWorkSpace(Image scaleBufferedImage, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 3);
        Graphics2D g = image.createGraphics();
        g.drawImage(scaleBufferedImage, (width - scaleBufferedImage.getWidth(null)) / 2, (height - scaleBufferedImage.getHeight(null)) / 2, null);
        g.dispose();
        return image;
    }

    public static Image scaleBufferedImage(BufferedImage img, int width, int height) {
        if (img == null) {
            return null;
        }
        double faktor = Math.max((double)img.getWidth() / (double)width, (double)img.getHeight() / (double)height);
        width = (int)((double)img.getWidth() / faktor);
        height = (int)((double)img.getHeight() / faktor);
        if (faktor == 1.0) {
            return img;
        }
        Image image = img.getScaledInstance(width, height, 4);
        try {
            return ImageProvider.dereferenceImage(image);
        }
        catch (IOException e) {
            LogV3.log(e);
            return null;
        }
    }

    public static ImageIcon scaleImageIcon(ImageIcon img, int w, int h) {
        BufferedImage dest;
        if (img.getIconHeight() == h && img.getIconWidth() == w) {
            return img;
        }
        if (ReflectionUtils.isInstanceOf("sun.awt.image.ToolkitImage", img.getImage())) {
            dest = new BufferedImage(w, h, 3);
            Graphics2D g2 = dest.createGraphics();
            g2.drawImage(img.getImage(), 0, 0, null);
            g2.dispose();
        } else {
            dest = (BufferedImage)img.getImage();
        }
        return new ImageIcon(ImageProvider.scaleBufferedImage(dest, w, h));
    }

    public static ImageIcon toImageIcon(JComponent component, Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = new BufferedImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            icon.paintIcon(component, g, 0, 0);
        }
        catch (NullPointerException e) {
            try {
                e.printStackTrace();
                JFrame frame = new JFrame();
                JButton bt = new JButton();
                frame.getContentPane().add(bt);
                icon.paintIcon(bt, g, 0, 0);
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
        g.dispose();
        return new ImageIcon(image);
    }

    public static ImageIcon toImageIcon(Icon icon) {
        return ImageProvider.toImageIcon(null, icon);
    }

    static {
        ImageIO.setUseCache(false);
        FONTNAME = new AtomicReference<Object>(null);
    }
}

