/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.IOErrorHandler;
import org.appwork.utils.NonInterruptibleRunnableException;
import org.appwork.utils.ProgressFeedback;
import org.appwork.utils.Time;
import org.appwork.utils.URLStream;
import org.appwork.utils.os.CrossSystem;

public class IO {
    public static void copyFile(File in, File out) throws IOException {
        IO.copyFile(in, out, null);
    }

    public static void copyFile(File in, File out, SYNC sync) throws IOException {
        IO.copyFile(null, in, out, sync);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(ProgressFeedback progress, File in, File out, SYNC sync) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            if (out.exists()) {
                throw new IOException("Cannot overwrite " + out);
            }
            if (!in.exists()) {
                throw new FileNotFoundException(in.getAbsolutePath());
            }
            fis = new FileInputStream(in);
            fos = new FileOutputStream(out);
            inChannel = fis.getChannel();
            outChannel = fos.getChannel();
            if (progress != null) {
                progress.setBytesTotal(in.length());
            }
            if (CrossSystem.isWindows()) {
                int maxCount = 67076096;
                long size = inChannel.size();
                for (long position = 0L; position < size; position += inChannel.transferTo(position, 67076096L, outChannel)) {
                    if (progress == null) continue;
                    progress.setBytesProcessed(position);
                }
            } else {
                int maxCount = 67076096;
                long size = inChannel.size();
                for (long position = 0L; position < size; position += inChannel.transferTo(position, 67076096L, outChannel)) {
                    if (progress == null) continue;
                    progress.setBytesProcessed(position);
                }
            }
            if (sync == null) return;
            switch (sync) {
                case DATA: {
                    outChannel.force(false);
                    return;
                }
                case META_AND_DATA: {
                    outChannel.force(true);
                    return;
                }
            }
            return;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void copyFolderRecursive(File src, File dest, boolean overwriteFiles) throws IOException {
        IO.copyFolderRecursive(src, dest, overwriteFiles, SYNC.NONE);
    }

    public static void copyFolderRecursive(final File src, final File dest, final boolean overwriteFiles, final FileFilter filter, final SYNC sync) throws IOException {
        Files.walkThroughStructure(new Files.AbstractHandler<IOException>(){

            @Override
            public void onFile(File f) throws IOException {
                if (filter != null && !filter.accept(f)) {
                    return;
                }
                String path = Files.getRelativePath(src, f);
                if (path == null) {
                    throw new IOException("No rel Path " + src + "-" + f);
                }
                if (f.isDirectory()) {
                    new File(dest, path).mkdirs();
                } else {
                    File dst = new File(dest, path);
                    if (overwriteFiles && dst.exists() && !dst.delete()) {
                        throw new IOException("Cannot overwrite " + dst);
                    }
                    dst.getParentFile().mkdirs();
                    IO.copyFile(f, dst, sync);
                }
            }
        }, src);
    }

    public static void copyFolderRecursive(File src, File dest, boolean overwriteFiles, SYNC sync) throws IOException {
        IO.copyFolderRecursive(src, dest, overwriteFiles, null, sync);
    }

    @Deprecated
    public static IOErrorHandler getErrorHandler() {
        return null;
    }

    public static String importFileToString(File file) throws IOException {
        return IO.importFileToString(file, -1);
    }

    public static void moveTo(File source, File dest, FileFilter filter) throws IOException {
        List<File> files = Files.getFiles(filter, source);
        for (File src : files) {
            String rel = Files.getRelativePath(source, src);
            File file = new File(dest, rel);
            if (src.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            if (src.renameTo(file)) continue;
            throw new IOException("Could not move file " + src + " to " + file);
        }
    }

    public static RandomAccessFile open(File file, String mode) throws IOException {
        if (CrossSystem.isWindows()) {
            int retry = 0;
            while (true) {
                try {
                    return new RandomAccessFile(file, mode);
                }
                catch (FileNotFoundException e) {
                    if (retry < 3) {
                        if (retry == 2 && CrossSystem.isWindows()) {
                            System.gc();
                        }
                        try {
                            Thread.sleep(500 * retry++);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            throw Exceptions.addSuppressed(new ClosedByInterruptException(), e);
                        }
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        return new RandomAccessFile(file, mode);
    }

    public static byte[] readFile(File ressource) throws IOException {
        int maxRead = ressource.length() < Integer.MAX_VALUE ? (int)ressource.length() : -1;
        return IO.readFile(ressource, maxRead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File ressource, int maxSize) throws IOException {
        FileInputStream fis = new FileInputStream(ressource);
        try {
            byte[] byArray = IO.readStream(maxSize, fis);
            return byArray;
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String importFileToString(File file, int maxSize) throws IOException {
        byte[] bytes = IO.readFile(file, maxSize);
        if (bytes == null) {
            return null;
        }
        return BOM.read(bytes, BOM.UTF8.getCharSet());
    }

    public static String readStreamToString(InputStream is, int maxSize) throws IOException {
        BOM.BOMInputStream bis = is instanceof BOM.BOMInputStream ? (BOM.BOMInputStream)is : BOM.wrap(is);
        byte[] bytes = IO.readStream(maxSize, bis);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, bis.getBOM() != null ? bis.getBOM().getCharSet() : BOM.UTF8.getCharSet());
    }

    public static String readFileToString(File file) throws IOException {
        return IO.importFileToString(file, -1);
    }

    public static String readFileToTrimmedString(File file) throws IOException {
        String ret = IO.readFileToString(file);
        if (ret != null) {
            return ret.trim();
        }
        return null;
    }

    @Deprecated
    public static String readInputStreamToString(InputStream is) throws IOException {
        BOM.BOMInputStream bis = is instanceof BOM.BOMInputStream ? (BOM.BOMInputStream)is : BOM.wrap(is);
        return IO.readToString(new BufferedReader(new InputStreamReader((InputStream)bis, bis.getBOM() != null ? bis.getBOM().getCharSet() : BOM.UTF8.getCharSet())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String readToString(Reader f) throws IOException {
        try {
            String line;
            BufferedReader bf = f instanceof BufferedReader ? (BufferedReader)f : new BufferedReader(f);
            StringBuilder ret = new StringBuilder();
            String sep = System.getProperty("line.separator");
            while ((line = bf.readLine()) != null) {
                if (ret.length() > 0) {
                    ret.append(sep);
                } else if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                ret.append(line);
            }
            String string = ret.toString();
            return string;
        }
        finally {
            try {
                f.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String readLine(BufferedInputStream is, byte[] array) throws IOException {
        Arrays.fill(array, 0, array.length, (byte)0);
        int read = 0;
        int total = 0;
        int totalString = 0;
        boolean nextLineReached = false;
        while (true) {
            if ((read = is.read()) == -1 && total == 0) {
                return null;
            }
            if (read == 13 || read == 10) {
                nextLineReached = true;
                is.mark(1024);
            } else {
                if (nextLineReached) {
                    is.reset();
                    --total;
                    break;
                }
                if (total < array.length) {
                    array[totalString++] = (byte)read;
                }
            }
            ++total;
        }
        return new String(array, 0, totalString, BOM.UTF8.getCharSet());
    }

    public static byte[] readStream(int maxSize, InputStream input) throws IOException {
        if (maxSize > 0) {
            return IO.readStream(maxSize, input, new ByteArrayOutputStream(maxSize));
        }
        return IO.readStream(maxSize, input, new ByteArrayOutputStream());
    }

    public static byte[] readStream(int maxSize, InputStream input, ByteArrayOutputStream baos) throws IOException {
        return IO.readStream(maxSize, input, baos, true);
    }

    public static byte[] readStream(int maxSize, InputStream input, ByteArrayOutputStream baos, boolean closeInput) throws IOException {
        IO.readStreamToOutputStream(maxSize, input, baos, closeInput);
        return baos.toByteArray();
    }

    public static int writeLongOptimized(long value, OutputStream out) throws IOException {
        return IO.writeLongOptimized(value, null, out);
    }

    public static int writeLongOptimized(long value, byte[] outBuf, OutputStream out) throws IOException {
        if (value < 0L) {
            throw new NumberFormatException("value must be >=0");
        }
        if (outBuf == null || outBuf.length < 8) {
            outBuf = new byte[8];
        }
        long rest = value;
        int bufferPosition = 0;
        while (true) {
            int write = (int)((rest & 0x7FL) << 1 & 0xFFL);
            outBuf[bufferPosition] = (byte)write;
            if ((rest >>>= 7) == 0L) {
                out.write(outBuf, 0, bufferPosition + 1);
                return bufferPosition + 1;
            }
            outBuf[bufferPosition] = (byte)(outBuf[bufferPosition] | 1);
            ++bufferPosition;
        }
    }

    public static long readLongOptimized(InputStream in) throws IOException {
        long value = 0L;
        int position = 0;
        while (true) {
            long read;
            if ((read = (long)in.read()) < 0L) {
                throw new EOFException("Expected bytes: position=" + position);
            }
            value += read >>> 1 << position * 7;
            if ((read & 1L) == 0L) {
                return value;
            }
            ++position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readStreamToOutputStream(int maxSize, InputStream input, OutputStream baos, boolean closeInput) throws IOException, Error {
        try {
            byte[] buffer = new byte[Short.MAX_VALUE];
            if (maxSize > 0) {
                int len;
                int done = 0;
                while (done < maxSize && (len = input.read(buffer, 0, Math.min(buffer.length, maxSize - done))) != -1) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new ClosedByInterruptException();
                    }
                    if (len <= 0) continue;
                    baos.write(buffer, 0, len);
                    done += len;
                }
            } else {
                int len;
                while ((len = input.read(buffer)) != -1) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new ClosedByInterruptException();
                    }
                    if (len <= 0) continue;
                    baos.write(buffer, 0, len);
                }
            }
        }
        finally {
            if (closeInput) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] readURL(URL f) throws IOException {
        return IO.readURL(f, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readURL(URL url, int maxSize) throws IOException {
        InputStream input = URLStream.openStream(url);
        try {
            byte[] byArray = IO.readStream(maxSize, input);
            return byArray;
        }
        finally {
            try {
                input.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readURLToString(URL ressourceURL) throws IOException {
        InputStream fis = URLStream.openStream(ressourceURL);
        try {
            String string = IO.readInputStreamToString(fis);
            return string;
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void secureWrite(File file, byte[] bytes) throws IOException {
        IO.secureWrite(file, bytes, SYNC.META_AND_DATA);
    }

    public static void secureWrite(File file, final byte[] bytes, SYNC sync) throws IOException {
        IO.secureWrite(file, new WriteToFileCallback(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                os.write(bytes);
            }

            @Override
            public void onIOException(IOException e) throws IOException {
            }

            @Override
            public void onClosed() {
            }
        }, sync);
    }

    public static void secureWrite(final File dstFile, final WriteToFileCallback writeToFileCallback, final SYNC sync) throws IOException {
        new NonInterruptibleRunnableException<IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void execute() throws IOException, InterruptedException {
                File tmpFile = new File(dstFile.getAbsolutePath() + ".bac");
                if (!dstFile.getParentFile().isDirectory() && !dstFile.getParentFile().mkdirs()) {
                    throw new IOException("failed to create parent for " + dstFile);
                }
                if (!tmpFile.delete() && tmpFile.exists()) {
                    throw new IOException("could not remove tmpFile" + tmpFile);
                }
                boolean finallyDeleteFileFlag = true;
                try {
                    IO.writeToFile(tmpFile, writeToFileCallback, sync);
                    if (!dstFile.delete() && dstFile.exists()) {
                        throw new IOException("could not remove dstFile" + dstFile);
                    }
                    long timeStamp = Time.systemIndependentCurrentJVMTimeMillis();
                    int retry = 0;
                    while (!tmpFile.renameTo(dstFile)) {
                        Thread.sleep(++retry * 10);
                        if (Time.systemIndependentCurrentJVMTimeMillis() - timeStamp <= 1000L) continue;
                        throw new IOException("could not rename " + tmpFile + " to " + dstFile.exists());
                    }
                    finallyDeleteFileFlag = false;
                }
                finally {
                    if (finallyDeleteFileFlag) {
                        tmpFile.delete();
                    }
                }
            }
        }.startAndWait();
    }

    public static void secureWrite(File file, String utf8String, SYNC sync) throws IOException {
        IO.secureWrite(file, utf8String.getBytes(BOM.UTF8.getCharSet()), sync);
    }

    @Deprecated
    public static void setErrorHandler(IOErrorHandler handler) {
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        IO.writeStringToFile(file, string, false, SYNC.META_AND_DATA);
    }

    public static void writeStringToFile(File file, String string, boolean append) throws IOException {
        IO.writeStringToFile(file, string, append, SYNC.META_AND_DATA);
    }

    public static void writeToFile(File file, byte[] data) throws IOException {
        IO.writeToFile(file, data, SYNC.META_AND_DATA);
    }

    public static void writeToFile(File file, final byte[] data, SYNC sync) throws IOException {
        IO.writeToFile(file, new WriteToFileCallback(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                os.write(data);
            }

            @Override
            public void onIOException(IOException e) throws IOException {
            }

            @Override
            public void onClosed() {
            }
        }, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String string, boolean append, SYNC sync) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists() && !append) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        boolean finallyDeleteFileFlag = true;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, append);
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, BOM.UTF8.getCharSet());
                writer.write(string);
                ((Writer)writer).flush();
                if (sync != null) {
                    switch (sync) {
                        case DATA: {
                            fileOutputStream.getChannel().force(false);
                            break;
                        }
                        case META_AND_DATA: {
                            fileOutputStream.getChannel().force(true);
                            break;
                        }
                    }
                }
                ((Writer)writer).close();
                finallyDeleteFileFlag = false;
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            if (finallyDeleteFileFlag) {
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, WriteToFileCallback writeToFileCallback, SYNC sync) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            throw new IllegalArgumentException("File already exists: " + file);
        }
        if (writeToFileCallback == null) {
            throw new IllegalArgumentException("WriteToFileCallback is null.");
        }
        file.createNewFile();
        if (!file.isFile()) {
            throw new IllegalArgumentException("Is not a file: " + file);
        }
        if (!file.canWrite()) {
            throw new IllegalArgumentException("Cannot write to file: " + file);
        }
        boolean finallyDeleteFileFlag = true;
        try {
            final FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                writeToFileCallback.writeTo(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        fileOutputStream.write(b);
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        fileOutputStream.write(b, off, len);
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        fileOutputStream.write(b);
                    }

                    @Override
                    public void flush() throws IOException {
                        fileOutputStream.flush();
                    }

                    @Override
                    public void close() throws IOException {
                    }
                });
                fileOutputStream.flush();
                if (sync != null) {
                    switch (sync) {
                        case DATA: {
                            fileOutputStream.getChannel().force(false);
                            break;
                        }
                        case META_AND_DATA: {
                            fileOutputStream.getChannel().force(true);
                            break;
                        }
                    }
                }
                fileOutputStream.close();
                finallyDeleteFileFlag = false;
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
                writeToFileCallback.onClosed();
            }
        }
        catch (IOException e) {
            writeToFileCallback.onIOException(e);
            throw e;
        }
        finally {
            if (finallyDeleteFileFlag) {
                file.delete();
            }
        }
    }

    public static interface WriteToFileCallback {
        public void writeTo(OutputStream var1) throws IOException;

        public void onIOException(IOException var1) throws IOException;

        public void onClosed();
    }

    public static enum BOM {
        UTF8(new byte[]{-17, -69, -65}, "UTF-8"),
        UTF16BE(new byte[]{-2, -1}, "UTF-16BE"),
        UTF16LE(new byte[]{-1, -2}, "UTF-16LE"),
        UTF32BE(new byte[]{0, 0, -2, -1}, "UTF-32BE"),
        UTF32LE(new byte[]{0, 0, -1, -2}, "UTF-32LE");

        private final byte[] bomMarker;
        private final Charset charSet;

        public final Charset getCharSet() {
            return this.charSet;
        }

        private BOM(byte[] bomMarker, String charSet) {
            this.bomMarker = bomMarker;
            this.charSet = Charset.forName(charSet);
        }

        public final int length() {
            return this.bomMarker.length;
        }

        public byte[] getBOM() {
            return (byte[])this.bomMarker.clone();
        }

        public static BOM get(byte[] bytes) {
            for (BOM bom : BOM.values()) {
                if (!bom.startsWith(bytes)) continue;
                return bom;
            }
            return null;
        }

        private boolean startsWith(byte[] bytes) {
            if (bytes != null && bytes.length >= this.length()) {
                for (int index = 0; index < this.length(); ++index) {
                    if (bytes[index] == this.bomMarker[index]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static BOMInputStream wrap(InputStream is) throws IOException {
            int pushBackSize;
            int read;
            byte[] peekBuf = new byte[4];
            int peekIndex = 0;
            BOM bom = null;
            while (peekIndex < peekBuf.length && bom == null && (read = is.read()) != -1) {
                peekBuf[peekIndex++] = (byte)(read & 0xFF);
                bom = BOM.get(peekBuf);
            }
            if (bom == null) {
                if (peekIndex == 0) {
                    return new BOMInputStream(is, null);
                }
                pushBackSize = peekIndex - 0;
                PushbackInputStream pbis = new PushbackInputStream(is, pushBackSize);
                pbis.unread(peekBuf, 0, peekIndex);
                return new BOMInputStream(pbis, null);
            }
            if (peekIndex == bom.length()) {
                return new BOMInputStream(is, bom);
            }
            pushBackSize = peekIndex - bom.length();
            PushbackInputStream pbis = new PushbackInputStream(is, pushBackSize);
            pbis.unread(peekBuf, bom.length(), peekIndex - bom.length());
            return new BOMInputStream(pbis, bom);
        }

        public static String read(byte[] bytes, Charset defaultCharset) throws IOException {
            BOM bom = BOM.get(bytes);
            if (bom != null) {
                return new String(bytes, bom.length(), bytes.length - bom.length(), bom.getCharSet());
            }
            if (defaultCharset != null) {
                return new String(bytes, defaultCharset);
            }
            return null;
        }

        public static class BOMInputStream
        extends FilterInputStream {
            private final BOM bom;

            public BOM getBOM() {
                return this.bom;
            }

            private BOMInputStream(InputStream is, BOM bom) {
                super(is);
                this.bom = bom;
            }
        }
    }

    public static enum SYNC {
        NONE,
        DATA,
        META_AND_DATA;

    }
}

