/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.net.LimitedInputStream;
import org.appwork.utils.net.NullOutputStream;

public class Hash {
    public static final String HASH_TYPE_SHA256 = "SHA-256";
    public static final String HASH_TYPE_SHA512 = "SHA-512";
    public static String HASH_TYPE_MD5 = "md5";
    public static String HASH_TYPE_SHA1 = "SHA-1";

    public static String getBytesHash(byte[] download, String type) {
        try {
            return Hash.getHash(new ByteArrayInputStream(download), type, -1L, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(byte[] data) throws IOException {
        CheckedOutputStream cos = new CheckedOutputStream(new NullOutputStream(), new CRC32());
        try {
            cos.write(data);
            long l = cos.getChecksum().getValue();
            return l;
        }
        finally {
            cos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCRC32(File arg) throws IOException {
        FileInputStream fis = new FileInputStream(arg);
        try {
            CheckedInputStream cis = new CheckedInputStream(fis, new CRC32());
            byte[] readBuffer = new byte[Short.MAX_VALUE];
            while (cis.read(readBuffer) >= 0) {
            }
            long l = cis.getChecksum().getValue();
            return l;
        }
        finally {
            fis.close();
        }
    }

    public static String getFileHash(File arg, String type) {
        return Hash.getFileHash(arg, type, -1L);
    }

    public static String getFileHash(File arg, String type, long maxHash) {
        if (arg == null || !arg.exists() || arg.isDirectory()) {
            return null;
        }
        try {
            return Hash.getHash(new FileInputStream(arg), type, maxHash, true);
        }
        catch (FileNotFoundException ignore) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static byte[] getHashBytes(InputStream is, String type, long maxRead, boolean closeStream) throws IOException, InterruptedException {
        InputStream inputStream = maxRead < 0L ? is : new LimitedInputStream(is, maxRead);
        try {
            byte[] digest;
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] buf = new byte[Short.MAX_VALUE];
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                int read = inputStream.read(buf);
                if (read > 0) {
                    md.update(buf, 0, read);
                    continue;
                }
                if (read == -1) break;
            }
            byte[] byArray = digest = md.digest();
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        finally {
            if (closeStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getHash(InputStream is, String type, long maxRead, boolean closeStream) throws InterruptedException {
        try {
            return HexFormatter.byteArrayToHex(Hash.getHashBytes(is, type, maxRead, closeStream));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getMD5(byte[] download) {
        return Hash.getBytesHash(download, HASH_TYPE_MD5);
    }

    public static String getMD5(File arg) {
        return Hash.getFileHash(arg, HASH_TYPE_MD5);
    }

    public static String getMD5(String arg) {
        return Hash.getStringHash(arg, HASH_TYPE_MD5);
    }

    public static String getSHA1(File arg) {
        return Hash.getFileHash(arg, HASH_TYPE_SHA1);
    }

    public static String getSHA1(String arg) {
        return Hash.getStringHash(arg, HASH_TYPE_SHA1);
    }

    public static String getSHA256(byte[] download) {
        return Hash.getBytesHash(download, HASH_TYPE_SHA256);
    }

    public static String getSHA256(File f) {
        return Hash.getFileHash(f, HASH_TYPE_SHA256);
    }

    public static String getSHA256(String createPostData) {
        return Hash.getStringHash(createPostData, HASH_TYPE_SHA256);
    }

    public static String getStringHash(String arg, String type) {
        try {
            return Hash.getBytesHash(arg.getBytes("UTF-8"), type);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

