/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.FileHandler;
import org.appwork.utils.Files17;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ProcMounts;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;

public class Files {
    public static void deleteRecursiv(File file) throws IOException {
        Files.deleteRecursive(file, true);
    }

    public static void deleteRecursiv(File file, boolean breakOnError) throws IOException {
        Files.deleteRecursive(file, breakOnError);
    }

    public static int deleteRecursive(File file) throws IOException {
        return Files.deleteRecursive(file, true);
    }

    public static int deleteRecursive(File file, boolean breakOnError) throws IOException {
        File[] files;
        int ret = 0;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                ret += Files.deleteRecursive(f, breakOnError);
            }
        }
        boolean deleted = false;
        IOException exception = null;
        if (JVMVersion.isMinimum(17000000L)) {
            try {
                deleted = Files17.deleteIfExists(file);
            }
            catch (IOException e) {
                exception = e;
                if (!file.exists() || file.delete()) {
                    deleted = true;
                }
            }
        } else {
            deleted = file.delete();
        }
        if (deleted) {
            ++ret;
        }
        if (file.exists() && !deleted && breakOnError) {
            if (exception != null) {
                throw new IOException("Could not delete " + file, exception);
            }
            throw new IOException("Could not delete " + file);
        }
        return ret;
    }

    public static LinkedList<String> getDirectories_NonRecursive(File startDirectory, boolean includeStart) throws IOException {
        LinkedList<String> done = new LinkedList<String>();
        File current = null;
        File[] currents = null;
        ArrayList<File> todo = new ArrayList<File>();
        todo.add(startDirectory);
        while (todo.size() > 0) {
            current = (File)todo.remove(0);
            currents = current.listFiles();
            done.add(current.getCanonicalPath());
            if (currents == null) continue;
            for (int index = currents.length - 1; index >= 0; --index) {
                String temp;
                if (!currents[index].isDirectory() || done.contains(temp = currents[index].getCanonicalPath())) continue;
                todo.add(currents[index]);
            }
        }
        if (!includeStart && done.size() > 0) {
            done.remove(0);
        }
        return done;
    }

    public static String getExtension(String name) {
        return Files.getExtension(name, true);
    }

    public static String getExtension(String name, boolean toLowerCase) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        int index = name.lastIndexOf(".");
        if (index < 0 || index + 1 >= name.length()) {
            return null;
        }
        String ret = name.substring(index + 1);
        if (toLowerCase) {
            ret = ret.toLowerCase(Locale.ENGLISH);
        }
        if (ret.matches("^[a-zA-Z0-9\\.\\-\\_]+$")) {
            return ret;
        }
        return null;
    }

    public static String getFileNameWithoutExtension(String filename) {
        int index = filename.lastIndexOf(".");
        if (index < 0) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static List<File> getFiles(final boolean includeDirectories, final boolean includeFiles, File ... files) {
        return Files.getFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (includeDirectories && pathname.isDirectory()) {
                    return true;
                }
                return includeFiles && pathname.isFile();
            }
        }, files);
    }

    public static List<File> getFiles(FileFilter filter, File ... files) {
        ArrayList<File> ret = new ArrayList<File>();
        if (files != null) {
            for (File f : files) {
                if (!f.exists()) continue;
                if (filter == null || filter.accept(f)) {
                    ret.add(f);
                }
                if (!f.isDirectory()) continue;
                ret.addAll(Files.getFiles(filter, f.listFiles()));
            }
        }
        return ret;
    }

    public static String getMimeType(String name) {
        String ret;
        if (name == null) {
            return null;
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String string = ret = fileNameMap != null ? fileNameMap.getContentTypeFor(name) : null;
        if (ret == null) {
            return "unknown/" + Files.getExtension(name);
        }
        return ret;
    }

    public static String getRelativePath(File root, File file) {
        return Files.getRelativePath(root.getAbsolutePath(), file.getAbsolutePath());
    }

    public static String getRelativePath(String root, String file) {
        String filePath;
        String rootPath;
        if (CrossSystem.isWindows() || CrossSystem.isOS2()) {
            if (!(root = root.replace("/", "\\")).endsWith("\\")) {
                root = root + "\\";
            }
            if ((rootPath = root.toLowerCase(Locale.ENGLISH)).equals((filePath = file.toLowerCase(Locale.ENGLISH).replace("/", "\\")) + "\\")) {
                return "";
            }
        } else {
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            if ((rootPath = root).equals((filePath = file) + "/")) {
                return "";
            }
        }
        if (!filePath.startsWith(rootPath)) {
            return null;
        }
        if (rootPath.equals(filePath)) {
            return "/";
        }
        if (CrossSystem.isWindows() || CrossSystem.isOS2()) {
            return file.substring(rootPath.length()).replace("\\", "/");
        }
        return file.substring(rootPath.length());
    }

    public static <T extends Throwable> void internalWalkThroughStructure(FileHandler<T> handler, File file, int depths) throws T {
        File[] directoryFiles;
        if (file.exists() && handler.onFile(file, depths) && file.isDirectory() && (directoryFiles = file.listFiles()) != null) {
            for (File directoryFile : directoryFiles) {
                Files.internalWalkThroughStructure(handler, directoryFile, depths + 1);
            }
        }
    }

    public static <T extends Exception> void internalWalkThroughStructureReverse(Handler<T> handler, File file) throws T {
        if (file.exists()) {
            File[] directoryFiles;
            if (file.isDirectory() && (directoryFiles = file.listFiles()) != null) {
                for (File directoryFile : directoryFiles) {
                    Files.internalWalkThroughStructureReverse(handler, directoryFile);
                }
            }
            handler.onFile(file);
        }
    }

    public static <ExceptionType extends Exception> void walkThroughStructure(FileHandler<ExceptionType> handler, File file) throws ExceptionType {
        handler.intro(file);
        try {
            Files.internalWalkThroughStructure(handler, file, 0);
        }
        finally {
            handler.outro(file);
        }
    }

    public static <T extends Exception> void walkThroughStructure(final Handler<T> handler, File file) throws T {
        handler.intro(file);
        try {
            Files.internalWalkThroughStructure(new FileHandler<T>(){

                @Override
                public void intro(File f) throws Exception {
                }

                @Override
                public boolean onFile(File f, int depths) throws Exception {
                    handler.onFile(f);
                    return true;
                }

                @Override
                public void outro(File f) throws Exception {
                }
            }, file, 0);
        }
        finally {
            handler.outro(file);
        }
    }

    public static <T extends Exception> void walkThroughStructureReverse(Handler<T> handler, File file) throws T {
        handler.intro(file);
        try {
            Files.internalWalkThroughStructureReverse(handler, file);
        }
        finally {
            handler.outro(file);
        }
    }

    public static File getCommonParent(File a, File b) {
        LinkedList<File> filesA = new LinkedList<File>();
        LinkedList<File> filesB = new LinkedList<File>();
        Files.fill(filesA, a);
        Files.fill(filesB, b);
        File last = null;
        for (int i = 0; i < Math.min(filesA.size(), filesB.size()); ++i) {
            String nameB;
            String nameA;
            if (CrossSystem.isWindows()) {
                if (i == 0) {
                    nameA = ((File)filesA.get(i)).getPath().toLowerCase(Locale.ENGLISH);
                    nameB = ((File)filesB.get(i)).getPath().toLowerCase(Locale.ENGLISH);
                } else {
                    nameA = ((File)filesA.get(i)).getName().toLowerCase(Locale.ENGLISH);
                    nameB = ((File)filesB.get(i)).getName().toLowerCase(Locale.ENGLISH);
                }
            } else if (i == 0) {
                nameA = ((File)filesA.get(i)).getPath();
                nameB = ((File)filesB.get(i)).getPath();
            } else {
                nameA = ((File)filesA.get(i)).getName();
                nameB = ((File)filesB.get(i)).getName();
            }
            if (!nameA.equals(nameB)) break;
            last = (File)filesA.get(i);
        }
        return last;
    }

    private static void fill(List<File> filesA, File a) {
        HashSet<File> dupe = new HashSet<File>();
        while (a != null) {
            if (!dupe.add(a)) {
                return;
            }
            filesA.add(0, a);
            File aTmp = a.getParentFile();
            if (aTmp == null || aTmp.equals(a)) break;
            a = aTmp;
        }
    }

    private static File guessRootByTotalSpaceDifference(File file) {
        long lastSpace = -1L;
        File lastFile = null;
        for (File currentFile = file; currentFile != null; currentFile = currentFile.getParentFile()) {
            long space = FileSpaceMethodHelper.TOTAL.get(currentFile);
            if (space <= 0L) continue;
            if (lastFile != null && lastSpace != space) break;
            lastFile = currentFile;
            lastSpace = space;
        }
        return lastFile;
    }

    public static File guessRoot(File file) {
        String bestRootMatch;
        block8: {
            block9: {
                bestRootMatch = null;
                if (CrossSystem.isUnix()) {
                    try {
                        List<ProcMounts> procMounts = ProcMounts.list();
                        if (procMounts != null) {
                            String destination = file.getAbsolutePath();
                            for (ProcMounts procMount : procMounts) {
                                if (procMount.isReadOnly() || !destination.startsWith(procMount.getMountPoint()) || bestRootMatch != null && procMount.getMountPoint().length() <= bestRootMatch.length()) continue;
                                bestRootMatch = procMount.getMountPoint();
                            }
                        }
                    }
                    catch (IOException e) {
                        LogV3.log(e);
                    }
                }
                if (bestRootMatch != null) break block8;
                String destination = file.getAbsolutePath();
                if (destination.startsWith("\\")) break block9;
                File bestByUsableSpace = Files.guessRootByTotalSpaceDifference(file);
                if (bestByUsableSpace != null) {
                    return bestByUsableSpace;
                }
                File[] roots = File.listRoots();
                if (roots == null) break block8;
                for (File root : roots) {
                    String rootString = root.getAbsolutePath();
                    boolean startsWith = CrossSystem.isWindows() ? StringUtils.startsWithCaseInsensitive(destination, rootString) : destination.startsWith(rootString);
                    if (!startsWith) continue;
                    bestRootMatch = rootString;
                    break block8;
                }
                break block8;
            }
            for (File existingFile = file; existingFile != null; existingFile = existingFile.getParentFile()) {
                if (!existingFile.exists()) continue;
                bestRootMatch = existingFile.getAbsolutePath();
            }
        }
        return bestRootMatch == null ? null : new File(bestRootMatch);
    }

    public static long getUsableSpace(File file) {
        File root = Files.guessRoot(file);
        File probeFile = root != null ? root : file;
        return FileSpaceMethodHelper.USABLE.get(probeFile);
    }

    public static long getDirectorySize(File path) {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkThroughStructure(new FileHandler<RuntimeException>(){

            @Override
            public void intro(File f) throws RuntimeException {
            }

            @Override
            public boolean onFile(File f, int depths) throws RuntimeException {
                if (f.isFile()) {
                    size.addAndGet(f.length());
                }
                return true;
            }

            @Override
            public void outro(File f) throws RuntimeException {
            }
        }, path);
        return size.get();
    }

    public static enum FileSpaceMethodHelper {
        FREE{

            @Override
            public long get(File probeFile) {
                File workaroundFile;
                long space = probeFile.getFreeSpace();
                if (space == 0L && (workaroundFile = FileSpaceMethodHelper.getWindowsSubstWorkaround(probeFile)) != null) {
                    space = workaroundFile.getFreeSpace();
                }
                return space;
            }
        }
        ,
        TOTAL{

            @Override
            public long get(File probeFile) {
                File workaroundFile;
                long space = probeFile.getTotalSpace();
                if (space == 0L && (workaroundFile = FileSpaceMethodHelper.getWindowsSubstWorkaround(probeFile)) != null) {
                    space = workaroundFile.getTotalSpace();
                }
                return space;
            }
        }
        ,
        USABLE{

            @Override
            public long get(File probeFile) {
                File workaroundFile;
                long space = probeFile.getUsableSpace();
                if (space == 0L && (workaroundFile = FileSpaceMethodHelper.getWindowsSubstWorkaround(probeFile)) != null) {
                    space = workaroundFile.getUsableSpace();
                }
                return space;
            }
        };


        private static final File getWindowsSubstWorkaround(File probeFile) {
            if (CrossSystem.isWindows() && (probeFile.getParent() == null || probeFile.isFile())) {
                File[] listFiles;
                if (probeFile.isDirectory()) {
                    listFiles = probeFile.listFiles();
                } else {
                    File parentFile = probeFile.getParentFile();
                    File[] fileArray = listFiles = parentFile != null ? parentFile.listFiles() : null;
                }
                if (listFiles != null) {
                    for (File listFile : listFiles) {
                        if (!listFile.isDirectory()) continue;
                        return listFile;
                    }
                }
            }
            return null;
        }

        public abstract long get(File var1);
    }

    public static interface Handler<T extends Exception> {
        public void intro(File var1) throws T;

        public void onFile(File var1) throws T;

        public void outro(File var1) throws T;
    }

    public static abstract class AbstractHandler<T extends Exception>
    implements Handler<T> {
        @Override
        public void intro(File f) {
        }

        @Override
        public abstract void onFile(File var1) throws T;

        @Override
        public void outro(File f) {
        }
    }
}

