/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.appwork.exceptions.ThrowUncheckedException;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.StringUtils;

public class Exceptions {
    private static Method addSuppressedMethod = null;

    @SafeVarargs
    public static boolean containsInstanceOf(Throwable e, Class<? extends Throwable> ... classes) {
        if (e instanceof UndeclaredThrowableException) {
            e = ((UndeclaredThrowableException)e).getUndeclaredThrowable();
        }
        if (classes != null) {
            for (Class<? extends Throwable> class1 : classes) {
                if (Exceptions.getInstanceof(e, class1) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static <E extends Exception> void throwUncheckedException(Throwable e) throws E {
        ThrowUncheckedException.throwUncheckedException(e);
    }

    public static <T extends Throwable> List<T> getInstancesof(Throwable e, Class<T> class1) {
        if (e == null || class1 == null) {
            return null;
        }
        ArrayList<Throwable> ret = new ArrayList<Throwable>();
        HashSet<Throwable> dupe = new HashSet<Throwable>();
        Throwable current = e;
        while (current != null) {
            if (class1.isAssignableFrom(current.getClass()) && !ret.contains(current)) {
                ret.add(current);
            }
            if ((current = current.getCause()) != null && dupe.add(current)) continue;
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public static <T extends Throwable> T getInstanceof(Throwable e, Class<T> class1) {
        if (e == null || class1 == null) {
            return null;
        }
        List<T> ret = Exceptions.getInstancesof(e, class1);
        if (ret != null && ret.size() > 0) {
            return (T)((Throwable)ret.get(0));
        }
        return null;
    }

    public static void getStackTrace(final StringBuilder sb, Throwable thrown) {
        Writer sw = new Writer(){
            final int startPos;
            {
                this.lock = sb;
                this.startPos = sb.length();
            }

            @Override
            public Writer append(char c) throws IOException {
                this.write(c);
                return this;
            }

            @Override
            public Writer append(CharSequence csq) throws IOException {
                if (csq == null) {
                    this.write("null");
                } else {
                    this.write(csq.toString());
                }
                return this;
            }

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                CharSequence cs = csq == null ? "null" : csq;
                this.write(cs.subSequence(start, end).toString());
                return this;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            public String toString() {
                return sb.substring(this.startPos);
            }

            @Override
            public void write(char[] cbuf) throws IOException {
                sb.append(cbuf);
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                sb.append(cbuf, off, len);
            }

            @Override
            public void write(int c) throws IOException {
                sb.append(c);
            }

            @Override
            public void write(String str) throws IOException {
                sb.append(str);
            }

            @Override
            public void write(String str, int off, int len) {
                sb.append(str.substring(off, off + len));
            }
        };
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.close();
    }

    public static String getStackTrace(Throwable thrown) {
        if (thrown == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        thrown.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static <E extends Throwable> E addSuppressed(E throwing, Throwable additional) {
        if (addSuppressedMethod == null || additional == null) {
            return throwing;
        }
        try {
            addSuppressedMethod.invoke(throwing, additional);
            return throwing;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String toCauseChainClassString(Throwable e, boolean simple) {
        if (e == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Throwable last = null;
        while (last != e && e != null) {
            if (sb.length() > 0) {
                sb.append(" < ");
            }
            sb.append(simple ? e.getClass().getSimpleName() : e.getClass().getName());
            last = e;
            e = e.getCause();
        }
        return sb.toString();
    }

    public static String stacktraceElementToThrownAtString(StackTraceElement source) {
        if (source == null) {
            return null;
        }
        String sourceString = source.getClassName();
        if (StringUtils.isNotEmpty(source.getFileName()) && source.getLineNumber() >= 0) {
            int li = sourceString.lastIndexOf(".");
            sourceString = li > 0 ? sourceString.substring(0, li) + " (" + source.getFileName() + ":" + source.getLineNumber() + ")" : "DEBUG" + sourceString;
        }
        sourceString = sourceString + "." + source.getMethodName();
        return sourceString;
    }

    static {
        try {
            addSuppressedMethod = Throwable.class.getMethod("addSuppressed", Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException ex) {
            LogV3.log(ex);
        }
    }
}

