/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.UIManager;
import org.appwork.exceptions.WTFException;
import org.appwork.shutdown.ShutdownController;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;

public class Application {
    private static Boolean IS_JARED = null;
    private static String APP_FOLDER = ".appwork";
    private static String ROOT;
    public static final long JAVA16 = 16000000L;
    public static final long JAVA17 = 17000000L;
    public static final long JAVA18 = 18000000L;
    public static final long JAVA19 = 9000000000000L;
    private static Boolean IS_SYNTHETICA;
    private static Boolean JVM64BIT;
    private static boolean REDIRECTED;
    public static PauseableOutputStream STD_OUT;
    public static PauseableOutputStream ERR_OUT;
    private static boolean DID_INIT;
    private static final ResourceLookup resourceLookup;

    public static void addStreamCopy(File file, PauseableOutputStream stream) {
        int i = 0;
        File orgFile = file;
        while (true) {
            try {
                if (file.exists()) {
                    throw new FileNotFoundException("Exists");
                }
                stream.addBranch(new BufferedOutputStream(new FileOutputStream(file)));
            }
            catch (FileNotFoundException e1) {
                ++i;
                e1.printStackTrace();
                String extension = Files.getExtension(orgFile.getName());
                if (extension != null) {
                    file = new File(orgFile.getParentFile(), orgFile.getName().substring(0, orgFile.getName().length() - extension.length() - 1) + "." + i + "." + extension);
                    continue;
                }
                file = new File(orgFile.getParentFile(), orgFile.getName() + "." + i);
                continue;
            }
            break;
        }
    }

    @Deprecated
    public static void addUrlToClassPath(URL url, ClassLoader cl) throws IOException {
        try {
            if (url == null) {
                throw new IllegalArgumentException("file==null");
            }
            Method method = null;
            try {
                method = cl.getClass().getMethod("addURL", URL.class);
            }
            catch (NoSuchMethodException e) {
                method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            }
            method.setAccessible(true);
            method.invoke((Object)cl, url);
        }
        catch (Throwable t) {
            throw new IOException("Failed to add URL to system classloader: URL:" + url + "ClassLoader:" + cl, t);
        }
    }

    public static String getApplication() {
        return APP_FOLDER;
    }

    public static File getApplicationRoot() {
        return Application.getRootByClass(Application.class, null);
    }

    public static String getHome() {
        return Application.getRoot(Application.class);
    }

    public static URL getHomeURL() {
        try {
            return new File(Application.getHome()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new WTFException(e);
        }
    }

    public static File getJarFile(Class<?> clazz) {
        String name = clazz.getName().replaceAll("\\.", "/") + ".class";
        URL url = Application.getRessourceURL(name);
        String prot = url.getProtocol();
        String path = url.getPath();
        if (!"jar".equals(prot)) {
            throw new WTFException("Works in Jared mode only");
        }
        int index = path.indexOf(".jar!");
        if (index < 0) {
            throw new WTFException("Works in Jared mode only");
        }
        try {
            return new File(new URL(path.substring(0, index + 4)).toURI());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static long getJavaVersion() {
        return JVMVersion.get();
    }

    public static String getJVMVersion() {
        return JVMVersion.getJVMVersion();
    }

    public static long parseJavaVersionString(String version) {
        return JVMVersion.parseJavaVersionString(version);
    }

    public static String getPackagePath(Class<?> class1) {
        return class1.getPackage().getName().replace('.', '/') + "/";
    }

    private static ResourceLookup initResourceLookup() {
        String resourceLookupClass = System.getProperty("org.appwork.utils.Application.ResourceLookup", null);
        if (resourceLookupClass != null) {
            try {
                Class<?> loadClass = Class.forName(resourceLookupClass);
                ResourceLookup ret = (ResourceLookup)loadClass.newInstance();
                return ret;
            }
            catch (ClassNotFoundException e) {
                throw new WTFException("ResourceLookupClass:" + resourceLookupClass, e);
            }
            catch (InstantiationException e) {
                throw new WTFException("ResourceLookupClass:" + resourceLookupClass, e);
            }
            catch (IllegalAccessException e) {
                throw new WTFException("ResourceLookupClass:" + resourceLookupClass, e);
            }
        }
        return null;
    }

    public static File getResource(String relative) {
        Application.warnInit();
        ResourceLookup resourceLookup = Application.resourceLookup;
        File ret = resourceLookup != null ? resourceLookup.getResource(relative) : Application.getHomeResource(relative);
        return ret;
    }

    public static File getHomeResource(String relative) {
        return new File(Application.getHome(), relative);
    }

    public static void warnInit() {
        if (!Application.isFrameWorkInitDone()) {
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            System.out.println(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application");
            new Exception(" !!!!!!! FrameWork Init is not done. Call Application.ensureFrameWorkInit() as very first action in your application").printStackTrace();
        }
    }

    public static URL getRessourceURL(String relative) {
        return Application.getRessourceURL(relative, true);
    }

    public static URL getRessourceURL(String relative, boolean preferClasspath) {
        ResourceLookup resourceLookup = Application.resourceLookup;
        URL ret = resourceLookup != null ? resourceLookup.getRessourceURL(relative, preferClasspath) : Application.getHomeRessourceURL(relative, preferClasspath);
        return ret;
    }

    public static URL getHomeRessourceURL(String relative, boolean preferClasspath) {
        try {
            if (relative == null) {
                return null;
            }
            if (relative.startsWith("/") || relative.startsWith("\\")) {
                throw new WTFException("getRessourceURL only works with relative paths.");
            }
            if (preferClasspath) {
                URL res = Application.class.getClassLoader().getResource(relative);
                if (res != null) {
                    return res;
                }
                File file = Application.getHomeResource(relative);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            } else {
                File file = Application.getHomeResource(relative);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
                URL res = Application.class.getClassLoader().getResource(relative);
                if (res != null) {
                    return res;
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getJarName(Class<?> clazz) {
        String name;
        String url;
        int index;
        if (clazz == null) {
            clazz = Application.class;
        }
        if ((index = (url = Application.getRessourceURL(name = clazz.getName().replaceAll("\\.", "/") + ".class").toString()).indexOf(".jar!")) < 0) {
            throw new IllegalStateException("No JarName Found");
        }
        try {
            return new File(new URL(url.substring(4, index + 4)).toURI()).getName();
        }
        catch (Exception exception) {
            throw new IllegalStateException("No JarName Found");
        }
    }

    public static String getRoot(Class<?> rootOfClazz) {
        if (rootOfClazz == null) {
            throw new IllegalArgumentException("rootOfClazz is null");
        }
        if (ROOT != null) {
            return ROOT;
        }
        String system = System.getProperty("ROOT");
        if (system != null) {
            ROOT = system;
            return system;
        }
        String key = "awuhome" + APP_FOLDER;
        String sysProp = System.getProperty(key);
        if (sysProp != null) {
            ROOT = sysProp;
            return sysProp;
        }
        if (Application.isJared(rootOfClazz)) {
            URL loc = rootOfClazz.getProtectionDomain().getCodeSource().getLocation();
            File appRoot = null;
            try {
                appRoot = Application.urlToFile(loc);
                ROOT = appRoot.getAbsolutePath();
            }
            catch (URISyntaxException e) {
                ROOT = System.getProperty("user.home") + System.getProperty("file.separator") + APP_FOLDER + System.getProperty("file.separator");
            }
        } else {
            ROOT = System.getProperty("user.home") + System.getProperty("file.separator") + APP_FOLDER;
        }
        return ROOT;
    }

    public static File urlToFile(URL loc) throws URISyntaxException {
        if (loc == null) {
            throw new IllegalArgumentException("loc is null");
        }
        String path = loc.getPath();
        File appRoot = null;
        try {
            appRoot = new File(URLDecoder.decode(path, "UTF-8"));
            if (!appRoot.exists()) {
                appRoot = null;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (appRoot == null && !(appRoot = new File(path)).exists()) {
            appRoot = null;
        }
        if (appRoot == null && !(appRoot = new File(loc.toURI())).exists()) {
            appRoot = null;
        }
        if (appRoot == null) {
            throw new URISyntaxException(loc + "", "Bad URI");
        }
        if (appRoot.isFile()) {
            appRoot = appRoot.getParentFile();
        }
        return appRoot;
    }

    public static File getRootByClass(Class<?> class1, String subPaths) {
        if (class1 == null) {
            throw new IllegalArgumentException("class is null");
        }
        URL loc = class1.getProtectionDomain().getCodeSource().getLocation();
        try {
            File appRoot = new File(loc.toURI());
            if (appRoot.isFile()) {
                appRoot = appRoot.getParentFile();
            }
            if (subPaths != null) {
                return new File(appRoot, subPaths);
            }
            return appRoot;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static URL getRootUrlByClass(Class<?> class1, String subPaths) {
        try {
            return Application.getRootByClass(class1, subPaths).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getTemp() {
        File ret = Application.getResource("tmp");
        if (!ret.exists()) {
            ret.mkdirs();
        }
        return ret;
    }

    public static File getTempFile(String prefix, String suffix) throws IOException {
        File tmp;
        String tmpDirProperty = System.getProperty("java.io.tmpdir");
        String random = Long.toString(UniqueAlltimeID.next());
        if (StringUtils.isEmpty(tmpDirProperty) || tmpDirProperty.contains("~") || !new File(tmpDirProperty).isDirectory()) {
            tmp = Application.getTemp();
            tmp.mkdirs();
        } else {
            tmp = null;
        }
        String tmpPrefix = prefix + random;
        try {
            return File.createTempFile(tmpPrefix, suffix, tmp);
        }
        catch (IOException e) {
            throw new IOException("failed to create tmpFile!prefix:" + tmpPrefix + "|suffix:" + suffix + "|tmp:" + tmp, e);
        }
    }

    public static File getTempResource(String cache) {
        return new File(Application.getTemp(), cache);
    }

    public static boolean is64BitJvm() {
        if (JVM64BIT != null) {
            return JVM64BIT;
        }
        String archDataModel = System.getProperty("sun.arch.data.model");
        try {
            if (archDataModel != null) {
                if (Integer.parseInt(archDataModel) == 64) {
                    JVM64BIT = true;
                    return true;
                }
                JVM64BIT = false;
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean is64BitJVM = CrossSystem.is64BitArch();
        JVM64BIT = is64BitJVM;
        return is64BitJVM;
    }

    public static boolean isJared(Class<?> rootOfClazz) {
        if (IS_JARED != null) {
            return IS_JARED == Boolean.TRUE;
        }
        if (rootOfClazz == null) {
            rootOfClazz = Application.class;
        }
        String name = rootOfClazz.getName().replaceAll("\\.", "/") + ".class";
        ClassLoader cll = Application.class.getClassLoader();
        if (cll == null) {
            IS_JARED = Boolean.TRUE;
            return true;
        }
        URL caller = cll.getResource(name);
        if (caller == null) {
            IS_JARED = false;
            return false;
        }
        boolean ret = caller.toString().matches("jar\\:.*\\.(jar|exe)\\!.*");
        IS_JARED = ret;
        return ret;
    }

    public static void printSystemProperties(LogInterface logger) {
        Application.printSystemProperties(logger, null);
    }

    public static void printSystemProperties(LogInterface logger, Collection<String> blackList) {
        Properties properties = System.getProperties();
        Enumeration<Object> propertiesKey = properties.keys();
        StringBuilder sb = new StringBuilder();
        while (propertiesKey.hasMoreElements()) {
            String key = String.valueOf(propertiesKey.nextElement());
            if (blackList != null && blackList.contains("prop_" + (String)key)) continue;
            sb.append("SysProp: ").append(key).append(": ").append(properties.get(key));
            logger.info(sb.toString());
            sb.setLength(0);
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            String key = (String)entry.getKey();
            if (blackList != null && blackList.contains("env_" + key)) continue;
            sb.append("SysEnv: ").append(key).append(": ").append((String)entry.getValue());
            logger.info(sb.toString());
            sb.setLength(0);
        }
        URL url = Application.getRessourceURL("version.nfo");
        if (url != null) {
            try {
                logger.info(url + ":\r\n" + IO.readURLToString(url));
            }
            catch (IOException iOException) {
                logger.log(iOException);
            }
        }
        if ((url = Application.getRessourceURL("build.json")) != null) {
            try {
                logger.info(url + ":\r\n" + IO.readURLToString(url));
            }
            catch (IOException iOException) {
                logger.log(iOException);
            }
        }
        if ((url = Application.getRessourceURL("version.txt")) != null) {
            try {
                logger.info(url + ":\r\n" + IO.readURLToString(url));
            }
            catch (IOException iOException) {
                logger.log(iOException);
            }
        }
    }

    private static String getCharSet(PrintStream ps) {
        try {
            String charSet;
            Field field = ReflectionUtils.getField(ps.getClass(), "charOut", (Object)ps, Writer.class);
            Writer writer = (Writer)field.get(ps);
            if (writer instanceof OutputStreamWriter && !StringUtils.isEmpty(charSet = ((OutputStreamWriter)writer).getEncoding())) {
                return Charset.forName(charSet).name();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Charset.defaultCharset().name();
    }

    public static void redirectOutputStreams() {
        if (REDIRECTED) {
            return;
        }
        try {
            if (System.getProperty("sun.stdout.encoding") == null && Charset.defaultCharset() == Charset.forName("cp1252")) {
                try {
                    STD_OUT = new PauseableOutputStream(new FileOutputStream(FileDescriptor.out));
                    System.setOut(new PrintStream((OutputStream)STD_OUT, true, "CP850"));
                    ERR_OUT = new PauseableOutputStream(new FileOutputStream(FileDescriptor.err));
                    System.setErr(new PrintStream((OutputStream)ERR_OUT, true, "CP850"));
                }
                catch (UnsupportedEncodingException e) {
                    STD_OUT = new PauseableOutputStream(System.out);
                    System.setOut(new PrintStream(STD_OUT));
                    ERR_OUT = new PauseableOutputStream(System.err);
                    System.setErr(new PrintStream(ERR_OUT));
                    e.printStackTrace();
                }
            } else {
                PrintStream stdOut = System.out;
                PrintStream stdErr = System.err;
                try {
                    STD_OUT = new PauseableOutputStream(stdOut);
                    System.setOut(new PrintStream((OutputStream)STD_OUT, true, System.getProperty("sun.stdout.encoding", Application.getCharSet(stdOut))));
                    ERR_OUT = new PauseableOutputStream(stdErr);
                    System.setErr(new PrintStream((OutputStream)ERR_OUT, true, System.getProperty("sun.stderr.encoding", Application.getCharSet(stdErr))));
                }
                catch (UnsupportedEncodingException e) {
                    STD_OUT = new PauseableOutputStream(stdOut);
                    System.setOut(new PrintStream(STD_OUT));
                    ERR_OUT = new PauseableOutputStream(stdErr);
                    System.setErr(new PrintStream(ERR_OUT));
                    e.printStackTrace();
                }
            }
        }
        finally {
            REDIRECTED = true;
        }
    }

    public static synchronized void setApplication(String newAppFolder) {
        ROOT = null;
        APP_FOLDER = newAppFolder;
        Application.ensureFrameWorkInit();
        ROOT = Application.getRoot(Application.class);
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static File generateNumberedTempResource(String string) {
        return Application.generateNumbered(Application.getTempResource(string));
    }

    public static File generateNumberedResource(String string) {
        return Application.generateNumbered(Application.getResource(string));
    }

    private static File generateNumbered(File orgFile) {
        int i = 0;
        String extension = Files.getExtension(orgFile.getName());
        File file = null;
        while (file == null || file.exists()) {
            ++i;
            if (extension != null) {
                file = new File(orgFile.getParentFile(), orgFile.getName().substring(0, orgFile.getName().length() - extension.length() - 1) + "." + i + "." + extension);
                continue;
            }
            file = new File(orgFile.getParentFile(), orgFile.getName() + "." + i);
        }
        return file;
    }

    public static boolean isSyntheticaLookAndFeel() {
        Boolean ret = IS_SYNTHETICA;
        if (ret != null) {
            return ret;
        }
        try {
            Class<?> lafClass = UIManager.getLookAndFeel().getClass();
            Class<?> cls = Class.forName("de.javasoft.plaf.synthetica.SyntheticaLookAndFeel", false, Application.class.getClassLoader());
            ret = cls != null && cls.isAssignableFrom(lafClass);
        }
        catch (Throwable throwable) {
        }
        finally {
            IS_SYNTHETICA = ret != null ? ret : Boolean.FALSE;
        }
        return IS_SYNTHETICA;
    }

    private static synchronized void ensureFrameWorkInit() {
        if (DID_INIT) {
            return;
        }
        DID_INIT = true;
        ShutdownController.getInstance();
    }

    public static boolean isFrameWorkInitDone() {
        return DID_INIT;
    }

    static {
        IS_SYNTHETICA = null;
        JVM64BIT = null;
        REDIRECTED = false;
        DID_INIT = false;
        if (System.getProperty("NO_SYSOUT_REDIRECT") == null) {
            Application.redirectOutputStreams();
        }
        System.setProperty("com.sun.jndi.rmi.object.trustURLCodebase", "false");
        System.setProperty("com.sun.jndi.ldap.object.trustURLCodebase", "false");
        System.setProperty("com.sun.jndi.cosnaming.object.trustURLCodebase", "false");
        System.setProperty("java.rmi.server.useCodebaseOnly", "true");
        resourceLookup = Application.initResourceLookup();
    }

    public static class PauseableOutputStream
    extends OutputStream {
        private final OutputStream _out;
        private final AtomicReference<ByteArrayOutputStream> buffer = new AtomicReference();
        private final CopyOnWriteArrayList<OutputStream> branches = new CopyOnWriteArrayList();

        public PauseableOutputStream(OutputStream out) {
            this._out = out;
        }

        @Override
        public void write(int paramInt) throws IOException {
            ByteArrayOutputStream buffer;
            if (this.branches.size() > 0) {
                for (OutputStream os : this.branches) {
                    try {
                        os.write(paramInt);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((buffer = this.buffer.get()) != null) {
                buffer.write(paramInt);
            } else {
                this._out.write(paramInt);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            ByteArrayOutputStream buffer;
            if (this.branches.size() > 0) {
                for (OutputStream os : this.branches) {
                    try {
                        os.write(b);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((buffer = this.buffer.get()) != null) {
                buffer.write(b);
            } else {
                this._out.write(b);
            }
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            ByteArrayOutputStream buffer;
            if (this.branches.size() > 0) {
                for (OutputStream os : this.branches) {
                    try {
                        os.write(buff, off, len);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((buffer = this.buffer.get()) != null) {
                buffer.write(buff, off, len);
            } else {
                this._out.write(buff, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            for (OutputStream os : this.branches) {
                try {
                    os.flush();
                }
                catch (Throwable throwable) {}
            }
            ByteArrayOutputStream buffer = this.buffer.get();
            if (buffer != null) {
                buffer.flush();
            } else {
                this._out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                for (OutputStream os : this.branches) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {}
                }
                ByteArrayOutputStream buffer = this.buffer.get();
                if (buffer != null) {
                    buffer.close();
                    this.setBufferEnabled(false);
                }
            }
            finally {
                this._out.close();
            }
        }

        public boolean enableBuffer() throws IOException {
            return this.setBufferEnabled(true);
        }

        public boolean disableBuffer(boolean dropBufferedData) throws IOException {
            if (dropBufferedData) {
                this.buffer.set(null);
            }
            return this.setBufferEnabled(false);
        }

        public boolean setBufferEnabled(boolean b) throws IOException {
            if (b) {
                return !this.buffer.compareAndSet(null, new ByteArrayOutputStream());
            }
            ByteArrayOutputStream buffer = this.buffer.getAndSet(null);
            if (buffer != null) {
                buffer.writeTo(this._out);
                return true;
            }
            return false;
        }

        public boolean addBranch(OutputStream os) {
            return os != null && this.branches.addIfAbsent(os);
        }

        public boolean removeBranch(OutputStream os) {
            return os != null && this.branches.remove(os);
        }

        public void setBranches(List<OutputStream> branches) {
            if (branches == null || branches.size() == 0) {
                this.branches.clear();
            } else {
                for (OutputStream os : branches) {
                    this.addBranch(os);
                }
                this.branches.retainAll(branches);
            }
        }

        public void setBranch(OutputStream outputStream) {
            if (outputStream == null) {
                this.branches.clear();
            } else {
                this.setBranches(Arrays.asList(outputStream));
            }
        }
    }

    public static interface ResourceLookup {
        public File getResource(String var1);

        public URL getRessourceURL(String var1, boolean var2);
    }
}

