/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange.setup;

import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableSee;
import org.appwork.updatesys.transport.exchange.Revision;
import org.appwork.updatesys.transport.exchange.setup.ConditionContext;
import org.appwork.updatesys.transport.exchange.setup.ExceptionMatcher;
import org.appwork.updatesys.transport.exchange.setup.FileContext;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.os.CrossSystem;

public class GenericConditionMatcher
implements Storable {
    @StorableDoc(value="If the Condition is used in a path context, this property is available to match on the context file or directory.")
    @StorableAvailableSince(value="2023-06-23T00:00+0200")
    private FileContext path;
    @StorableDoc(value="True if the maintenance mode is active")
    @StorableAvailableSince(value="2023-06-27T00:00+0200")
    private boolean maintenanceMode;
    @StorableDoc(value="The condition may be executed in a special context. Match against this field to trigger on this context")
    @StorableSee(value={ConditionContext.class})
    @StorableAvailableSince(value="2023-06-27T00:00+0200")
    private ConditionContext context;
    @StorableDoc(value="If the process failed, the resulting exception will be available here")
    @StorableSee(value={ExceptionMatcher.class})
    private ExceptionMatcher exception;
    @StorableDoc(value="Staging group")
    private String group;
    @StorableDoc(value="Java binary Path (e.g. java.exe)")
    private String jvmPath = CrossSystem.getJavaBinary();
    @StorableDoc(value="Java version. Example: 1.8 = 18000000, JAVA_9 = 9000000000000l, JAVA_11  = 11000000000000l etc.")
    private long jvmVersion = JVMVersion.get();
    @StorableDoc(value="Operating System")
    @StorableSee(value={CrossSystem.OperatingSystem.class})
    private CrossSystem.OperatingSystem os;
    @StorableDoc(value="Operating System Family")
    @StorableSee(value={CrossSystem.OSFamily.class})
    private CrossSystem.OSFamily osFamily;
    @StorableDoc(value="Installed Revision")
    private Revision revision;
    @StorableDoc(value="True if Connect runs on Self-Update/Self-Test mode")
    private boolean selftest;
    @StorableDoc(value="Target Revision")
    private Revision targetRevision;

    public boolean isMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    public FileContext getPath() {
        return this.path;
    }

    public void setPath(FileContext path) {
        this.path = path;
    }

    public ConditionContext getContext() {
        return this.context;
    }

    public void setContext(ConditionContext context) {
        this.context = context;
    }

    public ExceptionMatcher getException() {
        return this.exception;
    }

    public String getGroup() {
        return this.group;
    }

    public String getJvmPath() {
        return this.jvmPath;
    }

    public long getJvmVersion() {
        return this.jvmVersion;
    }

    public CrossSystem.OperatingSystem getOs() {
        return this.os;
    }

    public CrossSystem.OSFamily getOsFamily() {
        return this.osFamily;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public Revision getTargetRevision() {
        return this.targetRevision;
    }

    public boolean isSelftest() {
        return this.selftest;
    }

    public void setException(ExceptionMatcher exception) {
        this.exception = exception;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJvmPath(String jvmPath) {
        this.jvmPath = jvmPath;
    }

    public void setJvmVersion(long jvmVersion) {
        this.jvmVersion = jvmVersion;
    }

    public void setOs(CrossSystem.OperatingSystem os) {
        this.os = os;
    }

    public void setOsFamily(CrossSystem.OSFamily osFamily) {
        this.osFamily = osFamily;
    }

    public void setRevision(Revision revision) {
        this.revision = revision;
    }

    public void setSelftest(boolean selftest) {
        this.selftest = selftest;
    }

    public void setTargetRevision(Revision targetRevision) {
        this.targetRevision = targetRevision;
    }
}

