/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.regex.Pattern;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.storage.JSonStorage;
import org.appwork.updatesys.service.ServiceBadSignatureException;
import org.appwork.updatesys.service.ServiceCouldNotLoadVersionException;
import org.appwork.updatesys.service.ServiceExecutionExeption;
import org.appwork.updatesys.service.ServiceInstallation;
import org.appwork.updatesys.service.ServiceUnexpectedResponseCodeException;
import org.appwork.updatesys.service.ServiceUnexpectednoExitCodeException;
import org.appwork.updatesys.transport.exchange.ExecuteResult;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.logging2.LogInterface;

public class ServiceExecuter {
    private final ServiceInstallation service;
    private int httpReadTimeout = 900000;
    private int httpConnectTimeout = 10000;

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        this.httpConnectTimeout = timeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpReadTimeout(int timeout) {
        this.httpReadTimeout = timeout;
    }

    public ServiceExecuter(ServiceInstallation service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecuteResult executeViaConnectService(File file, boolean waitFor) throws ServiceExecutionExeption, IOException, InterruptedException {
        this.getLogger().info("Started: " + file + " Via Connect Service: ");
        StringBuilder ret = new StringBuilder();
        HttpURLConnection connection = null;
        try {
            String line;
            URL url;
            this.service.loadVersion();
            if (this.service.getVersion() <= 0L) {
                throw new ServiceCouldNotLoadVersionException();
            }
            this.getLogger().info("Connect Service version: " + JSonStorage.serializeToJson(this.service.getRuntimeInfo()));
            try {
                url = new URL(this.createUrlString(file));
                this.getLogger().info("url-with-token: " + url.toString().replaceAll(Pattern.quote(this.service.accessToken), "*******"));
                this.getLogger().info("url: " + url.toString().replaceAll(Pattern.quote(this.service.accessToken), "*******"));
            }
            catch (Throwable e) {
                throw new WTFException(e);
            }
            connection = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            connection.setConnectTimeout(this.getHttpConnectTimeout());
            connection.setReadTimeout(this.getHttpReadTimeout());
            this.getLogger().info("Open connection");
            connection.connect();
            int responseCode = connection.getResponseCode();
            this.getLogger().info("Connected. Response Code: " + responseCode);
            if (responseCode == HTTPConstants.ResponseCode.ERROR_FORBIDDEN.getCode()) {
                throw new ServiceBadSignatureException();
            }
            if (responseCode != 200) {
                String error = IO.readStreamToString(connection.getErrorStream(), -1);
                throw new ServiceUnexpectedResponseCodeException(responseCode, error);
            }
            if (!waitFor) {
                ExecuteResult error = new ExecuteResult(-1L, "");
                return error;
            }
            BufferedReader f = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF8"));
            while ((line = f.readLine()) != null) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Interrupted Service Execution");
                }
                if (ret.length() > 0) {
                    ret.append("\r\n");
                } else if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                ret.append(line);
                this.getLogger().info(file.getName() + "-process> " + line);
                this.parseResponseLine(line);
            }
            String consoleout = ret.toString();
            String exitCode = new Regex(consoleout, ".*[\r\n]{1,2}ExitCode\\:\\s*(\\-?\\d+)").getMatch(0);
            if (exitCode == null) {
                throw new ServiceUnexpectednoExitCodeException(responseCode, consoleout);
            }
            ExecuteResult executeResult = new ExecuteResult(Long.parseLong(exitCode), consoleout);
            return executeResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected void parseResponseLine(String line) {
    }

    protected String createUrlString(File file) {
        return "http://127.0.0.1:" + this.service.port + "/elevate?accessToken=" + URLEncode.encodeRFC2396(this.service.accessToken) + "&path=" + URLEncode.encodeRFC2396(file.getAbsolutePath());
    }

    public LogInterface getLogger() {
        return LogV3.I().getDefaultLogger();
    }

    public ExecuteResult execute(File file, boolean waitFor) throws ServiceExecutionExeption, IOException, InterruptedException {
        return this.executeViaConnectService(file, waitFor);
    }
}

