/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.tracker;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.storage.CleanedJSonObject;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.StorageException;
import org.appwork.storage.TypeRef;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.http.HttpClientInterface;
import org.appwork.updatesys.client.servertime.ServerTimeHandler;
import org.appwork.updatesys.client.servertime.UnsynchronizedStateException;
import org.appwork.updatesys.client.tracker.BatchRequestWithCustomHttpClient;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.exchange.SyncedTime;
import org.appwork.updatesys.transport.exchange.batch.BatchJobType;
import org.appwork.updatesys.transport.exchange.batch.JobRequest;
import org.appwork.updatesys.transport.exchange.track.TrafficLog;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.NonInterruptibleRunnableSimple;
import org.appwork.utils.ReflectionUtils;

public class TrafficTracker {
    protected final UpdateClient updateClient;
    protected final File file;
    protected List<TrafficLog> entries;
    protected final AtomicReference<Thread> thread = new AtomicReference<Object>(null);
    protected volatile long lastSuccessSend;
    protected final HttpClientInterface httpClient;
    protected final AtomicLong doNotSendAnythingUntil = new AtomicLong(-1L);
    protected final WeakHashMap<TrafficLog, TrafficLog> lastSentData = new WeakHashMap();
    private volatile boolean disposed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureThread() {
        TrafficTracker trafficTracker = this;
        synchronized (trafficTracker) {
            Thread thread;
            if (this.thread.get() == null && !this.disposed && this.thread.compareAndSet(null, thread = new Thread("Traffic Log Sender " + this.getUpdateClient()){
                protected volatile long lastException;
                protected volatile long lastSend;
                {
                    this.lastException = -1L;
                    this.lastSend = -1L;
                }

                private boolean isAbort() {
                    return Thread.currentThread() != TrafficTracker.this.thread.get() || TrafficTracker.this.disposed;
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 16[WHILELOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            })) {
                thread.setDaemon(true);
                thread.start();
            }
        }
    }

    public TrafficTracker(UpdateClient updateClient) {
        this.updateClient = updateClient;
        this.file = new File(updateClient.getPathBuilder().getUIDFile(updateClient).getParentFile(), "traffic");
        this.httpClient = updateClient.getBuilder().createHTTPClient(updateClient);
    }

    public File getFile() {
        return this.file;
    }

    protected UpdateClient getUpdateClient() {
        return this.updateClient;
    }

    protected HttpClientInterface getHttpClient() {
        return this.httpClient;
    }

    public boolean update(final TrafficLog item) {
        if (!this.isEnabled() || item == null) {
            return false;
        }
        this.initOnce();
        item.setDate(this.getUpdateClient().getServerTime().now());
        new NonInterruptibleRunnable<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws RuntimeException {
                TrafficTracker trafficTracker = TrafficTracker.this;
                synchronized (trafficTracker) {
                    List<TrafficLog> entries = TrafficTracker.this.getEntries();
                    if (!entries.contains(item)) {
                        entries.add(item);
                    }
                    while (entries.size() > 0 && entries.size() > TrafficTracker.this.getBacklogSize()) {
                        TrafficLog removed = entries.remove(0);
                        if (removed == null) continue;
                        TrafficTracker.this.getUpdateClient().getLogger().info("Discard Traffic Tracker entry: " + JSonStorage.serializeToJson(removed));
                    }
                    TrafficTracker.this.writeEntries();
                    TrafficTracker.this.ensureThread();
                    TrafficTracker.this.notifyAll();
                }
                return null;
            }
        }.startAndWait();
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    protected int getMaxBatchSize() {
        return 10;
    }

    protected int getBacklogSize() {
        return 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send() throws InterruptedException, TransportException {
        ArrayList<TrafficLog> entries = new ArrayList<TrafficLog>();
        int maxBatchSize = this.getMaxBatchSize();
        TrafficTracker trafficTracker = this;
        synchronized (trafficTracker) {
            for (TrafficLog trafficLog : this.getEntries()) {
                if (trafficLog == null) continue;
                entries.add(trafficLog);
                if (maxBatchSize <= 0 || entries.size() < maxBatchSize) continue;
                break;
            }
        }
        ArrayList<HashMap<String, Object>> diffsToSend = new ArrayList<HashMap<String, Object>>();
        ArrayList<TrafficLog> sentFinalized = new ArrayList<TrafficLog>();
        HashMap<TrafficLog, TrafficLog> copiesToSend = new HashMap<TrafficLog, TrafficLog>();
        for (TrafficLog ts : entries) {
            TrafficLog lastSend;
            TrafficLog copy = JSonStorage.restoreFromString(JSonStorage.serializeToJson(ts), TrafficLog.TYPEREF);
            WeakHashMap<TrafficLog, TrafficLog> weakHashMap = this.lastSentData;
            synchronized (weakHashMap) {
                lastSend = this.lastSentData.get(ts);
            }
            HashMap<String, Object> difference = null;
            if (!copy.isFinalized()) {
                try {
                    difference = new CleanedJSonObject(copy, new CleanedJSonObject.CompareInstanceProvider(){

                        @Override
                        public Object createInstance(Class<? extends Object> class1) {
                            if (class1 == TrafficLog.class) {
                                return lastSend;
                            }
                            return null;
                        }
                    }).storableToMap();
                }
                catch (NoSuchMethodException e) {
                    this.getUpdateClient().getLogger().log(e);
                }
                catch (InstantiationException e) {
                    this.getUpdateClient().getLogger().log(e);
                }
                catch (IllegalAccessException e) {
                    this.getUpdateClient().getLogger().log(e);
                }
                catch (InvocationTargetException e) {
                    this.getUpdateClient().getLogger().log(e);
                }
            } else {
                sentFinalized.add(ts);
            }
            if (difference == null) {
                difference = JSonStorage.convert(copy, TypeRef.HASHMAP);
            }
            if (difference == null || difference.size() <= 0) continue;
            difference.put("id", copy.getId());
            difference.put("downloadID", copy.getDownloadID());
            diffsToSend.add(difference);
            copiesToSend.put(ts, copy);
        }
        if (diffsToSend.size() == 0) {
            return false;
        }
        BatchRequestWithCustomHttpClient br = new BatchRequestWithCustomHttpClient(this.getUpdateClient(), this.getHttpClient());
        JobRequest job = new JobRequest(BatchJobType.TRAFFIC.name(), diffsToSend);
        br.add(job.withID());
        this.getUpdateClient().batchRequest(br);
        if (Boolean.TRUE.equals(job._getResponse().restoreParameter(TypeRef.BOOLEAN))) {
            Object object = this.lastSentData;
            synchronized (object) {
                this.lastSentData.putAll(copiesToSend);
            }
            if (sentFinalized.size() > 0) {
                object = this;
                synchronized (object) {
                    if (this.getEntries().removeAll(sentFinalized)) {
                        this.writeEntries();
                    }
                }
            }
            return true;
        }
        throw new TransportException("Server did not accept request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntries() {
        TrafficTracker trafficTracker = this;
        synchronized (trafficTracker) {
            try {
                this.getUpdateClient().getFileSystem().secureWrite(this.getFile(), JSonStorage.serializeToJsonByteArray(this.getEntries()), true);
            }
            catch (ExtIOException e) {
                this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.writeEntries", e);
            }
            catch (StorageException e) {
                this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.writeEntries", e);
            }
            catch (RuntimeException e) {
                this.getUpdateClient().getLogger().exception("Exception in TrafficTracker.writeEntries", e);
            }
        }
    }

    protected List<TrafficLog> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initOnce() {
        TrafficTracker trafficTracker = this;
        synchronized (trafficTracker) {
            if (this.entries == null) {
                this.entries = (List)new NonInterruptibleRunnable<List<TrafficLog>, RuntimeException>(){

                    @Override
                    public List<TrafficLog> run() throws RuntimeException, InterruptedException {
                        if (TrafficTracker.this.getFile().isFile()) {
                            try {
                                String json = TrafficTracker.this.getUpdateClient().getFileSystem().readFileToString(TrafficTracker.this.getFile());
                                List ret = JSonStorage.restoreFromString(json, new TypeRef<ArrayList<TrafficLog>>(){});
                                if (ret != null) {
                                    for (TrafficLog t : ret) {
                                        if (t == null) continue;
                                        t.setFinalized(true);
                                    }
                                    return ret;
                                }
                            }
                            catch (RuntimeException e) {
                                TrafficTracker.this.getUpdateClient().getLogger().log(e);
                            }
                            catch (ExtIOException e) {
                                TrafficTracker.this.getUpdateClient().getLogger().log(e);
                            }
                        }
                        return null;
                    }
                }.startAndWait();
                if (this.entries == null) {
                    this.entries = new ArrayList<TrafficLog>();
                } else if (this.entries.size() > 0) {
                    if (this.updateClient.getServerTime().isSynced()) {
                        this.onTimeSync(this.updateClient.getServerTime());
                    }
                    this.ensureThread();
                }
            }
        }
    }

    public void dispose() {
        new NonInterruptibleRunnableSimple(){

            @Override
            protected void execute() throws InterruptedException {
                TrafficTracker.this.dispose_interruptible();
            }
        }.startAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose_interruptible() throws InterruptedException {
        Thread thread;
        TrafficTracker trafficTracker = this;
        synchronized (trafficTracker) {
            this.disposed = true;
            thread = this.thread.getAndSet(null);
        }
        if (thread != null) {
            thread.interrupt();
            thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeSync(final ServerTimeHandler serverTimeHandler) {
        TrafficTracker trafficTracker = this;
        synchronized (trafficTracker) {
            block16: {
                if (this.getEntries() == null) {
                    return;
                }
                try {
                    Iterator<TrafficLog> it = this.getEntries().iterator();
                    final AtomicInteger modificationCount = new AtomicInteger(0);
                    block11: while (true) {
                        while (it.hasNext()) {
                            TrafficLog entry = it.next();
                            if (entry == null) {
                                modificationCount.incrementAndGet();
                                it.remove();
                                continue;
                            }
                            try {
                                ReflectionUtils.walkThroughObject(entry, new ReflectionUtils.WalkThroughObjectCallBack(){

                                    @Override
                                    public void onObject(String path, Type type, Object obj) {
                                        if (obj != null && type != null && type instanceof Class && SyncedTime.class.isAssignableFrom((Class)type) && ((SyncedTime)obj).sync(serverTimeHandler)) {
                                            modificationCount.incrementAndGet();
                                        }
                                    }
                                });
                                continue block11;
                            }
                            catch (UnsynchronizedStateException unsynchronizedStateException) {
                            }
                            catch (RuntimeException e) {
                                this.getUpdateClient().trackException(e);
                                this.getUpdateClient().getLogger().log(e);
                            }
                        }
                        break block16;
                        {
                            continue block11;
                            break;
                        }
                        break;
                    }
                    finally {
                        if (modificationCount.get() > 0) {
                            this.writeEntries();
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.getUpdateClient().getLogger().log(e);
                    this.getUpdateClient().trackException(e);
                }
            }
        }
    }
}

