/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.nio.charset.Charset;
import java.security.DigestOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.appwork.exceptions.WTFException;
import org.appwork.io.unixsplit.UnixSplitInputStream;
import org.appwork.moncompare.CompareException;
import org.appwork.moncompare.Condition;
import org.appwork.moncompare.ConditionBuilder;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storable;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.txtresource.LocaleMap;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.CalculationOptions;
import org.appwork.updatesys.client.ClientOptionsTask;
import org.appwork.updatesys.client.DeduplicationException;
import org.appwork.updatesys.client.DefaultFileAccessHandler;
import org.appwork.updatesys.client.DefaultFileAccessNIOHandler;
import org.appwork.updatesys.client.DeletingRootFoldersIsForbiddenException;
import org.appwork.updatesys.client.DisabledHIDProvider;
import org.appwork.updatesys.client.DiskSpaceException;
import org.appwork.updatesys.client.DownloadPackageInfo;
import org.appwork.updatesys.client.FailedActionException;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.FileList;
import org.appwork.updatesys.client.ImplBuilder;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.InstallationResult;
import org.appwork.updatesys.client.JSonHandlerHint;
import org.appwork.updatesys.client.LastChanceException;
import org.appwork.updatesys.client.LogAndIgnoreException;
import org.appwork.updatesys.client.ModuleProgress;
import org.appwork.updatesys.client.NoRelativeFileException;
import org.appwork.updatesys.client.PackageCreateException;
import org.appwork.updatesys.client.PathBuilder;
import org.appwork.updatesys.client.ReplacementModifier;
import org.appwork.updatesys.client.ServerLockedException;
import org.appwork.updatesys.client.TargetRevisionIsLowerThanInstalledRevisionException;
import org.appwork.updatesys.client.UninstallStatusInterface;
import org.appwork.updatesys.client.UpdateClientBatchRequest;
import org.appwork.updatesys.client.UpdateClientSetupInterface;
import org.appwork.updatesys.client.UrlFactoryInterface;
import org.appwork.updatesys.client.WindowsFileAccessJNAHandler;
import org.appwork.updatesys.client.extensions.CompiledServerOptions;
import org.appwork.updatesys.client.extensions.ExtensionManager;
import org.appwork.updatesys.client.extensions.ExtensionManagerInterface;
import org.appwork.updatesys.client.http.DownloadHooksInterface;
import org.appwork.updatesys.client.http.HttpClientInterface;
import org.appwork.updatesys.client.http.ProgressCallback;
import org.appwork.updatesys.client.http.ProxySelectorException;
import org.appwork.updatesys.client.iid.HIDProviderInterface;
import org.appwork.updatesys.client.iid.LegacyUIDprovider;
import org.appwork.updatesys.client.iid.UIDProviderInterface;
import org.appwork.updatesys.client.install.AbstractBackupFileWriter;
import org.appwork.updatesys.client.install.BackupFileReader;
import org.appwork.updatesys.client.install.BackupFileWriterImpl;
import org.appwork.updatesys.client.install.CleanupException;
import org.appwork.updatesys.client.install.DeleteCallback;
import org.appwork.updatesys.client.install.DeleteFileOrFolderV2;
import org.appwork.updatesys.client.install.InstallerAction;
import org.appwork.updatesys.client.install.MergeJarFilesAction;
import org.appwork.updatesys.client.install.NewFileInstallAction;
import org.appwork.updatesys.client.install.ReplaceExistingFileInstallAction;
import org.appwork.updatesys.client.install.RevertException;
import org.appwork.updatesys.client.jardelta.JarDeltaMerge;
import org.appwork.updatesys.client.jardelta.JarMergeException;
import org.appwork.updatesys.client.jardelta.UpdateNotifyInterface;
import org.appwork.updatesys.client.serveroptions.ServerOptionsManager;
import org.appwork.updatesys.client.servertime.ServerTimeHandler;
import org.appwork.updatesys.client.service.ConnectServiceExecutionException;
import org.appwork.updatesys.client.service.ConnectServiceMissingException;
import org.appwork.updatesys.client.uninstall.UninstallOptions;
import org.appwork.updatesys.service.ServiceExecuter;
import org.appwork.updatesys.service.ServiceExecutionExeption;
import org.appwork.updatesys.service.ServiceInstallation;
import org.appwork.updatesys.service.ServiceUtils;
import org.appwork.updatesys.transport.DataExchange;
import org.appwork.updatesys.transport.Ids;
import org.appwork.updatesys.transport.Pkg;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.UpdateServerOfflineException;
import org.appwork.updatesys.transport.exchange.BooleanTristate;
import org.appwork.updatesys.transport.exchange.ClientOptions;
import org.appwork.updatesys.transport.exchange.DeduplicationMode;
import org.appwork.updatesys.transport.exchange.DeduplicationSignature;
import org.appwork.updatesys.transport.exchange.DiskSpaceChanges;
import org.appwork.updatesys.transport.exchange.DownloadMirror;
import org.appwork.updatesys.transport.exchange.DownloadUrlList;
import org.appwork.updatesys.transport.exchange.ElevationMode;
import org.appwork.updatesys.transport.exchange.ErrorCode;
import org.appwork.updatesys.transport.exchange.Exec;
import org.appwork.updatesys.transport.exchange.ExecuteResult;
import org.appwork.updatesys.transport.exchange.ExecuteResultMapping;
import org.appwork.updatesys.transport.exchange.ExecuteResultMatcher;
import org.appwork.updatesys.transport.exchange.FailedAction;
import org.appwork.updatesys.transport.exchange.JarSignature;
import org.appwork.updatesys.transport.exchange.PackageInstallationHistory;
import org.appwork.updatesys.transport.exchange.ProtocolVersions;
import org.appwork.updatesys.transport.exchange.RemovedFile;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.Revision;
import org.appwork.updatesys.transport.exchange.SearchAndReplace;
import org.appwork.updatesys.transport.exchange.SessionInitData;
import org.appwork.updatesys.transport.exchange.SyncedTime;
import org.appwork.updatesys.transport.exchange.TimeSyncResponse;
import org.appwork.updatesys.transport.exchange.UninstallInfo;
import org.appwork.updatesys.transport.exchange.UpdateOptions;
import org.appwork.updatesys.transport.exchange.UpdateSignature;
import org.appwork.updatesys.transport.exchange.batch.BatchJobType;
import org.appwork.updatesys.transport.exchange.batch.BatchRequest;
import org.appwork.updatesys.transport.exchange.batch.BatchResponse;
import org.appwork.updatesys.transport.exchange.batch.JobRequest;
import org.appwork.updatesys.transport.exchange.batch.JobResponse;
import org.appwork.updatesys.transport.exchange.interfaces.ChangeLogResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.DiskSpaceChangesInterface;
import org.appwork.updatesys.transport.exchange.interfaces.ErrorResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.PackageResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.WaitResponseInterface;
import org.appwork.updatesys.transport.exchange.json.LocalPackageJsonResponse;
import org.appwork.updatesys.transport.exchange.json.PackageJsonResponse;
import org.appwork.updatesys.transport.exchange.setup.ConditionContext;
import org.appwork.updatesys.transport.exchange.setup.ConditionMatcherForSearchAndReplace;
import org.appwork.updatesys.transport.exchange.setup.ExecuteResultAction;
import org.appwork.updatesys.transport.exchange.setup.FileContext;
import org.appwork.updatesys.transport.exchange.setup.GenericConditionMatcher;
import org.appwork.updatesys.transport.exchange.setup.PreCondition;
import org.appwork.updatesys.transport.exchange.setup.UninstallRule;
import org.appwork.updatesys.transport.exchange.track.DiscardReason;
import org.appwork.updatesys.transport.exchange.track.TrafficLog;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.Files;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.NonInterruptibleRunnableException;
import org.appwork.utils.NonInterruptibleRunnableReturn;
import org.appwork.utils.NonInterruptibleRunnableSimple;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.UniqueAlltimeID;
import org.appwork.utils.awfc.AWFCEntry;
import org.appwork.utils.awfc.AWFCInputStream;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.duration.TimeSpanWithContext;
import org.appwork.utils.duration.Unit;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.encoding.URLEncode;
import org.appwork.utils.extioexceptions.FileNotFoundExtIOException;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.BasicHTTP.BadRangeResponse;
import org.appwork.utils.net.BasicHTTP.BadResponseLengthException;
import org.appwork.utils.net.BasicHTTP.BasicHTTPException;
import org.appwork.utils.net.BasicHTTP.InvalidResponseCode;
import org.appwork.utils.net.BasicHTTP.InvalidResponseException;
import org.appwork.utils.net.InterruptibleInputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionImpl;
import org.appwork.utils.net.httpconnection.HTTPConnectionProfiler;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.NotSupportedException;
import org.appwork.utils.processes.ContinuesFileLineReader;
import org.appwork.utils.processes.LineHandler;
import org.appwork.utils.processes.command.AbstractLineHandler;
import org.appwork.utils.processes.command.Command;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.appwork.utils.zip.ZipIOReader;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.XZInputStream;

public abstract class UpdateClient {
    public static final int PROTOCOL_VERSION = ProtocolVersions.PV_12.ordinal();
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final long CLIENT_VERSION = 20210716001L;
    public static final String UPD_REVERT_BACKUP = ".updRevertBackup";
    protected final HttpClientInterface httpClient;
    private UrlFactoryInterface urlBuilder;
    private final UpdateClientSetupInterface setup;
    private final PublicKey publicKey;
    private final ExtensionManagerInterface extensionManager;
    protected final ServerOptionsManager serverOptionsManager;
    protected LogInterface logger;
    private FileList filelist;
    protected Pkg update;
    private final File backupFile;
    private final File workingDirectory;
    private byte[] buffer;
    private final File revisionFile;
    protected final File updateOptionsFile;
    protected ModuleProgress moduleProgress;
    private final File failedCleanupsFile;
    private boolean validatePackageDownloadConnection = true;
    private final ImplBuilder builder;
    private volatile DownloadProgress downloadProgress = new DownloadProgress();
    private boolean reverting;
    private final PathBuilder pathBuilder;
    protected Map<String, ClientOptionsTask> clientOptionsTasks;
    private int forcedDestRevision = -1;
    private DownloadMirror lastUsedDownloadMirror;
    private InstallationResult installPackageResult;
    private ServiceInstallation service = null;
    protected UpdateOptions updateOptions = null;
    private FileAccessHandler fileSystem;
    protected HIDProviderInterface hidProvider;
    protected UIDProviderInterface uidProvider;
    protected final ServerTimeHandler serverTime;
    private final AtomicBoolean sessionInitInProgress = new AtomicBoolean(false);
    private SyncedTime initDoneTime;
    public static boolean PROCESS_IS_SELFTEST = false;
    private final ThreadLocal<String> currentUpdateServer = new ThreadLocal();
    private volatile String lastValidUpdateServer;

    public static String readEntry(InputStream input) throws IOException {
        return IO.readInputStreamToString(new FilterInputStream(input){

            @Override
            public void close() throws IOException {
            }
        });
    }

    public void parseExcecuteConsoleOutLine(Exec execute, String line) {
        try {
            String match;
            Matcher matcher;
            String pattern;
            LocaleMap localeMap = this.findMessageByPattern(line, execute.getErrorPattern());
            if (localeMap != null) {
                this.onExecuteErrorMessage(execute, localeMap);
            }
            if ((localeMap = this.findMessageByPattern(line, execute.getMessagePattern())) != null) {
                this.onExecuteStatusMessage(execute, localeMap);
            }
            if (StringUtils.isNotEmpty(pattern = execute.getProgressPattern()) && (matcher = Pattern.compile(pattern).matcher(line)).find() && (match = matcher.group(1)) != null) {
                double value = Double.parseDouble(match);
                this.onExecuteProgressMessage(execute, value);
            }
        }
        catch (Exception e) {
            this.getLogger().log(e);
        }
    }

    protected void onExecuteErrorMessage(Exec execute, LocaleMap localeMap) {
    }

    protected void onExecuteProgressMessage(Exec execute, double progress) {
        if (progress < 0.0) {
            this.getModuleProgress().setIndeterminated(true);
        } else {
            this.getModuleProgress().setIndeterminated(false);
            this.getModuleProgress().setStepValue(progress / 100.0);
        }
    }

    protected void onExecuteStatusMessage(Exec execute, LocaleMap localeMap) {
    }

    public void setUrlBuilder(UrlFactoryInterface urlBuilder) {
        this.urlBuilder = urlBuilder;
    }

    protected String[] getUpdateServers() {
        return this.getSetup().getUpdateServers();
    }

    public boolean isValidatePackageDownloadConnection() {
        return this.validatePackageDownloadConnection;
    }

    public void setValidatePackageDownloadConnection(boolean validatePackageDownloadConnection) {
        this.validatePackageDownloadConnection = validatePackageDownloadConnection;
    }

    protected ServerOptionsManager getServerOptionsManager() {
        return this.serverOptionsManager;
    }

    public UpdateOptions retry(Throwable e) {
        if (Exceptions.containsInstanceOf(e, JarMergeException.class, DeduplicationException.class)) {
            UpdateClient updateClient;
            InstallException installException = Exceptions.getInstanceof(e, InstallException.class);
            if (installException == null || installException.getUpdateClient() == null) {
                updateClient = this;
                this.getLogger().warning("retry for unknown update client instance!");
            } else if (installException.getUpdateClient() != this) {
                updateClient = installException.getUpdateClient();
                this.getLogger().warning("retry for different update client instance:" + installException.getUpdateClient() + "!=" + this);
            } else {
                updateClient = this;
            }
            UpdateOptions updateOptions = updateClient.getUpdateOptions();
            UpdateOptions retryUpdateOptions = new UpdateOptions(updateOptions);
            List<String> causes = retryUpdateOptions.getRetryCauses();
            if (causes == null) {
                causes = new ArrayList<String>();
                retryUpdateOptions.setRetryCauses(causes);
            }
            causes.add(Exceptions.getStackTrace(e));
            if (Exceptions.containsInstanceOf(e, JarMergeException.class) && (updateOptions == null || updateOptions.isJarDiffEnabled())) {
                retryUpdateOptions.setJarDiffEnabled(false);
                return retryUpdateOptions;
            }
            if (Exceptions.containsInstanceOf(e, DeduplicationException.class)) {
                DeduplicationException deduplicationException = Exceptions.getInstanceof(e, DeduplicationException.class);
                DeduplicationMode mode = deduplicationException.getMode();
                if (mode == null && updateOptions != null) {
                    mode = updateOptions.getDeduplicationMode();
                }
                if (mode == null) {
                    try {
                        mode = updateClient.createPkgRequest().getDeduplicationMode();
                    }
                    catch (IOException ignore) {
                        this.getLogger().log(ignore);
                    }
                }
                mode = updateClient.getSupportedDeduplicationMode(mode);
                switch (mode) {
                    case INTER: {
                        retryUpdateOptions.setDeduplicationMode(DeduplicationMode.INTRA);
                        return retryUpdateOptions;
                    }
                    case INTRA: {
                        retryUpdateOptions.setDeduplicationMode(DeduplicationMode.NONE);
                        return retryUpdateOptions;
                    }
                }
                return null;
            }
        }
        return null;
    }

    public UpdateOptions getUpdateOptions() {
        UpdateOptions ret = this.updateOptions;
        if (ret == null) {
            try {
                File file = this.getUpdateOptionsFile();
                if (file.isFile()) {
                    ret = this.readUpdateOptions(file);
                }
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
            if (ret == null) {
                ret = this.getDefaultUpdateOptions();
                if (ret == null) {
                    throw new NullPointerException("getDefaultUpdateOptions returns null");
                }
                this.getLogger().info(this.getClass().getName() + ":getDefaultUpdateOptions:" + JSonStorage.toString(ret));
            }
            this.updateOptions = ret;
        } else {
            this.getLogger().info(this.getClass().getName() + ":getUpdateOptions:" + JSonStorage.toString(ret));
        }
        return ret;
    }

    protected File getUpdateOptionsFile() {
        return this.updateOptionsFile;
    }

    protected void resetUpdateOptions(File pkgFile, PackageResponseInterface pkg) {
        this.setUpdateOptions(null);
    }

    public void setUpdateOptions(final UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
        this.getLogger().info(this + ":setUpdateOptions:" + JSonStorage.toString(updateOptions));
        new NonInterruptibleRunnableSimple(){

            @Override
            protected void execute() throws InterruptedException {
                try {
                    File file = UpdateClient.this.getUpdateOptionsFile();
                    if (updateOptions == null) {
                        UpdateClient.this.getFileSystem().deleteFileIfExists(file);
                    } else {
                        UpdateClient.this.writeUpdateOptions(file, updateOptions);
                    }
                }
                catch (ExtIOException e) {
                    UpdateClient.this.getLogger().log(e);
                }
            }
        }.startAndWait();
    }

    protected void writeUpdateOptions(File updateOptionsFile, UpdateOptions updateOptions) throws ExtIOException {
        FileAccessHandler fileSystem = this.getFileSystem();
        fileSystem.secureWrite(updateOptionsFile, JSonStorage.serializeToJsonByteArray(updateOptions), true);
    }

    protected UpdateOptions readUpdateOptions(File updateOptionsFile) throws InterruptedException, ExtIOException {
        if (updateOptionsFile == null || !updateOptionsFile.isFile()) {
            return null;
        }
        return JSonStorage.restoreFromString(this.getFileSystem().secureReadFileToString(updateOptionsFile), UpdateOptions.TYPE_REF);
    }

    protected UpdateOptions getDefaultUpdateOptions() {
        UpdateOptions ret = new UpdateOptions();
        ret.setJarDiffEnabled(true);
        ret.setDeduplicationMode(this.getMaxSupportedDeduplicationMode());
        return ret;
    }

    public ServerTimeHandler getServerTime() {
        return this.serverTime;
    }

    public UpdateClient(final UpdateClientSetupInterface setup, ImplBuilder builder) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        this.setup = setup;
        this.builder = builder;
        this.logger = builder.createLogger(this);
        this.workingDirectory = this.initWorkingDirectory();
        this.pathBuilder = this.initPathBuilder(builder);
        this.httpClient = this.initHTTPClient(builder);
        this.urlBuilder = this.initURLBuilder(builder);
        this.setFileSystem(this.initFileAccessHandler(builder));
        new NonInterruptibleRunnableSimple(){

            @Override
            protected void execute() throws InterruptedException {
                UpdateClient.this.fixPathesToToUniqueSetupIDChange(setup);
            }
        }.startAndWait();
        this.serverTime = this.initServerTimeHandler();
        this.moduleProgress = new ModuleProgress();
        this.backupFile = this.getPathBuilder().getBackupFile(this);
        new NonInterruptibleRunnableException<IOException>(){

            @Override
            protected void execute() throws IOException, InterruptedException {
                UpdateClient.this.getFileSystem().mkdirs(UpdateClient.this.getBackupFile().getParentFile());
            }
        }.startAndWait();
        this.failedCleanupsFile = this.getPathBuilder().getFailedCleanupsFile(this);
        this.uidProvider = this.initUIDProvider();
        this.publicKey = setup.getPublicSignatureKey() != null ? KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decode(setup.getPublicSignatureKey()))) : null;
        this.revisionFile = this.getPathBuilder().getRevisionFile(this);
        this.updateOptionsFile = this.getPathBuilder().getRepoStorageResource(this, "updateOptions.json");
        this.serverOptionsManager = this.createServerOptionsManager();
        this.extensionManager = this.createExtensionManager();
        new NonInterruptibleRunnableException<IOException>(){

            @Override
            protected void execute() throws IOException, InterruptedException {
                UpdateClient.this.getFileSystem().mkdirs(UpdateClient.this.getWorkingDirectory());
            }
        }.startAndWait();
        if (this.isFileListSupportEnabled()) {
            this.filelist = new FileList(this, this.getPathBuilder().getFilelist(this), this.getLogger());
        }
        this.serverOptionsManager.init();
    }

    protected File initWorkingDirectory() {
        return Application.getTemp().getParentFile();
    }

    protected ServerTimeHandler initServerTimeHandler() {
        ServerTimeHandler ret = new ServerTimeHandler(this);
        return ret;
    }

    protected DeduplicationMode getMaxSupportedDeduplicationMode() {
        return DeduplicationMode.INTER;
    }

    public DeduplicationMode getSupportedDeduplicationMode(DeduplicationMode mode) {
        if (mode == null) {
            return this.getMaxSupportedDeduplicationMode();
        }
        return this.getMaxSupportedDeduplicationMode().get(mode);
    }

    protected File getBackupFile() {
        return this.backupFile;
    }

    protected void fixPathesToToUniqueSetupIDChange(UpdateClientSetupInterface setup) throws InterruptedException {
    }

    protected UIDProviderInterface initUIDProvider() throws ExtIOException {
        return new LegacyUIDprovider(this);
    }

    public void setFileSystem(FileAccessHandler fileSystem) {
        if (fileSystem == null) {
            throw new NullPointerException();
        }
        this.fileSystem = fileSystem;
    }

    protected FileAccessHandler initFileAccessHandler(ImplBuilder builder) {
        if (JVMVersion.isMinimum(17000000L)) {
            if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_VISTA)) {
                return new WindowsFileAccessJNAHandler(this);
            }
            return new DefaultFileAccessNIOHandler(this);
        }
        return new DefaultFileAccessHandler(this);
    }

    protected UrlFactoryInterface initURLBuilder(ImplBuilder builder) {
        return builder.createUrlBuilder(this);
    }

    protected HttpClientInterface initHTTPClient(ImplBuilder builder) {
        return builder.createHTTPClient(this);
    }

    protected PathBuilder initPathBuilder(ImplBuilder builder) {
        return builder.createPathbuilder(this);
    }

    protected ServiceExecuter createServiceExecuter(ServiceInstallation service, Exec execute) {
        return new ClientServiceExecuter(this, service, execute);
    }

    protected ContinuesFileLineReader startExternalProcessLogFileReader(LineHandler lineHandler, String parseLOg) throws InterruptedException {
        return new ContinuesFileLineReader(lineHandler, parseLOg, null).run();
    }

    protected void applyClientOptions(List<ClientOptionsTask> clientOptionsTasks, AbstractBackupFileWriter backuplist) throws InstallException, InterruptedException {
        this.getModuleProgress().setStepID((Object)Module.CLIENT_OPTIONS);
        for (ClientOptionsTask ct : clientOptionsTasks) {
            try {
                String clientOptionPath = ct.getRelPath();
                ClientOptions co = ct.getClientOption();
                String path = clientOptionPath.substring(0, clientOptionPath.length() - ".clientOptions".length());
                AbsoluteFile file = this.convertRelPath(path);
                this.convertDeprecatedClientOptionProperties(co, file);
                this.onPreClientOption(path, co);
                try {
                    SearchAndReplace[] sars;
                    Exec[] executes;
                    this.getLogger().info("Apply CLientOption: " + clientOptionPath);
                    this.getLogger().info(JSonStorage.toString(co));
                    if (co.getExecutable() == BooleanTristate.TRUE) {
                        this.getLogger().info("Set Executable to " + (Object)((Object)co.getExecutable()) + ": " + file);
                        if (!file.exists()) {
                            throw new InstallException(this, (Throwable)new FileNotFoundExtIOException("File not found", null, file));
                        }
                        file.setExecutable(true);
                        if (!file.canExecute()) {
                            throw new InstallException(this, "Could not set " + file + " executable to" + (Object)((Object)co.getExecutable()));
                        }
                    } else if (co.getExecutable() == BooleanTristate.FALSE) {
                        this.getLogger().info("Set Executable to " + (Object)((Object)co.getExecutable()) + ": " + file);
                        if (!file.exists()) {
                            throw new InstallException(this, (Throwable)new FileNotFoundExtIOException("File not found", null, file));
                        }
                        file.setExecutable(false);
                        if (file.canExecute()) {
                            throw new InstallException(this, "Could not set " + file + " executable to" + (Object)((Object)co.getExecutable()));
                        }
                    }
                    if ((executes = co.getExecutes()) != null) {
                        for (Exec execute : executes) {
                            try {
                                if (StringUtils.isEmpty(execute.getWorkingDirectory())) {
                                    execute.setWorkingDirectory(file.getParentFile().getAbsolutePath());
                                }
                                GenericConditionMatcher matcher = this.createExecuteConditionMatcherObject(null);
                                matcher.setPath(new FileContext(file));
                                HashMap<String, String> commandline = new HashMap<String, String>();
                                commandline.put("%s1", file.getAbsolutePath());
                                commandline.put("%filepath%", file.getAbsolutePath());
                                commandline.put("%fileparentpath%", file.getParentFile().getAbsolutePath());
                                this.execute(execute, true, commandline, null, matcher);
                            }
                            catch (Exception e) {
                                throw InstallException.wrap(this, e);
                            }
                        }
                    }
                    if ((sars = co.getSearchAndReplaces()) != null) {
                        if (!file.exists()) {
                            throw new InstallException(this, (Throwable)new FileNotFoundExtIOException("File not found", null, file));
                        }
                        this.searchAndReplace(sars, file, backuplist);
                    }
                }
                catch (NoRelativeFileException e) {
                    throw InstallException.wrap(this, e);
                }
                finally {
                    this.onPostClientOption(path, co);
                    if (co.getDeleteAfterClientOptions() == BooleanTristate.TRUE) {
                        try {
                            this.getFileSystem().deleteFileIfExists(file);
                        }
                        catch (Throwable e) {
                            throw InstallException.wrap(this, e);
                        }
                    }
                }
                this.getLogger().info("Done");
            }
            catch (InstallException e) {
                FailedAction action = ct.getClientOption().getFailedAction();
                if (action == null) {
                    throw e;
                }
                switch (action) {
                    case REVERT: {
                        throw e;
                    }
                }
                this.getLogger().exception("FailedAction:" + action.name(), e);
            }
        }
    }

    protected void searchAndReplace(SearchAndReplace[] sars, AbsoluteFile file, AbstractBackupFileWriter backupFileWriter) throws InstallException, InterruptedException, NoRelativeFileException {
        if (sars == null || sars.length == 0) {
            return;
        }
        try {
            String string = this.getFileSystem().readFileToString(file);
            int replaces = 0;
            block5: for (SearchAndReplace sar : sars) {
                PreCondition[] conditions = sar.getConditions();
                if (conditions != null && conditions.length > 0) {
                    ConditionMatcherForSearchAndReplace matcher = this.createExecuteConditionMatcherObject(new ConditionMatcherForSearchAndReplace());
                    matcher.setPath(new FileContext(file));
                    matcher.setContent(string);
                    for (PreCondition condition : conditions) {
                        if (condition == null || condition.getQuery().matchesWithoutExceptions(matcher)) continue;
                        this.getLogger().info("Condition Failed: " + this.createDocumentedJSONObject(condition));
                        switch (condition.getFailAction()) {
                            case CONTINUE: {
                                continue block5;
                            }
                            default: {
                                throw new InstallException(this, null, condition.getFailMessage(), null, condition.getFailAction());
                            }
                        }
                    }
                }
                String replacement = sar.getReplacement();
                if (sar.isResolveDynLinks()) {
                    replacement = this.getPathBuilder().replaceDynLinks(this, replacement, new ReplacementModifier(){

                        @Override
                        public String replace(String output, String search, String replacement) {
                            return output.replace(search, Matcher.quoteReplacement(replacement));
                        }
                    });
                }
                Matcher matcher = Pattern.compile(sar.getRegex()).matcher(string);
                matcher.reset();
                boolean result = matcher.find();
                if (!result) continue;
                StringBuffer sb = new StringBuffer();
                do {
                    matcher.appendReplacement(sb, replacement);
                    String replace = string.substring(matcher.start(), matcher.end());
                    String toLog = replace.replaceAll(sar.getRegex(), replacement);
                    this.logger.info("Search&Replaced at index " + matcher.start() + "-" + matcher.end() + ": '" + replace + "' by '" + toLog + "'");
                    ++replaces;
                } while (result = matcher.find());
                matcher.appendTail(sb);
                string = sb.toString();
            }
            if (replaces > 0) {
                AbsoluteFile test;
                ArrayList<ReplaceExistingFileInstallAction> ret = new ArrayList<ReplaceExistingFileInstallAction>();
                AbsoluteFile backupFile = null;
                ReplaceExistingFileInstallAction action = null;
                int backupIndex = 1;
                while ((test = file.deriveWithPostFix(UPD_REVERT_BACKUP + backupIndex++)).exists()) {
                }
                backupFile = test;
                action = new ReplaceExistingFileInstallAction(backupFile.getRelative(), file.getRelative());
                if (backupFileWriter != null && backupFileWriter.write(action)) {
                    ret.add(action);
                }
                this.installFileBackupExisting(file, backupFile);
                this.getFileSystem().secureWrite(file, string.getBytes(UTF8), true);
            }
        }
        catch (IOException e) {
            throw InstallException.wrap(this, e);
        }
    }

    protected void convertDeprecatedClientOptionProperties(ClientOptions co, AbsoluteFile file) {
        if (co.getExecutes() == null) {
            String[] cmd = co.getInstallCMDLine();
            if (cmd != null && cmd.length > 0) {
                Exec exec = new Exec();
                exec.setElevation(new ElevationMode[]{ElevationMode.NONE});
                exec.setCmd(cmd);
                exec.setName(new LocaleMap(co._getLocalizedName(new File(cmd[0]).getName())));
                ArrayList<ExecuteResultMapping> list = new ArrayList<ExecuteResultMapping>();
                ExecuteResultMapping success = new ExecuteResultMapping();
                success.setAction(ExecuteResultAction.CONTINUE);
                if (co.getExecutionSuccessRegex() == null) {
                    success.setQuery(new Condition());
                    list.add(success);
                } else {
                    success.setQuery(new ConditionBuilder().property("console").matchesRegex("(?s).*" + co.getExecutionSuccessRegex() + ".*").build());
                    ExecuteResultMapping fail = new ExecuteResultMapping();
                    fail.setAction(ExecuteResultAction.REVERT);
                    fail.setQuery(new Condition());
                    list.add(success);
                    list.add(fail);
                }
                exec.setResultMapping(list);
                co.setExecutes(new Exec[]{exec});
                this.logger.info("Created Execute Instance from 'InstallCMDLine' property!");
            } else if (co.getExecuteService() == BooleanTristate.TRUE || co.getExecuteSelfTestService() == BooleanTristate.TRUE) {
                Exec exec = new Exec();
                exec.setCmd(new String[]{file.getAbsolutePath()});
                PreCondition condition = new PreCondition();
                ArrayList<ElevationMode> modes = new ArrayList<ElevationMode>();
                modes.add(ElevationMode.CONNECT_SERVICE);
                if (co.getExecuteSelfTestServiceFallback() == BooleanTristate.TRUE || co.getExecuteServiceFallback() == BooleanTristate.TRUE) {
                    modes.add(ElevationMode.ADMIN);
                }
                exec.setElevation(modes.toArray(new ElevationMode[0]));
                Condition query = new Condition();
                query.put("\u00a7or", (Object)new Condition[]{new Condition("selftest", co.getExecuteSelfTestService() == BooleanTristate.TRUE), new Condition("selftest", new Condition("\u00a7ne", co.getExecuteService() == BooleanTristate.TRUE))});
                condition.setQuery(query);
                condition.setFailAction(ExecuteResultAction.CONTINUE);
                exec.setConditions(new PreCondition[]{condition});
                ArrayList<ExecuteResultMapping> list = new ArrayList<ExecuteResultMapping>();
                ExecuteResultMapping success = new ExecuteResultMapping();
                success.setAction(ExecuteResultAction.CONTINUE);
                if (co.getExecutionSuccessRegex() == null) {
                    success.setQuery(new ConditionBuilder().property("console").matchesRegex("(?s).*" + Pattern.quote("Connect-Service-Result:Success") + ".*").build());
                } else {
                    success.setQuery(new ConditionBuilder().property("console").matchesRegex("(?s).*" + co.getExecutionSuccessRegex() + ".*").build());
                }
                list.add(success);
                ExecuteResultMapping fail = new ExecuteResultMapping();
                fail.setAction(ExecuteResultAction.REVERT);
                fail.setQuery(new Condition());
                list.add(fail);
                exec.setResultMapping(list);
                co.setExecutes(new Exec[]{exec});
                this.logger.info("Created Execute Instance from 'ExecuteService*' properties!");
            }
        }
    }

    public <MatcherType extends GenericConditionMatcher> MatcherType createExecuteConditionMatcherObject(MatcherType matcher) {
        if (matcher == null) {
            matcher = new GenericConditionMatcher();
        }
        ((GenericConditionMatcher)matcher).setSelftest(this.isSelfTestProcess());
        ((GenericConditionMatcher)matcher).setRevision(this.readRevision());
        ((GenericConditionMatcher)matcher).setJvmPath(CrossSystem.getJavaBinary());
        ((GenericConditionMatcher)matcher).setJvmVersion(JVMVersion.get());
        Pkg u = this.getUpdate();
        if (u != null) {
            ((GenericConditionMatcher)matcher).setTargetRevision(u.getDestRevision());
        }
        ((GenericConditionMatcher)matcher).setOs(CrossSystem.getOS());
        ((GenericConditionMatcher)matcher).setOsFamily(CrossSystem.getOSFamily());
        try {
            ModuleProgress mp = this.getModuleProgress();
            if (mp != null) {
                Object stepID = mp.getStepID();
                switch (Module.valueOf(String.valueOf(stepID))) {
                    case REINSTALL: {
                        ((GenericConditionMatcher)matcher).setContext(ConditionContext.REINSTALL);
                        break;
                    }
                    case UNINSTALL: {
                        ((GenericConditionMatcher)matcher).setContext(ConditionContext.UNINSTALL);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return (MatcherType)matcher;
    }

    /*
     * Exception decompiling
     */
    public void execute(Exec execute, boolean waitFor, Map<String, String> commandlineReplacer, Map<String, String> environment, GenericConditionMatcher conditionmatcher) throws InterruptedException, InstallException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 31[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ExecuteResultMatcher createExecuteResultMatcher(Exec execute, ExecuteResult result, Exception exception) {
        ExecuteResultMatcher ret = new ExecuteResultMatcher();
        ret.setExitcode(new Long(result.exitCode));
        ret.setConsole(result.consoleOut);
        String[] lines = StringUtils.getLines(result.consoleOut);
        for (int i = lines.length - 1; i >= 0; --i) {
            if (ret.getLastErrorMessageFromProcess() == null) {
                ret.setLastErrorMessageFromProcess(this.findMessageByPattern(lines[i], execute.getErrorPattern()));
            }
            if (ret.getLastStatusMessageFromProcess() == null) {
                ret.setLastStatusMessageFromProcess(this.findMessageByPattern(lines[i], execute.getMessagePattern()));
            }
            if (ret.getLastErrorMessageFromProcess() != null && ret.getLastStatusMessageFromProcess() != null) break;
        }
        if (exception != null) {
            ret.setStacktrace(Exceptions.getStackTrace(exception));
            ret.setExceptionClass(exception.getClass().getName());
        }
        return ret;
    }

    protected String createDocumentedJSONObject(Storable condition) {
        return JSonStorage.serializeToJson(condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult executeNormal(Exec execute, boolean waitFor, Map<String, String> commandlineReplacer, Map<String, String> environmentMap) throws InterruptedException, InstallException {
        ExecuteResult executeResult;
        block18: {
            String[] commandline = execute.getCmd();
            File file = new File(commandline[0]);
            if (!file.isAbsolute()) {
                file = new File(execute.getWorkingDirectory(), commandline[0]);
            }
            ServiceUtils.validateConnectServicePackage(file);
            int i = 1;
            File extracted = new File(file.getAbsolutePath() + "-extracted." + i);
            while (extracted.exists()) {
                extracted = new File(file.getAbsolutePath() + "-extracted." + ++i);
            }
            this.getLogger().info("Fallback at " + extracted);
            try {
                ExecuteResult ret;
                new ZipIOReader(file).extractTo(extracted);
                File bat = new File(extracted, "launch.bat");
                HashMap<String, String> environment = this.getConnectServiceFallbackEnvironment();
                if (environmentMap != null) {
                    environment.putAll(environmentMap);
                }
                execute.setCmd(new String[]{bat.getAbsolutePath()});
                execute.setWorkingDirectory(bat.getParent());
                executeResult = ret = this.executeNormalCommandline(execute, waitFor, environment);
                if (!waitFor) break block18;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (waitFor) {
                            long start = Time.systemIndependentCurrentJVMTimeMillis();
                            while (extracted.exists() && Time.systemIndependentCurrentJVMTimeMillis() - start < 5000L) {
                                try {
                                    this.deleteFileOrFolderRecursive(extracted, null, true);
                                    break;
                                }
                                catch (Throwable e) {
                                    this.getLogger().log(e);
                                    Thread.sleep(1000L);
                                }
                            }
                        }
                        throw throwable;
                    }
                    catch (ServiceUtils.CSValidationException e) {
                        this.modifyCommandlineForJarExecution(execute);
                        return this.executeNormalCommandline(execute, waitFor, environmentMap);
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw InstallException.wrap(this, e);
                }
            }
            long start = Time.systemIndependentCurrentJVMTimeMillis();
            while (extracted.exists() && Time.systemIndependentCurrentJVMTimeMillis() - start < 5000L) {
                try {
                    this.deleteFileOrFolderRecursive(extracted, null, true);
                    break;
                }
                catch (Throwable e) {
                    this.getLogger().log(e);
                    Thread.sleep(1000L);
                }
            }
        }
        return executeResult;
    }

    protected HashMap<String, String> getConnectServiceFallbackEnvironment() throws IOException, InterruptedException {
        HashMap<String, String> environment = new HashMap<String, String>();
        if ("rt" != null) {
            environment.put("Connect-runtype", this.isSelfTestProcess() ? "ST" : "SO");
        }
        environment.put("Connect-selftest", String.valueOf(this.isSelfTestProcess()));
        environment.put("ConnectService-fallback", "true");
        environment.put("ConnectService-jre", CrossSystem.getJavaBinary());
        long pid = CrossSystem.getPID();
        environment.put("ConnectService-parent-pid", String.valueOf(pid));
        environment.put("ConnectService-home", Application.getResource("").getCanonicalPath());
        try {
            environment.put("ConnectService-parent-path", CrossSystem.getDesktopSupport().getProcessExecutablePathByPID(pid));
        }
        catch (NotSupportedException e) {
            this.getLogger().info("ConnectService-parent-path not supported by OS");
        }
        try {
            environment.put("ConnectService-parent-cmd", CrossSystem.getDesktopSupport().getProcessCommandlineByPID(pid));
        }
        catch (NotSupportedException e) {
            this.getLogger().info("ConnectService-parent-cmd not supported by OS");
        }
        return environment;
    }

    protected String[] getCommandline(Exec execute, Map<String, String> commandlineReplacer) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : execute.getCmd()) {
            s = this.replaceCommandLineParameterVariables(s, commandlineReplacer);
            ret.add(s);
        }
        return ret.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult executeNormalCommandline(final Exec execute, boolean waitFor, Map<String, String> environment) throws InterruptedException, InstallException {
        try {
            int exitCode;
            File fullpath;
            this.getLogger().info("Run exec:" + FlexiUtils.serializeMinimizedWithWTF(execute));
            String[] cmd = execute.getCmd();
            if (CrossSystem.isWindows() && cmd.length > 0 && cmd[0].toLowerCase(Locale.ROOT).endsWith(".bat")) {
                ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList(cmd));
                commandLine.add(0, "/c");
                commandLine.add(0, "cmd.exe");
                cmd = commandLine.toArray(new String[0]);
            }
            if (CrossSystem.isWindows() && (StringUtils.equalsIgnoreCase(cmd[0], "cmd.exe") || StringUtils.equalsIgnoreCase(cmd[0], "cmd")) && (fullpath = new File(System.getenv("SYSTEMROOT"), "System32\\cmd.exe")).isFile()) {
                cmd[0] = fullpath.getAbsolutePath();
            }
            this.getLogger().info("commandline: " + Arrays.asList(cmd));
            Command command = new Command(cmd);
            command.setDirectory(new File(execute.getWorkingDirectory()));
            command.putAllEnvironment(environment);
            final StringBuffer out = new StringBuffer();
            final HashMap logFileReaders = new HashMap();
            AbstractLineHandler lineHandler = new AbstractLineHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleLine(String line, Object caller) {
                    HashMap hashMap = logFileReaders;
                    synchronized (hashMap) {
                        UpdateClient.this.getLogger().info(">" + caller + ">" + line);
                        StringBuffer stringBuffer = out;
                        synchronized (stringBuffer) {
                            if (out.length() > 0) {
                                out.append("\r\n");
                            }
                            out.append(line);
                        }
                        String parseLOg = new Regex(line, "parse_log=(.*)").getMatch(0);
                        if (parseLOg != null && !logFileReaders.containsKey(parseLOg.trim())) {
                            UpdateClient.this.getLogger().info("Read and Parse Log File: " + parseLOg);
                            try {
                                logFileReaders.put(parseLOg.trim(), UpdateClient.this.startExternalProcessLogFileReader(this, parseLOg));
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        UpdateClient.this.parseExcecuteConsoleOutLine(execute, line);
                    }
                }
            };
            if (waitFor) {
                command.setOutputHandler(lineHandler);
            }
            try {
                if (waitFor) {
                    exitCode = command.start(true).waitFor();
                } else {
                    command.start(true);
                    exitCode = -1;
                }
            }
            finally {
                if (waitFor) {
                    while (true) {
                        ArrayList readers;
                        HashMap hashMap = logFileReaders;
                        synchronized (hashMap) {
                            readers = new ArrayList(logFileReaders.values());
                        }
                        for (ContinuesFileLineReader reader : readers) {
                            try {
                                reader.closeAndFlush();
                            }
                            catch (Throwable e) {
                                this.getLogger().exception("Error during ContinuesFileLineReader", e);
                            }
                        }
                        hashMap = logFileReaders;
                        synchronized (hashMap) {
                            if (readers.size() == logFileReaders.size()) {
                                break;
                            }
                        }
                    }
                }
            }
            return new ExecuteResult(exitCode, out.toString());
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw InstallException.wrap(this, e, null, execute.getName(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult executeViaAdminElevation(Exec execute, boolean waitFor, Map<String, String> commandlineReplacer, Map<String, String> environmentMap) throws InstallException, InterruptedException {
        ExecuteResult executeResult;
        block18: {
            String[] commandline = execute.getCmd();
            File file = new File(commandline[0]);
            if (!file.isAbsolute()) {
                file = new File(execute.getWorkingDirectory(), commandline[0]);
            }
            ServiceUtils.validateConnectServicePackage(file);
            int i = 1;
            File extracted = new File(file.getAbsolutePath() + "-extracted." + i);
            while (extracted.exists()) {
                extracted = new File(file.getAbsolutePath() + "-extracted." + ++i);
            }
            this.getLogger().info("Fallback at " + extracted);
            try {
                ExecuteResult ret;
                new ZipIOReader(file).extractTo(extracted);
                File bat = new File(extracted, "launch.bat");
                HashMap<String, String> environment = this.getConnectServiceFallbackEnvironment();
                if (environmentMap != null) {
                    environment.putAll(environmentMap);
                }
                execute.setCmd(new String[]{bat.getAbsolutePath()});
                execute.setWorkingDirectory(bat.getParent());
                executeResult = ret = this.executeElevatedCommandline(execute, waitFor, environment);
                if (!waitFor) break block18;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (waitFor) {
                            long start = Time.systemIndependentCurrentJVMTimeMillis();
                            while (extracted.exists() && Time.systemIndependentCurrentJVMTimeMillis() - start < 5000L) {
                                try {
                                    this.deleteFileOrFolderRecursive(extracted, null, true);
                                    break;
                                }
                                catch (Throwable e) {
                                    this.getLogger().log(e);
                                    Thread.sleep(1000L);
                                }
                            }
                        }
                        throw throwable;
                    }
                    catch (ServiceUtils.CSValidationException e) {
                        this.modifyCommandlineForJarExecution(execute);
                        return this.executeElevatedCommandline(execute, waitFor, environmentMap);
                    }
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw InstallException.wrap(this, e);
                }
            }
            long start = Time.systemIndependentCurrentJVMTimeMillis();
            while (extracted.exists() && Time.systemIndependentCurrentJVMTimeMillis() - start < 5000L) {
                try {
                    this.deleteFileOrFolderRecursive(extracted, null, true);
                    break;
                }
                catch (Throwable e) {
                    this.getLogger().log(e);
                    Thread.sleep(1000L);
                }
            }
        }
        return executeResult;
    }

    protected void modifyCommandlineForJarExecution(Exec execute) throws InstallException {
        if (new File(execute.getCmd()[0]).getName().toLowerCase(Locale.ROOT).endsWith(".jar")) {
            switch (CrossSystem.getOSFamily()) {
                case WINDOWS: {
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add(CrossSystem.getJavaBinary().replace("javaw.exe", "java.exe"));
                    tmp.add("-jar");
                    for (String c : execute.getCmd()) {
                        tmp.add(c);
                    }
                    execute.setCmd(tmp.toArray(new String[0]));
                    break;
                }
                case LINUX: {
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add(CrossSystem.getJavaBinary());
                    tmp.add("-jar");
                    for (String c : execute.getCmd()) {
                        tmp.add(c);
                    }
                    execute.setCmd(tmp.toArray(new String[0]));
                    break;
                }
                default: {
                    throw new InstallException(this, "InstallAction not supported");
                }
            }
        }
    }

    protected ExecuteResult executeElevatedCommandline(Exec execute, boolean waitFor, Map<String, String> environment) throws InstallException, InterruptedException {
        throw new WTFException("Not Supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult executeViaConnectService(Exec execute, boolean waitFor, Map<String, String> commandlineReplacer, Map<String, String> environment) throws InterruptedException, InstallException {
        try {
            ExecuteResult result = null;
            String[] commandline = execute.getCmd();
            File file = new File(commandline[0]);
            if (!file.isAbsolute()) {
                file = new File(execute.getWorkingDirectory(), commandline[0]);
            }
            ServiceUtils.validateConnectServicePackage(file);
            if (!new File(file.getAbsolutePath() + ".signature").exists()) {
                throw new ConnectException("No Signature");
            }
            Throwable lastException = null;
            this.getLogger().info("Try to execute " + file + " elevated.");
            if (this.service != null) {
                this.getLogger().info("Try cached data: " + this.service);
                try {
                    TimoutWatchDog timeout = new TimoutWatchDog("Timeout", execute);
                    try {
                        result = this.createServiceExecuter(this.service, execute).execute(file, waitFor);
                    }
                    finally {
                        timeout.interrupt();
                    }
                }
                catch (ConnectException e) {
                    lastException = e;
                    this.getLogger().log(e);
                }
                catch (SocketException e) {
                    lastException = e;
                    this.getLogger().log(e);
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Throwable e) {
                    lastException = e;
                    this.getLogger().log(e);
                }
            }
            if (result == null) {
                List<ServiceInstallation> servicesPrimary = ServiceUtils.getInstallations();
                ArrayList<ServiceInstallation> allServices = new ArrayList<ServiceInstallation>(servicesPrimary);
                if (servicesPrimary != null) {
                    if (this.service != null) {
                        servicesPrimary.remove(this.service);
                    }
                    block25: for (ServiceInstallation service1st : servicesPrimary) {
                        try {
                            try {
                                this.getLogger().info("Try Service " + service1st);
                                TimoutWatchDog timeout = new TimoutWatchDog("Timeout", execute);
                                try {
                                    result = this.createServiceExecuter(service1st, execute).execute(file, waitFor);
                                }
                                finally {
                                    timeout.interrupt();
                                }
                                this.service = service1st;
                                break;
                            }
                            catch (ConnectException e) {
                                lastException = e;
                                this.getLogger().log(e);
                            }
                            catch (SocketException e) {
                                this.getLogger().log(e);
                                this.getLogger().warning("Socket Exception during Service package execution. Probably a Service selfupdate");
                                List<ServiceInstallation> servicesNew = null;
                                long started = Time.systemIndependentCurrentJVMTimeMillis();
                                while (Time.systemIndependentCurrentJVMTimeMillis() - started < 300000L) {
                                    servicesNew = ServiceUtils.getInstallations();
                                    if (servicesNew != null) {
                                        servicesNew.removeAll(allServices);
                                        if (servicesNew.size() > 0) break;
                                    }
                                    Thread.sleep(2000L);
                                }
                                if (servicesNew.size() == 0) {
                                    this.getLogger().warning("No Service Installation left");
                                    servicesNew = ServiceUtils.getInstallations();
                                    throw e;
                                }
                                this.getLogger().warning("New Services: " + servicesNew);
                                for (ServiceInstallation service2nd : servicesNew) {
                                    try {
                                        TimoutWatchDog timeout = new TimoutWatchDog("Timeout", execute);
                                        try {
                                            result = this.createServiceExecuter(service2nd, execute).execute(file, waitFor);
                                        }
                                        finally {
                                            timeout.interrupt();
                                        }
                                        this.service = service1st;
                                        continue block25;
                                    }
                                    catch (Throwable e2) {
                                        lastException = e2;
                                        this.getLogger().log(e2);
                                    }
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            lastException = e;
                            this.getLogger().log(e);
                        }
                    }
                }
            }
            if (result != null) {
                return result;
            }
            if (lastException != null) {
                throw lastException;
            }
            throw new ConnectServiceMissingException(this, null, null, execute.getName(), null);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConnectServiceExecutionException.wrap(this, e, null, execute.getName(), null);
        }
    }

    protected String replaceCommandLineParameterVariables(String cmd, Map<String, String> commandlineReplacer) throws IOException {
        cmd = cmd.replace("%connectpath%", Application.getResource("").getAbsolutePath());
        cmd = cmd.replace("%selftest%", String.valueOf(this.isSelfTestProcess()));
        cmd = cmd.replace("%javabinary%", CrossSystem.getJavaBinary());
        cmd = cmd.replace("%jre%", CrossSystem.getJavaBinary().replace("javaw.exe", "java.exe"));
        cmd = cmd.replace("%jre_w%", CrossSystem.getJavaBinary().replace("java.exe", "javaw.exe"));
        if ("rt" != null) {
            cmd = cmd.replace("%runtype%", this.isSelfTestProcess() ? "ST" : "SO");
        }
        if (cmd.startsWith(".%")) {
            try {
                cmd = this.getPathBuilder().fromRelPath(this, cmd).getAbsolutePath();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (commandlineReplacer != null) {
            for (Map.Entry<String, String> es : commandlineReplacer.entrySet()) {
                cmd = cmd.replace(es.getKey(), es.getValue());
            }
        }
        return cmd;
    }

    protected Map<String, String> getCommandEnvironmentVariables() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Connect-selftest", String.valueOf(this.isSelfTestProcess()));
        ret.put("Connect-java", CrossSystem.getJavaBinary());
        ret.put("Connect-path", Application.getResource("").getAbsolutePath());
        try {
            ret.put("ConnectM-jar", Application.getJarFile(UpdateClient.class).getAbsolutePath());
        }
        catch (WTFException e) {
            ret.put("ConnectM-jar", Application.getResource("ConnectM.jar").getAbsolutePath());
        }
        if ("rt" != null) {
            ret.put("Connect-runtype", this.isSelfTestProcess() ? "ST" : "SO");
        }
        return ret;
    }

    public boolean isSelfTestProcess() {
        return PROCESS_IS_SELFTEST;
    }

    public FileAccessHandler getFileSystem() {
        FileAccessHandler fileSystem = this.fileSystem;
        if (fileSystem != null) {
            return fileSystem;
        }
        throw new IllegalStateException("FileAccessHandler not yet initialized!");
    }

    protected void onPostClientOption(String path, ClientOptions co) throws InstallException {
    }

    protected void onPreClientOption(String path, ClientOptions co) throws InstallException {
    }

    public void cancel() {
        this.getHttpClientInterface().cancel();
    }

    private void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            this.getLogger().info("Thread was interrupted: " + Thread.currentThread());
            throw new InterruptedException("Updater has been interruped");
        }
    }

    private void checkLocked(Pkg update) throws ServerLockedException {
        ErrorResponseInterface errorResponse = update.getInterface(ErrorResponseInterface.class);
        if (errorResponse != null && ErrorCode.LOCKED.equals((Object)errorResponse.getErrorCode())) {
            throw new ServerLockedException(this, update);
        }
    }

    public String toString() {
        try {
            return "[Update Client:" + this.getSetup().getApplicationIdentifier() + "@" + new URL(this.getUpdateServer()).getHost() + "]";
        }
        catch (Throwable e) {
            return "[Update Client:" + this.getClass().getName() + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() throws CleanupException, ExtIOException, InterruptedException {
        if (!this.backupFile.exists() || this.backupFile.length() == 0L) {
            return;
        }
        this.moduleProgress.setStepID((Object)Module.CLEANUP);
        boolean errors = false;
        AbstractBackupFileWriter writer = null;
        try {
            writer = new BackupFileWriterImpl(this, this.failedCleanupsFile, true);
            BackupFileReader reader = new BackupFileReader(this, this.backupFile);
            try {
                InstallerAction entry;
                while ((entry = reader.read()) != null) {
                    entry.setLogger(this.getLogger());
                    this.checkInterruption();
                    try {
                        entry.cleanup(this, this.filelist);
                    }
                    catch (CleanupException e) {
                        writer.write(entry);
                        this.getLogger().log(e);
                        this.getLogger().info("Could not clean up " + entry);
                        errors = true;
                    }
                    this.moduleProgress.setStepValue(reader.getProgress());
                }
            }
            finally {
                reader.close();
            }
        }
        catch (InterruptedException e) {
            throw new CleanupException(e);
        }
        catch (IOException e) {
            throw new CleanupException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable throwable) {}
            if (this.filelist != null) {
                try {
                    this.filelist.close();
                }
                catch (Exception exception) {}
            }
        }
        this.getFileSystem().deleteFileIfExists(this.backupFile);
        if (errors) {
            throw new CleanupException("Cleanup errors occured.check Log");
        }
    }

    public AbsoluteFile convertRelPath(String string) throws InstallException {
        try {
            return this.getPathBuilder().fromRelPath(this, string);
        }
        catch (IOException e) {
            throw new InstallException(this, (Throwable)e);
        }
    }

    protected ExtensionManagerInterface createExtensionManager() throws IOException {
        return new ExtensionManager(this);
    }

    private byte[] createKey() throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(this.setup.getPublicSignatureKey().getBytes(UTF8));
    }

    public void runDiskspaceCheck(Map<String, DiskSpaceChanges> map) throws InstallException {
        if (map != null) {
            this.getLogger().info("Run Diskspace Check: " + map);
            HashMap<AbsoluteFile, DiskSpaceChanges> commonRootMap = new HashMap<AbsoluteFile, DiskSpaceChanges>();
            for (Map.Entry<String, DiskSpaceChanges> es : map.entrySet()) {
                File folder = this.convertRelPath(es.getKey());
                try {
                    File root = this.getFileSystem().guessRoot(folder);
                    if (root != null) {
                        folder = root;
                    }
                }
                catch (ExtIOException e) {
                    this.getLogger().log(e);
                }
                DiskSpaceChanges diskSpaceChanges = (DiskSpaceChanges)commonRootMap.get(folder);
                if (diskSpaceChanges == null) {
                    diskSpaceChanges = new DiskSpaceChanges();
                    commonRootMap.put((AbsoluteFile)folder, diskSpaceChanges);
                }
                diskSpaceChanges.addChanged(es.getValue().getChanged());
                diskSpaceChanges.addRequired(es.getValue().getRequired());
            }
            HashMap<File, DiskSpaceChanges> badMap = new HashMap<File, DiskSpaceChanges>();
            for (Map.Entry ese : commonRootMap.entrySet()) {
                try {
                    this.checkFreeDiskSpace((File)ese.getKey(), ((DiskSpaceChanges)ese.getValue()).getRequired());
                }
                catch (InstallException e) {
                    this.getLogger().log(e);
                    badMap.put((File)ese.getKey(), (DiskSpaceChanges)ese.getValue());
                }
            }
            if (badMap.size() > 0) {
                throw new DiskSpaceException(this, badMap);
            }
        }
    }

    protected void checkFreeDiskSpace(File path, long spaceCheck) throws InstallException {
        long freeSpace = 0L;
        try {
            freeSpace = this.getFileSystem().getUsableSpace(path);
        }
        catch (ExtIOException e) {
            this.getLogger().log(e);
        }
        if (freeSpace < 0L) {
            this.getLogger().info("Unlimited DiskSpace on '" + path.getAbsolutePath() + "'?");
        } else {
            long needed = spaceCheck + 0x3200000L;
            if (freeSpace <= needed) {
                throw new DiskSpaceException(this, path, needed);
            }
        }
    }

    public Pkg createPackage() throws TransportException, PackageCreateException, ServerLockedException, LastChanceException, ExtIOException, InterruptedException, InstallException {
        this.moduleProgress.setStepVolume(0.05);
        this.moduleProgress.setStepID((Object)Module.CREATE_PACKAGE);
        try {
            Pkg update = this.getUpdate();
            if (update == null) {
                update = this.downloadPackage();
                this.runChangelogDownload(update);
            }
            long started = Time.systemIndependentCurrentJVMTimeMillis();
            long delta = -1L;
            boolean building = false;
            boolean buildQueue = false;
            while (true) {
                switch (update.getResponseStatus()) {
                    case LASTCHANCE: {
                        this.setUpdate(update);
                        throw new LastChanceException(this, update);
                    }
                    case EMPTY: {
                        this.setUpdate(update);
                        this.onEmptyPackageResponse();
                        Pkg pkg = update;
                        return pkg;
                    }
                    case ERROR: {
                        this.setUpdate(update);
                        this.checkLocked(update);
                        throw new PackageCreateException(this, update);
                    }
                    case URL: 
                    case FILE: {
                        this.setUpdate(update);
                        Pkg pkg = update;
                        return pkg;
                    }
                    case WAIT: {
                        this.setUpdate(update);
                        if (!buildQueue && update.getWaitResponse().getEta() < 0L) {
                            buildQueue = true;
                            this.moduleProgress.setIndeterminated(true);
                            this.moduleProgress.setStepID((Object)Module.CREATE_PACKAGE_WAITING);
                        }
                        if (!building && update.getWaitResponse().getEta() > 0L) {
                            building = true;
                            buildQueue = false;
                            this.moduleProgress.fillStep();
                            this.moduleProgress.setStepID((Object)Module.CREATE_PACKAGE_BUILDING);
                            this.moduleProgress.setStepVolume(0.25);
                        }
                        if (building && update.getWaitResponse().getEta() >= 0L) {
                            delta = Time.systemIndependentCurrentJVMTimeMillis() - started;
                            this.moduleProgress.setStepValue(delta, update.getWaitResponse().getEta() + delta);
                        }
                        this.packageWait(update.getWaitResponse());
                        break;
                    }
                    case OK: {
                        this.setUpdate(update);
                        this.onUp2DateResponse();
                        Pkg pkg = update;
                        return pkg;
                    }
                    default: {
                        throw new TransportException("Unexpected Repsonse:" + (Object)((Object)update.getResponseStatus()));
                    }
                }
                update = this.downloadPackage();
                this.runChangelogDownload(update);
            }
        }
        finally {
            this.moduleProgress.fillStep();
        }
    }

    protected Pkg createPkgRequest() throws ExtIOException {
        return new Pkg(this);
    }

    protected ServerOptionsManager createServerOptionsManager() {
        return new ServerOptionsManager(this);
    }

    private DownloadMirror getNextMirror(DownloadUrlList downloadUrlList, DownloadMirror tryFirst) {
        int total = 0;
        if (tryFirst != null) {
            Iterator it = downloadUrlList.iterator();
            while (it.hasNext()) {
                DownloadMirror ret = (DownloadMirror)it.next();
                if (!ret.getUrl().equals(tryFirst.getUrl())) continue;
                it.remove();
                this.lastUsedDownloadMirror = ret;
                return ret;
            }
        }
        for (DownloadMirror m : downloadUrlList) {
            total += Math.max(m.getPriority(), 0);
        }
        int random = (int)(Math.random() * (double)total);
        Iterator it = downloadUrlList.iterator();
        while (it.hasNext()) {
            DownloadMirror ret = (DownloadMirror)it.next();
            if ((random -= Math.max(ret.getPriority(), 0)) > 0) continue;
            it.remove();
            this.lastUsedDownloadMirror = ret;
            return ret;
        }
        if (downloadUrlList.size() == 0) {
            return null;
        }
        this.lastUsedDownloadMirror = (DownloadMirror)downloadUrlList.remove(downloadUrlList.size() - 1);
        return this.lastUsedDownloadMirror;
    }

    public List<DownloadMirror> getDownloadMirrors(DownloadUrlList mirrors, DownloadMirror tryFirst) {
        ArrayList<DownloadMirror> ret = new ArrayList<DownloadMirror>();
        int maxMirrorRetry = this.getMaxRetriesPerMirror();
        DownloadUrlList downloadUrlList = mirrors.clone();
        while (true) {
            DownloadMirror next;
            if ((next = this.getNextMirror(downloadUrlList, tryFirst)) != null) {
                ret.add(next);
                continue;
            }
            if (maxMirrorRetry <= 0 || maxMirrorRetry >= 10) break;
            --maxMirrorRetry;
            downloadUrlList = mirrors.clone();
        }
        return ret;
    }

    protected int getMaxRetriesPerMirror() {
        return 2;
    }

    protected String convertTrafficLogStatus(TrafficLog trafficLog, TrafficLog.STATUS status, Throwable throwable) {
        if (throwable != null) {
            StringBuilder sb = new StringBuilder();
            for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
                if (sb.length() > 0) {
                    sb.append(".");
                }
                sb.append(cause.getClass().getSimpleName());
            }
            if (status == null) {
                status = TrafficLog.STATUS.UNKNOWN;
            }
            switch (status) {
                case OK: 
                case INTERRUPTED: {
                    return status.name();
                }
            }
            return status.name() + "." + sb.toString();
        }
        if (status != null) {
            return status.name();
        }
        return null;
    }

    protected void trackDownloadTraffic(TrafficLog trafficLog, TrafficLog.STATUS status, Throwable throwable) {
    }

    protected File download(DownloadMirror mirrorToUseFirst) throws TransportException, InterruptedException, IOException, URISyntaxException, InstallException, ProxySelectorException {
        return this.download(this.getPackageFile(), mirrorToUseFirst);
    }

    protected boolean continueDownload(File localFile, long lastFileSizeOnDisk, DownloadResultMap map, PackageResponseInterface response, long round) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (round > 1L && lastFileSizeOnDisk == localFile.length()) {
            this.getLogger().info("abort download in round " + round + " because file size hasn't changed");
            return false;
        }
        if (map != null) {
            if (map.get(TrafficLog.STATUS.HASH) > 2L) {
                this.getLogger().info("abort download in round " + round + " because of " + map.get(TrafficLog.STATUS.HASH) + " failed hash checks");
                return false;
            }
            if (map.get(TrafficLog.STATUS.MISSMATCH) > 2L) {
                this.getLogger().info("abort download in round " + round + " because of " + map.get(TrafficLog.STATUS.MISSMATCH) + " size missmatches");
                return false;
            }
        }
        if (round > 1L) {
            this.getLogger().info("retry download in 5 seconds");
            Thread.sleep(5000L);
        }
        return true;
    }

    public DownloadPackageInfo readDownloadPackageInfo(File file) throws ExtIOException, InterruptedException {
        File packageResponseFile = this.getDownloadPackageInfoFile(file);
        if (packageResponseFile != null && packageResponseFile.isFile()) {
            String readRevisionString = this.getFileSystem().secureReadFileToString(packageResponseFile).trim();
            try {
                String[] old = new Regex(readRevisionString, "^(-?\\d+)_(-?\\d+)_([a-fA-F0-9]{64})").getRow(0);
                if (old != null) {
                    DownloadPackageInfo ret = new DownloadPackageInfo();
                    ret.setSrc(Integer.parseInt(old[0]));
                    ret.setDest(Integer.parseInt(old[1]));
                    ret.setHash(old[2]);
                    return ret;
                }
                return JSonStorage.restoreFromString(readRevisionString, DownloadPackageInfo.TYPEREF);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    public File getDownloadPackageInfoFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".id");
    }

    public File getPackageInstallationHistoryFile(File file) {
        return new File(file.getParentFile(), file.getName() + ".history");
    }

    public String getPackageInstallationHistory(final File packageFile) {
        Map history = (Map)new NonInterruptibleRunnableReturn<Map<PackageInstallationHistory, Long>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Map<PackageInstallationHistory, Long> execute() throws InterruptedException {
                block8: {
                    FileAccessHandler fileSystem = UpdateClient.this.getFileSystem();
                    File historyFile = UpdateClient.this.getPackageInstallationHistoryFile(packageFile);
                    if (historyFile.isFile()) {
                        Map<PackageInstallationHistory, Long> map;
                        FileInputStream fis = fileSystem.openFileInputStream(historyFile);
                        try {
                            map = PackageInstallationHistory.read(UpdateClient.this.getLogger(), false, fis);
                        }
                        catch (Throwable throwable) {
                            try {
                                fis.close();
                                throw throwable;
                            }
                            catch (ExtIOException e) {
                                UpdateClient.this.getLogger().log(e);
                                break block8;
                            }
                            catch (ClosedByInterruptException e) {
                                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                            }
                            catch (IOException e) {
                                UpdateClient.this.getLogger().log(e);
                            }
                        }
                        fis.close();
                        return map;
                    }
                }
                return null;
            }
        }.startAndWait();
        return PackageInstallationHistory.convert(history);
    }

    protected void addPackageInstallationHistory(final File packageFile, final PackageInstallationHistory marker) {
        new NonInterruptibleRunnable<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws InterruptedException {
                FileAccessHandler fileSystem = UpdateClient.this.getFileSystem();
                try {
                    File historyFile = UpdateClient.this.getPackageInstallationHistoryFile(packageFile);
                    fileSystem.mkdirs(historyFile.getParentFile());
                    FileOutputStream fos = fileSystem.openFileOutputStream(historyFile, true);
                    try {
                        marker.write(fos);
                    }
                    finally {
                        fos.close();
                    }
                }
                catch (ExtIOException e) {
                    UpdateClient.this.getLogger().log(e);
                }
                catch (ClosedByInterruptException e) {
                    throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                }
                catch (IOException e) {
                    UpdateClient.this.getLogger().log(e);
                }
                return null;
            }
        }.startAndWait();
    }

    protected void writeDownloadPackageInfo(Revision currentRevision, Pkg pkg, File file) throws ExtIOException {
        File packageInfoFile = this.getDownloadPackageInfoFile(file);
        FileAccessHandler fileSystem = this.getFileSystem();
        DownloadPackageInfo packageInfo = new DownloadPackageInfo();
        PackageResponseInterface packageResponse = pkg.getInterface(PackageResponseInterface.class);
        packageInfo.setSrc(currentRevision.getId());
        packageInfo.setDest(packageResponse.getDestRevision());
        packageInfo.setSize(packageResponse.getSize());
        packageInfo.setHash(packageResponse.getHash());
        packageInfo.setPath(file.getAbsolutePath());
        List<String> extensions = pkg.getEidList();
        if (extensions != null) {
            packageInfo.setExtensions(new HashSet<String>(extensions));
        } else {
            packageInfo.setExtensions(new HashSet<String>(0));
        }
        List<String> extensionsInstall = pkg.getEipList();
        if (extensionsInstall != null) {
            packageInfo.setExtensionsInstall(new HashSet<String>(extensionsInstall));
        } else {
            packageInfo.setExtensionsInstall(new HashSet<String>(0));
        }
        List<String> extensionsUninstall = pkg.getEirList();
        if (extensionsUninstall != null) {
            packageInfo.setExtensionsUninstall(new HashSet<String>(extensionsUninstall));
        } else {
            packageInfo.setExtensionsUninstall(new HashSet<String>(0));
        }
        if (packageResponse instanceof PackageJsonResponse) {
            packageInfo.setPkg((PackageJsonResponse)packageResponse);
        } else {
            packageInfo.setPkg(new PackageJsonResponse(packageResponse));
        }
        packageInfo.setDeduplicationMode(pkg.getDeduplicationMode());
        packageInfo.setJarDiff(pkg.isJarDiffEnabled());
        fileSystem.secureWrite(packageInfoFile, JSonStorage.serializeToJsonByteArray(packageInfo), true);
    }

    public boolean matches(DownloadPackageInfo info, Revision currentRevision, Pkg pkg, File file) {
        PackageResponseInterface packageResponse = pkg.getInterface(PackageResponseInterface.class);
        if (info.getPath() != null && !StringUtils.equals(info.getPath(), file.getAbsolutePath())) {
            this.getLogger().info("don't resume:path missmatch!(" + info.getPath() + "|" + file.getAbsolutePath() + ")");
            return false;
        }
        if (info.getSrc() != currentRevision.getId()) {
            this.getLogger().info("don't resume:src revision missmatch!(" + info.getSrc() + "|" + currentRevision.getId() + ")");
            return false;
        }
        if (info.getDest() != packageResponse.getDestRevision()) {
            this.getLogger().info("don't resume:dst revision missmatch!(" + info.getDest() + "|" + packageResponse.getDestRevision() + ")");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase(info.getHash(), packageResponse.getHash())) {
            this.getLogger().info("don't resume:hash missmatch!(" + info.getHash() + "|" + packageResponse.getHash() + ")");
            return false;
        }
        if (info.getSize() >= 0L && info.getSize() != packageResponse.getSize()) {
            this.getLogger().info("don't resume:size missmatch!(" + info.getSize() + "|" + packageResponse.getSize() + ")");
            return false;
        }
        return true;
    }

    protected boolean deletePackage(File file) throws ExtIOException {
        FileAccessHandler fileSystem = this.getFileSystem();
        boolean deleted = false;
        try {
            this.getLogger().info("runPackageInstallation " + file + " errorFree, delete!");
            deleted = fileSystem.deleteFileIfExists(file);
        }
        catch (Throwable e) {
            LogAndIgnoreException.logTo(e, this.getLogger());
        }
        try {
            File packageInfoFile = this.getDownloadPackageInfoFile(file);
            fileSystem.deleteFileIfExists(packageInfoFile);
        }
        catch (Throwable e) {
            LogAndIgnoreException.logTo(e, this.getLogger());
        }
        try {
            File packageMarkFile = this.getPackageInstallationHistoryFile(file);
            fileSystem.deleteFileIfExists(packageMarkFile);
        }
        catch (Throwable e) {
            LogAndIgnoreException.logTo(e, this.getLogger());
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected File download(final File localFile, DownloadMirror mirrorToUseFirst) throws TransportException, InterruptedException, IOException, URISyntaxException, InstallException, ProxySelectorException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (localFile == null) {
            throw new IllegalArgumentException("localFile is null");
        }
        this.downloadProgress = new DownloadProgress();
        Pkg pkg = this.getUpdate();
        final PackageResponseInterface response = pkg.getInterface(PackageResponseInterface.class);
        this.getLogger().info("Download UpdatePackage ");
        TransportException latestTransportException = null;
        final FileAccessHandler fileSystem = this.getFileSystem();
        try {
            block83: {
                long fileSize;
                this.downloadProgress.setFile(localFile);
                this.getLogger().info("Local File: " + localFile + " (FileSize: " + localFile.length() + "|PackageSize:" + response.getSize() + ")");
                fileSystem.mkdirs(localFile.getParentFile());
                DownloadPackageInfo downloadPackageInfo = this.readDownloadPackageInfo(localFile);
                if (downloadPackageInfo != null && !this.matches(downloadPackageInfo, this.getCurrentRevision(), pkg, localFile)) {
                    fileSize = localFile.length();
                    if (this.deletePackage(localFile)) {
                        this.getLogger().info("Delete local File|Reason: outdated:" + JSonStorage.toString(downloadPackageInfo));
                        try {
                            PackageJsonResponse outdated = downloadPackageInfo.getPkg();
                            if (outdated != null && fileSize > 0L) {
                                this.trackDiscardedPackage(outdated, fileSize, DiscardReason.OUTDATED);
                            }
                        }
                        catch (Throwable writeThrowable) {
                            this.trackException(writeThrowable);
                        }
                    }
                }
                this.writeDownloadPackageInfo(this.getCurrentRevision(), pkg, localFile);
                if (response.getSize() < localFile.length()) {
                    fileSize = localFile.length();
                    if (this.deletePackage(localFile)) {
                        this.getLogger().info("Delete local File|Reason: package is smaller than file  (FileSize: " + fileSize + "|PackageSize:" + response.getSize() + ")");
                        try {
                            this.trackDiscardedPackage(response, fileSize, DiscardReason.MISSMATCH);
                        }
                        catch (Throwable writeThrowable) {
                            this.trackException(writeThrowable);
                        }
                    }
                } else if (localFile.length() > response.getSize()) {
                    fileSize = localFile.length();
                    if (this.deletePackage(localFile)) {
                        this.getLogger().info("Delete local File|Reason: file is bigger than package (FileSize: " + fileSize + "|PackageSize:" + response.getSize() + ")");
                        try {
                            this.trackDiscardedPackage(response, fileSize, DiscardReason.MISSMATCH);
                        }
                        catch (Throwable writeThrowable) {
                            this.trackException(writeThrowable);
                        }
                    }
                } else if (localFile.length() == response.getSize()) {
                    this.getLogger().info("local file seems to be finished (size check ok)");
                    this.downloadProgress.setHashing(true);
                    this.getModuleProgress().setIndeterminated(true);
                    try {
                        String sha256;
                        fileSystem.mkdirs(localFile.getParentFile());
                        long start = Time.systemIndependentCurrentJVMTimeMillis();
                        this.getLogger().info("Start hashing...");
                        FileInputStream fis = fileSystem.openFileInputStream(localFile);
                        try {
                            sha256 = Hash.getHash(fis, "SHA-256", -1L, true);
                        }
                        finally {
                            fis.close();
                        }
                        this.downloadProgress.addHashedBytes(localFile.length(), Time.systemIndependentCurrentJVMTimeMillis() - start);
                        if (!StringUtils.equalsIgnoreCase(response.getHash(), sha256)) {
                            this.getLogger().info("... but hashcheck failed. delete file");
                            if (this.deletePackage(localFile)) {
                                try {
                                    this.trackDiscardedPackage(response, response.getSize(), DiscardReason.HASH);
                                }
                                catch (Throwable writeThrowable) {
                                    this.trackException(writeThrowable);
                                }
                            }
                            break block83;
                        }
                        this.addPackageInstallationHistory(localFile, PackageInstallationHistory.PACKAGE_FINISH);
                        this.getLogger().info("... and hash is ok as well. perfect!");
                        this.moduleProgress.fillStep();
                        File writeThrowable = localFile;
                        return writeThrowable;
                    }
                    finally {
                        this.downloadProgress.setHashing(false);
                        this.getModuleProgress().setIndeterminated(false);
                    }
                }
            }
            this.downloadProgress.setDownloadStart(Time.systemIndependentCurrentJVMTimeMillis());
            try {
                long downloadRound = 0L;
                long lastFileSizeOnDisk = localFile.length();
                this.downloadProgress.setSizeBefore(lastFileSizeOnDisk);
                DownloadResultMap map = new DownloadResultMap();
                while (this.continueDownload(localFile, lastFileSizeOnDisk, map, response, downloadRound++)) {
                    lastFileSizeOnDisk = localFile.length();
                    List<DownloadMirror> downloadMirrors = this.getDownloadMirrors(response.getUrls(), mirrorToUseFirst);
                    if (downloadMirrors.size() == 0) {
                        throw new TransportException("No mirrors available");
                    }
                    for (int mirrorIndex = 0; mirrorIndex < downloadMirrors.size(); ++mirrorIndex) {
                        DownloadMirror downloadMirror;
                        TransportException mirrorTransportException = null;
                        this.lastUsedDownloadMirror = downloadMirror = downloadMirrors.get(mirrorIndex);
                        this.checkInterruption();
                        this.getLogger().info("Download Round:" + downloadRound + "|Try:" + mirrorIndex + "/" + (downloadMirrors.size() - 1) + "|Mirror:" + downloadMirror.getUrl() + "|Priority:" + downloadMirror.getPriority());
                        if (localFile.length() > 0L) {
                            this.getLogger().info("Try to resume download at " + localFile.length() + "/" + response.getSize());
                        } else {
                            this.getLogger().info("Size is 0. Full Download.");
                        }
                        long needed = response.getSize() - localFile.length();
                        this.checkFreeDiskSpace(localFile.getParentFile(), needed);
                        String sha256 = null;
                        final String mirrorURL = downloadMirror.getUrl();
                        final long expectedBytes = response.getSize();
                        final AtomicReference trafficLog = new AtomicReference();
                        final long challengeSeed = UniqueAlltimeID.next();
                        try {
                            TrafficLog.STATUS status;
                            TrafficLog entry;
                            try {
                                final AtomicLong downloadStartNanoTime = new AtomicLong(Time.getNanoSeconds());
                                this.downloadProgress.setEta(-1L);
                                this.downloadProgress.setDownloadSpeedBps(-1L);
                                try {
                                    sha256 = this.getHttpClientInterface().download(this, new URL(mirrorURL), localFile, new ProgressCallback(){
                                        private long total;
                                        private long firstTimeInNS;
                                        private long lastTimeInNS;
                                        private long loaded;
                                        private final AverageSpeedMeter speedMeterInNS;
                                        private final AtomicReference<Throwable> throwable;
                                        private String appworkcdnSignatureChallenge;
                                        private final String cdnSignatureSecret = ".Nanachi.";
                                        private long lastTrafficLogWrite;
                                        private long lastTrafficLogTime;
                                        private final long trafficLogDelta = 0x500000L;
                                        private final long trafficLogTimeout = 30000L;
                                        {
                                            this.total = response.getSize();
                                            this.firstTimeInNS = -1L;
                                            this.lastTimeInNS = -1L;
                                            this.loaded = 0L;
                                            this.speedMeterInNS = new AverageSpeedMeter(20000, SpeedMeterInterface.Resolution.NANO_SECONDS);
                                            this.throwable = new AtomicReference();
                                            this.appworkcdnSignatureChallenge = null;
                                            this.cdnSignatureSecret = ".Nanachi.";
                                            this.lastTrafficLogWrite = -1L;
                                            this.lastTrafficLogTime = 0L;
                                            this.trafficLogDelta = 0x500000L;
                                            this.trafficLogTimeout = 30000L;
                                        }

                                        private TrafficLog.STATUS getStatus(TrafficLog entry, TrafficLog.STATUS defaultStatus) {
                                            if (entry != null && entry.getStatus() != null) {
                                                try {
                                                    return TrafficLog.STATUS.valueOf(entry.getStatus());
                                                }
                                                catch (Throwable e) {
                                                    UpdateClient.this.trackException(e);
                                                }
                                            }
                                            return defaultStatus;
                                        }

                                        private TrafficLog newTrafficLog() {
                                            TrafficLog existingEntry = (TrafficLog)trafficLog.get();
                                            Throwable throwable = this.throwable.getAndSet(null);
                                            if (existingEntry != null) {
                                                existingEntry.setDuration((Time.getNanoSeconds() - downloadStartNanoTime.get()) / 1000000L);
                                                existingEntry.setFinalized(true);
                                                UpdateClient.this.trackDownloadTraffic(existingEntry, this.getStatus(existingEntry, TrafficLog.STATUS.UNKNOWN), throwable);
                                            }
                                            TrafficLog newEntry = new TrafficLog(mirrorURL, response.getDownloadID());
                                            newEntry.setBytesTotal(expectedBytes);
                                            trafficLog.set(newEntry);
                                            return newEntry;
                                        }

                                        @Override
                                        public void onConnect(HTTPConnection connection) throws IOException {
                                            this.lastTrafficLogWrite = -1L;
                                            this.lastTrafficLogTime = 0L;
                                            downloadStartNanoTime.set(Time.getNanoSeconds());
                                            this.appworkcdnSignatureChallenge = Hash.getMD5(challengeSeed + Hash.getMD5("" + UniqueAlltimeID.next()));
                                            connection.setRequestProperty("X-CDN-SIGNATURE-CHALLENGE", this.appworkcdnSignatureChallenge);
                                            connection.setRequestProperty("Accept-Encoding", "identity");
                                            try {
                                                TrafficLog log = this.newTrafficLog();
                                                log.setConnectDate(UpdateClient.this.getServerTime().now());
                                                UpdateClient.this.trackDownloadTraffic(log, TrafficLog.STATUS.CONNECTING, null);
                                            }
                                            catch (Throwable writeThrowable) {
                                                UpdateClient.this.trackException(writeThrowable);
                                            }
                                        }

                                        @Override
                                        public void onDisconnected(HTTPConnection connection) {
                                        }

                                        @Override
                                        public void onConnected(HTTPConnection connection) throws IOException {
                                            UpdateClient.this.addPackageInstallationHistory(localFile, PackageInstallationHistory.PACKAGE_DOWNLOAD);
                                            TrafficLog entry = (TrafficLog)trafficLog.get();
                                            if (entry != null) {
                                                List<String> cdnSignatures = connection.getHeaderFields("X-CDN-SIGNATURE");
                                                if (cdnSignatures == null) {
                                                    entry.setCdnSignature(TrafficLog.CDNSIGNATURE.MISSING.name());
                                                } else {
                                                    entry.setCdnSignature(TrafficLog.CDNSIGNATURE.INVALID.name());
                                                    for (String cdnSignature : cdnSignatures) {
                                                        if (StringUtils.equals(cdnSignature, this.appworkcdnSignatureChallenge + this.cdnSignatureSecret + this.appworkcdnSignatureChallenge)) {
                                                            entry.setCdnSignature(TrafficLog.CDNSIGNATURE.VALID.name());
                                                            break;
                                                        }
                                                        if (StringUtils.equals(cdnSignature, this.cdnSignatureSecret)) {
                                                            entry.setCdnSignature(TrafficLog.CDNSIGNATURE.FILTERED.name());
                                                            continue;
                                                        }
                                                        if (!StringUtils.contains(cdnSignature, this.cdnSignatureSecret)) continue;
                                                        entry.setCdnSignature(TrafficLog.CDNSIGNATURE.OUTDATED.name());
                                                    }
                                                    UpdateClient.this.getLogger().info("CDNSignature:" + entry.getCdnSignature() + " (" + connection.getURL() + ")");
                                                }
                                                entry.setHost(connection.getURL().getHost());
                                                entry.setResponseCode(connection.getResponseCode());
                                                entry.setContentType(connection.getContentType());
                                                entry.setServerTag(connection.getHeaderField("Server"));
                                                entry.setDuration((Time.getNanoSeconds() - downloadStartNanoTime.get()) / 1000000L);
                                                entry.setResponseBytes(connection.getCompleteContentLength());
                                                entry.setConnectedDate(UpdateClient.this.getServerTime().now());
                                                UpdateClient.this.trackDownloadTraffic(entry, TrafficLog.STATUS.CONNECTED, null);
                                            }
                                            if (UpdateClient.this.isValidatePackageDownloadConnection()) {
                                                UpdateClient.this.validatePackageDownloadConnection(mirrorURL, connection, response);
                                            }
                                        }

                                        @Override
                                        public void onException(HTTPConnection connection, Throwable throwable) {
                                            if (throwable instanceof InterruptedException) {
                                                UpdateClient.this.addPackageInstallationHistory(localFile, PackageInstallationHistory.PACKAGE_INTERRUPTED);
                                            } else {
                                                UpdateClient.this.addPackageInstallationHistory(localFile, PackageInstallationHistory.PACKAGE_EXCEPTION);
                                            }
                                            this.throwable.set(throwable);
                                        }

                                        @Override
                                        public synchronized void setLoadedBytes(long loaded) {
                                            TrafficLog entry = (TrafficLog)trafficLog.get();
                                            if (entry != null) {
                                                entry.setResume(loaded > 0L);
                                                entry.setResumeFrom(loaded);
                                                UpdateClient.this.trackDownloadTraffic(entry, TrafficLog.STATUS.CONNECTED, null);
                                            }
                                            long nanoTime = Time.getNanoSeconds();
                                            this.loaded = loaded;
                                            this.firstTimeInNS = nanoTime;
                                            this.lastTimeInNS = nanoTime;
                                            this.updateProgress();
                                        }

                                        protected void updateProgress() {
                                            long bytesPerSecond = this.speedMeterInNS.getValue(SpeedMeterInterface.Resolution.SECONDS);
                                            if (bytesPerSecond > 0L) {
                                                UpdateClient.this.downloadProgress.setDownloadSpeedBps(bytesPerSecond);
                                                UpdateClient.this.downloadProgress.setEta((this.total - this.loaded) / bytesPerSecond);
                                            } else {
                                                UpdateClient.this.downloadProgress.setDownloadSpeedBps(-1L);
                                                UpdateClient.this.downloadProgress.setEta(-1L);
                                            }
                                        }

                                        @Override
                                        public synchronized void updateLoadedBytes(long loaded) {
                                            long nanoTime = Time.getNanoSeconds();
                                            TrafficLog entry = (TrafficLog)trafficLog.get();
                                            if (entry != null) {
                                                entry.setBytesLoaded(loaded);
                                                if (this.lastTrafficLogWrite == -1L || loaded - this.lastTrafficLogWrite > this.trafficLogDelta || (nanoTime - this.lastTrafficLogTime) / 1000000L > this.trafficLogTimeout) {
                                                    entry.setDuration((nanoTime - downloadStartNanoTime.get()) / 1000000L);
                                                    UpdateClient.this.trackDownloadTraffic(entry, TrafficLog.STATUS.DOWNLOADING, null);
                                                    this.lastTrafficLogWrite = loaded;
                                                    this.lastTrafficLogTime = nanoTime;
                                                }
                                            }
                                            if (this.firstTimeInNS < 0L) {
                                                this.loaded = loaded;
                                                this.firstTimeInNS = nanoTime;
                                                this.lastTimeInNS = nanoTime;
                                            } else {
                                                long durationInNS = nanoTime - this.lastTimeInNS;
                                                this.lastTimeInNS = nanoTime;
                                                this.speedMeterInNS.putBytes(loaded - this.loaded, durationInNS);
                                                this.loaded = loaded;
                                                UpdateClient.this.moduleProgress.setStepValue(loaded, this.total);
                                            }
                                            this.updateProgress();
                                        }

                                        @Override
                                        public synchronized void updateTotalBytes(long total) {
                                            this.total = total;
                                            this.updateProgress();
                                        }
                                    }, new DownloadHooksInterface(){

                                        @Override
                                        public void onBeforePreHashing(File file) {
                                            UpdateClient.this.downloadProgress.setHashing(true);
                                            UpdateClient.this.getModuleProgress().setIndeterminated(true);
                                        }

                                        @Override
                                        public FileInputStream openInputStream(File file) throws IOException, InterruptedException {
                                            return fileSystem.openFileInputStream(file);
                                        }

                                        @Override
                                        public FileOutputStream openOutputStream(File file, boolean b) throws IOException, InterruptedException {
                                            return fileSystem.openFileOutputStream(file, b);
                                        }

                                        @Override
                                        public boolean deleteFileIfExists(File file) throws IOException {
                                            return UpdateClient.this.deletePackage(file);
                                        }

                                        @Override
                                        public void onAfterPreHashing(long ms, File file, Throwable throwable) {
                                            if (throwable == null) {
                                                UpdateClient.this.downloadProgress.addHashedBytes(file.length(), ms);
                                            }
                                            UpdateClient.this.downloadProgress.setHashing(false);
                                            UpdateClient.this.getModuleProgress().setIndeterminated(false);
                                        }
                                    });
                                    mirrorTransportException = null;
                                }
                                finally {
                                    entry = (TrafficLog)trafficLog.get();
                                    if (entry != null) {
                                        entry.setDuration((Time.getNanoSeconds() - downloadStartNanoTime.get()) / 1000000L);
                                    }
                                }
                            }
                            catch (TransportException e) {
                                mirrorTransportException = e;
                                latestTransportException = e;
                            }
                            catch (InterruptedException e) {
                                try {
                                    entry = trafficLog.getAndSet(null);
                                    if (entry != null) {
                                        entry.setFinalized(true);
                                        this.trackDownloadTraffic(entry, TrafficLog.STATUS.INTERRUPTED, e);
                                    }
                                }
                                catch (Throwable writeThrowable) {
                                    this.trackException(writeThrowable);
                                }
                                throw e;
                            }
                            if (localFile.length() < response.getSize()) {
                                status = TrafficLog.STATUS.INCOMPLETE;
                                entry = trafficLog.getAndSet(null);
                                if (entry != null) {
                                    try {
                                        entry.setFinalized(true);
                                        this.trackDownloadTraffic(entry, status, mirrorTransportException);
                                    }
                                    catch (Throwable writeThrowable) {
                                        this.trackException(writeThrowable);
                                    }
                                }
                                map.put(status);
                                this.getLogger().info("Keep local File (FileSize: " + localFile.length() + "|PackageSize:" + response.getSize() + ")");
                                continue;
                            }
                            if (response.getSize() < localFile.length()) {
                                status = TrafficLog.STATUS.MISSMATCH;
                                entry = trafficLog.getAndSet(null);
                                if (entry != null) {
                                    try {
                                        entry.setFinalized(true);
                                        this.trackDownloadTraffic(entry, status, mirrorTransportException);
                                    }
                                    catch (Throwable writeThrowable) {
                                        this.trackException(writeThrowable);
                                    }
                                }
                                map.put(status);
                                this.getLogger().info("Delete local File|Reason: package is smaller than file  (FileSize: " + localFile.length() + "|PackageSize:" + response.getSize() + ")");
                                this.deletePackage(localFile);
                                continue;
                            }
                            this.getLogger().info("local file seems to be finished (size check ok)");
                            if (!StringUtils.equalsIgnoreCase(response.getHash(), sha256)) {
                                status = TrafficLog.STATUS.HASH;
                                entry = trafficLog.getAndSet(null);
                                if (entry != null) {
                                    entry.setFinalized(true);
                                    try {
                                        this.trackDownloadTraffic(entry, status, mirrorTransportException);
                                    }
                                    catch (Throwable writeThrowable) {
                                        this.trackException(writeThrowable);
                                    }
                                }
                                map.put(status);
                                this.getLogger().info("... but hashcheck failed. delete file");
                                this.deletePackage(localFile);
                                continue;
                            }
                            this.addPackageInstallationHistory(localFile, PackageInstallationHistory.PACKAGE_FINISH);
                            TrafficLog entry2 = trafficLog.getAndSet(null);
                            if (entry2 != null) {
                                try {
                                    entry2.setFinalized(true);
                                    this.trackDownloadTraffic(entry2, TrafficLog.STATUS.OK, mirrorTransportException);
                                }
                                catch (Throwable writeThrowable) {
                                    this.trackException(writeThrowable);
                                }
                            }
                            this.getLogger().info("... and hash is ok as well. perfect!");
                            this.moduleProgress.fillStep();
                            File file = localFile;
                            return file;
                        }
                        finally {
                            TrafficLog entry = trafficLog.getAndSet(null);
                            if (entry != null) {
                                try {
                                    entry.setFinalized(true);
                                    this.trackDownloadTraffic(entry, TrafficLog.STATUS.UNKNOWN, null);
                                }
                                catch (Throwable writeThrowable) {
                                    this.trackException(writeThrowable);
                                }
                            }
                        }
                    }
                }
                if (latestTransportException == null) {
                    throw new TransportException("All mirrors failed");
                }
                throw new TransportException("All mirrors failed!Latest TransportException", latestTransportException);
            }
            finally {
                this.downloadProgress.setDownloadEnd(Time.systemIndependentCurrentJVMTimeMillis());
                this.downloadProgress.setSizeAfter(localFile.length());
            }
        }
        catch (InterruptedException e) {
            this.getLogger().info("Download interrupted; keep local file " + localFile + " (FileSize: " + localFile.length() + "|PackageSize:" + response.getSize() + ")");
            throw e;
        }
    }

    protected void trackDiscardedPackage(PackageResponseInterface pkg, long fileSize, DiscardReason reason) {
    }

    protected void validatePackageDownloadConnection(String mirrorURL, HTTPConnection connection, PackageResponseInterface response) throws IOException {
        long[] requestRange = HTTPConnectionUtils.parseRequestRange(connection);
        switch (connection.getResponseCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                break;
            }
            case 200: {
                if (requestRange[0] > 0L) {
                    if (StringUtils.contains(connection.getContentType(), "html")) {
                        throw new InvalidResponseException(connection);
                    }
                    throw new BadRangeResponse(connection);
                }
                long completeContentLength = connection.getCompleteContentLength();
                if (completeContentLength < 0L || completeContentLength == response.getSize()) break;
                if (StringUtils.contains(connection.getContentType(), "html")) {
                    throw new InvalidResponseException(connection);
                }
                throw new BadResponseLengthException(connection, response.getSize());
            }
            case 206: {
                long[] responseRange = connection.getRange();
                if (responseRange != null) {
                    if (responseRange[2] >= 0L && responseRange[2] != response.getSize()) {
                        if (StringUtils.contains(connection.getContentType(), "html")) {
                            throw new InvalidResponseException(connection);
                        }
                        throw new BadResponseLengthException(connection, response.getSize());
                    }
                    if (requestRange[0] == -1L && responseRange[0] != 0L) {
                        throw new BadRangeResponse(connection);
                    }
                    if (requestRange[0] < 0L || requestRange[0] == responseRange[0]) break;
                    throw new BadRangeResponse(connection);
                }
                throw new BadRangeResponse(connection);
            }
            case 416: {
                throw new BadRangeResponse(connection);
            }
            default: {
                throw new InvalidResponseCode(connection);
            }
        }
    }

    public DownloadProgress getDownloadProgress() {
        return this.downloadProgress;
    }

    private String downloadChangelog(String changeLogHash, long changeLogSize, DownloadUrlList changeLogUrls) throws TransportException {
        Exception firstException = null;
        List<DownloadMirror> mirrors = changeLogUrls != null ? this.getDownloadMirrors(changeLogUrls, null) : null;
        for (DownloadMirror mirror : mirrors) {
            try {
                String hash;
                byte[] bytes = this.getHttpClientInterface().get(this, new URL(mirror.getUrl()));
                if (bytes == null) {
                    throw new TransportException("No Bytes loaded");
                }
                if (changeLogHash != null && changeLogHash.matches("^[a-fA-F0-9]{64}$") && !StringUtils.equalsIgnoreCase(hash = Hash.getBytesHash(bytes, "SHA-256"), changeLogHash)) {
                    throw new TransportException("Hash Mismatch: " + changeLogHash + "!=" + hash);
                }
                return new String(bytes, UTF8);
            }
            catch (Exception e) {
                this.getLogger().log(e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            if (firstException instanceof TransportException) {
                throw (TransportException)firstException;
            }
            throw new TransportException(firstException);
        }
        return null;
    }

    public String[] downloadOptionalsList(HttpClientInterface http) throws TransportException, InterruptedException, ExtIOException, ServerLockedException, InstallException {
        Ids ids = (Ids)this.get(this.createIDsRequest(), http);
        return ids.list();
    }

    protected Ids createIDsRequest() throws ExtIOException {
        return new Ids(this);
    }

    public void forceDestRevision(int parseInt) {
        this.forcedDestRevision = parseInt;
    }

    /*
     * Exception decompiling
     */
    public <T extends DataExchange<E>, E> E get(T comWrapper, HttpClientInterface httpClient) throws TransportException, InterruptedException, ServerLockedException, InstallException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 4[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ensureTimeSync() throws InterruptedException, TransportException {
        long nanos = Time.getNanoSeconds();
        long timestamp = Time.timestamp();
        long total = 0L;
        AtomicBoolean atomicBoolean = this.sessionInitInProgress;
        synchronized (atomicBoolean) {
            boolean doSync;
            if (this.getServerTime().isUnsupportedServer()) {
                return false;
            }
            boolean bl = doSync = !this.getServerTime().isSynced();
            if (doSync |= this.getServerTime().isResyncRequested()) {
                for (int i = 0; i < 5; ++i) {
                    JobRequest job = new JobRequest(BatchJobType.TIME_SYNC.name());
                    UpdateClientBatchRequest br = this.createBatchRequest(job.withID());
                    final AtomicLong nanosAtBeforeConnect = new AtomicLong();
                    final AtomicLong payloadFullyReadNanos = new AtomicLong();
                    final HTTPConnectionProfiler profiler = new HTTPConnectionProfiler();
                    final AtomicReference connectionRef = new AtomicReference();
                    br._setConnectionHook(new UpdateClientBatchRequest.ConnectionHook(){

                        @Override
                        public void onBeforePost(HttpClientInterface httpClient) {
                        }

                        @Override
                        public void onConnected(HttpClientInterface httpClient, HTTPProxy proxy, HTTPConnection connection) {
                        }

                        @Override
                        public void onResponseBytes(HttpClientInterface httpClient, byte[] responseBytes) {
                            payloadFullyReadNanos.set(Time.getNanoSeconds());
                        }

                        @Override
                        public void onBeforeConnect(HttpClientInterface fHttpClient, HTTPProxy proxy, HTTPConnection connection) {
                            connectionRef.set(connection);
                            nanosAtBeforeConnect.set(Time.getNanoSeconds());
                            if (connection instanceof HTTPConnectionImpl) {
                                ((HTTPConnectionImpl)connection).setProfiler(profiler);
                            }
                        }
                    });
                    try {
                        this.batchRequest(br);
                        HTTPConnection connection = (HTTPConnection)connectionRef.get();
                        TimeSyncResponse syncData = job._getResponse().restoreParameter(TimeSyncResponse.TYPE);
                        if (syncData == null) {
                            String dateString;
                            this.getServerTime().setUnsupportedServer(true);
                            if (connection != null && connection.getHeaderField("JCGI") != null && (dateString = connection.getHeaderField("Date")) != null) {
                                SimpleDateFormat simpleDateFormat = HTTPConstants.DATE_FORMAT_HTTP_DATE_RFC1123;
                                synchronized (simpleDateFormat) {
                                    try {
                                        Date date = HTTPConstants.DATE_FORMAT_HTTP_DATE_RFC1123.parse(dateString);
                                        this.getServerTime().validateSync(date.getTime(), TimeUnit.NANOSECONDS.toMillis(Time.getNanoSeconds() - profiler.getStart()));
                                    }
                                    catch (ParseException e) {
                                        this.getLogger().log(e);
                                    }
                                    catch (RuntimeException e) {
                                        this.trackException(e);
                                    }
                                }
                            }
                            return false;
                        }
                        boolean allRequiredProfilerDataAvailable = true;
                        allRequiredProfilerDataAvailable &= profiler.getFirstHeaderByteReadNanos() != null;
                        if (!(allRequiredProfilerDataAvailable &= profiler.getRequestSentInclPostNanos() != null)) continue;
                        long clientTimestampAtSendPost = timestamp + TimeUnit.NANOSECONDS.toMillis(profiler.getRequestSentInclPostNanos() - nanos);
                        long clientTimestampAtDataReceice = timestamp + TimeUnit.NANOSECONDS.toMillis(profiler.getFirstHeaderByteReadNanos() - nanos);
                        long serverDataSentTime = syncData.getConnectTime() + TimeUnit.NANOSECONDS.toMillis(syncData.getSendOffset());
                        long serverReadRequestTimestamp = syncData.getConnectTime() + TimeUnit.NANOSECONDS.toMillis(syncData.getPayloadReadOffset());
                        long offsetPostSent = clientTimestampAtSendPost - serverReadRequestTimestamp;
                        long offsetSend = clientTimestampAtDataReceice - serverDataSentTime;
                        long medianOffset = (offsetSend * 3L + offsetPostSent) / 4L;
                        total += medianOffset;
                        continue;
                    }
                    catch (TransportException e) {
                        HTTPConnection unsupportedServer = this.isUnsupportedServer(br, e);
                        if (unsupportedServer != null) {
                            this.getLogger().info("Time Sync: Unsupported Server:" + unsupportedServer.getURL().getHost());
                            this.getServerTime().setUnsupportedServer(true);
                            return false;
                        }
                        throw e;
                    }
                }
                System.out.println("Offset done " + total / 5L);
                this.getServerTime().setUnsupportedServer(false);
                this.getServerTime().sync(timestamp, nanos, total / 5L);
                return true;
            }
        }
        return false;
    }

    protected HTTPConnection isUnsupportedServer(BatchRequest batchRequest, TransportException e) {
        HTTPConnection connection;
        BasicHTTPException http = Exceptions.getInstanceof(e, BasicHTTPException.class);
        if (http != null && http.getConnection() != null && (connection = http.getConnection()).getHeaderField("JCGI") != null && connection.getResponseCode() == HTTPConstants.ResponseCode.ERROR_BAD_REQUEST.getCode()) {
            return connection;
        }
        return null;
    }

    public ImplBuilder getBuilder() {
        return this.builder;
    }

    public Revision getCurrentRevision() {
        return this.readRevision();
    }

    public Revision getDestRevision() {
        Pkg pkg = this.getUpdate();
        return pkg.getDestRevision();
    }

    @Deprecated
    public long getDownloadETA() {
        return this.downloadProgress.getEta();
    }

    @Deprecated
    public long getDownloadSpeedBps() {
        return this.downloadProgress.getDownloadSpeedBps();
    }

    public ExtensionManagerInterface getExtensionManager() {
        return this.extensionManager;
    }

    public int getForcedDestRevision() {
        return this.forcedDestRevision;
    }

    public HttpClientInterface getHttpClientInterface() {
        return this.httpClient;
    }

    public DownloadMirror getLastUsedDownloadMirror() {
        return this.lastUsedDownloadMirror;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public ModuleProgress getModuleProgress() {
        return this.moduleProgress;
    }

    public double getModuleProgressValue() {
        return this.moduleProgress.getValue() * 100.0;
    }

    protected boolean isLocalPackageSupportEnabled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getPackageFile() {
        final File oldFolder = new File(this.getPathBuilder().getTmpFolder(this), this.getSetup().getApplicationIdentifier());
        final File folder = new File(this.getPathBuilder().getTmpFolder(this), this.getSetup().getNamespace());
        if (oldFolder.isDirectory()) {
            UpdateClient updateClient = this;
            synchronized (updateClient) {
                if (!folder.isDirectory()) {
                    new NonInterruptibleRunnableSimple(){

                        @Override
                        protected void execute() throws InterruptedException {
                            try {
                                UpdateClient.this.getLogger().info("Migrate from '" + oldFolder + "' to '" + folder + "' started");
                                UpdateClient.this.getFileSystem().moveFile(oldFolder, folder, false);
                                UpdateClient.this.getLogger().info("Migrate from '" + oldFolder + "' to '" + folder + "' successful");
                            }
                            catch (ExtIOException e) {
                                UpdateClient.this.getLogger().exception("Migration failed", e);
                            }
                        }
                    }.startAndWait();
                }
            }
        }
        return new File(folder, "updatePackage");
    }

    public PathBuilder getPathBuilder() {
        return this.pathBuilder;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public File getRevisionFile() {
        return this.revisionFile;
    }

    public UpdateClientSetupInterface getSetup() {
        return this.setup;
    }

    public Pkg getUpdate() {
        return this.update;
    }

    public String getUpdateServer() {
        String ret = this.currentUpdateServer.get();
        if (StringUtils.isEmpty(ret) && StringUtils.isEmpty(ret = this.lastValidUpdateServer)) {
            ret = this.getUpdateServers()[0];
        }
        return ret;
    }

    public UrlFactoryInterface getUrlBuilder() {
        return this.urlBuilder;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    private ClientOptions installClientOption(InputStream input, String relPath, String signature) throws FailedActionException, InterruptedException {
        try {
            ByteArrayOutputStream clientOption = new ByteArrayOutputStream();
            this.verifyFileSignature(input, clientOption, relPath, signature);
            return JSonStorage.restoreFromString(new String(clientOption.toByteArray(), UTF8), ClientOptions.TYPE);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw FailedActionException.wrap(this, e);
        }
    }

    protected ArrayList<InstallerAction> dedupFile(AbstractBackupFileWriter backupFileWriter, File dest, DeduplicationSignature deduplicationSignature, String relPath, String signature, AbsoluteFile backupFile) throws FailedActionException, InterruptedException {
        this.getLogger().info("Install:dedupFile|" + dest);
        OutputStream outputStream = null;
        InputStream inputStream = null;
        FileAccessHandler fileSystem = this.getFileSystem();
        try {
            AbsoluteFile src;
            ArrayList<InstallerAction> ret = new ArrayList<InstallerAction>();
            NewFileInstallAction action = new NewFileInstallAction(relPath);
            if (backupFileWriter != null && backupFileWriter.write(action)) {
                ret.add(action);
            }
            if (!(src = this.convertRelPath(deduplicationSignature.getRel())).isFile() && src.getAbsolutePath().equalsIgnoreCase(dest.getAbsolutePath()) && backupFile != null && backupFile.isFile()) {
                this.getLogger().info("Install:dedupFile|Src-file does not exist. CaseSensitive Workaround: Lookup in backupfile " + backupFile);
                src = backupFile;
            }
            if (JVMVersion.isMinimum(17000000L)) {
                try {
                    fileSystem.createHardlink(src, dest);
                    this.getLogger().info("Install:hardLinkFile|" + src + "|" + dest);
                    inputStream = fileSystem.openFileInputStream(dest);
                }
                catch (IOException e) {
                    this.getLogger().log(e);
                    fileSystem.deleteFileIfExists(dest);
                }
            }
            if (inputStream == null) {
                inputStream = fileSystem.openFileInputStream(src);
                outputStream = fileSystem.openFileOutputStream(dest, false);
            }
            this.verifyFileSignature(inputStream, outputStream, relPath, signature);
            ArrayList<InstallerAction> arrayList = ret;
            return arrayList;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FailedActionException(this, (Throwable)new DeduplicationException(deduplicationSignature, dest, e));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void installFileBackupExisting(File local, File backup) throws InterruptedException, ExtIOException {
        this.logger.info("Backup:" + local + "->" + backup);
        this.getFileSystem().moveFile(local, backup, false);
    }

    public void verifyFileSignature(final InputStream inputStream, OutputStream output, String relPath, final String signature) throws SignatureViolationException, InterruptedException {
        final OutputStream outputStream = output == null ? new NullOutputStream() : output;
        new UpdateSignature(null, this.getUpdate().getPackageResponse().getDestRevision(), relPath){

            @Override
            public InputStream getInputstream() throws IOException {
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        int ret = inputStream.read();
                        if (ret == -1) {
                            return -1;
                        }
                        outputStream.write(ret);
                        return ret;
                    }

                    @Override
                    public int read(byte[] abyte0) throws IOException {
                        int ret = inputStream.read(abyte0);
                        if (ret > 0) {
                            outputStream.write(abyte0, 0, ret);
                        }
                        return ret;
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        int ret = inputStream.read(b, off, len);
                        if (ret > 0) {
                            outputStream.write(b, off, ret);
                        }
                        return ret;
                    }
                };
            }

            @Override
            public boolean isFile() {
                return true;
            }

            @Override
            public String readSignatureString() throws IOException {
                return signature;
            }
        }.verify(this.getPublicKey());
    }

    protected void verifyDirectoryUpdateSignature(String relPath, final String signature) throws SignatureViolationException, InterruptedException {
        new UpdateSignature(null, this.getUpdate().getPackageResponse().getDestRevision(), relPath){

            @Override
            public boolean isFile() {
                return false;
            }

            @Override
            public String readSignatureString() throws IOException {
                return signature;
            }
        }.verify(this.getPublicKey());
    }

    protected ArrayList<InstallerAction> writeFile(AbstractBackupFileWriter backupFileWriter, File dest, InputStream inputStream, String relPath, String signature) throws FailedActionException, InterruptedException {
        this.getLogger().info("Install:writeFile|" + dest);
        FileOutputStream fileOutputStream = null;
        FileAccessHandler fileSystem = this.getFileSystem();
        try {
            ArrayList<InstallerAction> ret = new ArrayList<InstallerAction>();
            NewFileInstallAction action = new NewFileInstallAction(relPath);
            if (backupFileWriter != null && backupFileWriter.write(action)) {
                ret.add(action);
            }
            fileSystem.mkdirs(dest.getParentFile());
            fileOutputStream = fileSystem.openFileOutputStream(dest, false);
            this.verifyFileSignature(inputStream, fileOutputStream, relPath, signature);
            ArrayList<InstallerAction> arrayList = ret;
            return arrayList;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw FailedActionException.wrap(this, e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected ArrayList<InstallerAction> installFile(AbstractBackupFileWriter backupFileWriter, InputStream inputStream, String relPath, String fileSignature) throws FailedActionException, InterruptedException {
        boolean isDeduplication = relPath.endsWith(".dedupSignature");
        if (isDeduplication) {
            relPath = relPath.substring(0, relPath.length() - ".dedupSignature".length());
        }
        try {
            AbsoluteFile dest = this.convertRelPath(relPath);
            try {
                ArrayList<InstallerAction> ret = new ArrayList<InstallerAction>();
                AbsoluteFile backupFile = null;
                ReplaceExistingFileInstallAction action = null;
                if (dest.exists()) {
                    AbsoluteFile test;
                    int backupIndex = 1;
                    while ((test = dest.deriveWithPostFix(UPD_REVERT_BACKUP + backupIndex++)).exists()) {
                    }
                    backupFile = test;
                    action = new ReplaceExistingFileInstallAction(backupFile.getRelative(), relPath);
                    if (backupFileWriter != null && backupFileWriter.write(action)) {
                        ret.add(action);
                    }
                    this.installFileBackupExisting(dest, backupFile);
                } else if (!dest.getParentFile().exists()) {
                    this.installFolder(backupFileWriter, new File(relPath).getParent(), null, false);
                }
                if (isDeduplication) {
                    ret.addAll(this.dedupFile(action == null ? backupFileWriter : null, dest, DeduplicationSignature.read(inputStream), relPath, fileSignature, backupFile));
                } else {
                    ret.addAll(this.writeFile(action == null ? backupFileWriter : null, dest, inputStream, relPath, fileSignature));
                }
                this.onFileWritten(dest, backupFile, backupFileWriter);
                return ret;
            }
            catch (FailedActionException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                if (isDeduplication) {
                    throw new FailedActionException(this, (Throwable)new DeduplicationException(null, dest, e));
                }
                throw FailedActionException.wrap(this, e);
            }
        }
        catch (InstallException e) {
            throw FailedActionException.wrap(this, e);
        }
    }

    protected void installFolder(AbstractBackupFileWriter backuplist, String relPath, String signature, boolean validateSignature) throws FailedActionException {
        if (relPath == null) {
            return;
        }
        try {
            AbsoluteFile folder = this.convertRelPath(relPath);
            this.getLogger().info("Install folder:" + folder);
            if (folder.exists()) {
                this.getLogger().info("Folder already exists");
                return;
            }
            NewFileInstallAction ret = new NewFileInstallAction(folder);
            if (validateSignature) {
                this.verifyDirectoryUpdateSignature(relPath, signature);
            }
            ArrayList<NewFileInstallAction> lst = new ArrayList<NewFileInstallAction>();
            lst.add(ret);
            while ((folder = folder.getParentFile()) != null && !folder.exists()) {
                if (folder.getRelative() != null) {
                    lst.add(0, new NewFileInstallAction(folder.getRelative()));
                    continue;
                }
                this.getLogger().info("Unexpected missing path: " + folder + " should exist.");
            }
            for (NewFileInstallAction nfia : lst) {
                backuplist.write(nfia);
                AbsoluteFile fold = this.convertRelPath(nfia.getFile());
                if (fold.exists()) continue;
                this.getFileSystem().mkdirs(fold);
                this.onFolderCreated(fold, relPath);
            }
        }
        catch (Exception e) {
            throw FailedActionException.wrap(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installJar(AbstractBackupFileWriter backupFileWriter, InputStream input, final String relPath, String signature, final String jarSignature) throws FailedActionException, InterruptedException {
        try {
            AbsoluteFile test;
            AbsoluteFile local = this.convertRelPath(relPath);
            this.jarCopy(backupFileWriter, local, relPath);
            FileAccessHandler fileSystem = this.getFileSystem();
            int i = 1;
            while ((test = this.convertRelPath(relPath + UPD_REVERT_BACKUP + i++)).exists()) {
            }
            AbsoluteFile backup = test;
            if (local.exists()) {
                if (backupFileWriter != null) {
                    backupFileWriter.write(new MergeJarFilesAction(backup.getRelative(), relPath));
                }
            } else {
                throw new JarMergeException("Cannot merge. " + local + " does not exist");
            }
            this.installJarBackupExisting(local, backup);
            FileOutputStream out = null;
            AbsoluteFile localdiff = this.convertRelPath(relPath + ".updJarDiff");
            try {
                int len;
                if (!local.getParentFile().exists()) {
                    this.installFolder(backupFileWriter, local.getParentFile().getRelative(), null, false);
                }
                fileSystem.mkdirs(((File)localdiff).getParentFile());
                out = fileSystem.openFileOutputStream(localdiff, false);
                while ((len = input.read(this.buffer)) != -1) {
                    if (len <= 0) continue;
                    out.write(this.buffer, 0, len);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (Throwable len) {}
            }
            JarDeltaMerge jarDeltaMerge = new JarDeltaMerge(localdiff, backup, local, new UpdateNotifyInterface(){

                @Override
                public void onUpdatedJarDiff(String filename) {
                    UpdateClient.this.installJarDif(relPath, filename);
                }
            });
            jarDeltaMerge.setLogUpdates(this.isJarUpdateEntryLoggingEnabled(local, relPath));
            jarDeltaMerge.mergeJarDelta(this);
            this.getLogger().info("Merging Done..verify signature");
            new JarSignature(local, this.getUpdate().getPackageResponse().getDestRevision(), relPath){

                @Override
                public String readSignatureString() throws IOException {
                    return jarSignature;
                }
            }.verify(this.getPublicKey());
            this.getLogger().info("Sig ok");
            this.onFileWritten(local, backup, backupFileWriter);
        }
        catch (FailedActionException e) {
            throw e;
        }
        catch (JarMergeException e) {
            throw new FailedActionException(this, (Throwable)e);
        }
        catch (Exception e) {
            throw new FailedActionException(this, (Throwable)new JarMergeException(relPath, e));
        }
    }

    protected void installJarBackupExisting(File local, File backup) throws InterruptedException, ExtIOException {
        this.getLogger().info("Replace " + local);
        this.getFileSystem().moveFile(local, backup, false);
    }

    protected void installJarDif(String relPath, String filename) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AWFCInputStream openAWFCInputStream(File file, PackageResponseInterface pkg, boolean rawUncryptedAWFC) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InterruptedException {
        FileInputStream fis = this.getFileSystem().openFileInputStream(file);
        boolean closeFileInputStream = true;
        try {
            InputStream is;
            if (rawUncryptedAWFC) {
                is = fis;
            } else {
                if (pkg.isEncrypted()) {
                    try {
                        byte[] decryptionKey = this.createKey();
                        IvParameterSpec ivSpec = new IvParameterSpec(Arrays.copyOfRange(decryptionKey, 0, 16));
                        SecretKeySpec skeySpec = new SecretKeySpec(Arrays.copyOfRange(decryptionKey, 16, 32), "AES");
                        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                        cipher.init(2, (Key)skeySpec, ivSpec);
                        is = new XZInputStream(new CipherInputStream(fis, cipher));
                    }
                    catch (XZFormatException e) {
                        throw new IOException("Wrong pubkey?", e);
                    }
                }
                try {
                    is = new XZInputStream(fis);
                }
                catch (XZFormatException e) {
                    throw new IOException("XZ Error in plain(no encryption) AWF", e);
                }
            }
            AWFCInputStream ret = new AWFCInputStream(new BufferedInputStream(is, 0x100000));
            ret.readAWFCHeader();
            closeFileInputStream = false;
            AWFCInputStream aWFCInputStream = ret;
            return aWFCInputStream;
        }
        finally {
            if (closeFileInputStream) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installPackage(File file, boolean rawUncryptedAWFC, AbstractBackupFileWriter backuplist) throws InstallException, InterruptedException {
        ModuleProgress mp = new ModuleProgress(this.moduleProgress);
        mp.setStepVolume(0.1);
        mp.setStepID((Object)Module.PREPARE_INSTALL);
        PackageResponseInterface pkg = this.getUpdate().getInterface(PackageResponseInterface.class);
        this.runDiskspaceCheck(pkg.getDiskSpaceChanges());
        AWFCInputStream is = null;
        boolean deleteFile = false;
        FileAccessHandler fileSystem = this.getFileSystem();
        try {
            try {
                this.retryFailedCleanups();
                fileSystem.mkdirs(this.getWorkingDirectory());
                if (this.isFileListSupportEnabled()) {
                    this.filelist = new FileList(this, this.getPathBuilder().getFilelist(this), this.getLogger());
                }
                this.getServerOptionsManager().init();
                this.buffer = new byte[65536];
                is = this.openAWFCInputStream(file, pkg, rawUncryptedAWFC);
                this.addPackageInstallationHistory(file, PackageInstallationHistory.INSTALLATION_START);
                mp.setStepVolume(1.0);
                this.moduleProgress.setStepID((Object)Module.INSTALLING);
                mp.setStepID((Object)Module.INSTALLING);
                AWFCEntry currentEntry = null;
                String signature = null;
                String jarSignature = null;
                this.clientOptionsTasks = new HashMap<String, ClientOptionsTask>();
                long bytesExtracted = 0L;
                while ((currentEntry = is.getNextEntry()) != null) {
                    try {
                        if (currentEntry.getSize() > 0L) {
                            bytesExtracted += currentEntry.getSize();
                        }
                        this.checkInterruption();
                        String relPath = currentEntry.getPath().replace("\\", "/");
                        while (relPath.endsWith("/")) {
                            relPath = relPath.substring(0, relPath.length() - 1);
                        }
                        this.getLogger().info("Entry:" + relPath + "|Size:" + currentEntry.getSize());
                        if (!this.isAllowedToTouch(relPath)) {
                            this.getLogger().info("Skipped due to AllowedToTouch-Rule:" + relPath);
                            continue;
                        }
                        try {
                            this.onPreInstallEntry(relPath, currentEntry);
                            try {
                                if (relPath.endsWith(".updateSignature")) {
                                    signature = this.readEntry(currentEntry, is);
                                    continue;
                                }
                                if (relPath.endsWith(".jarSignature")) {
                                    jarSignature = this.readEntry(currentEntry, is);
                                    continue;
                                }
                                if (relPath.endsWith(".removed")) {
                                    this.removeFile(backuplist, is, relPath);
                                    continue;
                                }
                                if (relPath.endsWith(".clientOptions")) {
                                    this.clientOptionsTasks.put(relPath, new ClientOptionsTask(relPath, this.installClientOption(is, relPath, signature)));
                                    continue;
                                }
                                if (relPath.endsWith(".serverOptions")) {
                                    this.serverOptionsManager.installServerOption(is, relPath, signature, pkg.getDestRevision());
                                    continue;
                                }
                                try {
                                    if (currentEntry.isFile()) {
                                        if (relPath.endsWith(".jar") && jarSignature != null) {
                                            this.getLogger().info("Install Jar");
                                            this.installJar(backuplist, is, relPath, signature, jarSignature);
                                            continue;
                                        }
                                        this.installFile(backuplist, is, relPath, signature);
                                        continue;
                                    }
                                    if (this.convertRelPath(relPath).exists()) continue;
                                    this.installFolder(backuplist, relPath, signature, true);
                                }
                                finally {
                                    jarSignature = null;
                                    signature = null;
                                }
                            }
                            finally {
                                this.onPostInstallEntry(relPath, currentEntry);
                            }
                        }
                        catch (InterruptedException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            this.getLogger().log(e);
                            ClientOptionsTask ct = this.clientOptionsTasks.get(relPath);
                            if (ct != null) {
                                FailedAction action = ct.getClientOption().getFailedAction();
                                if (action == null) {
                                    throw e;
                                }
                                switch (action) {
                                    case REVERT: {
                                        throw e;
                                    }
                                }
                                this.getLogger().exception("FailedAction:" + action.name(), e);
                                continue;
                            }
                            throw e;
                        }
                    }
                    finally {
                        mp.setStepValue(bytesExtracted, pkg.getContentSize());
                    }
                }
                is.close();
                deleteFile = true;
                this.addPackageInstallationHistory(file, PackageInstallationHistory.INSTALLATION_FINISH);
                this.resetUpdateOptions(file, pkg);
            }
            catch (InterruptedException e) {
                this.addPackageInstallationHistory(file, PackageInstallationHistory.INSTALLATION_INTERRUPTED);
                throw e;
            }
            catch (ClosedByInterruptException e) {
                this.addPackageInstallationHistory(file, PackageInstallationHistory.INSTALLATION_INTERRUPTED);
                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
            }
            catch (ExtIOException e) {
                this.addPackageInstallationHistory(file, PackageInstallationHistory.INSTALLATION_EXCEPTION);
                throw InstallException.wrap(this, e);
            }
            catch (IOException e) {
                this.addPackageInstallationHistory(file, PackageInstallationHistory.INSTALLATION_EXCEPTION);
                throw InstallException.wrap(this, e);
            }
            catch (Throwable e) {
                this.addPackageInstallationHistory(file, PackageInstallationHistory.INSTALLATION_EXCEPTION);
                throw InstallException.wrap(this, e);
            }
            finally {
                this.buffer = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (deleteFile) {
                    try {
                        this.deletePackageFileAfterSuccessfulInstallation(file);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (InstallException e) {
            this.trackException(e);
            throw e;
        }
    }

    public boolean isAllowedToTouch(String relPath) throws InstallException {
        return true;
    }

    protected void onPostInstallEntry(String relPath, AWFCEntry entry) throws InstallException {
    }

    protected String readEntry(AWFCEntry entry, InputStream input) throws IOException {
        return UpdateClient.readEntry(input);
    }

    protected void onPreInstallEntry(String relPath, AWFCEntry entry) throws InstallException {
    }

    protected void deletePackageFileAfterSuccessfulInstallation(File file) throws IOException, InterruptedException {
        this.deletePackage(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryFailedCleanups() throws InterruptedException {
        try {
            if (!this.failedCleanupsFile.exists() || this.failedCleanupsFile.length() == 0L) {
                return;
            }
            FileAccessHandler fileSystem = this.getFileSystem();
            this.getLogger().info("Try to handle Failed Cleanups");
            int i = 0;
            File tmpFile = new File(this.failedCleanupsFile.getAbsolutePath() + ".tmp_" + i++);
            while (tmpFile.exists()) {
                tmpFile = new File(this.failedCleanupsFile.getAbsolutePath() + ".tmp_" + i++);
            }
            BackupFileWriterImpl writer = new BackupFileWriterImpl(this, tmpFile, true);
            try {
                BackupFileReader reader = new BackupFileReader(this, this.failedCleanupsFile);
                try {
                    InstallerAction entry;
                    while ((entry = reader.read()) != null) {
                        try {
                            this.getLogger().info(entry.getID() + " " + Arrays.toString(entry.getParameters()));
                            entry.retryFailedcleanup(this, this.filelist);
                        }
                        catch (CleanupException e) {
                            this.getLogger().log(e);
                            ((AbstractBackupFileWriter)writer).write(entry);
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
            finally {
                ((AbstractBackupFileWriter)writer).close();
            }
            fileSystem.mkdirs(this.failedCleanupsFile.getParentFile());
            fileSystem.moveFile(tmpFile, this.failedCleanupsFile, true);
        }
        catch (ExtIOException e) {
            this.getLogger().log(e);
        }
        catch (ClosedByInterruptException e) {
            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
        }
        catch (IOException e) {
            this.getLogger().log(e);
        }
    }

    protected Revision internalWriteRevision() throws ExtIOException {
        Revision rev = this.getDestRevision();
        File file = this.getRevisionFile();
        this.getLogger().info("Write Revision: " + rev.getId() + "/" + rev.getName() + " to " + file);
        this.getFileSystem().secureWrite(file, JSonStorage.serializeToJsonByteArray(rev), true);
        return rev;
    }

    @Deprecated
    public boolean isAtHead() {
        Pkg pkg = this.getUpdate();
        if (pkg == null) {
            throw new IllegalStateException("Call runUpdateCheck() first");
        }
        int currentRevision = this.getCurrentRevision().getId();
        switch (pkg.getResponseStatus()) {
            case ERROR: {
                ErrorResponseInterface errorResponse = pkg.getInterface(ErrorResponseInterface.class);
                switch (errorResponse.getErrorCode()) {
                    case OUTDATED_REVISION: {
                        return false;
                    }
                    case LOCKED: {
                        return currentRevision >= errorResponse.getDestRevision();
                    }
                    case PACKAGE_FAILED: {
                        return false;
                    }
                }
                return false;
            }
            case OK: {
                return true;
            }
            case EMPTY: {
                return true;
            }
            case URL: 
            case FILE: {
                return false;
            }
            case WAIT: {
                return false;
            }
        }
        return false;
    }

    public boolean isChangeLogEnabled() {
        return false;
    }

    protected boolean isFileListSupportEnabled() {
        return true;
    }

    protected boolean isJarUpdateEntryLoggingEnabled(AbsoluteFile local, String relPath) {
        return false;
    }

    public boolean isReverting() {
        return this.reverting;
    }

    protected void jarCopy(AbstractBackupFileWriter backuplist, AbsoluteFile local, String relPath) throws FailedActionException, InterruptedException {
    }

    protected void onFileOrFolderRemoved(File file, File removed, String relPath) throws Exception {
    }

    protected void onFileWritten(AbsoluteFile local, File backup, AbstractBackupFileWriter backuplist) throws Exception {
    }

    protected void onFolderCreated(File relFile, String relPath) throws Exception {
    }

    protected void packageWait(WaitResponseInterface waitResponse) throws InterruptedException {
        Thread.sleep(Math.max(1000L, waitResponse.getCheckInterval()));
    }

    public String readInputStreamToString(Process process, InputStream fis) throws UnsupportedEncodingException, IOException, InterruptedException {
        return IO.readInputStreamToString(new FilterInputStream(fis){

            @Override
            public void close() throws IOException {
            }
        });
    }

    public Revision readRevision() {
        File revisionFile = this.getRevisionFile();
        try {
            if (revisionFile.isFile()) {
                return this.readRevision(revisionFile);
            }
            return Revision.NO_REVISION;
        }
        catch (Throwable e) {
            this.getLogger().log(e);
            return Revision.NO_REVISION;
        }
    }

    public Revision readRevision(File revisionFile) throws IOException, InterruptedException {
        String string;
        String string2 = string = revisionFile != null && revisionFile.isFile() ? this.getFileSystem().secureReadFileToString(revisionFile) : null;
        if (string != null && string.matches("^\\s*-?\\d+\\s*$")) {
            int revision = Integer.parseInt(string.trim());
            return new Revision(revision);
        }
        Revision ret = JSonStorage.restoreFromString(string, Revision.TYPE);
        if (ret != null) {
            return ret;
        }
        return Revision.NO_REVISION;
    }

    protected void removeFile(AbstractBackupFileWriter backupFileWriter, InputStream input, String relPath) throws FailedActionException {
        try {
            String signature = UpdateClient.readEntry(input);
            String filePath = relPath.substring(0, relPath.length() - ".removed".length());
            if (filePath.endsWith(".serverOptions")) {
                new RemovedFile(signature).verify(this.getUpdate().getPackageResponse().getDestRevision(), filePath, this.getPublicKey());
                this.getServerOptionsManager().removeServerOption(filePath.substring(0, filePath.length() - ".serverOptions".length()));
            } else {
                AbsoluteFile file = this.convertRelPath(filePath);
                this.getLogger().info("Remove Abs.File: " + file);
                if (!CrossSystem.caseSensitiveFileExists(file)) {
                    this.getLogger().info("File does not exist: " + file);
                } else {
                    this.getLogger().info("Verify Signature");
                    new RemovedFile(signature).verify(this.getUpdate().getPackageResponse().getDestRevision(), filePath, this.getPublicKey());
                    this.removeFile(backupFileWriter, relPath, file);
                }
            }
        }
        catch (Exception e) {
            throw FailedActionException.wrap(this, e);
        }
    }

    public void removeFile(AbstractBackupFileWriter backupFileWriter, String relPathWithRemovedExt, AbsoluteFile actualFile) throws FailedActionException, NoRelativeFileException, IOException, InterruptedException, ExtIOException {
        if (!this.isAllowedToDelete(actualFile.getRelative(), actualFile)) {
            this.getLogger().info("Skip Deletion:" + actualFile);
        } else {
            AbsoluteFile test;
            int i = 0;
            while ((test = actualFile.deriveWithPostFix("." + i++ + ".updRemoved")).exists()) {
            }
            AbsoluteFile backup = test;
            this.getLogger().info("Backup: " + backup);
            if (backupFileWriter != null) {
                backupFileWriter.write(new DeleteFileOrFolderV2(backup.getRelative(), actualFile.getRelative()));
            }
            this.removeFileBackupExisting(actualFile, backup);
            try {
                this.onFileOrFolderRemoved(actualFile, backup, relPathWithRemovedExt);
            }
            catch (Exception e) {
                throw FailedActionException.wrap(this, e);
            }
        }
    }

    public boolean isAllowedToDelete(String relPath, File file) throws FailedActionException {
        if (relPath.startsWith(".%") && file.isDirectory() && this.getPathBuilder().isProtectedFolder(this, file)) {
            throw new FailedActionException(this, (Throwable)new DeletingRootFoldersIsForbiddenException(file, relPath));
        }
        return true;
    }

    protected void removeFileBackupExisting(File file, File removed) throws InterruptedException, ExtIOException {
        this.getLogger().info("Rename file to " + removed);
        this.getFileSystem().moveFile(file, removed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revert() throws RevertException, InterruptedException {
        File backupFile = this.getBackupFile();
        if (!backupFile.isFile() || backupFile.length() == 0L) {
            return;
        }
        this.reverting = true;
        this.moduleProgress.setStepID((Object)Module.REVERT);
        BackupFileReader f = null;
        boolean errors = false;
        try {
            InstallerAction entry;
            f = new BackupFileReader(this, backupFile);
            while ((entry = f.read()) != null) {
                entry.setLogger(this.getLogger());
                this.checkInterruption();
                RevertException revertException = null;
                try {
                    this.onPreRevertEntry(entry);
                    entry.revert(this);
                }
                catch (RevertException e) {
                    revertException = e;
                    this.getLogger().exception("Could not revert:" + entry, e);
                    errors = true;
                }
                finally {
                    this.onPostRevertEntry(entry, revertException);
                }
                this.moduleProgress.setStepValue(f.getProgress());
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RevertException(e);
        }
        finally {
            this.reverting = false;
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                this.getFileSystem().deleteFileIfExists(backupFile);
            }
            catch (ExtIOException e) {
                LogAndIgnoreException.logTo(e, this.getLogger());
            }
        }
        if (errors) {
            throw new RevertException("Reverting errors occured.check Log");
        }
    }

    protected void onPostRevertEntry(InstallerAction entry, RevertException revertException) throws RevertException {
    }

    protected void onPreRevertEntry(InstallerAction entry) throws RevertException {
    }

    protected void revertOnException(Throwable throwable) {
        new NonInterruptibleRunnableSimple(){

            @Override
            protected void execute() throws InterruptedException {
                try {
                    try {
                        UpdateClient.this.getLogger().info("Revert Update");
                        UpdateClient.this.revert();
                        FileList fileList = UpdateClient.this.filelist;
                        if (fileList != null) {
                            fileList.revert();
                        }
                    }
                    finally {
                        InstallationResult installPackageResult = UpdateClient.this.getInstallPackageResult();
                        if (installPackageResult != null) {
                            installPackageResult.reachedRevertedOnExceptionTime();
                        }
                    }
                }
                catch (Throwable ignore) {
                    UpdateClient.this.getLogger().log(ignore);
                }
            }
        }.startAndWait();
    }

    private void runChangelogDownload(Pkg update) throws TransportException {
        ChangeLogResponseInterface changeLogResponse;
        if (update != null && (changeLogResponse = update.getInterface(ChangeLogResponseInterface.class)) != null && changeLogResponse.getChangeLogText() == null && changeLogResponse.getChangeLogUrls() != null && changeLogResponse.getChangeLogUrls().size() > 0) {
            String txt = this.downloadChangelog(changeLogResponse.getChangeLogHash(), changeLogResponse.getChangeLogSize(), changeLogResponse.getChangeLogUrls());
            changeLogResponse.setChangeLogText(txt);
        }
    }

    public UninstallResult runUninstallation(UninstallOptions options, UninstallStatusInterface status) throws InterruptedException, InstallException {
        UninstallInfo uninstallRulesFromSetup = this.getSetup().getUninstall();
        UninstallResult retFromSetup = uninstallRulesFromSetup != null ? this.runUninstallation(options, uninstallRulesFromSetup) : null;
        UninstallInfo uninstallFromRepoConfig = null;
        try {
            AbsoluteFile file = this.convertRelPath(".%repoconfig/uninstall.json");
            if (file.isFile()) {
                String json = this.getFileSystem().secureReadFileToString(file);
                uninstallFromRepoConfig = JSonStorage.restoreFromString(json, UninstallInfo.TYPE);
            }
        }
        catch (IOException e) {
            throw new InstallException(this, (Throwable)e);
        }
        UninstallResult retFromUninstallJson = uninstallFromRepoConfig != null ? this.runUninstallation(options, uninstallFromRepoConfig) : null;
        if (retFromSetup != null) {
            if (retFromUninstallJson != null) {
                retFromSetup.add(retFromUninstallJson);
            }
            return retFromSetup;
        }
        if (retFromUninstallJson != null) {
            return retFromUninstallJson;
        }
        UninstallResult ret = new UninstallResult();
        return ret;
    }

    protected UninstallResult runUninstallation(UninstallOptions options, UninstallInfo uninstall) throws InterruptedException, InstallException {
        File tmp;
        List<UninstallInfo.ExecuteRule> deprecatedExecutes;
        this.moduleProgress.fillStep();
        switch (options.getUninstallMode()) {
            case REINSTALL: {
                this.moduleProgress.setStepID((Object)Module.REINSTALL);
                break;
            }
            case UNINSTALL: {
                this.moduleProgress.setStepID((Object)Module.UNINSTALL);
                break;
            }
            default: {
                throw new WTFException("Not Supported: " + (Object)((Object)options.getUninstallMode()));
            }
        }
        this.moduleProgress.setStepVolume(1.0);
        final UninstallResult ret = new UninstallResult();
        if (uninstall == null) {
            return ret;
        }
        this.moduleProgress.reset();
        List<Exec> executes = uninstall.getExecutes();
        if (executes == null && (deprecatedExecutes = uninstall.getExecute()) != null) {
            executes = new ArrayList<Exec>();
            for (UninstallInfo.ExecuteRule dep : deprecatedExecutes) {
                File[] exec = new Exec();
                exec.setWorkingDirectory(dep.getDir());
                PreCondition osCondition = new PreCondition();
                osCondition.setQuery(new ConditionBuilder("osFamily").is((Object)dep.getOs()).build());
                osCondition.setFailAction(ExecuteResultAction.CONTINUE);
                exec.setConditions(new PreCondition[]{osCondition});
                exec.setElevation(new ElevationMode[]{ElevationMode.NONE});
                exec.setCmd(dep.getCmd());
                ArrayList<ExecuteResultMapping> list = new ArrayList<ExecuteResultMapping>();
                ExecuteResultMapping success = new ExecuteResultMapping();
                success.setAction(ExecuteResultAction.CONTINUE);
                success.setQuery(new Condition());
                list.add(success);
                exec.setResultMapping(list);
                executes.add((Exec)exec);
            }
        }
        this.moduleProgress.setStepVolume(executes != null && executes.size() > 0 ? 0.3 : 0.0);
        this.moduleProgress.setIndeterminated(true);
        if (options.isTmp() && (tmp = new File(this.getPathBuilder().getTmpFolder(this), this.setup.getNamespace())).exists()) {
            Files.internalWalkThroughStructureReverse(new Files.Handler<InterruptedException>(){

                @Override
                public void intro(File f) throws RuntimeException {
                }

                @Override
                public void onFile(File f) throws InterruptedException {
                    ret.add(UpdateClient.this.deleteFileAndParentFolderIfEmpty(f));
                }

                @Override
                public void outro(File f) throws RuntimeException {
                }
            }, tmp);
        }
        try {
            this.getExtensionManager().uninstall();
        }
        catch (ExtIOException e) {
            throw InstallException.wrap(this, e);
        }
        if (options.isExtensions()) {
            String extensions = this.getPathBuilder().getOptionalConfigPath(this);
            final Pattern startPattern = Pattern.compile("^" + Pattern.quote(new File(extensions).getName()) + "(\\..+)?\\.json$", 2);
            File[] deletFiles = Application.getResource(extensions).getParentFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return startPattern.matcher(name).matches();
                }
            });
            if (deletFiles != null) {
                for (File f : deletFiles) {
                    ret.add(this.deleteFileAndParentFolderIfEmpty(f));
                }
            }
        }
        if (executes != null) {
            int count = 0;
            for (Exec execute : executes) {
                GenericConditionMatcher matcher = this.createExecuteConditionMatcherObject(null);
                try {
                    this.execute(execute, true, null, null, matcher);
                }
                catch (Throwable e) {
                    ret.addException(e);
                    this.getLogger().log(e);
                }
                this.moduleProgress.setStepValue(count++, executes.size());
            }
        }
        if (options.isRules()) {
            this.deleteFileAndParentFolderIfEmpty(this.getPathBuilder().getRevisionFile(this));
            for (UninstallResult ur : this.applyUninstallRules(uninstall.getRules())) {
                ret.add(ur);
            }
        }
        if (options.isMeta()) {
            ret.add(this.deleteFileAndParentFolderIfEmpty(this.getPathBuilder().getFailedCleanupsFile(this)));
            ret.add(this.deleteFileAndParentFolderIfEmpty(this.getPathBuilder().getFilelist(this)));
            ret.add(this.deleteFileAndParentFolderIfEmpty(this.getPathBuilder().getServerOptionsFilePath(this)));
            Files.internalWalkThroughStructureReverse(new Files.Handler<InterruptedException>(){

                @Override
                public void intro(File f) throws RuntimeException {
                }

                @Override
                public void onFile(File f) throws InterruptedException {
                    ret.add(UpdateClient.this.deleteFileAndParentFolderIfEmpty(f));
                }

                @Override
                public void outro(File f) throws RuntimeException {
                }
            }, this.getPathBuilder().getRepoStorageResource(this, ""));
        }
        this.moduleProgress.fillStep();
        return ret;
    }

    protected UninstallResult deleteFileAndParentFolderIfEmpty(File file) throws InterruptedException {
        UninstallResult ret = new UninstallResult();
        for (int i = 0; i < 2 && file.exists(); ++i) {
            try {
                this.getFileSystem().deleteFileIfExists(file);
                this.onFileOrFolderUninstalled(file);
                ret.incDeleted(1);
            }
            catch (ExtIOException e) {
                if (i != 0) break;
                String reason = this.deleteExceptionToReasonText(file, e);
                ret.addFailed(reason, file);
                break;
            }
            file = file.getParentFile();
        }
        return ret;
    }

    protected void onFileOrFolderUninstalled(File file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<UninstallResult> applyUninstallRules(List<UninstallRule> uninstallRules) throws InterruptedException, InstallException {
        ArrayList<UninstallResult> results;
        block23: {
            int extra;
            results = new ArrayList<UninstallResult>();
            if (uninstallRules == null) break block23;
            ArrayList<String> directories = new ArrayList<String>();
            HashMap includes = new HashMap();
            HashMap excludes = new HashMap();
            Object conditionmatcher = this.createExecuteConditionMatcherObject(null);
            Iterator<UninstallRule> iterator = uninstallRules.iterator();
            block9: while (true) {
                String[] excludePatterns;
                int n;
                String directory;
                UninstallRule uninstallRule;
                block25: {
                    int n2;
                    String[] stringArray;
                    ArrayList<Matcher> list;
                    block26: {
                        block24: {
                            String[] includePatterns;
                            if (!iterator.hasNext()) break block24;
                            uninstallRule = iterator.next();
                            PreCondition[] conditions = uninstallRule.getConditions();
                            if (conditions != null) {
                                Condition.OpHandler oldHandler = Condition.putThreadResolver("\u00a7file", new Condition.ConditionResolver<String, FileContext>(){

                                    @Override
                                    public FileContext resolve(String path) throws CompareException {
                                        try {
                                            return new FileContext(new File(UpdateClient.this.replaceCommandLineParameterVariables(path, null)));
                                        }
                                        catch (IOException e) {
                                            throw new CompareException(e);
                                        }
                                    }
                                });
                                try {
                                    for (PreCondition condition : conditions) {
                                        if (condition.getQuery().matchesWithoutExceptions(conditionmatcher)) continue;
                                        this.getLogger().info("Condition Failed: " + this.createDocumentedJSONObject(condition));
                                        switch (condition.getFailAction()) {
                                            case CONTINUE: {
                                                continue block9;
                                            }
                                        }
                                        throw new InstallException(this, null, condition.getFailMessage(), null, condition.getFailAction());
                                    }
                                }
                                finally {
                                    Condition.putThreadOPHandler("\u00a7file", oldHandler);
                                    continue;
                                }
                            }
                            if ((directory = uninstallRule.getDir()) == null) continue;
                            this.getLogger().info("Parse Rule|Directory:" + directory + "\r\n" + JSonStorage.serializeToJson(uninstallRule));
                            if (!directories.contains(directory)) {
                                directories.add(directory);
                            }
                            if ((includePatterns = uninstallRule.getInclude()) == null) break block25;
                            list = (ArrayList<Matcher>)includes.get(directory);
                            if (list == null) {
                                list = new ArrayList<Matcher>();
                            }
                            stringArray = includePatterns;
                            n2 = stringArray.length;
                            break block26;
                        }
                        extra = 0;
                        break;
                    }
                    block11: for (n = 0; n < n2; ++n) {
                        String includePattern = stringArray[n];
                        if (!StringUtils.isNotEmpty(includePattern)) continue;
                        for (Matcher matcher : list) {
                            if (!matcher.pattern().pattern().equals(includePattern)) continue;
                            continue block11;
                        }
                        list.add(Pattern.compile(includePattern).matcher(""));
                    }
                    if (list.size() > 0) {
                        includes.put(directory, list);
                    }
                }
                if ((excludePatterns = uninstallRule.getExclude()) == null) continue;
                ArrayList<Matcher> list = (ArrayList<Matcher>)excludes.get(directory);
                if (list == null) {
                    list = new ArrayList<Matcher>();
                }
                String[] stringArray = excludePatterns;
                int n3 = stringArray.length;
                block13: for (n = 0; n < n3; ++n) {
                    String excludePattern = stringArray[n];
                    if (!StringUtils.isNotEmpty(excludePattern)) continue;
                    for (Matcher matcher : list) {
                        if (!matcher.pattern().pattern().equals(excludePattern)) continue;
                        continue block13;
                    }
                    list.add(Pattern.compile(excludePattern).matcher(""));
                }
                if (list.size() <= 0) continue;
                excludes.put(directory, list);
            }
            for (int index = 0; index < directories.size(); ++index) {
                AbsoluteFile[] list;
                AbsoluteFile base;
                String directory = (String)directories.get(index);
                try {
                    base = this.convertRelPath(directory);
                }
                catch (InstallException e) {
                    this.getLogger().log(e);
                    HashMap failed = new HashMap();
                    failed.put(e.getMessage(), new HashSet());
                    results.add(new UninstallResult(failed, 0L, 0L, 0L));
                    continue;
                }
                results.add(this.processUninstallRules(base, (List)includes.get(directory), (List)excludes.get(directory)));
                if (!base.getParentFile().exists()) continue;
                final Pattern parent = Pattern.compile(Pattern.quote(base.getName()) + "(?i)\\.\\d+\\.updRemoved$");
                for (AbsoluteFile updRemoved : list = base.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (new File(dir, name).isDirectory()) {
                            return parent.matcher(name).matches();
                        }
                        return false;
                    }
                })) {
                    results.add(this.processUninstallRules(updRemoved, (List)includes.get(directory), (List)excludes.get(directory)));
                    this.moduleProgress.setStepValue(index + ++extra, directories.size() + extra);
                }
            }
        }
        return results;
    }

    protected void onPreUninstallEntry(String relPath, File file) throws InstallException {
    }

    protected void onPostUninstallEntry(String relPath, File file, boolean deleted) throws InstallException {
    }

    protected UninstallResult processUninstallRules(final AbsoluteFile base, final List<Matcher> includes, final List<Matcher> excludes) throws InterruptedException {
        final HashMap failedToRemove = new HashMap();
        final AtomicLong deleted = new AtomicLong(0L);
        final AtomicLong ignored = new AtomicLong(0L);
        final AtomicLong blocked = new AtomicLong(0L);
        if (base.exists() && includes != null && includes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Process Rule(s)|Directory:" + base + "\r\n");
            if (excludes != null && excludes.size() > 0) {
                for (Matcher matcher : excludes) {
                    sb.append("Exclude-Patterns:" + matcher.pattern().pattern() + "\r\n");
                }
            } else {
                sb.append("No Exclude-Patterns:\r\n");
            }
            for (Matcher matcher : includes) {
                sb.append("Include-Patterns:" + matcher.pattern().pattern() + "\r\n");
            }
            this.getLogger().info(sb.toString());
            try {
                Files.walkThroughStructureReverse(new Files.Handler<RuntimeException>(){
                    private final HashSet<String> blockedPaths = new HashSet();

                    private final String getRelativePath(File base2, File f) {
                        String pathBase = base2.getAbsolutePath();
                        String pathSub = f.getAbsolutePath();
                        if (base2 instanceof AbsoluteFile) {
                            pathBase = ((AbsoluteFile)base2).getRelative();
                        }
                        if (f instanceof AbsoluteFile) {
                            pathSub = ((AbsoluteFile)f).getRelative();
                        }
                        String relPath = Files.getRelativePath(pathBase, pathSub);
                        String ret = relPath.replaceAll("\\\\", "/").replaceFirst("(\\.\\d+\\.updRemoved)$", "").replaceFirst("(\\.updRevertBackup\\d+)$", "");
                        if (f.isDirectory()) {
                            return ret + "/";
                        }
                        return ret;
                    }

                    @Override
                    public void intro(File f) throws RuntimeException {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFile(File f) throws RuntimeException {
                        if (Thread.interrupted()) {
                            throw new RuntimeException(new InterruptedException());
                        }
                        String matcherRelPath = this.getRelativePath(base, f);
                        if (this.isBlocked(matcherRelPath)) {
                            blocked.incrementAndGet();
                            return;
                        }
                        if (excludes != null) {
                            for (Matcher matcher : excludes) {
                                if (!matcher.reset(matcherRelPath).matches()) continue;
                                ignored.incrementAndGet();
                                if (matcherRelPath.endsWith("/")) {
                                    this.blockedPaths.add(matcherRelPath);
                                } else {
                                    this.blockedPaths.add(matcherRelPath.substring(0, matcherRelPath.lastIndexOf("/") + 1));
                                }
                                return;
                            }
                        }
                        for (Matcher matcher : includes) {
                            String reason;
                            boolean result;
                            block21: {
                                if (!matcher.reset(matcherRelPath).matches()) continue;
                                result = false;
                                reason = null;
                                try {
                                    UpdateClient.this.onPreUninstallEntry(matcherRelPath, f);
                                    try {
                                        try {
                                            UpdateClient.this.getLogger().info("Uninstall " + f);
                                            UpdateClient.this.getFileSystem().deleteFileIfExists(f);
                                            result = true;
                                        }
                                        catch (Throwable e) {
                                            UpdateClient.this.getLogger().log(e);
                                            reason = UpdateClient.this.deleteExceptionToReasonText(f, e);
                                            result = false;
                                        }
                                        if (result || !f.isDirectory()) break block21;
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException e) {
                                            throw new RuntimeException(e);
                                        }
                                        try {
                                            UpdateClient.this.getFileSystem().deleteFileIfExists(f);
                                            result = true;
                                        }
                                        catch (Throwable e) {
                                            UpdateClient.this.getLogger().log(e);
                                            result = false;
                                        }
                                    }
                                    finally {
                                        UpdateClient.this.onPostUninstallEntry(matcherRelPath, f, result);
                                    }
                                }
                                catch (InstallException e) {
                                    UpdateClient.this.getLogger().log(e);
                                }
                            }
                            if (!result) {
                                HashSet<File> lst = (HashSet<File>)failedToRemove.get(reason);
                                if (lst == null) {
                                    lst = new HashSet<File>();
                                    failedToRemove.put(reason, lst);
                                }
                                lst.add(f);
                            } else {
                                deleted.incrementAndGet();
                            }
                            UpdateClient.this.getLogger().info("Uninstall: " + f + " \t(" + matcherRelPath + " <> " + matcher.pattern().pattern() + ") Success: " + result);
                            return;
                        }
                    }

                    private final boolean isBlocked(String relPath) {
                        if (relPath.endsWith("/")) {
                            for (String blockedPath : this.blockedPaths) {
                                if (!blockedPath.startsWith(relPath)) continue;
                                return true;
                            }
                        }
                        return "/".equals(relPath) && this.blockedPaths.size() > 0;
                    }

                    @Override
                    public void outro(File f) throws RuntimeException {
                    }
                }, base);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof InterruptedException) {
                    throw (InterruptedException)e.getCause();
                }
                throw e;
            }
        }
        return new UninstallResult(failedToRemove, deleted.get(), ignored.get(), blocked.get());
    }

    public File runPackageDownload() throws InterruptedException, TransportException, PackageCreateException, InstallException, IOException, URISyntaxException, ServerLockedException, LastChanceException, ProxySelectorException {
        return this.runPackageDownload(null);
    }

    public File runPackageDownload(DownloadMirror downloadMirror) throws InterruptedException, TransportException, PackageCreateException, InstallException, IOException, URISyntaxException, ServerLockedException, LastChanceException, ProxySelectorException {
        this.moduleProgress.setStepVolume(0.15);
        Revision source = this.getCurrentRevision();
        Pkg upd = this.getUpdate();
        Revision dest = upd.getDestRevision();
        switch (this.getUpdate().getResponseStatus()) {
            case FILE: {
                if (this.isLocalPackageSupportEnabled()) {
                    if (!dest._isNewerThan(source)) {
                        this.onDowngradeRequest(source, dest, upd);
                    }
                    this.moduleProgress.setStepVolume(0.35);
                    this.moduleProgress.setStepID((Object)Module.DOWNLOAD);
                    return this.prepareLocalPackage(this.getPackageFile());
                }
                throw new IllegalStateException("Unsupported Response: " + (Object)((Object)this.getUpdate().getResponseStatus()));
            }
            case URL: {
                if (!dest._isNewerThan(source)) {
                    this.onDowngradeRequest(source, dest, upd);
                }
                this.moduleProgress.setStepVolume(0.35);
                this.moduleProgress.setStepID((Object)Module.DOWNLOAD);
                return this.download(downloadMirror);
            }
            case EMPTY: {
                if (!dest._isNewerThan(source)) {
                    this.onDowngradeRequest(source, dest, upd);
                }
                this.moduleProgress.setStepVolume(1.0);
                this.moduleProgress.fillStep();
                this.onEmptyPackageResponse();
                return null;
            }
        }
        throw new IllegalStateException("Ilegal Response: " + (Object)((Object)this.getUpdate().getResponseStatus()));
    }

    protected void onDowngradeRequest(Revision source, Revision dest, Pkg update) throws TargetRevisionIsLowerThanInstalledRevisionException {
        throw new TargetRevisionIsLowerThanInstalledRevisionException(this, dest, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File prepareLocalPackage(File localFile) throws TransportException, InterruptedException, IOException, URISyntaxException, InstallException, ProxySelectorException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (localFile == null) {
            throw new IllegalArgumentException("localFile is null");
        }
        this.downloadProgress = new DownloadProgress();
        Pkg pkg = this.getUpdate();
        LocalPackageJsonResponse response = pkg.getInterface(LocalPackageJsonResponse.class);
        this.getLogger().info("Prepare UpdatePackage ");
        FileAccessHandler fileSystem = this.getFileSystem();
        try {
            long fileSize;
            this.downloadProgress.setFile(localFile);
            this.getLogger().info("Local File: " + localFile + " (FileSize: " + localFile.length() + "|PackageSize:" + response.getSize() + ")");
            fileSystem.mkdirs(localFile.getParentFile());
            DownloadPackageInfo downloadPackageInfo = this.readDownloadPackageInfo(localFile);
            if (downloadPackageInfo != null && !this.matches(downloadPackageInfo, this.getCurrentRevision(), pkg, localFile) && this.deletePackage(localFile)) {
                this.getLogger().info("Delete local File|Reason: outdated package:" + JSonStorage.toString(downloadPackageInfo));
            }
            this.writeDownloadPackageInfo(this.getCurrentRevision(), pkg, localFile);
            if (response.getSize() < localFile.length()) {
                fileSize = localFile.length();
                if (this.deletePackage(localFile)) {
                    this.getLogger().info("Delete local File|Reason: package is smaller than file  (FileSize: " + fileSize + "|PackageSize:" + response.getSize() + ")");
                }
            } else if (localFile.length() > response.getSize()) {
                fileSize = localFile.length();
                if (this.deletePackage(localFile)) {
                    this.getLogger().info("Delete local File|Reason: file is bigger than package (FileSize: " + fileSize + "|PackageSize:" + response.getSize() + ")");
                }
            } else if (localFile.length() == response.getSize() && !DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                this.getLogger().info("local file seems to be finished (size check ok)");
                this.downloadProgress.setHashing(true);
                this.getModuleProgress().setIndeterminated(true);
                try {
                    String sha256;
                    fileSystem.mkdirs(localFile.getParentFile());
                    long start = Time.systemIndependentCurrentJVMTimeMillis();
                    this.getLogger().info("Start hashing...");
                    FileInputStream fis = fileSystem.openFileInputStream(localFile);
                    try {
                        sha256 = Hash.getHash(fis, "SHA-256", -1L, true);
                    }
                    finally {
                        fis.close();
                    }
                    this.downloadProgress.addHashedBytes(localFile.length(), Time.systemIndependentCurrentJVMTimeMillis() - start);
                    if (StringUtils.equalsIgnoreCase(response.getHash(), sha256)) {
                        this.addPackageInstallationHistory(localFile, PackageInstallationHistory.PACKAGE_FINISH);
                        this.getLogger().info("... and hash is ok as well. perfect!");
                        this.moduleProgress.fillStep();
                        File file = localFile;
                        return file;
                    }
                    this.getLogger().info("... but hashcheck failed. delete file");
                    this.deletePackage(localFile);
                }
                finally {
                    this.getModuleProgress().setIndeterminated(false);
                    this.downloadProgress.setHashing(false);
                }
            }
            this.deletePackage(localFile);
            this.downloadProgress.setDownloadStart(Time.systemIndependentCurrentJVMTimeMillis());
            this.downloadProgress.setSizeBefore(localFile.length());
            this.downloadProgress.setEta(-1L);
            this.downloadProgress.setDownloadSpeedBps(-1L);
            try {
                String localFileLocation = response.getLocalFileLocation();
                MessageDigest sha256Digest = null;
                InputStream is = this.openLocalPackageFile(new File(localFileLocation));
                try {
                    ZipEntry entry;
                    ZipInputStream zipInputStream = new ZipInputStream(new InterruptibleInputStream(new BufferedInputStream(is, 1269760)));
                    while ((entry = zipInputStream.getNextEntry()) != null) {
                        if (!"pkg.data".equals(entry.getName()) || entry.isDirectory()) continue;
                        FileOutputStream os = this.getFileSystem().openFileOutputStream(localFile, false);
                        try {
                            int read;
                            sha256Digest = MessageDigest.getInstance("SHA-256");
                            DigestOutputStream dos = new DigestOutputStream(os, sha256Digest);
                            byte[] buf = new byte[524288];
                            AverageSpeedMeter speedMeterInNS = new AverageSpeedMeter(20000, SpeedMeterInterface.Resolution.NANO_SECONDS);
                            long written = 0L;
                            BufferedInputStream buff = new BufferedInputStream(zipInputStream, buf.length);
                            long before = Time.getNanoSeconds();
                            while ((read = ((InputStream)buff).read(buf)) != -1) {
                                if (read <= 0) continue;
                                dos.write(buf, 0, read);
                                long now = Time.getNanoSeconds();
                                speedMeterInNS.putBytes(read, now - before);
                                before = now;
                                this.moduleProgress.setStepValue(written += (long)read, response.getSize());
                                long bytesPerSecond = speedMeterInNS.getValue(SpeedMeterInterface.Resolution.SECONDS);
                                if (bytesPerSecond > 0L) {
                                    this.downloadProgress.setDownloadSpeedBps(bytesPerSecond);
                                    this.downloadProgress.setEta((response.getSize() - written) / bytesPerSecond);
                                    continue;
                                }
                                this.downloadProgress.setDownloadSpeedBps(-1L);
                                this.downloadProgress.setEta(-1L);
                            }
                            break;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new TransportException(e);
                        }
                        finally {
                            ((OutputStream)os).close();
                        }
                    }
                    zipInputStream.close();
                }
                catch (IOException e) {
                    if (!Exceptions.containsInstanceOf(e, InterruptedIOException.class)) throw e;
                    throw (InterruptedException)new InterruptedException().initCause(e);
                }
                finally {
                    is.close();
                }
                if (sha256Digest == null) {
                    throw new FileNotFoundExtIOException(null, new FileNotFoundException("pkg.data missing"), new File(localFileLocation));
                }
                if (localFile.length() != response.getSize()) {
                    long fileSize2 = localFile.length();
                    if (!this.deletePackage(localFile)) throw new TransportException("Incomplete Offline Package");
                    this.getLogger().info("Delete local File|Reason: file size doesn't match package (FileSize: " + fileSize2 + "|PackageSize:" + response.getSize() + ")");
                    throw new TransportException("Incomplete Offline Package");
                }
                this.getLogger().info("local file seems to be finished (size check ok)");
                String sha256 = HexFormatter.byteArrayToHex(sha256Digest.digest());
                if (!StringUtils.equalsIgnoreCase(response.getHash(), sha256)) {
                    this.getLogger().info("... but hashcheck failed. delete file");
                    this.deletePackage(localFile);
                    throw new TransportException("Copying Offline Package failed");
                }
                this.addPackageInstallationHistory(localFile, PackageInstallationHistory.PACKAGE_FINISH);
                this.getLogger().info("... and hash is ok as well. perfect!");
                this.moduleProgress.fillStep();
                File file = localFile;
                return file;
            }
            finally {
                this.downloadProgress.setDownloadEnd(Time.systemIndependentCurrentJVMTimeMillis());
                this.downloadProgress.setSizeAfter(localFile.length());
            }
        }
        catch (InterruptedException e) {
            this.getLogger().info("Copy interrupted; keep local file " + localFile + " (FileSize: " + localFile.length() + "|PackageSize:" + response.getSize() + ")");
            throw e;
        }
    }

    public InputStream openLocalPackageFile(File file) throws ExtIOException {
        try {
            InputStream is = file.getName().matches("(?i).+\\.(zip|cop)$") ? this.getFileSystem().openFileInputStream(file) : new UnixSplitInputStream(file){

                @Override
                protected InputStream openInputStream(File file) throws IOException {
                    return UpdateClient.this.getFileSystem().openFileInputStream(file);
                }
            };
            return is;
        }
        catch (IOException e) {
            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
        }
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public File runPackageExtraction(File file) throws InterruptedException, InstallException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runPackageInstallation(File file) throws InterruptedException, InstallException {
        this.runPackageInstallation(file, false);
    }

    protected InstallationResult getOrSetInstallPackageResult() {
        InstallationResult ret = this.getInstallPackageResult();
        if (ret != null) {
            return ret;
        }
        ret = new InstallationResult();
        this.setInstallPackageResult(ret);
        return ret;
    }

    public void runPackageInstallation(File file, boolean awfFormat) throws InterruptedException, InstallException {
        this.getLogger().info("run Package Installation " + file + " is awf: " + awfFormat);
        InstallationResult installationResult = this.getOrSetInstallPackageResult();
        try {
            installationResult.reachedStartTime();
            this.checkInterruption();
            this.getModuleProgress().setStepID((Object)Module.PREPARE_INSTALL);
            this.getModuleProgress().setStepVolume(0.2);
            try {
                this.revertBeforePackageInstallation();
            }
            catch (RevertException e) {
                this.getLogger().log(e);
                this.checkInterruption();
            }
            AbstractBackupFileWriter backuplist = null;
            try {
                backuplist = new BackupFileWriterImpl(this, this.getBackupFile(), false);
                installationResult.reachedInitRevertTime();
                this.onBeforeInstallation();
                this.getModuleProgress().setStepVolume(0.55);
                this.installPackage(file, awfFormat, backuplist);
                installationResult.reachedInstalledPackageTime();
                this.getModuleProgress().setStepVolume(0.5);
                this.getExtensionManager().runInstallation(this.getServerOptionsManager(), this.getBackupFile());
                installationResult.reachedInstalledExtensionsTime();
                this.getModuleProgress().setStepVolume(1.0);
                try {
                    ArrayList<ClientOptionsTask> lst = new ArrayList<ClientOptionsTask>(this.clientOptionsTasks.values());
                    Collections.sort(lst, new Comparator<ClientOptionsTask>(){

                        @Override
                        public int compare(ClientOptionsTask o1, ClientOptionsTask o2) {
                            return CompareUtils.compare((Comparable)((Object)o1.getRelPath()), (Comparable)((Object)o2.getRelPath()));
                        }
                    });
                    this.applyClientOptions(lst, backuplist);
                    try {
                        this.getExtensionManager().setRequestsDone();
                        this.getServerOptionsManager().save();
                    }
                    catch (ExtIOException e) {
                        throw InstallException.wrap(this, e);
                    }
                    catch (IOException e) {
                        throw InstallException.wrap(this, e);
                    }
                    this.onBeforeInstallationCleanup();
                    try {
                        if (backuplist != null) {
                            backuplist.close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.cleanup();
                }
                catch (CleanupException e) {
                    this.getLogger().log(e);
                }
                installationResult.reachedInstalledClientOptionsTime();
                this.getModuleProgress().fillStep();
                installationResult.reachedStopTime();
            }
            catch (ExtIOException e) {
                throw InstallException.wrap(this, e);
            }
            finally {
                try {
                    if (backuplist != null) {
                        backuplist.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (InterruptedException e) {
            this.getLogger().log(e);
            this.getModuleProgress().setStepVolume(1.0);
            this.revertOnException(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.getLogger().log(e);
            this.getModuleProgress().setStepVolume(1.0);
            this.revertOnException(e);
            throw e;
        }
        catch (InstallException e) {
            this.getLogger().log(e);
            this.getModuleProgress().setStepVolume(1.0);
            this.revertOnException(e);
            throw e;
        }
        finally {
            this.getModuleProgress().fillStep();
        }
    }

    protected void revertBeforePackageInstallation() throws RevertException, InterruptedException, InstallException {
        this.revert();
    }

    protected void onBeforeInstallationCleanup() throws InstallException, InterruptedException {
    }

    protected void onBeforeInstallation() throws InstallException, InterruptedException {
    }

    public InstallationResult getInstallPackageResult() {
        return this.installPackageResult;
    }

    public void setInstallPackageResult(InstallationResult installPackageResult) {
        this.installPackageResult = installPackageResult;
    }

    public void runUpdateCheck(String updateServer) throws TransportException, InterruptedException, PackageCreateException, ServerLockedException, LastChanceException, ExtIOException, InstallException {
        this.setUpdate(this.downloadPackage());
    }

    public String getKeyHash() {
        String publicSignatureKey = this.getSetup().getPublicSignatureKey();
        return publicSignatureKey != null ? Hash.getMD5(publicSignatureKey) : null;
    }

    public String getAppID() {
        return this.getSetup().getApplicationIdentifier();
    }

    protected File getLocalPackageMetaFile() {
        return this.getPathBuilder().getRepoStorageResource(this, "pkg.local.json");
    }

    public void writeLocalPackage(File localPackageFile, LocalPackageJsonResponse pkg) throws InstallException, ExtIOException {
        if (!this.isLocalPackageSupportEnabled()) {
            throw new InstallException(this, "Unsupported feature!");
        }
        if (pkg.getRequiredClientVersion() > 20210716001L) {
            throw new InstallException(this, "Unsupported client version:20210716001<" + pkg.getRequiredClientVersion());
        }
        if (!ResponseStatus.FILE.equals((Object)pkg.getStatus())) {
            throw new InstallException(this, "Invalid status:" + (Object)((Object)pkg.getStatus()));
        }
        if (!StringUtils.equalsIgnoreCase(this.getAppID(), pkg.getAppID())) {
            throw new InstallException(this, "AppID missmatch?:" + this.getAppID() + "!=" + (Object)((Object)pkg.getStatus()));
        }
        if (!StringUtils.equalsIgnoreCase(this.getKeyHash(), pkg.getPubKeyHash())) {
            throw new InstallException(this, "PubKeyHash missmatch?:" + this.getKeyHash() + "!=" + pkg.getPubKeyHash());
        }
        if (localPackageFile == null || !localPackageFile.isFile()) {
            throw new InstallException(this, "Missing file:" + localPackageFile.getAbsoluteFile());
        }
        pkg.setLocalFileLocation(localPackageFile.getAbsolutePath());
        pkg.setTag(Hash.getMD5(JSonStorage.toString(pkg)) + "_" + UniqueAlltimeID.create());
        this.getFileSystem().secureWrite(this.getLocalPackageMetaFile(), JSonStorage.serializeToJsonByteArray(pkg), true);
    }

    public Pkg loadLocalPackage() throws ExtIOException, InstallException {
        File pkgFile;
        if (this.isLocalPackageSupportEnabled() && (pkgFile = this.getLocalPackageMetaFile()).isFile()) {
            try {
                String json = this.getFileSystem().secureReadFileToString(pkgFile);
                Pkg pkg = new Pkg(this, null);
                pkg.parseServerResponse(json.getBytes(UTF8));
                Revision currentRevision = this.getCurrentRevision();
                if (pkg.getLocalPackageResponse() == null || !pkg.getDestRevision()._isNewerThan(currentRevision)) {
                    if (StringUtils.equals(pkg.getDestRevision().getTag(), currentRevision.getTag())) {
                        this.logger.info("Delete installed local package:" + pkgFile);
                    } else {
                        this.logger.info("Delete outdated local package:" + pkgFile);
                    }
                    this.getFileSystem().deleteFileIfExists(pkgFile);
                    return null;
                }
                LocalPackageJsonResponse localePackageResponse = pkg.getLocalPackageResponse();
                if (localePackageResponse == null || !ResponseStatus.FILE.equals((Object)pkg.getResponseStatus())) {
                    this.logger.info("Delete invalid local package:" + pkgFile);
                    this.getFileSystem().deleteFileIfExists(pkgFile);
                    return null;
                }
                if (localePackageResponse.getRequiredClientVersion() > 20210716001L) {
                    this.logger.info("Delete unsupported local package:" + pkgFile);
                    this.getFileSystem().deleteFileIfExists(pkgFile);
                    return null;
                }
                return pkg;
            }
            catch (Exception e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    protected Pkg downloadPackage() throws TransportException, InterruptedException, ExtIOException, ServerLockedException, InstallException {
        Pkg pkg = this.loadLocalPackage();
        if (pkg != null) {
            return pkg;
        }
        pkg = this.createPkgRequest();
        return (Pkg)this.get(pkg, this.getHttpClientInterface());
    }

    public DownloadPackageInfo readDownloadPackageInfo(Pkg pkg) {
        File packageFile = this.getPackageFile();
        if (packageFile.isFile() && packageFile.length() > 0L) {
            try {
                DownloadPackageInfo info = this.readDownloadPackageInfo(packageFile);
                if (info == null) {
                    return null;
                }
                if (!StringUtils.equals(packageFile.getAbsolutePath(), info.getPath())) {
                    this.getLogger().info("don't resume:path missmatch!(" + info.getPath() + "|" + packageFile.getAbsolutePath() + ")");
                    return null;
                }
                if (info.getSrc() != this.getCurrentRevision().getId()) {
                    this.getLogger().info("don't resume:src revision missmatch!(" + info.getSrc() + "|" + this.getCurrentRevision().getId() + ")");
                    return null;
                }
                if (packageFile.length() > info.getSize()) {
                    this.getLogger().info("don't resume:size missmatch!(" + info.getSize() + "|" + packageFile.length() + ")");
                    return null;
                }
                Set<String> extensions = info.getExtensions();
                if (extensions != null && !extensions.equals(new HashSet<String>(pkg.getEidList()))) {
                    this.getLogger().info("don't resume:extensions missmatch!(" + extensions + "|" + pkg.getEidList() + ")");
                    return null;
                }
                Set<String> extensionsInstall = info.getExtensionsInstall();
                if (extensionsInstall != null && !extensionsInstall.equals(new HashSet<String>(pkg.getEipList()))) {
                    this.getLogger().info("don't resume:extensionsInstall missmatch!(" + extensionsInstall + "|" + pkg.getEipList() + ")");
                    return null;
                }
                Set<String> extensionsUninstall = info.getExtensionsUninstall();
                if (extensionsUninstall != null && !extensionsUninstall.equals(new HashSet<String>(pkg.getEirList()))) {
                    this.getLogger().info("don't resume:extensionsUninstall missmatch!(" + extensionsUninstall + "|" + pkg.getEirList() + ")");
                    return null;
                }
                if (this.getSupportedDeduplicationMode(info.getDeduplicationMode()) != pkg.getDeduplicationMode()) {
                    this.getLogger().info("don't resume:DeduplicationMode missmatch!(" + (Object)((Object)info.getDeduplicationMode()) + "|" + (Object)((Object)pkg.getDeduplicationMode()) + ")");
                    return null;
                }
                if (info.isJarDiff() != pkg.isJarDiffEnabled()) {
                    this.getLogger().info("don't resume:JarDiff missmatch!(" + info.isJarDiff() + "|" + pkg.isJarDiffEnabled() + ")");
                    return null;
                }
                return info;
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    public void runUpdateCheck() throws TransportException, InterruptedException, PackageCreateException, ServerLockedException, LastChanceException, ExtIOException, ProxySelectorException, InstallException {
        HttpClientInterface client = this.getHttpClientInterface();
        client.getProxySelector().setDialogAskAuthRequiredAllowedForCurrentThread(false);
        client.getProxySelector().setDialogAskNoConnectionAllowedForCurrentThread(false);
        try {
            this.runPackageRequestAndServerSelection();
        }
        catch (InstallException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            client.getProxySelector().setDialogAskAuthRequiredAllowedForCurrentThread(true);
            client.getProxySelector().setDialogAskNoConnectionAllowedForCurrentThread(true);
            this.runPackageRequestAndServerSelection();
            client.getProxySelector().setDialogAskAuthRequiredAllowedForCurrentThread(false);
            client.getProxySelector().setDialogAskNoConnectionAllowedForCurrentThread(false);
        }
        Pkg pkg = this.getUpdate();
        this.runChangelogDownload(pkg);
        switch (pkg.getResponseStatus()) {
            case LASTCHANCE: {
                throw new LastChanceException(this, pkg);
            }
            case EMPTY: {
                this.onEmptyPackageResponse();
                break;
            }
            case ERROR: {
                this.checkLocked(pkg);
                throw new PackageCreateException(this, pkg);
            }
            case OK: {
                this.onUp2DateResponse();
            }
        }
    }

    protected void onEmptyPackageResponse() throws ExtIOException {
        this.internalWriteRevision();
    }

    protected void onUp2DateResponse() throws ExtIOException {
        Revision rev = this.getUpdate().getDestRevision();
        if (rev != null) {
            boolean write;
            Revision stored = this.readRevision();
            if (stored != null && rev.getChangelog() == null) {
                rev.setChangelog(stored.getChangelog());
            }
            boolean bl = write = stored == null;
            if (rev.getName() != null) {
                write |= !StringUtils.equals(stored.getName(), rev.getName());
            }
            if (write) {
                this.internalWriteRevision();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPackageRequestAndServerSelection() throws TransportException, InterruptedException, PackageCreateException, ServerLockedException, LastChanceException, ExtIOException, UpdateServerOfflineException, ProxySelectorException, InstallException {
        TransportException firstException = null;
        LinkedHashSet<String> updateServers = new LinkedHashSet<String>();
        String latestActive = this.getUpdateServer();
        if (StringUtils.isNotEmpty(latestActive)) {
            updateServers.add(latestActive);
        }
        updateServers.addAll(Arrays.asList(this.getUpdateServers()));
        for (String updateServer : updateServers) {
            try {
                this.currentUpdateServer.set(updateServer);
                try {
                    this.runUpdateCheck(updateServer);
                    this.lastValidUpdateServer = updateServer;
                }
                finally {
                    this.currentUpdateServer.set(null);
                }
                return;
            }
            catch (UpdateServerOfflineException updateServerOfflineException) {
                this.getLogger().log(updateServerOfflineException);
                if (firstException != null) continue;
                firstException = updateServerOfflineException;
            }
            catch (TransportException transportException) {
                ProxySelectorException pse;
                this.getLogger().log(transportException);
                if (firstException == null) {
                    firstException = transportException;
                }
                if ((pse = Exceptions.getInstanceof(transportException, ProxySelectorException.class)) != null) {
                    if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) break;
                    throw pse;
                }
                InterruptedException in = Exceptions.getInstanceof(transportException, InterruptedException.class);
                if (in == null) continue;
                if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) break;
                throw (InterruptedException)new InterruptedException(transportException.getMessage()).initCause(transportException);
            }
        }
        if (firstException != null) {
            if (firstException instanceof UpdateServerOfflineException) {
                throw (UpdateServerOfflineException)firstException;
            }
            if (firstException instanceof TransportException) {
                throw (TransportException)firstException;
            }
            throw new WTFException(firstException);
        }
        throw new WTFException("Unable to reach any update server");
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public void setModuleProgress(ModuleProgress moduleProgress) {
        this.moduleProgress = moduleProgress;
    }

    public void setUpdate(Pkg update) {
        this.update = update;
    }

    public <T> T batchRequest(JobRequest job, TypeRef<T> type) throws InterruptedException, TransportException {
        this.batchRequest(this.createBatchRequest(job.withID()));
        return job._getResponse().restoreParameter(type);
    }

    public void writeRevisionFile() throws ExtIOException {
        this.internalWriteRevision();
    }

    public boolean isUninstallSupported() {
        try {
            if (this.getSetup().getUninstall() != null) {
                return true;
            }
            return this.convertRelPath(".%repoconfig/uninstall.json").isFile();
        }
        catch (InstallException e) {
            this.getLogger().log(e);
            return false;
        }
    }

    public void onPreServerOptionInstall(String rel, CompiledServerOptions cso) throws InstallException {
    }

    public void onPostServerOptionInstall(String rel, CompiledServerOptions cso) throws InstallException {
    }

    protected String deleteExceptionToReasonText(File f, Throwable e) {
        String reason = null;
        if (StringUtils.isEmpty(reason) && e.getCause() != null) {
            reason = e.getCause().getMessage();
        }
        if (StringUtils.isEmpty(reason) && e.getCause() != null) {
            reason = e.getCause().getClass().getSimpleName();
        }
        if (StringUtils.isEmpty(reason)) {
            reason = e.getClass().getSimpleName();
        }
        if (reason != null) {
            try {
                reason = reason.replaceAll(Pattern.quote(f.getCanonicalPath()) + ":?\\s*", "");
            }
            catch (IOException e1) {
                this.getLogger().log(e1);
            }
            reason = reason.trim();
        }
        return reason;
    }

    protected Map<String, DiskSpaceChanges> getDiskSpaceChanges(Pkg pkg) {
        Map<String, DiskSpaceChanges> changes;
        DiskSpaceChangesInterface diskSpaceChanges;
        if (pkg != null && (diskSpaceChanges = pkg.getInterface(DiskSpaceChangesInterface.class)) != null && (changes = diskSpaceChanges.getDiskSpaceChanges()) != null && changes.size() > 0) {
            return changes;
        }
        return null;
    }

    public Map<String, DiskSpaceChanges> computeChangesMap(Pkg pkg, CalculationOptions options) {
        if (pkg != null) {
            long cs;
            PackageResponseInterface pr = pkg.getPackageResponse();
            Map<String, DiskSpaceChanges> changes = this.getDiskSpaceChanges(pkg);
            Map<String, DiskSpaceChanges> ret = changes == null || changes.size() == 0 ? new HashMap<String, DiskSpaceChanges>() : (Map)JSonStorage.restoreFromString(JSonStorage.serializeToJson(changes), new TypeRef<HashMap<String, DiskSpaceChanges>>(){});
            if (ret.size() == 0 && pr != null && (cs = pr.getContentSize()) > 0L) {
                ret.put("", new DiskSpaceChanges().addRequired(cs * 2L));
            }
            if (pr != null) {
                if (options.isRemainingDownloadBytes()) {
                    DiskSpaceChanges e = ret.get("");
                    if (e == null) {
                        e = new DiskSpaceChanges();
                        ret.put("", e);
                    }
                    File localFile = this.getPackageFile();
                    long remainingBytesToDownload = pr.getSize() - localFile.length();
                    if (options.isPreExtractionBytes()) {
                        long whilePreExtracting = remainingBytesToDownload + pr.getContentSize();
                        long whileInstalling = e.getRequired() + pr.getContentSize() - localFile.length();
                        if (!options.isDeleteCompressedFileAfterPreExtraction()) {
                            whileInstalling += pr.getSize();
                        }
                        e.setRequired(Math.max(whilePreExtracting, whileInstalling));
                    } else {
                        long whileInstalling = e.getRequired() + remainingBytesToDownload;
                        e.setRequired(whileInstalling);
                    }
                } else if (options.isPreExtractionBytes()) {
                    DiskSpaceChanges e = ret.get("");
                    if (e == null) {
                        e = new DiskSpaceChanges();
                        ret.put("", e);
                    }
                    long whilePreExtracting = pr.getContentSize();
                    long whileInstalling = pr.getContentSize() + e.getRequired() - pr.getSize();
                    if (!options.isDeleteCompressedFileAfterPreExtraction()) {
                        whileInstalling += pr.getSize();
                    }
                    e.setRequired(Math.max(whilePreExtracting, whileInstalling));
                }
            }
            return ret;
        }
        return null;
    }

    public void deleteFileOrFolderRecursive(final File toDelete, DeleteCallback callback, final boolean exceptionOnError) throws ExtIOException, InterruptedException {
        int waitRetry = 5000;
        if (!toDelete.exists()) {
            return;
        }
        final DeleteCallback finalCallback = callback != null ? callback : new DeleteCallback(){

            @Override
            public void onDeleted(File file) throws ExtIOException {
            }
        };
        final FileAccessHandler fileSystem = this.getFileSystem();
        if (toDelete.isFile()) {
            try {
                fileSystem.deleteFileIfExists(toDelete);
                finalCallback.onDeleted(toDelete);
            }
            catch (ExtIOException e) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    throw Exceptions.addSuppressed(ie, e);
                }
                try {
                    fileSystem.deleteFileIfExists(toDelete);
                    finalCallback.onDeleted(toDelete);
                }
                catch (ExtIOException e1) {
                    if (exceptionOnError) {
                        throw e;
                    }
                    this.getLogger().log(new Exception("Swallow", e1));
                }
            }
        } else {
            try {
                final AtomicBoolean retryFlag = new AtomicBoolean(false);
                Files.internalWalkThroughStructureReverse(new Files.AbstractHandler<IOException>(){

                    @Override
                    public void onFile(File file) throws IOException {
                        try {
                            fileSystem.deleteFileIfExists(file);
                            finalCallback.onDeleted(toDelete);
                        }
                        catch (InterruptedException e) {
                            throw DefaultFileAccessHandler.wrapInterruptedException(e);
                        }
                        catch (ExtIOException e) {
                            retryFlag.set(true);
                        }
                    }
                }, toDelete);
                if (retryFlag.get()) {
                    Thread.sleep(5000L);
                    Files.internalWalkThroughStructureReverse(new Files.AbstractHandler<IOException>(){

                        @Override
                        public void onFile(File file) throws IOException {
                            try {
                                fileSystem.deleteFileIfExists(file);
                                finalCallback.onDeleted(toDelete);
                            }
                            catch (InterruptedException e) {
                                throw DefaultFileAccessHandler.wrapInterruptedException(e);
                            }
                            catch (ExtIOException e) {
                                if (exceptionOnError) {
                                    throw e;
                                }
                                UpdateClient.this.getLogger().log(new Exception("Swallow", e));
                            }
                        }
                    }, toDelete);
                }
            }
            catch (ClosedByInterruptException e) {
                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
            }
            catch (IOException e1) {
                throw ExtIOException.getInstance(e1, ExtIOException.IOExceptionType.LOCAL);
            }
        }
    }

    public UIDProviderInterface getUIDProvider() {
        return this.uidProvider;
    }

    public HIDProviderInterface getHIDProvider() {
        if (this.hidProvider == null) {
            this.hidProvider = new DisabledHIDProvider(this);
        }
        return this.hidProvider;
    }

    public void trackException(Throwable e) {
        this.getLogger().log(e);
    }

    protected long getMaxRequestTimeout(Object request) {
        return 120000L;
    }

    /*
     * Exception decompiling
     */
    public BatchResponse batchRequest(UpdateClientBatchRequest br) throws InterruptedException, TransportException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureSessionInit() throws InterruptedException, TransportException {
        AtomicBoolean atomicBoolean = this.sessionInitInProgress;
        synchronized (atomicBoolean) {
            if (this.sessionInitInProgress.get()) {
                return;
            }
            this.sessionInitInProgress.set(true);
            UpdateClientBatchRequest br = null;
            try {
                this.ensureTimeSync();
                if (this.initDoneTime == null) {
                    JobRequest initJob = new JobRequest(BatchJobType.SESSION_INIT.name(), this.createSessionInitData());
                    br = this.createBatchRequest(initJob.withID());
                    this.batchRequest(br);
                    if (initJob._getResponse().restoreParameter(TypeRef.OBJECT) == null) {
                        // empty if block
                    }
                    this.initDoneTime = this.getServerTime().now();
                }
            }
            catch (TransportException e) {
                HTTPConnection unsupportedServer = this.isUnsupportedServer(br, e);
                if (unsupportedServer != null) {
                    this.getLogger().info("Session Init: Unsupported Server:" + unsupportedServer.getURL().getHost());
                    this.initDoneTime = this.getServerTime().now();
                    return;
                }
                throw e;
            }
            finally {
                this.sessionInitInProgress.set(false);
            }
        }
    }

    protected SessionInitData createSessionInitData() {
        SessionInitData ret = new SessionInitData();
        ret.setSyncedDate(this.getServerTime().now());
        ret.setOperatingSystem(CrossSystem.OS.name());
        ret.setJvmVersion(Application.getJavaVersion());
        ret.setJvmVersionString(Application.getJVMVersion());
        return ret;
    }

    protected void onBatchResponse(BatchRequest request, BatchResponse response) throws ExtIOException, InterruptedException, InstallException {
        block0: for (JobResponse es : response.getJobs()) {
            if (es.getId() > 0L) {
                for (JobRequest job : request.getJobs()) {
                    if (job.getId() != es.getId()) continue;
                    job.onResponse(es);
                    continue block0;
                }
            }
            this.onBatchAPIResponse(request, es);
        }
    }

    protected void onBatchAPIResponse(BatchRequest request, JobResponse response) throws ExtIOException, InterruptedException, InstallException {
        UIDProviderInterface uid;
        if ("ACK_HID".equals(response.getName())) {
            HIDProviderInterface hid = this.getHIDProvider();
            if (hid != null) {
                hid.onServerSentAcceptedID(response.restoreParameter(TypeRef.STRING));
            }
        } else if ("UID".equals(response.getName()) && (uid = this.getUIDProvider()) != null) {
            uid.onServerSentAcceptedID(response.restoreParameter(TypeRef.STRING));
        }
    }

    protected void fillBatchRequest(BatchRequest br) throws InterruptedException {
    }

    public UpdateClientBatchRequest createBatchRequest(JobRequest ... jobRequests) {
        UpdateClientBatchRequest ret = new UpdateClientBatchRequest(this);
        if (jobRequests != null) {
            for (JobRequest job : jobRequests) {
                ret.add(job);
            }
        }
        return ret;
    }

    public LocaleMap findMessageByPattern(String line, String pattern) {
        block9: {
            if (line == null) {
                return null;
            }
            if (StringUtils.isEmpty(pattern)) {
                return null;
            }
            try {
                String match;
                Matcher matcher = Pattern.compile(pattern).matcher(line);
                if (!matcher.find() || (match = matcher.group(1)) == null) break block9;
                if (match.matches("^\\s*\\{.*\\}\\s*$")) {
                    try {
                        LocaleMap localeMap = this.jsonToObject(match, LocaleMap.TYPE, JSonHandlerHint.ENSURE_CORRECT_VALUES);
                        if (localeMap != null && localeMap.size() > 0) {
                            return localeMap;
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        this.getLogger().info("Parsing error: " + match);
                        this.getLogger().log(e);
                    }
                }
                return new LocaleMap(match);
            }
            catch (PatternSyntaxException e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    protected <T> T jsonToObject(String match, TypeRef<T> type, JSonHandlerHint ... hint) {
        return JSonStorage.restoreFromString(match, type);
    }

    public String objectToJson(Object obj) {
        return JSonStorage.serializeToJson(obj);
    }

    public static class UninstallResult {
        public HashMap<String, HashSet<File>> failedToRemove;
        private final List<Throwable> exceptions = new ArrayList<Throwable>();
        public long deleted;
        public long ignored;
        public long blocked;

        public HashMap<String, HashSet<File>> getFailedToRemove() {
            return this.failedToRemove;
        }

        public List<Throwable> getExceptions() {
            return this.exceptions;
        }

        public void addException(Throwable e) {
            this.exceptions.add(e);
        }

        public void add(UninstallResult add) {
            if (add.countFailedPaths() > 0) {
                for (Map.Entry<String, HashSet<File>> es : add.failedToRemove.entrySet()) {
                    this.ensureList(es.getKey()).addAll((Collection<File>)es.getValue());
                }
            }
            this.deleted += add.deleted;
            this.ignored += add.ignored;
            this.blocked += add.blocked;
        }

        protected HashSet<File> ensureList(String key) {
            HashSet<File> lst;
            if (this.failedToRemove == null) {
                this.failedToRemove = new HashMap();
            }
            if ((lst = this.failedToRemove.get(key)) == null) {
                lst = new HashSet();
                this.failedToRemove.put(key, lst);
            }
            return lst;
        }

        public void addFailed(String reason, File file) {
            this.ensureList(reason).add(file);
        }

        public void incDeleted(int i) {
            this.deleted += (long)i;
        }

        public void setFailedToRemove(HashMap<String, HashSet<File>> failedToRemove) {
            this.failedToRemove = failedToRemove;
        }

        public long getDeleted() {
            return this.deleted;
        }

        public void setDeleted(long deleted) {
            this.deleted = deleted;
        }

        public long getIgnored() {
            return this.ignored;
        }

        public void setIgnored(long ignored) {
            this.ignored = ignored;
        }

        public long getBlocked() {
            return this.blocked;
        }

        public void setBlocked(long blocked) {
            this.blocked = blocked;
        }

        public UninstallResult() {
            this.failedToRemove = new HashMap();
            this.deleted = 0L;
            this.blocked = 0L;
        }

        private UninstallResult(HashMap<String, HashSet<File>> failedToRemove, long deleted, long ignored, long blocked) {
            this.failedToRemove = failedToRemove;
            this.deleted = deleted;
            this.ignored = ignored;
            this.blocked = blocked;
        }

        public int countFailedPaths() {
            if (this.failedToRemove == null) {
                return 0;
            }
            int ret = 0;
            for (Map.Entry<String, HashSet<File>> es : this.failedToRemove.entrySet()) {
                ret += es.getValue().size();
            }
            return ret;
        }

        public Collection<File> listFailedToRemove() {
            HashSet<File> ret = new HashSet<File>();
            if (this.failedToRemove != null) {
                for (Map.Entry<String, HashSet<File>> es : this.failedToRemove.entrySet()) {
                    ret.addAll((Collection<File>)es.getValue());
                }
            }
            return ret;
        }
    }

    public static class DownloadProgress {
        private boolean hashing = false;
        private long downloadSpeedBps;
        private long eta;
        private long hashedBytes;
        private long hashedMS;
        private long downloadStart;
        private File file;
        private long sizeAfter;
        private long sizeBefore;
        private long downloadEnd;

        public long getDownloadSpeedBps() {
            return this.downloadSpeedBps;
        }

        public long getEta() {
            return this.eta;
        }

        protected void setDownloadSpeedBps(long downloadSpeedBps) {
            this.downloadSpeedBps = downloadSpeedBps;
        }

        protected void setEta(long eta) {
            this.eta = eta;
        }

        public boolean isHashing() {
            return this.hashing;
        }

        protected void setHashing(boolean hashing) {
            this.hashing = hashing;
        }

        public void addHashedBytes(long length, long l) {
            this.hashedBytes += length;
            this.hashedMS += l;
        }

        public long getHashingDuration() {
            return this.hashedMS;
        }

        public long getHashingBps() {
            if (this.hashedMS <= 0L) {
                return -1L;
            }
            return this.hashedBytes * 1000L / this.hashedMS;
        }

        public long getHashedBytes() {
            return this.hashedBytes;
        }

        public long getDownloadStart() {
            return this.downloadStart;
        }

        public void setDownloadStart(long downloadStart) {
            this.downloadStart = downloadStart;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public long getSizeAfter() {
            return this.sizeAfter;
        }

        public void setSizeAfter(long sizeAfter) {
            this.sizeAfter = sizeAfter;
        }

        public long getSizeBefore() {
            return this.sizeBefore;
        }

        public void setSizeBefore(long sizeBefore) {
            this.sizeBefore = sizeBefore;
        }

        public long getDownloadedBytes() {
            return this.sizeAfter - this.sizeBefore;
        }

        public long getDownloadEnd() {
            return this.downloadEnd;
        }

        public void setDownloadEnd(long downloadEnd) {
            this.downloadEnd = downloadEnd;
        }

        public long getDownloadDuration() {
            return this.downloadEnd - this.downloadStart;
        }
    }

    public static class DownloadResultMap {
        private final Map<TrafficLog.STATUS, AtomicLong> map = new HashMap<TrafficLog.STATUS, AtomicLong>();

        public synchronized long get(TrafficLog.STATUS status) {
            AtomicLong value = this.map.get((Object)status);
            return value != null ? value.get() : 0L;
        }

        public synchronized void put(TrafficLog.STATUS status) {
            if (status != null) {
                AtomicLong value = this.map.get((Object)status);
                if (value == null) {
                    value = new AtomicLong(0L);
                    this.map.put(status, value);
                }
                value.incrementAndGet();
            }
        }
    }

    public static enum Module {
        CREATE_PACKAGE,
        CREATE_PACKAGE_BUILDING,
        CREATE_PACKAGE_WAITING,
        INSTALLING,
        PREPARE_INSTALL,
        DOWNLOAD,
        REVERT,
        CLEANUP,
        EXTRACTION,
        REINSTALL,
        UNINSTALL,
        CLIENT_OPTIONS;

    }

    public static class ClientServiceExecuter
    extends ServiceExecuter {
        private final UpdateClient client;
        private final Exec execute;

        public ClientServiceExecuter(UpdateClient client, ServiceInstallation service, Exec execute) {
            super(service);
            this.client = client;
            this.execute = execute;
        }

        @Override
        public LogInterface getLogger() {
            return this.client.getLogger();
        }

        @Override
        protected String createUrlString(File file) {
            String ret = super.createUrlString(file);
            boolean isSelfTest = this.client.isSelfTestProcess();
            ret = ret + "&selftest=" + URLEncode.encodeRFC2396(String.valueOf(isSelfTest));
            if ("rt" != null) {
                ret = ret + "&runtype=" + URLEncode.encodeRFC2396(isSelfTest ? "ST" : "SO");
            }
            return ret;
        }

        @Override
        protected void parseResponseLine(String line) {
            super.parseResponseLine(line);
            this.client.parseExcecuteConsoleOutLine(this.execute, line);
        }

        @Override
        public ExecuteResult execute(File file, boolean waitFor) throws ServiceExecutionExeption, IOException, InterruptedException {
            this.client.getModuleProgress().setIndeterminated(true);
            return super.execute(file, waitFor);
        }
    }

    public static class TimoutWatchDog
    extends Thread {
        private final Exec execute;
        private Thread toInterrupt = Thread.currentThread();
        private final TimeSpanWithContext timeout;

        public TimoutWatchDog(String name, Exec execute) {
            super(name);
            this.setDaemon(true);
            this.execute = execute;
            this.timeout = TimeSpan.withFallbackAverageYearContext(execute.getTimeout());
            if (execute.getTimeout() != null && execute.getTimeout().isMoreThan(TimeSpan.ZERO)) {
                this.start();
            }
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeout.getLong(Unit.MILLISECONDS));
            }
            catch (InterruptedException e) {
                return;
            }
            this.toInterrupt.interrupt();
        }
    }
}

