/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.trayicon;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;

public final class TrayIconPopup
extends JPopupMenu
implements MouseListener {
    private static final long serialVersionUID = 2623190748929934409L;
    private boolean enteredPopup;
    private boolean hideThreadrunning = false;
    private transient Thread hideThread;

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.startAutoHide();
        } else {
            this.hideThreadrunning = false;
        }
    }

    public TrayIconPopup() {
        this.setInvoker(this);
        this.addMouseListener(this);
    }

    public void startAutoHide() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!TrayIconPopup.this.enteredPopup) {
                    new EDTHelper<Object>(){

                        @Override
                        public Object edtRun() {
                            TrayIconPopup.this.setVisible(false);
                            return null;
                        }
                    }.start();
                }
            }
        }.start();
        this.hideThread = new Thread(){

            @Override
            public void run() {
                while (TrayIconPopup.this.hideThreadrunning) {
                    try {
                        2.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    new EDTRunner(){

                        @Override
                        protected void runInEDT() {
                            if (TrayIconPopup.this.enteredPopup && TrayIconPopup.this.hideThreadrunning) {
                                PointerInfo mouse = MouseInfo.getPointerInfo();
                                try {
                                    Point location = TrayIconPopup.this.getLocationOnScreen();
                                    Point mouseLocation = mouse.getLocation();
                                    boolean activeFrame = false;
                                    for (Window w : Window.getWindows()) {
                                        try {
                                            boolean active;
                                            String cls;
                                            if (!w.isShowing() || !(cls = w.getClass().getName()).startsWith(Popup.class.getName()) || !(active = w.getBounds().contains(mouseLocation))) continue;
                                            activeFrame = true;
                                            break;
                                        }
                                        catch (Throwable e) {
                                            LogV3.log(e);
                                        }
                                    }
                                    if (activeFrame) {
                                        return;
                                    }
                                    if (mouse.getLocation().x < location.x || mouse.getLocation().x > location.x + TrayIconPopup.this.getSize().width) {
                                        TrayIconPopup.this.setVisible(false);
                                    } else if (mouse.getLocation().y < location.y || mouse.getLocation().y > location.y + TrayIconPopup.this.getSize().height) {
                                        TrayIconPopup.this.setVisible(false);
                                    }
                                }
                                catch (Exception e) {
                                    TrayIconPopup.this.setVisible(false);
                                }
                            }
                        }
                    }.waitForEDT();
                }
            }
        };
        this.hideThreadrunning = true;
        this.hideThread.start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.enteredPopup = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void dispose() {
        this.setVisible(false);
    }

    public void show(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }
}

