/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;

public abstract class ExtTextColumn<E>
extends ExtColumn<E>
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 2114805529462086691L;
    protected JLabel rendererField;
    protected JTextField editorField;
    private final Border defaultBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    private Color rendererForeground;
    private Color editorForeground;
    private Font rendererFont;
    private Font editorFont;
    protected JPanel editor;
    protected JLabel rendererIcon;
    protected JPanel renderer;
    protected JLabel editorIconLabel;
    protected final AtomicInteger noSet = new AtomicInteger(0);
    private boolean clipingEnabled = true;

    public JLabel getRendererField() {
        return this.rendererField;
    }

    public void setNoSet(boolean b) {
        if (b) {
            this.noSet.incrementAndGet();
        } else if (this.noSet.get() > 0) {
            this.noSet.decrementAndGet();
        }
    }

    public boolean isClipingEnabled() {
        return this.clipingEnabled;
    }

    public void setClipingEnabled(boolean clipingEnabled) {
        this.clipingEnabled = clipingEnabled;
    }

    public ExtTextColumn(String name) {
        this(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getCellSizeEstimation(E element, int row) {
        boolean clip = this.isClipingEnabled();
        try {
            Dimension ret;
            this.setClipingEnabled(false);
            Component c = this.getTableCellRendererComponent(this.getModel().getTable(), element, false, false, row, 1);
            c.invalidate();
            Dimension dimension = ret = c.getPreferredSize();
            return dimension;
        }
        finally {
            this.setClipingEnabled(clip);
        }
    }

    public ExtTextColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.editorField = new JTextField();
        this.editorField.addFocusListener(this);
        this.editorField.setBorder(null);
        this.rendererIcon = new RenderLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setIcon(Icon icon) {
                this.setVisible(icon != null);
                if (icon != this.getIcon()) {
                    super.setIcon(icon);
                }
            }
        };
        this.editorField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ExtTextColumn.this.setNoSet(true);
                    try {
                        ExtTextColumn.this.stopCellEditing();
                    }
                    finally {
                        ExtTextColumn.this.setNoSet(false);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.editorIconLabel = new RenderLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setIcon(Icon icon) {
                this.setVisible(icon != null);
                super.setIcon(icon);
            }
        };
        this.rendererField = this.createRendererField();
        this.rendererForeground = this.rendererField.getForeground();
        this.editorForeground = this.editorField.getForeground();
        this.rendererFont = this.rendererField.getFont();
        this.editorFont = this.editorField.getFont();
        this.editor = this.createEditorPanel();
        this.renderer = this.createRendererPanel();
        this.layoutEditor(this.editor, this.editorIconLabel, this.editorField);
        this.layoutRenderer(this.renderer, this.rendererIcon, this.rendererField);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                String o1s = ExtTextColumn.this.getStringValue(o1);
                String o2s = ExtTextColumn.this.getStringValue(o2);
                if (o1s == null) {
                    o1s = "";
                }
                if (o2s == null) {
                    o2s = "";
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return o1s.compareToIgnoreCase(o2s);
                }
                return o2s.compareToIgnoreCase(o1s);
            }
        });
    }

    protected RenderLabel createRendererField() {
        return new RenderLabel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setIcon(Icon icon) {
                ExtTextColumn.this.rendererIcon.setIcon(icon);
            }

            @Override
            public void setText(String text) {
                if (text != null && text.equals(this.getText())) {
                    return;
                }
                if (text == null && this.getText() == null) {
                    return;
                }
                super.setText(text);
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.editorField.removeActionListener(this);
        this.fireEditingStopped();
    }

    @Override
    protected void configureCurrentlyEditingComponent(E value, boolean isSelected, int row, int column) {
        this.editorIconLabel.setIcon(this.getIcon(value));
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
        this.prepareColumn(value);
        this.editorField.removeActionListener(this);
        String str = this.getStringValue(value);
        if (str == null) {
            str = "";
        }
        this.editorField.setText(str);
        this.editorField.addActionListener(this);
        this.editorIconLabel.setIcon(this.getIcon(value));
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.prepareColumn(value);
        this.rendererIcon.setIcon(this.getIcon(value));
        String str = this.getStringValue(value);
        if (str == null) {
            str = "";
        }
        if (this.getTableColumn() != null) {
            try {
                this.rendererField.setText(this.clip(this.rendererField, this.rendererField.getFontMetrics(this.rendererField.getFont()), str, this.calculateClippingWidth(value)));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.rendererField.setText(str);
            }
        } else {
            this.rendererField.setText(str);
        }
    }

    protected int calculateClippingWidth(E value) {
        return this.getTableColumn().getWidth() - this.rendererIcon.getPreferredSize().width - 5;
    }

    public JLabel getRendererIcon() {
        return this.rendererIcon;
    }

    protected String clip(JComponent label, FontMetrics fontMetrics, String str, int width) {
        if (!this.clipingEnabled) {
            return str;
        }
        return SwingUtilities2Wrapper.clipStringIfNecessary(label, fontMetrics, str, width);
    }

    protected MigPanel createEditorPanel() {
        return new MigPanel("ins 0 0 0 0", "[]5[grow,fill]", "[grow,fill]"){

            @Override
            public void requestFocus() {
                ExtTextColumn.this.editorField.requestFocus();
            }
        };
    }

    protected MigPanel createRendererPanel() {
        return new RendererMigPanel("ins 0 0 0 0", "[]0[grow,fill]", "[grow,fill]");
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.editorField.selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary() || e.getOppositeComponent() == null) {
            this.setNoSet(true);
            try {
                this.stopCellEditing();
            }
            finally {
                this.setNoSet(false);
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorField.getText();
    }

    @Override
    protected Color getDefaultForeground() {
        ExtTable table = this.getModel().getTable();
        if (table != null) {
            return table.getForeground();
        }
        return this.editorForeground;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return this.editor;
    }

    public JTextField getEditorField() {
        return this.editorField;
    }

    protected Icon getIcon(E value) {
        return null;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    public abstract String getStringValue(E var1);

    @Override
    protected String getTooltipText(E obj) {
        return this.getStringValue(obj);
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    protected void layoutEditor(JPanel editor, JLabel editorIconLabel, JTextField editorField) {
        editor.add((Component)editorIconLabel, "hidemode 2");
        editor.add(editorField);
    }

    protected void layoutRenderer(JPanel renderer, JLabel rendererIcon, JLabel rendererField) {
        renderer.add((Component)rendererIcon, "hidemode 2");
        renderer.add(rendererField);
    }

    @Override
    public boolean matchSearch(E object, Pattern pattern) {
        String stringValue = this.getStringValue(object);
        if (stringValue == null) {
            return false;
        }
        return pattern.matcher(stringValue).matches();
    }

    @Override
    public boolean onRenameClick(MouseEvent e, E obj) {
        if (this.isEditable(obj)) {
            this.startEditing(obj);
            return true;
        }
        return super.onRenameClick(e, obj);
    }

    protected void prepareColumn(E value) {
    }

    @Override
    public void resetEditor() {
        this.editor.setEnabled(true);
        this.editorField.setFont(this.editorFont);
        this.editorField.setBackground(null);
        this.editorIconLabel.setIcon(null);
        SwingUtils.setOpaque(this.editorIconLabel, false);
        SwingUtils.setOpaque(this.editorField, false);
    }

    @Override
    public void resetRenderer() {
        this.renderer.setEnabled(true);
        this.rendererField.setBorder(this.defaultBorder);
        this.rendererField.setOpaque(false);
        this.rendererField.setBackground(null);
        this.rendererField.setFont(this.rendererFont);
        this.renderer.setOpaque(false);
        this.rendererIcon.setIcon(null);
        SwingUtils.setOpaque(this.rendererIcon, false);
        SwingUtils.setOpaque(this.rendererField, false);
    }

    protected void setStringValue(String value, E object) {
    }

    protected boolean noSet() {
        return this.noSet.get() > 0;
    }

    @Override
    public void setValue(Object value, E object) {
        if (!this.noSet()) {
            this.setStringValue((String)value, object);
        }
    }
}

