/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.swing.renderer.RenderLabel;

public abstract class ExtLongColumn<E>
extends ExtColumn<E> {
    private static final long serialVersionUID = -6917352290094392921L;
    protected final RenderLabel renderer;
    private final Border defaultBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);

    public ExtLongColumn(String name) {
        this(name, null);
    }

    public ExtLongColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.renderer = new RenderLabel();
        this.renderer.setHorizontalAlignment(4);
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                long l2;
                long l1 = ExtLongColumn.this.getLong(o1);
                if (l1 == (l2 = ExtLongColumn.this.getLong(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return l1 > l2 ? -1 : 1;
                }
                return l1 < l2 ? -1 : 1;
            }
        });
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer.setText(this.getLong(value) + "");
        this.renderer.setEnabled(this.isEnabled(value));
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return null;
    }

    protected abstract long getLong(E var1);

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    @Override
    protected String getTooltipText(E obj) {
        return this.getLong(obj) + "";
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public void resetEditor() {
    }

    @Override
    public void resetRenderer() {
        this.renderer.setOpaque(false);
        this.renderer.setBorder(this.defaultBorder);
    }

    @Override
    public void setValue(Object value, E object) {
    }
}

