/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.text.DecimalFormat;
import javax.swing.JComponent;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.utils.swing.renderer.RenderLabel;

public abstract class ExtEuroColumn<E>
extends ExtColumn<E> {
    private static final long serialVersionUID = 3468695684952592989L;
    private RenderLabel renderer;
    private final DecimalFormat format = new DecimalFormat("0.00");

    public ExtEuroColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.renderer = new RenderLabel();
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (ExtEuroColumn.this.getCent(o1) == ExtEuroColumn.this.getCent(o2)) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return ExtEuroColumn.this.getCent(o1) > ExtEuroColumn.this.getCent(o2) ? -1 : 1;
                }
                return ExtEuroColumn.this.getCent(o1) < ExtEuroColumn.this.getCent(o2) ? -1 : 1;
            }
        });
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.renderer.setText(this.format.format((float)this.getCent(value) / 100.0f) + " \u20ac");
        }
        catch (Exception e) {
            this.renderer.setText(this.format.format("0.0f") + " \u20ac");
        }
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    protected abstract long getCent(Object var1);

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return null;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    @Override
    public boolean isEditable(Object obj) {
        return false;
    }

    @Override
    public boolean isEnabled(Object obj) {
        return true;
    }

    @Override
    public boolean isSortable(Object obj) {
        return true;
    }

    @Override
    public void resetEditor() {
    }

    @Override
    public void resetRenderer() {
        this.renderer.setOpaque(false);
        this.renderer.setBorder(ExtColumn.DEFAULT_BORDER);
    }

    @Override
    public void setValue(Object value, Object object) {
    }
}

