/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.appwork.resources.AWUTheme;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.MigPanel;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.RadioBoxIcon;
import org.appwork.swing.exttable.ExtTableIcon;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.swing.renderer.RendererMigPanel;

public abstract class ExtComboColumn<E, ModelType>
extends ExtTextColumn<E>
implements ActionListener {
    private static final long serialVersionUID = 2114805529462086691L;
    private final ComboBoxModel<ModelType> dataModel;
    protected RendererPanel rendererPanel;
    private Icon iconDown;
    private Icon iconUp;
    protected long lastHide = 0L;
    private E editing = null;
    private JPopupMenu popup;

    public ExtComboColumn(String name, ComboBoxModel<ModelType> model) {
        this(name, null, model);
    }

    protected Icon createDropUpIcon() {
        return ExtTableIcon.TABLE_COLUMN_COMBO_popUpLarge.get(-1);
    }

    protected Icon createDropDownIcon() {
        return ExtTableIcon.TABLE_COLUMN_COMBO_popDownLarge.get(-1);
    }

    @Override
    protected int adjustWidth(int w) {
        Dimension estimated = this.getEstimatedPopupDimensions();
        if (estimated == null) {
            return w;
        }
        return Math.max(w, estimated.width);
    }

    protected Dimension getEstimatedPopupDimensions() {
        if (this.dataModel != null && this.dataModel.getSize() > 0) {
            JPopupMenu opup = this.createPopupMenu();
            this.fillPopup(opup, null, this.dataModel.getElementAt(0), this.dataModel);
            return opup.getPreferredSize();
        }
        return null;
    }

    @Override
    protected MigPanel createEditorPanel() {
        return new MigPanel("ins 0", "[]5[grow,fill]", "[grow,fill]"){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
            }

            @Override
            public void requestFocus() {
                ExtComboColumn.this.editorField.requestFocus();
            }
        };
    }

    @Override
    protected RendererMigPanel createRendererPanel() {
        this.iconDown = this.createDropDownIcon();
        this.iconUp = this.createDropUpIcon();
        this.rendererPanel = new RendererPanel(){

            @Override
            public Icon getIcon() {
                if (ExtComboColumn.this.popup == null || !ExtComboColumn.this.popup.isVisible()) {
                    return ExtComboColumn.this.iconDown;
                }
                return super.getIcon();
            }
        };
        return this.rendererPanel;
    }

    public ExtComboColumn(String name, ExtTableModel<E> table, ComboBoxModel<ModelType> model) {
        super(name, table);
        this.dataModel = model;
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        ModelType selected = this.getSelectedItem(value);
        this.rendererPanel.setEditable(this.isEditable(value));
        this.rendererPanel.setIcon(this.editing == value ? this.iconUp : this.iconDown);
        Icon icon = this.getIconForRenderer(value, selected);
        this.rendererIcon.setIcon(icon);
        String str = this.getStringForRenderer(value, selected);
        if (str == null) {
            str = "";
        }
        if (this.getTableColumn() != null && str.length() > 0) {
            try {
                int upDownIconWidth = this.rendererPanel.getIcon() != null ? this.rendererPanel.getIcon().getIconWidth() : 0;
                int iconWidth = icon != null ? icon.getIconWidth() : 0;
                int availableWidth = this.getTableColumn().getWidth() - upDownIconWidth - iconWidth - 5 - 10;
                String clipped = SwingUtilities2Wrapper.clipStringIfNecessary(this.rendererField, this.rendererField.getFontMetrics(this.rendererField.getFont()), str, availableWidth);
                this.rendererField.setText(clipped);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.rendererField.setText(str);
            }
        } else {
            this.rendererField.setText(str);
        }
    }

    public Icon getIconForRenderer(E value, ModelType selected) {
        return this.modelItemToIcon(selected, value);
    }

    public String getStringForRenderer(E value, ModelType selected) {
        return this.modelItemToString(selected, value);
    }

    protected Icon modelItemToIcon(ModelType selected, E value) {
        return null;
    }

    @Override
    public boolean onMousePressed(MouseEvent e, E value) {
        if (!this.isEditable(value, this.isEnabled(value))) {
            return false;
        }
        int row = this.getModel().getTable().rowAtPoint(new Point(e.getX(), e.getY()));
        return this.startEdit(value, row);
    }

    protected boolean startEdit(E value, int row) {
        long timeSinceLastHide = System.currentTimeMillis() - this.lastHide;
        if (timeSinceLastHide < 250L && this.editing == value) {
            this.editing = null;
            this.repaint();
            return true;
        }
        this.editing = value;
        this.popup = this.createPopupMenu();
        try {
            ModelType selected = this.getSelectedItem(value);
            ComboBoxModel<ModelType> dm = this.updateModel(this.dataModel, value);
            this.fillPopup(this.popup, value, selected, dm);
            Rectangle bounds = this.getModel().getTable().getCellRect(row, this.getIndex(), true);
            Dimension pref = this.popup.getPreferredSize();
            this.popup.setPreferredSize(new Dimension(Math.max(pref.width, bounds.width), pref.height));
            this.popup.show(this.getModel().getTable(), bounds.x, bounds.y + bounds.height);
            return true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
    }

    public JPopupMenu createPopupMenu() {
        return new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                super.setVisible(b);
                if (!b) {
                    ExtComboColumn.this.lastHide = System.currentTimeMillis();
                }
            }
        };
    }

    protected void fillPopup(final JPopupMenu popup, final E value, ModelType selected, ComboBoxModel<ModelType> dm) {
        for (int i = 0; i < dm.getSize(); ++i) {
            final Object o = dm.getElementAt(i);
            JComponent bt = this.getPopupElement(o, CompareUtils.equals(selected, o), value);
            if (bt == null) continue;
            if (bt instanceof AbstractButton) {
                ((AbstractButton)bt).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExtComboColumn.this.setValue(o, value);
                        popup.setVisible(false);
                    }
                });
            }
            popup.add(bt);
        }
    }

    protected JComponent getPopupElement(final ModelType o, final boolean selected, final E value) {
        return new JMenuItem(new BasicAction(""){
            {
                super(name);
                this.setName(ExtComboColumn.this.getStringForRenderer(value, o));
                if (selected) {
                    this.setSmallIcon(RadioBoxIcon.TRUE);
                } else {
                    this.setSmallIcon(RadioBoxIcon.FALSE);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    @Override
    protected final Icon getIcon(E value) {
        return this.modelItemToIcon(this.getSelectedItem(value), value);
    }

    @Override
    public String getStringValue(E value) {
        return this.modelItemToString(this.getSelectedItem(value), value);
    }

    protected abstract ModelType getSelectedItem(E var1);

    protected abstract void setSelectedItem(E var1, ModelType var2);

    protected String modelItemToString(ModelType selectedItem, E value) {
        if (selectedItem == null) {
            return null;
        }
        return selectedItem.toString();
    }

    @Override
    protected String getTooltipText(E obj) {
        return super.getTooltipText(obj);
    }

    @Override
    public boolean isEditable(E obj) {
        ComboBoxModel<ModelType> mod = this.updateModel(this.dataModel, obj);
        return mod != null && mod.getSize() > 1;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public final void setValue(Object value, E object) {
        try {
            this.setSelectedItem(object, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ComboBoxModel<ModelType> updateModel(ComboBoxModel<ModelType> dataModel, E value) {
        return dataModel;
    }

    public static class RendererPanel
    extends RendererMigPanel {
        private boolean editable = false;
        private Icon downIcon;

        public RendererPanel() {
            super("ins 0", "[]0[grow,fill]", "[grow,fill]");
        }

        public Icon getIcon() {
            return this.downIcon;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Icon ico = this.getIcon();
            if (this.editable && ico != null) {
                if (this.isEnabled()) {
                    ico.paintIcon(this, g, this.getWidth() - 5 - ico.getIconWidth(), (this.getHeight() - ico.getIconHeight()) / 2);
                } else {
                    if (ico instanceof ImageIcon) {
                        ico = AWUTheme.I().getDisabledIcon(ico);
                    }
                    ico.paintIcon(this, g, this.getWidth() - 5 - ico.getIconWidth(), (this.getHeight() - ico.getIconHeight()) / 2);
                }
            }
        }

        public void setEditable(boolean editable) {
            this.editable = editable;
        }

        public void setIcon(Icon object) {
            this.downIcon = object;
        }
    }
}

