/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.appwork.loggingv3.LogV3;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.Storage;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.exttable.CustomOriginalTableColumn;
import org.appwork.swing.exttable.ExtCheckBoxMenuItem;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtColumnModel;
import org.appwork.swing.exttable.ExtDataFlavor;
import org.appwork.swing.exttable.ExtOverlayRowHighlighter;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableEventSender;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableIcon;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.ExtTransferHandler;
import org.appwork.swing.exttable.SearchDialog;
import org.appwork.swing.exttable.columnmenu.ResetColumns;
import org.appwork.swing.exttable.columnmenu.SearchContextAction;
import org.appwork.swing.exttable.columns.CellHeightProvider;
import org.appwork.utils.Application;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;

public class ExtTable<E>
extends JTable
implements ToolTipHandler,
PropertyChangeListener {
    private static final String DEFAULT_COLUMN_STORE = "";
    private static final long serialVersionUID = 2822230056021924679L;
    private static final ScheduledExecutorService EXECUTER = Executors.newSingleThreadScheduledExecutor();
    private final Color columnBackground;
    private final Color columnBackgroundSelected;
    private final Color columnForeground;
    private final Color columnForegroundSelected;
    private final ExtTableModel<E> model;
    private final List<ExtOverlayRowHighlighter> rowHighlighters;
    private boolean searchEnabled = false;
    private SearchDialog searchDialog;
    private final ExtTableEventSender eventSender;
    private JComponent columnButton = null;
    private boolean columnButtonVisible = true;
    private int verticalScrollPolicy;
    protected boolean headerDragging;
    private ExtColumn<E> lastTooltipCol;
    private int lastTooltipRow;
    private ExtDataFlavor<E> flavor;
    private DelayedRunnable renameClickDelayer;
    private Runnable clickDelayerRunable;
    private String columnSaveID = "";
    private static final KeyStroke KEY_STROKE_CTRL_HOME = Application.isHeadless() ? null : KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final KeyStroke KEY_STROKE_END = Application.isHeadless() ? null : KeyStroke.getKeyStroke(35, 0);
    private static final KeyStroke KEY_STROKE_HOME = Application.isHeadless() ? null : KeyStroke.getKeyStroke(36, 0);
    private static final KeyStroke KEY_STROKE_CTRL_END = Application.isHeadless() ? null : KeyStroke.getKeyStroke(35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private boolean dontDoRightNow = false;
    private int columModifications;
    private ArrayList<CellHeightProvider> cellHeightProviders;
    private int defaultRowHeight;

    public ExtTable(ExtTableModel<E> model) {
        super(model);
        if (model == null) {
            throw new NullPointerException("Model must not be null");
        }
        this.flavor = new ExtDataFlavor(this.getClass());
        this.eventSender = new ExtTableEventSender();
        ToolTipController.getInstance().register(this);
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.rowHighlighters = new ArrayList<ExtOverlayRowHighlighter>();
        this.model = model;
        this.setColumnModel(new ExtColumnModel(this.getColumnModel()));
        model.setTable(this);
        this.setRowHeight(22);
        this.renameClickDelayer = new DelayedRunnable(EXECUTER, this.setupRenameClickInterval()){

            @Override
            public void delayedrun() {
                if (ExtTable.this.clickDelayerRunable != null) {
                    if (ExtTable.this.getDropLocation() == null) {
                        ExtTable.this.clickDelayerRunable.run();
                    }
                    ExtTable.this.clickDelayerRunable = null;
                }
            }

            @Override
            public String getID() {
                return "renameClickDelayer_" + ((ExtTableModel)ExtTable.this.getModel()).getModelID();
            }
        };
        this.setTableHeader(new JTableHeader(this.getColumnModel()){
            private static final long serialVersionUID = 6099615257824836337L;

            @Override
            public Dimension getPreferredSize() {
                Dimension ret = super.getPreferredSize();
                ret.height = 19;
                return ret;
            }
        });
        this.createColumns();
        ((ExtTableModel)this.getModel()).autoColumnWidth();
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        Component c = renderer.getTableCellRendererComponent(this, null, true, false, 0, 0);
        this.columnBackgroundSelected = c.getBackground();
        this.columnForegroundSelected = c.getForeground();
        c = renderer.getTableCellRendererComponent(this, null, false, false, 0, 0);
        this.columnBackground = c.getBackground();
        this.columnForeground = c.getForeground();
        this.addPropertyChangeListener("dropLocation", this);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    ExtTable.this.onSortHeaderClick(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ExtTable.this.headerDragging = true;
                if (ExtTable.this.getTableHeader().getCursor().getType() == Cursor.getDefaultCursor().getType() && e.getButton() == 3) {
                    JPopupMenu ccm = ExtTable.this.columnControlMenu(ExtTable.this.getExtColumnAtPoint(e.getPoint()));
                    if (ccm == null) {
                        return;
                    }
                    ccm.show(ExtTable.this.getTableHeader(), e.getX(), e.getY());
                    if (ccm.getComponentCount() == 0) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ExtTable.this.headerDragging = false;
                try {
                    if (ExtTable.this.getTableHeader().getCursor().getType() == Cursor.getDefaultCursor().getType()) {
                        for (MouseListener ms : ExtTable.this.getTableHeader().getMouseListeners()) {
                            if (!(ms instanceof BasicTableHeaderUI.MouseInputHandler)) continue;
                            Field field = BasicTableHeaderUI.MouseInputHandler.class.getDeclaredField("otherCursor");
                            field.setAccessible(true);
                            field.set(ms, Cursor.getPredefinedCursor(11));
                        }
                    }
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.getTableHeader().addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int col = ExtTable.this.getExtColumnModelIndexByPoint(e.getPoint());
                if (col >= 0) {
                    ExtTable.this.getTableHeader().setToolTipText(((ExtTableModel)ExtTable.this.getModel()).getExtColumnByModelIndex(col).getHeaderTooltip());
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e == null || e.getValueIsAdjusting() || ((ExtTableModel)ExtTable.this.getModel()).isTableSelectionClearing()) {
                    return;
                }
                ExtTable.this.onSelectionChanged();
                ExtTable.this.eventSender.fireEvent(new ExtTableEvent<ArrayList>(ExtTable.this, ExtTableEvent.Types.SELECTION_CHANGED, new ArrayList[0]));
            }
        });
        this.getTableHeader().setReorderingAllowed(true);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(2);
        this.setAutoscrolls(true);
        if (Application.getJavaVersion() >= 16000000L) {
            this.setFillsViewportHeight(true);
        }
        this.setPreferredScrollableViewportSize(new Dimension(450, 20000));
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getFromIndex() == e.getToIndex()) {
                    return;
                }
                TableColumnModel tcm = ExtTable.this.getColumnModel();
                for (int i = 0; i < tcm.getColumnCount(); ++i) {
                    try {
                        ExtTable.this.getStorage().put(ExtTable.this.getColumnStoreKey("POS_COL_", i), ((ExtTableModel)ExtTable.this.getModel()).getExtColumnByModelIndex(tcm.getColumn(i).getModelIndex()).getID());
                        continue;
                    }
                    catch (Exception e1) {
                        LogV3.log(e1);
                    }
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    @Override
    protected void resizeAndRepaint() {
        if (this.dontDoRightNow) {
            return;
        }
        super.resizeAndRepaint();
    }

    @Override
    public void setRowHeight(int rowHeight) {
        this.defaultRowHeight = rowHeight;
        super.setRowHeight(rowHeight);
    }

    private ArrayList<CellHeightProvider> ensureCellHeightProviders() {
        if (((ExtTableModel)this.getModel()).getColumnModifications() == this.columModifications) {
            return this.cellHeightProviders;
        }
        ArrayList<CellHeightProvider> providers = null;
        for (ExtColumn c : ((ExtTableModel)this.getModel()).getColumns()) {
            if (!(c instanceof CellHeightProvider)) continue;
            if (providers == null) {
                providers = new ArrayList<CellHeightProvider>();
            }
            providers.add((CellHeightProvider)((Object)c));
        }
        this.cellHeightProviders = providers;
        this.columModifications = ((ExtTableModel)this.getModel()).getColumnModifications();
        return this.cellHeightProviders;
    }

    public void addRowHighlighter(ExtOverlayRowHighlighter highlighter) {
        this.removeRowHighlighter(highlighter);
        this.rowHighlighters.add(highlighter);
    }

    protected JPopupMenu columnControlMenu(ExtColumn<E> extColumn) {
        int i;
        JPopupMenu popup;
        if (extColumn == null) {
            popup = new JPopupMenu();
            for (i = 0; i < ((ExtTableModel)this.getModel()).getColumnCount(); ++i) {
                ((ExtTableModel)this.getModel()).getExtColumnByModelIndex(i).extendControlButtonMenu(popup);
            }
        } else {
            popup = extColumn.createHeaderPopup();
            if (popup == null) {
                popup = new JPopupMenu();
            }
        }
        for (i = 0; i < ((ExtTableModel)this.getModel()).getColumnCount(); ++i) {
            final int j = i;
            if (!((ExtTableModel)this.getModel()).isHidable(i)) continue;
            final ExtCheckBoxMenuItem mi = new ExtCheckBoxMenuItem(((ExtTableModel)this.getModel()).getColumnName(i));
            mi.setHideOnClick(false);
            mi.setSelected(((ExtTableModel)this.getModel()).isColumnVisible(i));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((ExtTableModel)ExtTable.this.getModel()).setColumnVisible(j, mi.isSelected());
                }
            });
            popup.add(mi);
        }
        popup.add(new JSeparator());
        if (this.isSearchEnabled()) {
            popup.add(new JMenuItem(new SearchContextAction(this)));
        }
        popup.add(new JMenuItem(new ResetColumns(this)));
        return popup;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.reconfigureColumnButton();
    }

    void createColumns() {
        TableColumnModel tcm = this.getColumnModel();
        while (tcm.getColumnCount() > 0) {
            tcm.removeColumn(tcm.getColumn(0));
        }
        LinkedHashMap<String, CustomOriginalTableColumn> columns = new LinkedHashMap<String, CustomOriginalTableColumn>();
        for (int i = 0; i < ((ExtTableModel)this.getModel()).getColumnCount(); ++i) {
            int j = i;
            ExtColumn<E> ext = this.model.getExtColumnByModelIndex(j);
            CustomOriginalTableColumn tableColumn = new CustomOriginalTableColumn(ext, i);
            ext.setTableColumn(tableColumn, true);
            ExtColumn<E> column = this.model.getExtColumnByModelIndex(j);
            ExtTableHeaderRenderer customRenderer = column.getHeaderRenderer(this.getTableHeader());
            tableColumn.setHeaderRenderer(customRenderer != null ? customRenderer : this.createDefaultHeaderRenderer(column));
            if (!this.model.isColumnVisible(i) && column.isHidable()) continue;
            columns.put(this.model.getExtColumnByModelIndex(j).getID(), tableColumn);
        }
        int index = 0;
        while (!columns.isEmpty()) {
            if (index < ((ExtTableModel)this.getModel()).getColumnCount()) {
                try {
                    TableColumn item;
                    String id = this.getColumnStore("POS_COL_", index, DEFAULT_COLUMN_STORE);
                    ++index;
                    if (id == null || (item = (TableColumn)columns.remove(id)) == null) continue;
                    this.addColumn(item);
                }
                catch (Exception e) {
                    LogV3.log(e);
                }
                continue;
            }
            for (TableColumn ritem : columns.values()) {
                this.addColumn(ritem);
            }
        }
    }

    private JComponent createDefaultColumnButton() {
        MigPanel p = new MigPanel("ins 0 2 0 0", "[grow,fill]", "[grow,fill]");
        JButton button = new JButton(ExtTableIcon.TABLE_COLUMN_BUTTON.get(10));
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        p.setBackground(null);
        p.setOpaque(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JButton source = (JButton)event.getSource();
                int x = source.getLocation().x;
                int y = source.getLocation().y;
                JPopupMenu ccm = ExtTable.this.columnControlMenu(null);
                if (ccm == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ccm.show(source, x, y);
                if (ccm.getComponentCount() == 0) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        p.add((Component)button, "width 12!,height 12!");
        return p;
    }

    protected ExtTableHeaderRenderer createDefaultHeaderRenderer(ExtColumn<E> column) {
        return new ExtTableHeaderRenderer(column, this.getTableHeader());
    }

    @Override
    public ExtTooltip createExtTooltip(Point position) {
        if (position == null) {
            position = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(position, this);
        }
        int row = this.getRowIndexByPoint(position);
        ExtColumn<E> col = this.getExtColumnAtPoint(position);
        this.lastTooltipCol = col;
        this.lastTooltipRow = row;
        ExtTooltip ret = this.createToolTip(col, row, position, ((ExtTableModel)this.getModel()).getElementAt(row));
        return ret;
    }

    protected ExtTooltip createToolTip(ExtColumn<E> col, int row, Point position, E elementAt) {
        if (row < 0) {
            return null;
        }
        return col.createToolTip(position, elementAt);
    }

    @Override
    public void doLayout() {
        TableColumn resizeColumn = this.getTableHeader().getResizingColumn();
        if (resizeColumn == null) {
            super.doLayout();
            return;
        }
        int orgResizeMode = this.getAutoResizeMode();
        int beforeWidth = resizeColumn.getWidth();
        super.doLayout();
        if (resizeColumn.getWidth() - beforeWidth != 0) {
            this.setAutoResizeMode(2);
            resizeColumn.setWidth(beforeWidth);
            super.doLayout();
            if (resizeColumn.getWidth() - beforeWidth != 0) {
                this.setAutoResizeMode(4);
                resizeColumn.setWidth(beforeWidth);
                super.doLayout();
                if (this.headerDragging && resizeColumn.getWidth() - beforeWidth != 0) {
                    Toolkit.getDefaultToolkit().beep();
                    this.getTableHeader().setCursor(null);
                    this.headerDragging = false;
                }
            }
        }
        this.saveWidthsRatio();
        this.setAutoResizeMode(orgResizeMode);
    }

    protected void doSortOnColumn(ExtColumn<E> column, MouseEvent e) {
        column.doSort();
    }

    private boolean dropLocationSame(JTable.DropLocation a, JTable.DropLocation b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.isInsertColumn() != b.isInsertColumn()) {
            return false;
        }
        if (a.isInsertRow() != b.isInsertRow()) {
            return false;
        }
        if (a.getColumn() != b.getColumn()) {
            return false;
        }
        return a.getRow() == b.getRow();
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean ret;
        if (e != null && e instanceof KeyEvent) {
            int code = ((KeyEvent)e).getKeyCode();
            if (code != 10 && this.isAutoEditLimitedOnEnter()) {
                return false;
            }
            if (((KeyEvent)e).isControlDown() && this.isAutoEditDisabledForCtrl()) {
                return false;
            }
        }
        if (ret = super.editCellAt(row, column, e)) {
            if (this.renameClickDelayer != null) {
                this.renameClickDelayer.stop();
            }
            this.transferFocus();
        }
        return ret;
    }

    protected void fireColumnModelUpdate() {
        ((ExtTableModel)this.getModel()).autoColumnWidth();
        this.eventSender.fireEvent(new ExtTableEvent<MouseEvent>(this, ExtTableEvent.Types.COLUMN_MODEL_UPDATE, new MouseEvent[0]));
    }

    @Override
    public boolean getAutoCreateColumnsFromModel() {
        return false;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int columnIndex) {
        return this.model.getCelleditorByColumn(this.convertColumnIndexToModel(columnIndex));
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.model.getCellrendererByColumn(this.convertColumnIndexToModel(column));
    }

    public Color getColumnBackground() {
        return this.columnBackground;
    }

    public Color getColumnBackgroundSelected() {
        return this.columnBackgroundSelected;
    }

    public JComponent getColumnButton() {
        if (this.columnButton == null) {
            this.columnButton = this.createDefaultColumnButton();
        }
        return this.columnButton;
    }

    public Color getColumnForeground() {
        return this.columnForeground;
    }

    public Color getColumnForegroundSelected() {
        return this.columnForegroundSelected;
    }

    public String getColumnSaveID() {
        return this.columnSaveID;
    }

    public <T> T getColumnStore(String key, Object key2, T string2) {
        return this.getStorage().get(this.getColumnStoreKey(key, key2), this.getStorage().get(key + DEFAULT_COLUMN_STORE + key2, string2));
    }

    public String getColumnStoreKey(String key1, Object key2) {
        return key1 + this.getColumnSaveID() + key2;
    }

    public int getContextIconSize() {
        return 22;
    }

    public ExtDataFlavor<E> getDataFlavor() {
        return this.flavor;
    }

    @Override
    public Component getEditorComponent() {
        if (this.getCellEditor() != null && this.getCellEditor() instanceof ExtColumn) {
            ((ExtColumn)this.getCellEditor()).getTableCellEditorComponent(this, this.getValueAt(this.getEditingRow(), this.getEditingColumn()), this.isCellSelected(this.getEditingRow(), this.getEditingColumn()), this.getEditingRow(), this.getEditingColumn(), true);
        }
        return this.editorComp;
    }

    public ExtTableEventSender getEventSender() {
        return this.eventSender;
    }

    public ExtColumn<E> getExtColumnAtPoint(Point point) {
        int x = this.getExtColumnModelIndexByPoint(point);
        return ((ExtTableModel)this.getModel()).getExtColumnByModelIndex(x);
    }

    public int getExtColumnModelIndexByPoint(Point point) {
        int x = this.columnAtPoint(point);
        return this.convertColumnIndexToModel(x);
    }

    public TableCellEditor getLafCellEditor(int row, int column) {
        return super.getCellEditor(row, column);
    }

    public TableCellRenderer getLafCellRenderer(int row, int column) {
        return super.getCellRenderer(row, column);
    }

    @Override
    public ExtTableModel<E> getModel() {
        return (ExtTableModel)super.getModel();
    }

    public List<ExtOverlayRowHighlighter> getRowHighlighters() {
        return this.rowHighlighters;
    }

    public int getRowIndexByPoint(Point point) {
        return this.rowAtPoint(point);
    }

    public Storage getStorage() {
        if (this.getModel() == null) {
            new RuntimeException("TableID has to be initialized here");
        }
        return ((ExtTableModel)this.getModel()).getStorage();
    }

    @Override
    public int getTooltipDelay(Point mousePositionOnScreen) {
        return 0;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return null;
    }

    protected boolean isAutoEditDisabledForCtrl() {
        return true;
    }

    protected boolean isAutoEditLimitedOnEnter() {
        return true;
    }

    protected boolean isClearSelectionTrigger(KeyStroke ks) {
        return CrossSystem.isClearSelectionTrigger(ks);
    }

    public boolean isColumnButtonVisible() {
        return this.columnButtonVisible;
    }

    protected boolean isCopySelectionTrigger(KeyStroke ks) {
        return CrossSystem.isCopySelectionTrigger(ks);
    }

    protected boolean isCutSelectionTrigger(KeyStroke ks) {
        return CrossSystem.isCutSelectionTrigger(ks);
    }

    protected boolean isDeleteFinalSelectionTrigger(KeyStroke ks) {
        return CrossSystem.isDeleteFinalSelectionTrigger(ks);
    }

    protected boolean isDeleteSelectionTrigger(KeyStroke ks) {
        return CrossSystem.isDeleteSelectionTrigger(ks);
    }

    protected boolean isPasteSelectionTrigger(KeyStroke ks) {
        return CrossSystem.isPasteSelectionTrigger(ks);
    }

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    protected boolean isSearchTrigger(KeyStroke ks) {
        return CrossSystem.isSearchTrigger(ks);
    }

    protected boolean isSelectionAllTrigger(KeyStroke ks) {
        return CrossSystem.isSelectionAllTrigger(ks);
    }

    protected boolean isSelectionDownTrigger(KeyStroke ks) {
        return CrossSystem.isSelectionDownTrigger(ks);
    }

    protected boolean isSelectionUpTrigger(KeyStroke ks) {
        return CrossSystem.isSelectionUpTrigger(ks);
    }

    @Override
    public boolean isTooltipDisabledUntilNextRefocus() {
        return false;
    }

    @Override
    public boolean isTooltipWithoutFocusEnabled() {
        return false;
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, E contextObject, List<E> selection, ExtColumn<E> column, MouseEvent mouseEvent) {
        return null;
    }

    protected boolean onDoubleClick(MouseEvent e, E obj) {
        return false;
    }

    protected boolean onHeaderSortClick(MouseEvent e, ExtColumn<E> oldColumn, String oldIdentifier, ExtColumn<E> newColumn) {
        return false;
    }

    protected boolean onRenameClick(MouseEvent e, E obj) {
        return false;
    }

    protected void onSelectionChanged() {
    }

    protected boolean isWrapAroundEnabled() {
        return true;
    }

    protected boolean onShortcutCopy(List<E> selectedObjects, KeyEvent evt) {
        return false;
    }

    protected boolean onShortcutCut(List<E> selectedObjects, KeyEvent evt) {
        return false;
    }

    protected boolean onShortcutDelete(List<E> selectedObjects, KeyEvent evt, boolean direct) {
        return false;
    }

    protected boolean onShortcutPaste(List<E> selectedObjects, KeyEvent evt) {
        return false;
    }

    protected boolean onShortcutSearch(List<E> selectedObjects, KeyEvent evt) {
        if (this.isSearchEnabled() && this.hasFocus()) {
            this.startSearch();
            return true;
        }
        return false;
    }

    protected boolean onSingleClick(MouseEvent e, E obj) {
        return false;
    }

    protected void onSortHeaderClick(MouseEvent e) {
        String oldIdentifier;
        int col = this.getExtColumnModelIndexByPoint(e.getPoint());
        if (col == -1) {
            return;
        }
        ExtColumn oldColumn = ((ExtTableModel)this.getModel()).getSortColumn();
        String string = oldIdentifier = oldColumn == null ? null : oldColumn.getSortOrderIdentifier();
        if (!this.onHeaderSortClick(e, oldColumn, oldIdentifier, ((ExtTableModel)this.getModel()).getExtColumnByModelIndex(col)) && ((ExtTableModel)this.getModel()).getExtColumnByModelIndex(col).isSortable(null)) {
            this.doSortOnColumn(((ExtTableModel)this.getModel()).getExtColumnByModelIndex(col), e);
        }
        this.eventSender.fireEvent(new ExtTableEvent<MouseEvent>(this, ExtTableEvent.Types.SORT_HEADER_CLICK, e));
    }

    public boolean isResizeableColumns() {
        return true;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.handleCellHeightProviders(g)) {
            this.paintHighlighters(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleCellHeightProviders(Graphics g) {
        ArrayList<CellHeightProvider> providers = this.ensureCellHeightProviders();
        if (providers == null) {
            if (this.getRowHeight() != this.defaultRowHeight) {
                this.setRowHeight(this.defaultRowHeight);
            }
            return false;
        }
        this.dontDoRightNow = true;
        boolean repaintRequired = false;
        try {
            boolean anyThingNonDefault = false;
            for (int i = 0; i < this.getRowCount(); ++i) {
                int height = this.defaultRowHeight;
                for (CellHeightProvider p : providers) {
                    if (!((ExtTableModel)this.getModel()).isColumnVisible((ExtColumn)((Object)p))) continue;
                    height = p.adjustRowHeight(i, height);
                }
                int is = this.getRowHeight(i);
                if (height == is) {
                    if (height == this.defaultRowHeight) continue;
                    anyThingNonDefault = true;
                    continue;
                }
                repaintRequired = true;
                if (height != this.defaultRowHeight) {
                    anyThingNonDefault = true;
                }
                this.setRowHeight(i, height);
                System.out.println(i + " - " + height);
            }
            if (!anyThingNonDefault) {
                this.setRowHeight(this.defaultRowHeight);
            }
            boolean bl = repaintRequired;
            return bl;
        }
        finally {
            this.dontDoRightNow = false;
            if (repaintRequired) {
                this.resizeAndRepaint();
            }
        }
    }

    private void paintHighlighters(Graphics g) {
        if (this.getRowCount() == 0) {
            return;
        }
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle first = this.getCellRect(0, 0, true);
        Rectangle last = this.getCellRect(0, this.getColumnCount() - 1, true);
        int width = last.x + last.width - first.x;
        for (ExtOverlayRowHighlighter rh : this.rowHighlighters) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                first = this.getCellRect(i, 0, true);
                if (first.y + first.height < visibleRect.y || first.y > visibleRect.y + visibleRect.height || !rh.doHighlight(this, i)) continue;
                rh.paint((Graphics2D)g, 0, first.y, width, first.height - 1);
            }
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
        if (evt.getModifiers() == 0 && evt.getKeyCode() == 525 && !pressed) {
            int viewportHeight;
            Object contextObject = ((ExtTableModel)this.getModel()).getObjectbyRow(this.getSelectedRow());
            List selectedObjects = ((ExtTableModel)this.getModel()).getSelectedObjects();
            ExtColumn firstColumn = ((ExtTableModel)this.getModel()).getExtColumnByModelIndex(0);
            Point point = new Point(firstColumn.getWidth() / 2, 0);
            int scrollPosition = -this.getY();
            JViewport viewport = this.getParent() instanceof JViewport ? (JViewport)this.getParent() : null;
            int n = viewportHeight = viewport == null ? this.getHeight() : viewport.getHeight();
            if (this.getSelectedRow() == -1) {
                point.y = this.getRowCount() * this.rowHeight;
                point.y = point.y + (this.rowHeight - 1) / 2 < viewportHeight ? (point.y += (this.rowHeight - 1) / 2) : (point.y < viewportHeight ? (point.y += (viewportHeight - point.y) / 2) : scrollPosition + (viewportHeight - 1) / 2);
            } else {
                int[] selectedRows = this.getSelectedRows();
                int upperY = Math.max(selectedRows[0] * this.rowHeight, scrollPosition);
                upperY = Math.min(upperY, scrollPosition + viewportHeight - 1);
                int lowerY = Math.max((selectedRows[selectedRows.length - 1] + 1) * this.rowHeight - 1, scrollPosition);
                lowerY = Math.min(lowerY, scrollPosition + viewportHeight - 1);
                point.y = (upperY + lowerY) / 2;
            }
            Point absolutePoint = (Point)point.clone();
            SwingUtilities.convertPointToScreen(absolutePoint, this);
            MouseEvent mouseEvent = new MouseEvent(this, 502, evt.getWhen(), 0, point.x, point.y, absolutePoint.x, absolutePoint.y, 1, true, 3);
            JPopupMenu menu = this.onContextMenu(new JPopupMenu(), contextObject, selectedObjects, firstColumn, mouseEvent);
            this.showPopup(menu, point);
            return true;
        }
        if (evt.isControlDown() && evt.getKeyCode() == 36) {
            return false;
        }
        if (evt.isControlDown() && evt.getKeyCode() == 35) {
            return false;
        }
        if (evt.getModifiers() == 1 && evt.getKeyCode() == 36 && pressed && this.getSelectionModel().getSelectionMode() != 0) {
            this.changeSelection(0, 0, false, true);
            return true;
        }
        if (evt.getModifiers() == 1 && evt.getKeyCode() == 35 && pressed && this.getSelectionModel().getSelectionMode() != 0) {
            this.changeSelection(this.getRowCount() - 1, 0, false, true);
            return true;
        }
        if (!evt.isControlDown() && evt.getKeyCode() == 10 && pressed) {
            int leadRow = this.getSelectionModel().getLeadSelectionIndex();
            int leadColumn = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (leadRow != -1 && leadColumn != -1 && !this.isEditing()) {
                return this.editCellAt(leadRow, leadColumn, evt);
            }
        }
        if (!pressed) {
            return super.processKeyBinding(stroke, evt, condition, pressed);
        }
        KeyStroke ks = stroke;
        if (ks != null) {
            if (this.isClearSelectionTrigger(ks)) {
                this.clearSelection();
                return true;
            }
            if (this.isCutSelectionTrigger(ks)) {
                this.eventSender.fireEvent(new ExtTableEvent<List>(this, ExtTableEvent.Types.SHORTCUT_CUT, ((ExtTableModel)this.getModel()).getSelectedObjects()));
                return this.onShortcutCut(((ExtTableModel)this.getModel()).getSelectedObjects(), evt);
            }
            if (this.isPasteSelectionTrigger(ks)) {
                this.eventSender.fireEvent(new ExtTableEvent<List>(this, ExtTableEvent.Types.SHORTCUT_PASTE, ((ExtTableModel)this.getModel()).getSelectedObjects()));
                return this.onShortcutPaste(((ExtTableModel)this.getModel()).getSelectedObjects(), evt);
            }
            if (this.isCopySelectionTrigger(ks)) {
                this.eventSender.fireEvent(new ExtTableEvent<List>(this, ExtTableEvent.Types.SHORTCUT_COPY, ((ExtTableModel)this.getModel()).getSelectedObjects()));
                return this.onShortcutCopy(((ExtTableModel)this.getModel()).getSelectedObjects(), evt);
            }
            if (this.isDeleteFinalSelectionTrigger(ks)) {
                this.eventSender.fireEvent(new ExtTableEvent<Object>(this, ExtTableEvent.Types.SHORTCUT_DELETE, ((ExtTableModel)this.getModel()).getSelectedObjects(), BinaryLogic.containsSome(evt.getModifiers(), 1)));
                return this.onShortcutDelete(((ExtTableModel)this.getModel()).getSelectedObjects(), evt, true);
            }
            if (this.isDeleteSelectionTrigger(ks)) {
                this.eventSender.fireEvent(new ExtTableEvent<Object>(this, ExtTableEvent.Types.SHORTCUT_DELETE, ((ExtTableModel)this.getModel()).getSelectedObjects(), BinaryLogic.containsSome(evt.getModifiers(), 1)));
                return this.onShortcutDelete(((ExtTableModel)this.getModel()).getSelectedObjects(), evt, false);
            }
            if (this.isSearchTrigger(ks)) {
                this.eventSender.fireEvent(new ExtTableEvent<List>(this, ExtTableEvent.Types.SHORTCUT_SEARCH, ((ExtTableModel)this.getModel()).getSelectedObjects()));
                return this.onShortcutSearch(((ExtTableModel)this.getModel()).getSelectedObjects(), evt);
            }
            if (this.isSelectionUpTrigger(ks) && this.isWrapAroundEnabled() && this.getSelectedRow() == 0) {
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                this.changeSelection(this.getRowCount() - 1, 0, false, false);
                return true;
            }
            if (this.isSelectionDownTrigger(ks) && this.isWrapAroundEnabled() && this.getSelectedRow() == this.getRowCount() - 1) {
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                this.changeSelection(0, 0, false, false);
                return true;
            }
            if (this.isSelectionAllTrigger(ks)) {
                this.onShortcutSelectAll();
                return true;
            }
            if (ks.equals(KEY_STROKE_CTRL_HOME)) {
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                if (this.getSelectedRow() != -1 && this.getRowCount() != 0) {
                    this.getSelectionModel().setSelectionInterval(0, this.getSelectedRows()[this.getSelectedRows().length - 1]);
                    return true;
                }
            }
            if (ks.equals(KEY_STROKE_CTRL_END)) {
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                if (this.getSelectedRow() != -1 && this.getRowCount() != 0) {
                    this.getSelectionModel().setSelectionInterval(this.getSelectedRow(), this.getRowCount() - 1);
                    return true;
                }
            }
            if (ks.equals(KEY_STROKE_END)) {
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                if (this.getRowCount() != 0) {
                    int index = this.getRowCount() - 1;
                    this.getSelectionModel().setSelectionInterval(index, index);
                }
            }
            if (ks.equals(KEY_STROKE_HOME)) {
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
                if (this.getRowCount() != 0) {
                    this.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        }
        return super.processKeyBinding(stroke, evt, condition, pressed);
    }

    public void onShortcutSelectAll() {
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        this.getSelectionModel().setSelectionInterval(0, this.getRowCount() - 1);
    }

    protected void showPopup(JPopupMenu popup, Point p) {
        popup.show(this, p.x, p.y);
    }

    @Override
    protected void processMouseEvent(final MouseEvent e) {
        if (e.getID() == 502) {
            if (CrossSystem.isContextMenuTrigger(e)) {
                int row = this.rowAtPoint(e.getPoint());
                Object obj = ((ExtTableModel)this.getModel()).getObjectbyRow(row);
                ExtColumn<E> col = this.getExtColumnAtPoint(e.getPoint());
                if (obj == null || row == -1) {
                    this.clearSelection();
                    JPopupMenu popup = this.onContextMenu(new JPopupMenu(), null, null, col, e);
                    if (popup != null) {
                        this.eventSender.fireEvent(new ExtTableEvent<JPopupMenu>(this, ExtTableEvent.Types.CONTEXTMENU, popup));
                        if (popup.getComponentCount() > 0) {
                            this.showPopup(popup, e.getPoint());
                            return;
                        }
                    }
                } else {
                    List selected;
                    JPopupMenu popup;
                    if (!this.isRowSelected(row)) {
                        this.clearSelection();
                        this.addRowSelectionInterval(row, row);
                    }
                    if ((popup = this.onContextMenu(new JPopupMenu(), obj, selected = ((ExtTableModel)this.getModel()).getSelectedObjects(), col, e)) != null && popup.getComponentCount() > 0) {
                        this.showPopup(popup, e.getPoint());
                        return;
                    }
                }
            }
        } else if (e.getID() == 500) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                int row = this.rowAtPoint(e.getPoint());
                Object obj = ((ExtTableModel)this.getModel()).getObjectbyRow(row);
                this.renameClickDelayer.stop();
                boolean ret = false;
                if (obj != null) {
                    ExtColumn col = this.getExtColumnAtPoint(e.getPoint());
                    if (col != null) {
                        ret = col.onDoubleClick(e, obj);
                    }
                    if (!ret) {
                        ret = this.onDoubleClick(e, obj);
                        this.eventSender.fireEvent(new ExtTableEvent<Object>(this, ExtTableEvent.Types.DOUBLECLICK, obj));
                    }
                }
                if (ret) {
                    return;
                }
            } else if (e.getButton() == 1 && e.getClickCount() == 1) {
                int row = this.rowAtPoint(e.getPoint());
                Object obj = ((ExtTableModel)this.getModel()).getObjectbyRow(row);
                boolean ret = false;
                if (obj != null) {
                    ExtColumn col = this.getExtColumnAtPoint(e.getPoint());
                    if (col != null) {
                        ret = col.onSingleClick(e, obj);
                    }
                    if (!ret) {
                        ret = this.onSingleClick(e, obj);
                    }
                    if (ret) {
                        return;
                    }
                    if (this.clickDelayerRunable != null) {
                        this.renameClickDelayer.resetAndStart();
                    }
                }
            }
        } else if (e.getID() == 501) {
            final int row = this.rowAtPoint(e.getPoint());
            if (row < 0) {
                this.clearSelection();
            } else if (e.getClickCount() == 1 && e.getButton() == 1) {
                final Object obj = ((ExtTableModel)this.getModel()).getObjectbyRow(row);
                boolean ret = false;
                if (obj != null) {
                    int[] slRows;
                    final ExtColumn col = this.getExtColumnAtPoint(e.getPoint());
                    if (col != null) {
                        ret = col.onMousePressed(e, obj);
                    }
                    if (!ret) {
                        ret = this.onMousePressed(e, obj);
                    }
                    if (!ret && (slRows = this.getSelectedRows()).length == 1 && row == slRows[0] && obj != null && col != null) {
                        this.clickDelayerRunable = new Runnable(){

                            @Override
                            public void run() {
                                new EDTRunner(){

                                    @Override
                                    protected void runInEDT() {
                                        Point mousePosition;
                                        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                                        if (pointerInfo != null) {
                                            mousePosition = pointerInfo.getLocation();
                                            SwingUtilities.convertPointFromScreen(mousePosition, ExtTable.this);
                                        } else {
                                            mousePosition = null;
                                        }
                                        if (mousePosition != null) {
                                            int rowNow = ExtTable.this.rowAtPoint(mousePosition);
                                            if (rowNow != row) {
                                                return;
                                            }
                                            ExtColumn colNow = ExtTable.this.getExtColumnAtPoint(mousePosition);
                                            if (col != colNow) {
                                                return;
                                            }
                                            if (((ExtTableModel)ExtTable.this.getModel()).getObjectbyRow(rowNow) != obj) {
                                                return;
                                            }
                                        }
                                        if (!ExtTable.this.getSelectionModel().isSelectedIndex(row)) {
                                            return;
                                        }
                                        if (!col.onRenameClick(e, obj)) {
                                            ExtTable.this.onRenameClick(e, obj);
                                        }
                                        ExtTable.this.setDispatchComponent(e);
                                        TableCellEditor ce = ExtTable.this.getCellEditor();
                                        if (ce != null) {
                                            ce.shouldSelectCell(e);
                                        }
                                    }
                                };
                            }
                        };
                    }
                }
            }
        }
        super.processMouseEvent(e);
    }

    public boolean onMousePressed(MouseEvent e, E obj) {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JTable.DropLocation newLoc;
        JTable.DropLocation oldLoc;
        if ("dropLocation".equals(evt.getPropertyName()) && !this.dropLocationSame(oldLoc = (JTable.DropLocation)evt.getOldValue(), newLoc = (JTable.DropLocation)evt.getNewValue())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtTable.this.repaint();
                }
            });
        }
    }

    protected void reconfigureColumnButton() {
        Container c2;
        Container c1 = this.getParent();
        if (c1 instanceof JViewport && (c2 = c1.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)c2;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (this.isColumnButtonVisible()) {
                this.verticalScrollPolicy = scrollPane.getVerticalScrollBarPolicy();
                scrollPane.setCorner("UPPER_TRAILING_CORNER", this.getColumnButton());
                scrollPane.setVerticalScrollBarPolicy(22);
            } else {
                if (this.verticalScrollPolicy != 0) {
                    scrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
                }
                try {
                    scrollPane.setCorner("UPPER_TRAILING_CORNER", null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void removeRowHighlighter(ExtOverlayRowHighlighter highlighter) {
        this.rowHighlighters.remove(highlighter);
    }

    public void resetColumnDimensions() {
        for (ExtColumn col : ((ExtTableModel)this.getModel()).getColumns()) {
            try {
                this.getStorage().put(this.getColumnStoreKey("WIDTH_COL_", col.getID()), col.getDefaultWidth());
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
    }

    public void resetColumnLocks() {
        for (ExtColumn col : ((ExtTableModel)this.getModel()).getColumns()) {
            this.getStorage().put("ColumnWidthLocked_" + this.getColumnSaveID() + col.getID(), !col.isDefaultResizable());
        }
    }

    public void resetColumnOrder() {
        for (int i = 0; i < ((ExtTableModel)this.getModel()).getColumns().size(); ++i) {
            ExtColumn col = ((ExtTableModel)this.getModel()).getColumns().get(i);
            try {
                this.getStorage().put(this.getColumnStoreKey("POS_COL_", i), col.getID());
                continue;
            }
            catch (Exception e1) {
                LogV3.log(e1);
            }
        }
    }

    public void resetColumnVisibility() {
        for (ExtColumn col : ((ExtTableModel)this.getModel()).getColumns()) {
            try {
                this.getStorage().put(this.getColumnStoreKey("VISABLE_COL_", col.getID()), col.isDefaultVisible());
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
    }

    public void saveWidthsRatio() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            ExtColumn col = ((ExtTableModel)this.getModel()).getExtColumnByModelIndex(this.convertColumnIndexToModel(i));
            try {
                col.getTableColumn().setPreferredWidth(col.getTableColumn().getWidth());
                this.getStorage().put(this.getColumnStoreKey("WIDTH_COL_", col.getID()), col.getTableColumn().getWidth());
                continue;
            }
            catch (Exception e) {
                LogV3.log(e);
            }
        }
    }

    public void scrollToRow(final int row, final int preferedXPosition) {
        if (row < 0) {
            return;
        }
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                JViewport viewport = (JViewport)ExtTable.this.getParent();
                if (viewport == null) {
                    return null;
                }
                Rectangle rect = ExtTable.this.getCellRect(row, 0, true);
                Rectangle viewRect = viewport.getViewRect();
                rect.width = viewRect.width;
                rect.height = viewRect.height;
                rect.x = preferedXPosition < 0 ? viewRect.x : preferedXPosition;
                ExtTable.this.scrollRectToVisible(rect);
                return null;
            }
        }.start();
    }

    public void scrollToSelection(final int preferedXPosition) {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                JViewport viewport = (JViewport)ExtTable.this.getParent();
                if (viewport == null) {
                    return null;
                }
                int[] sel = ExtTable.this.getSelectedRows();
                if (sel == null || sel.length == 0) {
                    return null;
                }
                Rectangle rect = ExtTable.this.getCellRect(sel[0], 0, true);
                Rectangle rect2 = ExtTable.this.getCellRect(sel[sel.length - 1], 0, true);
                rect.height += rect2.y - rect.y;
                Rectangle viewRect = viewport.getViewRect();
                rect.width = viewRect.width;
                rect.x = preferedXPosition < 0 ? viewRect.x : preferedXPosition;
                ExtTable.this.scrollRectToVisible(rect);
                return null;
            }
        }.start();
    }

    public void setColumnBottonVisibility(boolean visible) {
        this.columnButtonVisible = visible;
        this.reconfigureColumnButton();
    }

    public void setColumnButton(JComponent c) {
        this.columnButton = c;
        this.reconfigureColumnButton();
    }

    public void setColumnSaveID(String columnSaveID) {
        if (columnSaveID == null) {
            columnSaveID = DEFAULT_COLUMN_STORE;
        }
        this.columnSaveID = columnSaveID;
        this.updateColumns();
    }

    private void setDispatchComponent(MouseEvent e) {
        Component editorComponent = this.getEditorComponent();
        if (editorComponent != null) {
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(this, p, editorComponent);
            Component dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
            if (dispatchComponent != null) {
                SwingUtilities2Wrapper.setSkipClickCount(dispatchComponent, e.getClickCount() - 1);
                MouseEvent e2 = SwingUtilities.convertMouseEvent(this, e, dispatchComponent);
                dispatchComponent.dispatchEvent(e2);
            }
        }
    }

    public void setSearchEnabled(boolean searchEnabled) {
        this.searchEnabled = searchEnabled;
    }

    public void setTransferHandler(ExtTransferHandler<E> newHandler) {
        newHandler.setTable(this);
        super.setTransferHandler(newHandler);
    }

    protected long setupRenameClickInterval() {
        return 500L;
    }

    public synchronized void startSearch() {
        if (this.searchDialog != null && this.searchDialog.isShowing()) {
            this.searchDialog.requestFocus();
        } else {
            this.searchDialog = new SearchDialog(1, this){
                private static final long serialVersionUID = 2652101312418765845L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    String ret = ExtTable.this.searchDialog.getReturnID();
                    if (ret != null) {
                        int[] sel = ExtTable.this.getSelectedRows();
                        int startRow = -1;
                        if (sel != null & sel.length > 0) {
                            startRow = sel[sel.length - 1];
                        }
                        Object found = ((ExtTableModel)ExtTable.this.getModel()).searchNextObject(startRow + 1, ret, ExtTable.this.searchDialog.isCaseSensitive(), ExtTable.this.searchDialog.isRegex());
                        ((ExtTableModel)ExtTable.this.getModel()).setSelectedObject(found);
                        ExtTable.this.scrollToSelection(-1);
                    }
                }
            };
        }
    }

    public void updateColumns() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ExtTable.this.createColumns();
                ExtTable.this.revalidate();
                ExtTable.this.repaint();
                if (ExtTable.this.fireTableStructureChangedOnUpdateColumns()) {
                    ((AbstractTableModel)ExtTable.this.getModel()).fireTableStructureChanged();
                }
            }
        };
    }

    protected boolean fireTableStructureChangedOnUpdateColumns() {
        return false;
    }

    @Override
    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        int row = this.getRowIndexByPoint(e.getPoint());
        ExtColumn<E> col = this.getExtColumnAtPoint(e.getPoint());
        return this.lastTooltipCol != col || this.lastTooltipRow != row;
    }

    public boolean isColumnLockingFeatureEnabled() {
        return true;
    }
}

