/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.appwork.loggingv3.LogV3;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.ToolTip;
import org.appwork.swing.exttable.columnmenu.LockColumnWidthAction;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;

public abstract class ExtColumn<E>
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    protected static Color background = null;
    protected static Color backgroundselected = null;
    protected static Color foreground = null;
    protected static Color foregroundselected = null;
    private static final long serialVersionUID = -2662459732650363059L;
    protected static final Border DEFAULT_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    private int clickcount = 2;
    private ExtTableModel<E> model;
    private final String name;
    private static Thread sortThread = null;
    private static Object sortLOCK = new Object();
    protected ExtDefaultRowSorter<E> rowSorter;
    private String id;
    private TableColumn tableColumn;
    private String sortOrderIdentifier;
    protected final ToolTip tooltip;
    private boolean editableProgrammaticly = false;
    public static final String SORT_DESC = "DESC";
    public static final String SORT_ASC = "ASC";
    protected volatile boolean modifying = false;
    private int forcedWidth = -1;

    public ExtColumn(String name, ExtTableModel<E> table) {
        this.name = name;
        this.model = table;
        this.sortOrderIdentifier = null;
        this.id = this.generateID();
        this.rowSorter = new ExtDefaultRowSorter();
        this.tooltip = new ToolTip();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getModel().getModelID() + "." + this.getName();
    }

    public int calculateMinimumHeaderWidth() {
        TableColumn tableColumn = this.getTableColumn();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getModel().getTable().createDefaultHeaderRenderer(this);
        }
        Component component = renderer.getTableCellRendererComponent(this.getModel().getTable(), this.getName(), false, false, -1, 2);
        Dimension pref = component.getPreferredSize();
        if (this.getModel() != null) {
            pref.width += Math.max(this.getModel().createSortASCIcon().getIconWidth(), this.getModel().createSortDESCIcon().getIconWidth());
        }
        return pref.width;
    }

    protected void repaint() {
        ExtTableModel<E> model = this.getModel();
        if (model == null) {
            return;
        }
        ExtTable<E> table = model.getTable();
        if (table == null) {
            return;
        }
        Rectangle visibleRect = table.getVisibleRect();
        Rectangle first = table.getCellRect(0, this.getIndex(), true);
        int w = this.getWidth() - Math.max(0, visibleRect.x - first.x);
        if (w > 0) {
            table.repaint(Math.max(first.x, visibleRect.x), visibleRect.y, w, visibleRect.height);
        }
    }

    protected void adaptHighlighters(E value, JComponent comp, boolean isSelected, boolean hasFocus, int row) {
        try {
            List<ExtComponentRowHighlighter<E>> hs = this.getModel().getExtComponentRowHighlighters();
            SwingUtils.setOpaque(comp, false);
            comp.setBackground(this.getDefaultBackground());
            comp.setForeground(this.getDefaultForeground());
            for (ExtComponentRowHighlighter<E> rh : hs) {
                if (!rh.highlight(this, comp, value, isSelected, hasFocus, row)) continue;
            }
        }
        catch (Throwable e) {
            LogV3.log(e);
        }
    }

    protected Color getDefaultForeground() {
        return null;
    }

    protected Color getDefaultBackground() {
        return null;
    }

    protected void configureCurrentlyEditingComponent(E value, boolean isSelected, int row, int column) {
    }

    public abstract void configureEditorComponent(E var1, boolean var2, int var3, int var4);

    public void configureEditorHighlighters(JComponent component, E value, boolean isSelected, int row) {
        this.adaptHighlighters(value, component, isSelected, true, row);
    }

    public abstract void configureRendererComponent(E var1, boolean var2, boolean var3, int var4, int var5);

    public void configureRendererHighlighters(JComponent component, E value, boolean isSelected, boolean hasFocus, int row) {
        this.adaptHighlighters(value, component, isSelected, hasFocus, row);
    }

    public JPopupMenu createHeaderPopup() {
        if (this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0) {
            return null;
        }
        JPopupMenu ret = new JPopupMenu();
        if (this.getModel().getTable().isColumnLockingFeatureEnabled()) {
            ret.add(new JCheckBoxMenuItem(new LockColumnWidthAction(this)));
            ret.add(new JSeparator());
        }
        return ret;
    }

    public ExtTooltip createToolTip(Point position, E obj) {
        String txt = this.getTooltipText(obj);
        if (txt == null || txt.length() == 0) {
            return null;
        }
        this.tooltip.setTipText(txt);
        return this.tooltip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSort() {
        final String newID = this.getNextSortIdentifier();
        System.out.println("Sort: " + newID);
        Object object = sortLOCK;
        synchronized (object) {
            if (sortThread != null && sortThread.isAlive()) {
                return;
            }
            sortThread = new Thread("TableSorter " + this.getID()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Integer sel = (Integer)new EDTHelper<Integer>(){

                            @Override
                            public Integer edtRun() {
                                Container p = ExtColumn.this.getModel().getTable().getParent();
                                if (p == null || !(p instanceof JViewport)) {
                                    return 0;
                                }
                                JViewport viewport = (JViewport)p;
                                Rectangle rec = viewport.getViewRect();
                                return ExtColumn.this.getModel().getTable().rowAtPoint(new Point(0, (int)(rec.getY() + 15.0)));
                            }
                        }.getReturnValue();
                        final Rectangle view = (Rectangle)new EDTHelper<Rectangle>(){

                            @Override
                            public Rectangle edtRun() {
                                Container p = ExtColumn.this.getModel().getTable().getParent();
                                if (p == null || !(p instanceof JViewport)) {
                                    return null;
                                }
                                JViewport viewport = (JViewport)p;
                                Rectangle rec = viewport.getViewRect();
                                return rec;
                            }
                        }.getReturnValue();
                        Object selObject = ExtColumn.this.getModel().getObjectbyRow(sel);
                        List data = ExtColumn.this.model.getElements();
                        try {
                            ExtColumn.this.setSortOrderIdentifier(newID);
                            ExtColumn.this.getModel().setSortColumn(ExtColumn.this);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ExtColumn.this.getModel()._fireTableStructureChanged(data, true);
                        if (view != null) {
                            new EDTHelper<Object>(){

                                @Override
                                public Object edtRun() {
                                    ExtColumn.this.getModel().getTable().getTableHeader().repaint();
                                    if (ExtColumn.this.getModel().getTable().getSelectedRowCount() > 0) {
                                        ExtColumn.this.getModel().getTable().scrollToSelection(view.x);
                                    } else {
                                        ExtColumn.this.getModel().getTable().scrollToRow(0, view.x);
                                    }
                                    return null;
                                }
                            }.waitForEDT();
                        }
                    }
                    finally {
                        Object object = sortLOCK;
                        synchronized (object) {
                            sortThread = null;
                        }
                    }
                }
            };
            sortThread.start();
        }
    }

    public void extendControlButtonMenu(JPopupMenu popup) {
    }

    protected String generateID() {
        return this.getClass().getSuperclass().getSimpleName() + "." + this.getClass().getName();
    }

    public Rectangle getBounds() {
        Rectangle first = this.getModel().getTable().getCellRect(0, this.getIndex(), true);
        Rectangle last = this.getModel().getTable().getCellRect(this.getModel().getRowCount() - 1, this.getIndex(), true);
        first.height = last.y + last.height - first.y;
        return first;
    }

    @Override
    public abstract Object getCellEditorValue();

    public int getClickcount() {
        return this.clickcount;
    }

    public int getDefaultWidth() {
        return 100;
    }

    public abstract JComponent getEditorComponent(E var1, boolean var2, int var3, int var4);

    public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
        return null;
    }

    public String getID() {
        return this.id;
    }

    public int getIndex() {
        return this.getModel().getTable().convertColumnIndexToView(this.tableColumn.getModelIndex());
    }

    public int getMaxWidth() {
        return -1;
    }

    public int getMinWidth() {
        return 10;
    }

    public ExtTableModel<E> getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    protected String getNextSortIdentifier() {
        return this.getModel().getNextSortIdentifier(this.getSortOrderIdentifier());
    }

    public abstract JComponent getRendererComponent(E var1, boolean var2, boolean var3, int var4, int var5);

    public ExtDefaultRowSorter<E> getRowSorter() {
        this.rowSorter.setSortOrderIdentifier(this.getSortOrderIdentifier());
        return this.rowSorter;
    }

    public Icon getSortIcon() {
        return this.getModel().getSortIcon(this.getSortOrderIdentifier());
    }

    public String getSortOrderIdentifier() {
        return this.sortOrderIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getTableCellEditorComponent(JTable table, E value, boolean isSelected, int row, int column, boolean editing) {
        try {
            this.modifying = true;
            JComponent ret = this.getEditorComponent(value, isSelected, row, column);
            this.resetEditor();
            SwingUtils.setOpaque(ret, false);
            ret.setBackground(null);
            this.configureEditorHighlighters(ret, value, isSelected, row);
            if (editing) {
                this.configureCurrentlyEditingComponent(value, isSelected, row, column);
            } else {
                this.configureEditorComponent(value, isSelected, row, column);
            }
            ret.setEnabled(this.getModel().getTable().isEnabled() && this.isEnabled(value));
            JComponent jComponent = ret;
            return jComponent;
        }
        finally {
            this.modifying = false;
        }
    }

    @Override
    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.getTableCellEditorComponent(table, value, isSelected, row, column, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.modifying = true;
            JComponent ret = this.getRendererComponent(value, isSelected, hasFocus, row, column);
            this.resetRenderer();
            this.configureRendererHighlighters(ret, value, isSelected, hasFocus, row);
            this.configureRendererComponent(value, isSelected, hasFocus, row, column);
            ret.setEnabled(this.getModel().getTable().isEnabled() && this.isEnabled(value));
            JComponent jComponent = ret;
            return jComponent;
        }
        finally {
            this.modifying = false;
        }
    }

    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    protected String getTooltipText(E value) {
        return null;
    }

    public int getWidth() {
        return this.tableColumn.getWidth();
    }

    public void setWidth(int width) {
        this.tableColumn.setWidth(width);
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (this.editableProgrammaticly) {
            return true;
        }
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= this.getClickcount() && this.getClickcount() > 0;
        }
        return true;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        E obj = this.model.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            return false;
        }
        return this.isEditable(obj, this.isEnabled(obj));
    }

    protected boolean isDefaultResizable() {
        return true;
    }

    public boolean isDefaultVisible() {
        return true;
    }

    public abstract boolean isEditable(E var1);

    protected boolean isEditable(E obj, boolean enabled) {
        return enabled && this.isEditable(obj);
    }

    public abstract boolean isEnabled(E var1);

    public boolean isHidable() {
        return true;
    }

    public boolean isModifying() {
        return this.modifying;
    }

    public boolean isPaintHeaderText() {
        return true;
    }

    public boolean isPaintWidthLockIcon() {
        return true;
    }

    public boolean isResizable() {
        return this.getModel().getTable().isResizeableColumns() && (this.getModel().getTable().getColumnStore("ColumnWidthLocked_", this.getID(), !this.isDefaultResizable()) == false || !this.getModel().getTable().isColumnLockingFeatureEnabled());
    }

    public boolean isSelectRowWhenEditing(EventObject anEvent) {
        return true;
    }

    public abstract boolean isSortable(E var1);

    public boolean isVisible(boolean savedValue) {
        return savedValue;
    }

    public boolean matchSearch(E object, Pattern pattern) {
        return false;
    }

    public boolean onDoubleClick(MouseEvent e, E obj) {
        return false;
    }

    public boolean onRenameClick(MouseEvent e, E obj) {
        return false;
    }

    public boolean onSingleClick(MouseEvent e, E obj) {
        return false;
    }

    public abstract void resetEditor();

    public abstract void resetRenderer();

    public void setClickcount(int clickcount) {
        this.clickcount = Math.max(0, clickcount);
    }

    public void setModel(ExtTableModel<E> model) {
        this.model = model;
        this.generateID();
    }

    public void setResizable(boolean resizeAllowed) {
        this.getModel().getStorage().put(this.getModel().getTable().getColumnStoreKey("ColumnWidthLocked_", this.getID()), !resizeAllowed);
        this.updateColumnGui();
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ExtColumn.this.getModel().getTable().getTableHeader().repaint();
                ExtColumn.this.getModel().getTable().revalidate();
            }
        };
        this.getModel().getTable().fireColumnModelUpdate();
    }

    public Dimension getCellSizeEstimation(E element, int row) {
        Component c = this.getTableCellRendererComponent(this.getModel().getTable(), element, false, false, row, 1);
        return c.getPreferredSize();
    }

    public void setRowSorter(ExtDefaultRowSorter<E> rowSorter) {
        this.rowSorter = rowSorter;
    }

    public void setSortOrderIdentifier(String id) {
        this.sortOrderIdentifier = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableColumn(TableColumn tableColumn, boolean updateSize) {
        this.tableColumn = tableColumn;
        if (updateSize) {
            int w = this.getDefaultWidth();
            try {
                w = this.getModel().getTable().getColumnStore("WIDTH_COL_", this.getID(), w);
                int minw = this.getMinWidth();
                if (minw > 0 && w < minw) {
                    w = this.adjustWidth(w);
                }
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            finally {
                tableColumn.setPreferredWidth(w);
                tableColumn.setWidth(w);
            }
            this.updateColumnGui();
        }
        if (this.forcedWidth > 0) {
            tableColumn.setWidth(this.forcedWidth);
            tableColumn.setPreferredWidth(this.forcedWidth);
        }
    }

    protected int adjustWidth(int w) {
        return w;
    }

    public abstract void setValue(Object var1, E var2);

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        E obj = this.model.getValueAt(rowIndex, columnIndex);
        if (obj == null) {
            return;
        }
        this.setValue(value, obj);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.isSelectRowWhenEditing(anEvent);
    }

    public void startEditing(final E obj) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ExtColumn.this.editableProgrammaticly = true;
                try {
                    ExtColumn.this.getModel().getTable().editCellAt(((ExtTableModel)ExtColumn.this.getModel().getTable().getModel()).getRowforObject(obj), ExtColumn.this.getIndex());
                }
                finally {
                    ExtColumn.this.editableProgrammaticly = false;
                }
            }
        };
    }

    protected void updateColumnGui() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ExtColumn.this.getModel().getTable().saveWidthsRatio();
                ExtColumn.this.configureColumnWidth();
            }
        };
    }

    public String getHeaderTooltip() {
        if (this.isResizable()) {
            return _AWU.T.tableheader_tooltip_normal(this.getName());
        }
        return _AWU.T.tableheader_tooltip_locked(this.getName());
    }

    public boolean isPaintSortIcon() {
        return true;
    }

    public TableColumn getInternalColumn() {
        return this.tableColumn;
    }

    public boolean isAutoWidthEnabled() {
        return false;
    }

    public void setForcedWidth(int value) {
        this.forcedWidth = value;
        TableColumn in = this.getInternalColumn();
        if (in != null) {
            in.setWidth(value);
            in.setPreferredWidth(value);
        }
    }

    public int getForcedWidth() {
        if (!this.isResizable()) {
            return this.tableColumn.getWidth();
        }
        return this.forcedWidth;
    }

    public boolean onMousePressed(MouseEvent e, E obj) {
        return false;
    }

    public void onTableResized() {
        this.configureColumnWidth();
    }

    public void configureColumnWidth() {
        int max = this.getMaxWidth() < 0 ? Integer.MAX_VALUE : this.getMaxWidth();
        this.tableColumn.setMaxWidth(max);
        this.tableColumn.setMinWidth(this.getMinWidth() < 0 ? 15 : this.getMinWidth());
        this.tableColumn.setResizable(true);
    }
}

