/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.appwork.resources.AWUTheme;
import org.appwork.utils.ImageProvider.ImageProvider;

public final class RadioBoxIcon
implements Icon {
    public static final RadioBoxIcon FALSE = new RadioBoxIcon(false);
    public static final RadioBoxIcon TRUE = new RadioBoxIcon(true);
    public static final RadioBoxIcon UNDEFINED = new RadioBoxIcon(true, false);
    private final JRadioButton cb;
    private final JPanel panel;
    private final Icon internalIcon;
    private final int size;

    public RadioBoxIcon(final boolean selected, boolean enabled) {
        this.cb = new JRadioButton(){
            {
                this.setSelected(selected);
            }

            @Override
            public int getWidth() {
                return this.getPreferredSize().width;
            }

            @Override
            public int getHeight() {
                return this.getPreferredSize().height;
            }

            @Override
            public boolean isVisible() {
                return true;
            }
        };
        this.panel = new JPanel();
        this.panel.add(this.cb);
        this.size = 16;
        this.internalIcon = !enabled ? AWUTheme.I().getDisabledIcon(ImageProvider.toImageIcon(this)) : ImageProvider.toImageIcon(this);
    }

    public RadioBoxIcon(boolean selected) {
        this(selected, true);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.internalIcon != null) {
            this.internalIcon.paintIcon(c, g, x, y);
        } else {
            g = g.create(x, y, this.size, this.size);
            g.translate(-4, -4);
            this.cb.paint(g);
            g.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }
}

