/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.ExtTextHighlighter;
import org.appwork.swing.components.TextComponentInterface;
import org.appwork.utils.StringUtils;

public class ExtPasswordField
extends MigPanel
implements FocusListener,
DocumentListener,
TextComponentInterface,
ActionListener {
    private static final long serialVersionUID = 9035297840443317147L;
    public static String MASK = "\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022";
    protected final ExtTextField renderer;
    protected final JPasswordField editor;
    private boolean rendererMode;
    private char[] password = new char[0];
    private String mask = null;
    private final AtomicInteger modifier = new AtomicInteger(0);
    protected final CopyOnWriteArrayList<ExtTextHighlighter> highlighters = new CopyOnWriteArrayList();

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.renderer != null) {
            this.renderer.setBackground(bg);
        }
        if (this.editor != null) {
            this.editor.setBackground(bg);
        }
    }

    public ExtPasswordField() {
        super("ins 0", "[grow,fill]", "[grow,fill]");
        this.renderer = new CustomTextField();
        this.editor = new CustomPasswordField();
        this.renderer.addFocusListener(this);
        this.editor.addFocusListener(this);
        this.add((Component)this.renderer, "hidemode 3");
        this.add((Component)this.editor, "hidemode 3");
        this.editor.setText("");
        this.renderer.setText("");
        this.editor.getDocument().addDocumentListener(this);
        this.editor.addActionListener(this);
        this.renderer.setHelpText("");
        this.setRendererMode(true);
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExtPasswordField.this.applyTextHighlighter(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExtPasswordField.this.applyTextHighlighter(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExtPasswordField.this.applyTextHighlighter(e);
            }
        });
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.renderer.addKeyListener(l);
        this.editor.addKeyListener(l);
    }

    protected void applyTextHighlighter(DocumentEvent e) {
        Highlighter highlighter = this.editor.getHighlighter();
        highlighter.removeAllHighlights();
        CharSequence pw = new CharSequence(){
            final char[] pw;
            {
                this.pw = ExtPasswordField.this.editor.getPassword();
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return null;
            }

            @Override
            public int length() {
                return this.pw.length;
            }

            @Override
            public char charAt(int index) {
                return this.pw[index];
            }
        };
        for (ExtTextHighlighter textHighlighter : this.getTextHighlighter()) {
            textHighlighter.highlight(highlighter, pw);
        }
    }

    public List<ExtTextHighlighter> getTextHighlighter() {
        return this.highlighters;
    }

    public boolean addTextHighlighter(ExtTextHighlighter highlighter) {
        return highlighter != null && this.highlighters.addIfAbsent(highlighter);
    }

    public boolean removeTextHighlighter(ExtTextHighlighter highlighter) {
        return highlighter != null && this.highlighters.remove(highlighter);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.renderer.addMouseListener(l);
        this.editor.addMouseListener(l);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.modifier.get() == 0 && !Arrays.equals(this.editor.getPassword(), this.getMask().toCharArray())) {
            this.onChanged();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.renderer) {
            this.setRendererMode(false);
            this.editor.requestFocus();
        } else {
            if (this.password.length == 0) {
                this.setEditorText("");
            }
            this.editor.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.editor || e == null) {
            char[] mask;
            char[] pass = this.editor.getPassword();
            if (!Arrays.equals(pass, mask = this.getMask().toCharArray())) {
                this.password = pass;
            }
            this.setRendererMode(true);
            this.setHelpText(this.getHelpText());
        }
    }

    public Document getDocument() {
        return this.editor.getDocument();
    }

    @Override
    public Color getHelpColor() {
        return this.renderer.getHelpColor();
    }

    @Override
    public String getHelpText() {
        return this.renderer.getHelpText();
    }

    protected String getMask() {
        return this.mask != null ? this.mask : MASK;
    }

    public char[] getPassword() {
        char[] mask;
        char[] pass;
        if (this.editor.isVisible() && !Arrays.equals(pass = this.editor.getPassword(), mask = this.getMask().toCharArray())) {
            this.password = pass;
        }
        return this.password;
    }

    @Override
    public String getText() {
        char[] pass = this.getPassword();
        return pass == null ? null : new String(pass);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        char[] mask;
        char[] pass;
        if (this.modifier.get() == 0 && !Arrays.equals(pass = this.editor.getPassword(), mask = this.getMask().toCharArray())) {
            this.onChanged();
            if (pass.length > 0) {
                this.renderer.setText(this.getMask());
            } else {
                this.renderer.setText("");
            }
        }
    }

    @Override
    public void onChanged() {
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        this.renderer.removeKeyListener(l);
        this.editor.removeKeyListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.renderer.removeMouseListener(l);
        this.editor.removeMouseListener(l);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.modifier.get() == 0 && !Arrays.equals(this.editor.getPassword(), this.getMask().toCharArray())) {
            this.onChanged();
        }
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
    }

    private void setEditorText(String text) {
        this.modifier.incrementAndGet();
        try {
            this.editor.setText(text);
        }
        finally {
            this.modifier.decrementAndGet();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.editor.setEnabled(b);
        this.renderer.setEnabled(b);
        super.setEnabled(b);
    }

    @Override
    public void setHelpColor(Color helpColor) {
        this.renderer.setHelpColor(helpColor);
    }

    @Override
    public void setHelpText(String helpText) {
        this.renderer.setHelpText(helpText);
        char[] password = this.getPassword();
        if (this.getHelpText() != null && (password == null || password.length == 0 || this.getMask().equals(new String(password)))) {
            this.renderer.setText(this.getHelpText());
            this.renderer.setForeground(this.getHelpColor());
        } else {
            this.renderer.setText(this.getMask());
            this.renderer.setForeground(this.renderer.getDefaultColor());
        }
        this.setRendererMode(this.rendererMode);
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.renderer.requestFocusInWindow();
    }

    public void setPassword(char[] password) {
        this.password = password;
        this.setEditorText(new String(password));
        this.setHelpText(this.getHelpText());
        this.onChanged();
    }

    private void setRendererMode(boolean b) {
        this.rendererMode = b;
        this.renderer.setVisible(b &= this.getHelpText() != null);
        this.editor.setVisible(!b);
        this.revalidate();
    }

    @Override
    public void setText(String text) {
        this.setPassword(StringUtils.isEmpty(text) ? new char[]{} : text.toCharArray());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.onChanged();
    }

    public final class CustomPasswordField
    extends JPasswordField {
        private boolean key = false;

        @Override
        public void replaceSelection(String content) {
            if (this.key) {
                super.replaceSelection(content);
            } else {
                ExtPasswordField.this.setText(content);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            ExtPasswordField.this.dispatchEvent(e);
            if (e.isConsumed()) {
                return true;
            }
            this.key = true;
            try {
                boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                return bl;
            }
            finally {
                this.key = false;
            }
        }
    }

    public final class CustomTextField
    extends ExtTextField {
        @Override
        public void replaceSelection(String content) {
            ExtPasswordField.this.setText(content);
        }
    }
}

