/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.sunwrapper.sun.awt.shell;

import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.appwork.loggingv3.LogV3;
import org.appwork.sunwrapper.WrapperNotAvailableException;
import org.appwork.utils.DebugMode;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.images.IconIO;

public class ShellFolderWrapper {
    private static final FileSystemView view = FileSystemView.getFileSystemView();
    private static boolean shellFolderGetIconAccess = true;
    private static boolean shellFolderGetAccess = true;
    private static boolean shellFolderGetShellFolderAccess = true;

    public static Image getIcon(File file) throws WrapperNotAvailableException, FileNotFoundException {
        try {
            File shellFolder;
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            if (shellFolderGetIconAccess && ShellFolderWrapper.isInstanceof(shellFolder = ShellFolderWrapper.getShellFolder(file))) {
                return ReflectionUtils.invoke(shellFolder.getClass(), "getIcon", (Object)shellFolder, Image.class, true);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            shellFolderGetIconAccess = false;
            DebugMode.logInIDEOnly(LogV3.I().getLogger(ShellFolderWrapper.class.getName()), e);
        }
        Icon icon = view.getSystemIcon(file);
        if (icon != null) {
            return IconIO.toImage(icon);
        }
        return null;
    }

    public static File getShellFolderIfAvailable(File file) throws FileNotFoundException {
        return ShellFolderWrapper.getShellFolder(file);
    }

    public static boolean isInstanceof(File f) {
        return ReflectionUtils.isInstanceOf("sun.awt.shell.ShellFolder", f);
    }

    public static Object get(String key) {
        try {
            if ("roots".equals(key)) {
                return view.getRoots();
            }
            if ("fileChooserDefaultFolder".equals(key)) {
                return view.getDefaultDirectory();
            }
            if (JVMVersion.isMinimum(9000000000000L) && "fileChooserComboBoxFolders".equals(key)) {
                return ReflectionUtils.invoke(view.getClass(), "getChooserComboBoxFiles", (Object)view, File[].class, new Object[0]);
            }
            if (JVMVersion.isMinimum(12000000000000L) && "fileChooserShortcutPanelFolders".equals(key)) {
                return ReflectionUtils.invoke(view.getClass(), "getChooserShortcutPanelFiles", (Object)view, File[].class, new Object[0]);
            }
            if (shellFolderGetAccess) {
                return ReflectionUtils.invoke("sun.awt.shell.ShellFolder", "get", null, String.class, key);
            }
        }
        catch (InvocationTargetException e) {
            shellFolderGetAccess = false;
            DebugMode.logInIDEOnly(LogV3.I().getLogger(ShellFolderWrapper.class.getName()), e);
        }
        return null;
    }

    public static File getShellFolderViaFileSystem(File file) throws FileNotFoundException {
        if (ShellFolderWrapper.isInstanceof(file)) {
            return file;
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        File parent = view.getParentDirectory(file);
        if (parent != null) {
            boolean initialShellFolderInstanceCheck = true;
            File[] children = view.getFiles(parent, true);
            if (children != null && children.length > 0) {
                for (File child : children) {
                    if (initialShellFolderInstanceCheck) {
                        if (!ShellFolderWrapper.isInstanceof(child)) {
                            return null;
                        }
                        initialShellFolderInstanceCheck = false;
                    }
                    if (!child.equals(file)) continue;
                    if (ShellFolderWrapper.isInstanceof(child)) {
                        return child;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public static File getShellFolder(File file) throws FileNotFoundException {
        try {
            if (file == null) {
                return null;
            }
            if (ShellFolderWrapper.isInstanceof(file)) {
                return file;
            }
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            if (shellFolderGetShellFolderAccess) {
                return ReflectionUtils.invoke(FileSystemView.class, "getShellFolder", (Object)view, File.class, file);
            }
        }
        catch (InvocationTargetException e) {
            shellFolderGetShellFolderAccess = false;
            DebugMode.logInIDEOnly(LogV3.I().getLogger(ShellFolderWrapper.class.getName()), e);
        }
        File shellFolderViaFileSystem = ShellFolderWrapper.getShellFolderViaFileSystem(file);
        if (shellFolderViaFileSystem != null) {
            return shellFolderViaFileSystem;
        }
        return file;
    }
}

