/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.validator.classvalidator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.appwork.storage.FailLevel;
import org.appwork.storage.StorableValidator;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.validator.classvalidator.StorableAbstractValidator;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.reflection.CompiledType;

public class StorableValidURLValidator
extends StorableAbstractValidator {
    @Override
    public List<? extends StorableValidator.ValidatorException> validate(StorableValidator validator, Object root, Object value, FlexiJSonNode node, JSPath path, CompiledType type, String parameter, FailLevel level, String message) {
        ArrayList<InvalidHTTPURLException> ret = new ArrayList<InvalidHTTPURLException>();
        if (!(value instanceof String)) {
            ret.add(new InvalidHTTPURLException(validator, null, path, node, type, StringUtils.isEmpty(message) ? "The value must be a valid URL string" : message, level));
        }
        try {
            URL url = new URL((String)value);
            URLHelper.verifyURL(url);
        }
        catch (MalformedURLException e) {
            ret.add(new InvalidHTTPURLException(validator, e, path, node, type, StringUtils.isEmpty(message) ? "Malformed URL" : message, level));
        }
        return ret;
    }

    @Override
    public String getDocsDescription(String parameter, Object anno) {
        return "The value must be a valid URL string";
    }

    public static class InvalidHTTPURLException
    extends StorableValidator.ValidatorException {
        public InvalidHTTPURLException(StorableValidator validator, Throwable cause, JSPath path, FlexiJSonNode value, CompiledType targetType, String message, FailLevel failLevel) {
            super(validator, cause, path, value, targetType, message, failLevel);
        }
    }
}

