/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.JSonObject;
import org.appwork.storage.simplejson.JSonUtils;
import org.appwork.utils.StringUtils;

public class JsonObjectLinkedHashMap
extends LinkedHashMap<String, JSonNode>
implements JSonObject {
    protected String close = "\r\n}";
    protected String keyValueDeliminator = " : ";
    protected String empty = "{}";
    protected String open = "{\r\n";
    protected String fieldDeliminator = ",\r\n";
    public static String PRETTY_PRINT_LAYER_INSET = " ";
    private static final long serialVersionUID = 1L;

    public JsonObjectLinkedHashMap() {
    }

    public JsonObjectLinkedHashMap(Map<String, JSonNode> map) {
        super(map);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            Map.Entry next = it.next();
            sb.append(this.toStringKey((String)next.getKey()));
            sb.append(":");
            sb.append(((JSonNode)next.getValue()).toString());
        }
        sb.append("}");
        return sb.toString();
    }

    protected String toStringKey(String key) {
        return "\"" + JSonUtils.escape(key) + "\"";
    }

    @Override
    public String toPrettyString() {
        if (this.size() == 0) {
            return this.empty;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.open);
        int keyLength = 0;
        this.get(null);
        for (Map.Entry es : this.entrySet()) {
            keyLength = Math.max(JSonUtils.escape((String)es.getKey()).length() + 2, keyLength);
        }
        for (String key : this.getPrettyPrintKeys()) {
            if (sb.length() > 3) {
                sb.append(this.fieldDeliminator);
            }
            sb.append(PRETTY_PRINT_LAYER_INSET + StringUtils.fillPost(this.toStringKey(key), " ", keyLength));
            sb.append(this.keyValueDeliminator);
            String value = ((JSonNode)this.get(key)).toPrettyString();
            String[] lines = value.split("[\r\n]+");
            boolean first = true;
            if (lines.length > 1) {
                for (String line : lines) {
                    if (!first) {
                        sb.append("\r\n" + PRETTY_PRINT_LAYER_INSET + StringUtils.fillPre("", " ", keyLength + 3) + line);
                    } else {
                        sb.append(line);
                    }
                    first = false;
                }
                continue;
            }
            sb.append(value);
        }
        sb.append(this.close);
        return sb.toString();
    }

    protected List<String> getPrettyPrintKeys() {
        return new ArrayList<String>(this.keySet());
    }
}

