/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.appwork.storage.simplejson.NoNumberException;
import org.appwork.storage.simplejson.ParserException;
import org.appwork.utils.CharSequenceUtils;

public class JSonParser {
    private static final char[] CHAR_ARRAY_FALSE = "false".toCharArray();
    private static final char[] CHAR_ARRAY_TRUE = "true".toCharArray();
    private static final char[] CHAR_ARRAY_NULL = "null".toCharArray();
    public static boolean DEBUG = false;
    protected int global = 0;
    protected char c;
    public final String str;
    final StringBuilder sb;
    private final StringBuilder sb2;
    private int counter;
    private String debug;
    protected final boolean naNAllowed;
    private Token token;
    private final HashMap<String, String> DEDUPEMAP = new HashMap();

    public JSonParser(String json) {
        this(json, false);
    }

    public JSonParser(String json, boolean naNAllowed) {
        this.str = json;
        this.sb = new StringBuilder();
        this.sb2 = new StringBuilder();
        this.counter = 0;
        this.naNAllowed = naNAllowed;
    }

    protected ParserException bam(String expected, Object path) {
        return this.bam(expected, path, null);
    }

    protected ParserException bam(String expected, Object path, Throwable cause) {
        String pre = this.str.substring(Math.max(this.global - 20, 0), this.global);
        pre = pre.replace("\r", "\\r").replace("\n", "\\n");
        StringBuilder sb = new StringBuilder();
        sb.append(expected);
        sb.append("\r\n\t");
        sb.append(pre);
        sb.append(this.str.substring(this.global, Math.min(this.str.length(), this.global + 20)));
        sb.append("\r\n\t");
        for (int i = 1; i < pre.length(); ++i) {
            sb.append("-");
        }
        sb.append('|');
        return new ParserException(this.global, path, sb.toString(), cause);
    }

    protected String findString(Object path) throws ParserException {
        try {
            this.sb.setLength(0);
            this.c = this.charAt(path, this.global++);
            if (this.c != '\"') {
                this.throwParserException("'\"' expected", path);
                return null;
            }
            boolean escaped = false;
            block15: while (true) {
                this.c = this.charAt(path, this.global++);
                switch (this.c) {
                    case '\"': {
                        return this.sb.toString();
                    }
                    case '\\': {
                        escaped = true;
                        while ((this.c = this.charAt(path, this.global++)) == '\\') {
                            if (escaped = !escaped) continue;
                            this.sb.append("\\");
                        }
                        if (escaped) {
                            switch (this.c) {
                                case '\"': 
                                case '/': {
                                    this.sb.append(this.c);
                                    continue block15;
                                }
                                case 'r': {
                                    this.sb.append('\r');
                                    continue block15;
                                }
                                case 'n': {
                                    this.sb.append('\n');
                                    continue block15;
                                }
                                case 't': {
                                    this.sb.append('\t');
                                    continue block15;
                                }
                                case 'f': {
                                    this.sb.append('\f');
                                    continue block15;
                                }
                                case 'b': {
                                    this.sb.append('\b');
                                    continue block15;
                                }
                                case 'u': {
                                    this.sb2.setLength(0);
                                    this.counter = this.global + 4;
                                    while (this.global < this.counter) {
                                        this.c = this.getChar(path);
                                        if (this.sb2.length() > 0 || this.c != '0') {
                                            this.sb2.append(this.c);
                                        }
                                        ++this.global;
                                    }
                                    if (this.sb2.length() == 0) {
                                        this.sb.append('\u0000');
                                        continue block15;
                                    }
                                    this.sb.append((char)Integer.parseInt(this.sb2.toString(), 16));
                                    continue block15;
                                }
                            }
                            this.throwParserException("illegal escape char", path);
                            return this.sb.toString();
                        }
                        --this.global;
                        continue block15;
                    }
                }
                this.sb.append(this.c);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            --this.global;
            this.throwParserException("Unexpected End of String \"" + this.sb.toString(), path, e);
            return this.sb.toString();
        }
    }

    protected char getChar(Object path) throws ParserException {
        if (this.isDebugEnabled()) {
            String pos = this.str.substring(0, this.global);
            this.debug = pos + this.str.substring(this.global) + "\r\n";
            for (int i = 0; i < pos.length(); ++i) {
                this.debug = this.debug + "-";
            }
            this.debug = this.debug + '\u2934';
            System.err.println(this.debug);
        }
        if (this.global >= this.str.length()) {
            this.throwParserException("Ended unexpected", path);
        }
        return this.charAt(path, this.global);
    }

    protected char charAt(Object path, int index) {
        return this.str.charAt(index);
    }

    protected boolean isDebugEnabled() {
        return DEBUG;
    }

    public Object parse() throws ParserException {
        Object ret = this.parseValue(null);
        this.skipWhiteSpace(null);
        if (this.global != this.str.length()) {
            this.skipWhiteSpace(null, true);
            if (this.global != this.str.length()) {
                ++this.global;
                this.throwParserException("Unexpected End of JSonString", "");
            }
        }
        return ret;
    }

    protected List<? extends Object> parseArray(Object path) throws ParserException {
        this.setToken(path, Token.START_OF_ARRAY);
        ++this.global;
        List<Object> ret = this.createJSonArray();
        block4: while (true) {
            this.parseArrayValue(ret, path);
            this.c = this.getChar(path);
            switch (this.c) {
                case ',': {
                    this.setToken(path, Token.COMMA);
                    ++this.global;
                    continue block4;
                }
                case ']': {
                    this.setToken(path, Token.END_OF_ARRAY);
                    ++this.global;
                    return ret;
                }
            }
            this.throwParserException("']' or ',' expected", path);
        }
    }

    protected Object parseArrayValue(List<Object> ret, Object path) throws ParserException {
        this.setToken(path, Token.WS_BEFORE_VALUE);
        this.skipWhiteSpace(path);
        this.c = this.getChar(path);
        Object newPath = path;
        switch (this.c) {
            case ']': {
                break;
            }
            case ',': {
                this.throwParserException("Value missing", path);
            }
            default: {
                newPath = this.extendPath(path, ret.size());
                ret.add(this.parseValue(newPath));
                this.setToken(path, Token.WS_AFTER_VALUE);
                this.skipWhiteSpace(path);
            }
        }
        return newPath;
    }

    protected List<? extends Object> createJSonArray() {
        return new ArrayList();
    }

    public String toString() {
        return this.global + ". " + this.str.charAt(this.global);
    }

    protected Object parseNumber(Object path) throws ParserException, NoNumberException {
        this.sb.setLength(0);
        boolean pointFound = false;
        boolean potFound = false;
        this.c = this.getChar(path);
        if (this.c == '+' || this.c == '-' || Character.isDigit(this.c) || this.naNAllowed && (this.c == 'N' || this.c == 'a')) {
            this.sb.append(this.c);
            while (this.global + 1 < this.str.length()) {
                ++this.global;
                this.c = this.getChar(path);
                if (Character.isDigit(this.c) || !pointFound && this.c == '.' || pointFound && this.c == 'e' || pointFound && this.c == 'E' || potFound && this.c == '+' || potFound && this.c == '-' || this.naNAllowed && (this.c == 'N' || this.c == 'a')) {
                    if (this.c == '.') {
                        pointFound = true;
                    } else if (pointFound && (this.c == 'e' || this.c == 'E')) {
                        potFound = true;
                    }
                    this.sb.append(this.c);
                    continue;
                }
                --this.global;
                break;
            }
            ++this.global;
            if (pointFound) {
                return this.createJSonValue(this.parseFloatNumber(this.sb));
            }
            if (this.naNAllowed && CharSequenceUtils.contentEquals("NaN", this.sb)) {
                return this.createJSonValue(Double.NaN);
            }
            return this.createJSonValue(this.parseFixedNumber(this.sb));
        }
        throw new NoNumberException();
    }

    protected Number parseFloatNumber(CharSequence charSequence) {
        String string = charSequence.toString();
        double num = Double.parseDouble(string);
        float check = (float)num;
        Number ret = (double)check == num && Float.toString(check).length() >= string.length() ? (Number)Float.valueOf(check) : (Number)num;
        return ret;
    }

    protected Number parseFixedNumber(CharSequence charSequence) {
        String string = charSequence.toString();
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e2) {
            return Long.valueOf(string);
        }
    }

    protected Object createJSonValue(Number number) {
        return number;
    }

    protected Map<String, ? extends Object> parseObject(Object path) throws ParserException {
        this.setToken(path, Token.START_OF_OBJECT);
        ++this.global;
        Map<String, Object> ret = this.createJSonObject();
        block4: while (true) {
            this.parseKeyValuePair(path, ret);
            if (this.global >= this.str.length()) {
                this.throwParserException("} or , expected", path);
            }
            this.c = this.getChar(path);
            switch (this.c) {
                case ',': {
                    this.setToken(path, Token.COMMA);
                    ++this.global;
                    continue block4;
                }
                case '}': {
                    this.setToken(path, Token.END_OF_OBJECT);
                    ++this.global;
                    return ret;
                }
            }
            this.throwParserException(", or }' expected", path);
            ++this.global;
        }
    }

    protected ParserException throwParserException(String string, Object path) throws ParserException {
        ParserException ex = this.bam(string, path);
        if (ex != null) {
            throw ex;
        }
        return ex;
    }

    protected ParserException throwParserException(String string, Object path, Throwable e) throws ParserException {
        ParserException ex = this.bam(string, path, e);
        if (ex != null) {
            throw ex;
        }
        return ex;
    }

    protected Object parseKeyValuePair(Object newPath, Map<String, Object> ret) throws ParserException {
        this.setToken(newPath, Token.WS_BEFORE_KEY);
        this.skipWhiteSpace(newPath);
        this.c = this.getChar(newPath);
        if (this.c == '\"') {
            this.setToken(newPath, Token.KEY);
            String key = this.findString(newPath);
            key = this.dedupeString(key);
            this.setToken(newPath, Token.WS_AFTER_KEY);
            newPath = this.extendPath(newPath, key);
            this.skipWhiteSpace(newPath);
            this.setToken(newPath, Token.ASSIGN);
            this.c = this.getChar(newPath);
            if (this.c != ':') {
                this.throwParserException("':' expected", newPath);
            }
            ++this.global;
            this.setToken(newPath, Token.WS_AFTER_ASSIGN);
            this.skipWhiteSpace(newPath);
            this.setToken(newPath, Token.VALUE);
            Object newValue = this.parseValue(newPath);
            String mappedKey = this.mapKey(key);
            if (ret.containsKey(mappedKey)) {
                this.onDuplicateProperty(newPath, ret, newValue);
            }
            this.putKeyValuePair(newPath, ret, mappedKey, newValue);
            this.setToken(newPath, Token.WS_AFTER_VALUE);
            this.skipWhiteSpace(newPath);
        }
        return newPath;
    }

    protected void putKeyValuePair(Object newPath, Map<String, Object> map, String key, Object value) {
        map.put(key, value);
    }

    protected void onDuplicateProperty(Object path, Object parent, Object newValue) {
    }

    protected Map<String, ? extends Object> createJSonObject() {
        return new LinkedHashMap();
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Object path, Token token) throws ParserException {
        this.token = token;
    }

    protected Object extendPath(Object path, Object key) {
        return null;
    }

    protected String mapKey(String key) {
        return key;
    }

    protected Object parseValue(Object path) throws ParserException {
        this.setToken(path, Token.WS_BEFORE_VALUE);
        this.global = this.skipWhiteSpace(path, this.global == 0);
        this.setToken(path, Token.VALUE);
        switch (this.getChar(path)) {
            case '{': {
                return this.parseObject(path);
            }
            case '[': {
                return this.parseArray(path);
            }
            case 'n': {
                this.setToken(path, Token.VALUE_NULL);
                this.expectChars(path, CHAR_ARRAY_NULL);
                return this.createJSonValue((String)null);
            }
            case 't': {
                this.setToken(path, Token.VALUE_BOOLEAN);
                this.expectChars(path, CHAR_ARRAY_TRUE);
                return this.createJSonValue(true);
            }
            case 'f': {
                this.setToken(path, Token.VALUE_BOOLEAN);
                this.expectChars(path, CHAR_ARRAY_FALSE);
                return this.createJSonValue(false);
            }
            case '\"': {
                this.setToken(path, Token.VALUE_STRING);
                String string = this.findString(path);
                return this.createJSonValue(string);
            }
        }
        try {
            this.setToken(path, Token.VALUE_NUMBER);
            return this.parseNumber(path);
        }
        catch (NumberFormatException e) {
            ++this.global;
            this.throwParserException("Illegal Char", path, e);
            return this.parseValue(path);
        }
        catch (NoNumberException e) {
            ++this.global;
            this.throwParserException("Illegal Char", path, e);
            return this.parseValue(path);
        }
    }

    protected Map<String, String> getDedupeMap() {
        return this.DEDUPEMAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String dedupeString(String string) {
        Map<String, String> dedupeMap = this.getDedupeMap();
        if (string != null && dedupeMap != null) {
            Map<String, String> map = dedupeMap;
            synchronized (map) {
                String deduped = dedupeMap.get(string);
                if (deduped == null) {
                    dedupeMap.put(string, string);
                    deduped = string;
                }
                return deduped;
            }
        }
        return string;
    }

    protected Object createJSonValue(String value) {
        return value;
    }

    protected Object createJSonValue(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    protected void expectChars(Object path, char[] chars) throws ParserException {
        for (char c : chars) {
            ParserException parserException = this.expectChar(path, c);
            if (parserException == null) continue;
            throw parserException;
        }
    }

    protected ParserException expectChar(Object path, char expected) {
        char is;
        if ((is = this.charAt(path, this.global++)) != expected) {
            return this.bam("Unexpected char: " + is + " instead of " + expected, path);
        }
        return null;
    }

    protected int skipWhiteSpace(Object path) throws ParserException {
        return this.skipWhiteSpace(path, false);
    }

    protected int skipWhiteSpace(Object path, boolean skipNull) throws ParserException {
        while (this.global < this.str.length()) {
            char c;
            if (Character.isWhitespace(c = this.charAt(path, this.global++)) || skipNull && '\u0000' == c) continue;
            --this.global;
            break;
        }
        return this.global;
    }

    public static String decodeJavaScriptString(String str) throws ParserException {
        char c;
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        boolean escaped = false;
        int global = 0;
        int counter = 0;
        if ((c = str.charAt(global++)) != '\"') {
            throw new ParserException(global, null, "'\"' expected");
        }
        sb.append("\"");
        block7: while (global < str.length()) {
            c = str.charAt(global++);
            switch (c) {
                case '\"': {
                    sb.append("\"");
                    return sb.toString();
                }
                case '\\': {
                    escaped = true;
                    while ((c = str.charAt(global++)) == '\\') {
                        if (escaped = !escaped) continue;
                        sb.append("\\");
                    }
                    if (escaped) {
                        switch (c) {
                            case 'x': {
                                sb2.setLength(0);
                                counter = global + 2;
                                while (global < counter) {
                                    c = str.charAt(global);
                                    if (sb2.length() > 0 || c != '0') {
                                        sb2.append(c);
                                    }
                                    ++global;
                                }
                                if (sb2.length() == 0) {
                                    sb.append('\u0000');
                                    continue block7;
                                }
                                sb.append("\\").append((char)Short.parseShort(sb2.toString(), 16));
                                continue block7;
                            }
                        }
                        continue block7;
                    }
                    --global;
                    continue block7;
                }
            }
            sb.append(c);
        }
        throw new ParserException(global, null, "Unfinished String");
    }

    public static enum Token {
        KEY,
        VALUE,
        VALUE_STRING,
        VALUE_NULL,
        VALUE_BOOLEAN,
        VALUE_NUMBER,
        END_OF_OBJECT,
        START_OF_OBJECT,
        START_OF_ARRAY,
        END_OF_ARRAY,
        ASSIGN,
        COMMA,
        WS_BEFORE_VALUE,
        WS_AFTER_VALUE,
        WS_AFTER_ASSIGN,
        WS_AFTER_KEY,
        WS_BEFORE_KEY;

    }
}

