/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.WeakHashMap;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.flexijson.FinalKey;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSONParserExtension;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.ParsingError;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.simplejson.ValueType;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.CompiledType;

public class FlexiJSONParser {
    static final HashSet<ParsingError> IGNORE_LIST_ALL = new HashSet();
    public static final HashSet<ParsingError> IGNORE_LIST_JS = new HashSet();
    public static final HashSet<ParsingError> IGNORE_LIST_ENSURE_CORRECT_VALUES = new HashSet();
    public static final HashSet<ParsingError> IGNORE_LIST_EXTRA_COMMAS = new HashSet();
    public static final HashSet<ParsingError> IGNORE_LIST_COMMENTS = new HashSet();
    private static final char SQUARE_BRACKET_CLOSE = ']';
    private static final char CURLY_BRACKET_CLOSE = '}';
    private static final char COLON = ':';
    private static final char ASTERISK = '*';
    private static final char SLASH = '/';
    private static final char SQUARE_BRACKET_OPEN = '[';
    private static final char CURLY_BRACKET_OPEN = '{';
    private static final char COMMA = ',';
    private static final char BACKSLASH = '\\';
    private static final char BACKSPACE = '\b';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char[] CHAR_ARRAY_FALSE;
    private static final char[] CHAR_ARRAY_NAN;
    private static final char[] CHAR_ARRAY_UNDEFINED;
    private static final char[] CHAR_ARRAY_NULL;
    private static final char[] CHAR_ARRAY_TRUE;
    private static final WeakHashMap<String, WeakReference<String>> DEDUPEMAP;
    private static final char DOUBLE_QUOTE = '\"';
    protected static final char END_OF_TRANSMISSION = '\u2404';
    private static final char FORM_FEED = '\f';
    private static final char LINE_FEED = '\n';
    private static final char SINGLE_QUOTE = '\'';
    private static final char TAB = '\t';
    private char[] aheadBuffer;
    private final char[] buffer = new char[1];
    private FlexiJSonNode container;
    StringBuilder debug = null;
    public HashSet<ParsingError> ignoreIssues = new HashSet();
    protected int index = 0;
    private StringParser isFalse;
    private StringParser isNull;
    private NumberParser isNumber;
    private StringParser isTrue;
    private int lastNonWhitespaceIndex;
    public final Reader reader;
    final StringBuilder sb;
    private final StringBuilder sb2;
    private Token token;
    private StringParser isUndefined;
    protected StringQuoting stringQuoting = StringQuoting.NONE;
    private LinkedList<FlexiJSONParserExtension> tokenParserExtensions;
    private boolean breakAtEndOfObject = false;

    public int getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dedupeString(String string) {
        if (string != null) {
            WeakHashMap<String, WeakReference<String>> weakHashMap = DEDUPEMAP;
            synchronized (weakHashMap) {
                String ret = null;
                WeakReference<String> ref = DEDUPEMAP.get(string);
                if (ref != null && (ret = (String)ref.get()) != null) {
                    return ret;
                }
                ref = new WeakReference<String>(string);
                DEDUPEMAP.put(string, ref);
                return string;
            }
        }
        return null;
    }

    public FlexiJSONParser(InputStream is) {
        this(new InputStreamReader(is, Charset.forName("UTF-8")));
    }

    public FlexiJSONParser(Reader reader) {
        this.reader = reader;
        this.sb = new StringBuilder();
        this.sb2 = new StringBuilder();
        this.initParsers();
    }

    protected void initParsers() {
        this.isNumber = new NumberParser();
        this.isNull = new StringParser(CHAR_ARRAY_NULL);
        this.isUndefined = new StringParser(CHAR_ARRAY_UNDEFINED);
        this.isTrue = new StringParser(CHAR_ARRAY_TRUE);
        this.isFalse = new StringParser(CHAR_ARRAY_FALSE);
    }

    public FlexiJSONParser(String json) {
        this(new StringReader(json));
    }

    protected void appendC(char c) {
        this.isNumber.validate(c);
        this.isNull.validate(c);
        this.isTrue.validate(c);
        this.isFalse.validate(c);
        this.isUndefined.validate(c);
        if (this.tokenParserExtensions != null) {
            for (FlexiJSONParserExtension sp : this.tokenParserExtensions) {
                sp.validate(c);
            }
        }
        this.sb.append(c);
        if (!Character.isWhitespace(c)) {
            this.lastNonWhitespaceIndex = this.sb.length();
        }
    }

    protected Object assignFinalType(Object path, Token type) throws FlexiParserException {
        String str = null;
        if (this.tokenParserExtensions != null) {
            for (FlexiJSONParserExtension sp : this.tokenParserExtensions) {
                Object ret;
                if (str == null) {
                    str = FlexiJSONParser.dedupeString(this.sb.toString());
                }
                if (type == Token.KEY) {
                    ret = sp.getKey(this, str, path, this.stringQuoting, this.currentChar(path));
                    if (ret == null) continue;
                    if (StringUtils.equals(((FinalKey)ret).key, str)) {
                        // empty if block
                    }
                    return ret;
                }
                ret = sp.getValue(this, str, path, this.stringQuoting, this.currentChar(path));
                if (ret == null) continue;
                return ret;
            }
        }
        switch (this.stringQuoting) {
            case DOUBLE: {
                if (this.currentChar(path) != '\"') {
                    this.throwParserExceptionInternal(ParsingError.EXPECTED_STRING_OR_DOUBLE_QUOTE, path, null, this.container, null);
                }
                if (str == null) {
                    str = FlexiJSONParser.dedupeString(this.sb.toString());
                }
                return str;
            }
            case SINGLE: {
                if (this.currentChar(path) != '\'') {
                    this.throwParserExceptionInternal(ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE, path, null, this.container, null);
                }
                if (str == null) {
                    str = FlexiJSONParser.dedupeString(this.sb.toString());
                }
                return str;
            }
        }
        if (this.isFalse.isFinished()) {
            return Boolean.FALSE;
        }
        if (this.isTrue.isFinished()) {
            return Boolean.TRUE;
        }
        if (this.isUndefined.isFinished()) {
            return null;
        }
        if (this.isNull.isFinished()) {
            return null;
        }
        if (this.isNumber.isFinished()) {
            try {
                if (str == null) {
                    str = this.sb.toString();
                }
                return this.isNumber.getValue(str, path);
            }
            catch (NumberFormatException e) {
                throw new WTFException(e);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw e;
            }
        }
        if (this.sb.length() == 0) {
            return this.createJSonValue();
        }
        this.throwParserExceptionInternal(ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES, path, null, this.container, null);
        return FlexiJSONParser.dedupeString(this.sb.substring(0, this.lastNonWhitespaceIndex));
    }

    public FlexiJSonArray createJSonArray() {
        return new FlexiJSonArray();
    }

    public FlexiJSonObject createJSonObject() {
        return new FlexiJSonObject();
    }

    public FlexiJSonValue createJSonValue() {
        return new FlexiJSonValue();
    }

    public FlexiJSonValue createJSonValue(Number longValue) {
        return new FlexiJSonValue(longValue);
    }

    public FlexiJSonValue createJSonValue(Boolean value) {
        return new FlexiJSonValue(value);
    }

    public FlexiJSonValue createJSonValue(String value) {
        if (value == null) {
            return new FlexiJSonValue((String)null);
        }
        return new FlexiJSonValue(FlexiJSONParser.dedupeString(value));
    }

    protected char currentChar(Object path) {
        return this.buffer[0];
    }

    protected Object extendPath(Object path, Object key) {
        return null;
    }

    public StringBuilder getDebug() {
        return this.debug;
    }

    public HashSet<ParsingError> getIgnoreIssues() {
        return this.ignoreIssues;
    }

    public Token getToken() {
        return this.token;
    }

    protected boolean isEndOfStreamReached() {
        return this.currentChar(null) == '\u2404';
    }

    private char lookahead(Object path) throws FlexiParserException {
        if (this.aheadBuffer != null) {
            return this.aheadBuffer[0];
        }
        this.aheadBuffer = new char[1];
        try {
            if (this.reader.read(this.aheadBuffer) != 1) {
                this.aheadBuffer[0] = 9220;
            }
        }
        catch (IOException e) {
            this.throwParserExceptionInternal(ParsingError.ERROR_IO_EXCEPTION_IN_STREAM, path, e, this.container, null);
        }
        return this.aheadBuffer[0];
    }

    protected String mapKey(String key) {
        return key;
    }

    protected void nextAtEndOfToken(Object path, FlexiJSonNode parent) throws FlexiParserException {
        if (parent instanceof FlexiJSonObject) {
            this.nextChar(path, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG);
        } else if (parent instanceof FlexiJSonArray) {
            this.nextChar(path, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG);
        } else {
            this.nextChar(path, null);
        }
    }

    protected boolean nextChar(Object path, ParsingError expected) throws FlexiParserException {
        try {
            if (this.buffer[0] == '\u2404') {
                return false;
            }
            if (this.readNextChar() == 1) {
                ++this.index;
                if (this.debug != null) {
                    this.debug.append(this.buffer[0]);
                }
                return true;
            }
        }
        catch (IOException e) {
            this.throwParserExceptionInternal(ParsingError.ERROR_IO_EXCEPTION_IN_STREAM, path, e, this.container, null);
        }
        if (expected != null) {
            this.throwParserExceptionInternal(expected, path, null, this.container, null);
        }
        this.buffer[0] = 9220;
        return false;
    }

    protected void onComment(Object path, FlexiJSonNode ret, String string) {
    }

    /*
     * Exception decompiling
     */
    public FlexiJSonNode parse() throws FlexiParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 8[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void addToArray(FlexiJSonArray array, FlexiJSonNode newElement) {
        array.add(newElement);
    }

    protected FlexiJSonArray parseArray(Object path) throws FlexiParserException {
        FlexiJSonNode parent = this.container;
        try {
            this.setToken(path, Token.START_OF_ARRAY);
            FlexiJSonArray ret = this.createJSonArray();
            this.container = ret;
            if (!this.nextChar(path, ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG)) {
                FlexiJSonArray flexiJSonArray = ret;
                return flexiJSonArray;
            }
            int lastActualValueIndex = -1;
            block18: while (true) {
                FlexiJSonArray flexiJSonArray;
                if (!this.skipWhitespace(path, ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG, Token.WS_BEFORE_VALUE)) {
                    FlexiJSonArray flexiJSonArray2 = ret;
                    return flexiJSonArray2;
                }
                FlexiJSonComments beforeValue = this.readComment(this.extendPath(path, ret.size()), ret, Token.WS_BEFORE_VALUE);
                switch (this.currentChar(path)) {
                    case ',': {
                        FlexiJSonValue value = this.createJSonValue();
                        value.addCommentsBefore(beforeValue);
                        this.addToArray(ret, value);
                        if (ret.size() == 1) {
                            this.throwParserExceptionInternal(ParsingError.ERROR_LEADING_COMMA_IN_ARRAY, this.extendPath(path, ret.size() - 1), null, ret, null);
                        } else if (ret.size() > 1) {
                            if (lastActualValueIndex == -1) {
                                this.throwParserExceptionInternal(ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_ARRAY, this.extendPath(path, ret.size() - 1), null, ret, null);
                            }
                            this.throwParserExceptionInternal(ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY, this.extendPath(path, ret.size() - 1), null, ret, null);
                        }
                        this.setToken(this.extendPath(path, ret.size()), Token.COMMA);
                        if (this.nextChar(this.extendPath(path, ret.size()), ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG)) continue block18;
                        FlexiJSonArray flexiJSonArray3 = ret;
                        return flexiJSonArray3;
                    }
                    case ']': {
                        this.setToken(path, Token.END_OF_ARRAY);
                        ret.addCommentsInside(beforeValue);
                        if (ret.size() - lastActualValueIndex > 1) {
                            this.throwParserExceptionInternal(ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY, this.extendPath(path, ret.size() - 1), null, ret, null);
                            this.throwParserExceptionInternal(ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY, this.extendPath(path, ret.size() - 1), null, ret, null);
                        } else if (ret.size() > 0) {
                            this.throwParserExceptionInternal(ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY, this.extendPath(path, ret.size() - 1), null, ret, null);
                        }
                        this.nextAtEndOfToken(this.extendPath(path, ret.size() - 1), parent);
                        FlexiJSonArray flexiJSonArray3 = ret;
                        return flexiJSonArray3;
                    }
                }
                Object newPath = this.parseArrayValue(ret, path);
                if (beforeValue != null && beforeValue.size() > 0) {
                    FlexiJSonNode newValue = (FlexiJSonNode)ret.get(ret.size() - 1);
                    FlexiJSonComments tmp = newValue.getCommentsBefore();
                    if (tmp == null) {
                        newValue.setCommentsBefore(beforeValue);
                    } else {
                        tmp.addAll(0, beforeValue);
                        newValue.setCommentsBefore(tmp);
                    }
                }
                lastActualValueIndex = ret.size() - 1;
                if (!this.skipWhitespace(newPath, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG, Token.WS_AFTER_VALUE)) {
                    flexiJSonArray = ret;
                    return flexiJSonArray;
                }
                switch (this.currentChar(newPath)) {
                    case ',': {
                        this.setToken(newPath, Token.COMMA);
                        if (this.nextChar(newPath, ParsingError.EXPECTED_ARRAY_VALUE_COMMA_OR_ARRAY_CLOSE_TAG)) continue block18;
                        flexiJSonArray = ret;
                        return flexiJSonArray;
                    }
                    case ']': {
                        this.setToken(newPath, Token.END_OF_ARRAY);
                        this.nextAtEndOfToken(newPath, parent);
                        flexiJSonArray = ret;
                        return flexiJSonArray;
                    }
                }
                this.throwParserExceptionInternal(ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG, newPath, null, ret, null);
            }
        }
        finally {
            this.container = parent;
        }
    }

    protected Object parseArrayValue(FlexiJSonArray ret, Object path) throws FlexiParserException {
        Object newPath = path;
        newPath = this.extendPath(path, ret.size());
        this.addToArray(ret, this.parseValue(newPath));
        return newPath;
    }

    protected boolean parseKeyValuePair(Object newPath, FlexiJSonObject ret) throws FlexiParserException {
        this.skipWhitespace(newPath, ParsingError.EXPECTED_KEY_OR_OBJECT_END_TAG, Token.WS_BEFORE_KEY);
        FlexiJSonComments commentsBeforeKey = this.readComment(newPath, this.container, Token.WS_BEFORE_KEY);
        if (this.currentChar(newPath) == '}') {
            ret.setCommentsInside(commentsBeforeKey);
            return false;
        }
        this.setToken(newPath, Token.KEY);
        Object keyToken = this.readToken(newPath, Token.KEY);
        String key = this.modifyKey(String.valueOf(keyToken));
        if (keyToken instanceof FinalKey) {
            key = this.modifyKey(String.valueOf(((FinalKey)keyToken).key));
        } else if (keyToken instanceof FlexiJSonNode) {
            key = "undefined";
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_WITHOUT_QUOTES, newPath, null, this.container, null);
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_IS_UNDEFINED, newPath, null, this.container, null);
        } else if (keyToken == null) {
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_WITHOUT_QUOTES, newPath, null, this.container, null);
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_IS_NULL, newPath, null, this.container, null);
        } else if (keyToken instanceof Boolean) {
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_WITHOUT_QUOTES, newPath, null, this.container, null);
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_IS_BOOLEAN, newPath, null, this.container, null);
        } else if (keyToken instanceof Number) {
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_WITHOUT_QUOTES, newPath, null, this.container, null);
            this.throwParserExceptionInternal(ParsingError.ERROR_KEY_IS_NUMBER, newPath, null, this.container, null);
        } else {
            switch (this.stringQuoting) {
                case SINGLE: {
                    this.throwParserExceptionInternal(ParsingError.ERROR_KEY_WITH_SINGLE_QUOTES, newPath, null, this.container, null);
                    break;
                }
                case NONE: {
                    this.throwParserExceptionInternal(ParsingError.ERROR_KEY_WITHOUT_QUOTES, newPath, null, this.container, null);
                    break;
                }
            }
        }
        newPath = this.extendPath(newPath, key);
        KeyValueElement element = new KeyValueElement(newPath);
        element.setKey(this.mapKey(key));
        element.addCommentsBeforeKey(commentsBeforeKey, true);
        this.skipWhitespace(newPath, ParsingError.EXPECTED_ANY_CHARACTER, Token.WS_AFTER_KEY);
        FlexiJSonComments commentsAfterKey = this.readComment(newPath, this.container, Token.WS_AFTER_KEY);
        element.addCommentsAfterKey(commentsAfterKey);
        if (this.skipWhitespaceToChar(newPath, ParsingError.EXPECTED_COLON, Token.WS_AFTER_KEY, ':')) {
            this.setToken(newPath, Token.ASSIGN);
            this.nextChar(newPath, ParsingError.EXPECTED_ANY_VALUE);
        }
        FlexiJSonComments commentsBeforeValue1 = this.readComment(newPath, this.container, Token.WS_BEFORE_VALUE);
        if (!this.skipWhitespace(newPath, ParsingError.EXPECTED_ANY_VALUE, Token.WS_BEFORE_VALUE)) {
            FlexiJSonValue empty = this.createJSonValue();
            empty.addCommentsBefore(commentsBeforeValue1);
            ret.add(new KeyValueElement(ret, newPath, this.mapKey(key), empty));
            return false;
        }
        FlexiJSonComments commentsBeforeValue2 = this.readComment(newPath, this.container, Token.WS_BEFORE_VALUE);
        this.setToken(newPath, Token.VALUE);
        FlexiJSonNode newValue = this.parseValue(newPath);
        newValue.addCommentsBefore(commentsBeforeValue1);
        newValue.addCommentsBefore(commentsBeforeValue2);
        newValue.addCommentsAfter(this.readComment(newPath, this.container, Token.WS_AFTER_VALUE));
        if (newValue instanceof FlexiJSonValue && ((FlexiJSonValue)newValue).getType() == ValueType.UNDEFINED) {
            this.throwParserExceptionInternal(ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED, newPath, null, this.container, newValue);
        }
        if (ret.containsKey(element.getKey())) {
            this.throwParserExceptionInternal(ParsingError.ERROR_DUPLICATED_KEY_PROPERTY, newPath, null, ret, newValue);
        }
        element.setValue(newValue);
        this.onNewKeyValueElement(ret, element, keyToken);
        ret.add(element);
        this.skipWhitespace(newPath, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, Token.WS_AFTER_VALUE);
        newValue.addCommentsAfter(this.readComment(newPath, this.container, Token.WS_AFTER_VALUE));
        return true;
    }

    protected void onNewKeyValueElement(FlexiJSonObject ret, KeyValueElement element, Object keyToken) {
    }

    protected String modifyKey(String keyString) {
        return keyString;
    }

    protected FlexiJSonObject parseObject(Object path) throws FlexiParserException {
        FlexiJSonNode parent = this.container;
        try {
            this.setToken(path, Token.START_OF_OBJECT);
            FlexiJSonObject ret = this.createJSonObject();
            this.container = ret;
            if (!this.nextChar(path, ParsingError.EXPECTED_KEY_VALUE_PAIR_COMMA_OR_OBJECT_END_TAG)) {
                FlexiJSonObject flexiJSonObject = ret;
                return flexiJSonObject;
            }
            this.skipWhitespace(path, ParsingError.EXPECTED_KEY_VALUE_PAIR_COMMA_OR_OBJECT_END_TAG, Token.WS_BEFORE_KEY);
            int entryIndex = 0;
            int lastObjectIndex = -1;
            block18: while (true) {
                FlexiJSonComments beforeElement = this.readComment(path, ret, Token.WS_BEFORE_KEY);
                switch (this.currentChar(path)) {
                    case '\u2404': {
                        this.throwParserExceptionInternal(ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, path, null, ret, null);
                        FlexiJSonObject flexiJSonObject = ret;
                        return flexiJSonObject;
                    }
                    case ',': {
                        this.setToken(path, Token.COMMA);
                        ++entryIndex;
                        KeyValueElement empty = new KeyValueElement(ret, path, null, this.createJSonValue());
                        empty.setCommentsBeforeKey(beforeElement);
                        beforeElement = null;
                        ret.add(empty);
                        if (entryIndex == 1) {
                            this.throwParserExceptionInternal(ParsingError.ERROR_LEADING_COMMA_IN_OBJECT, path, null, ret, null);
                        } else if (entryIndex > 1) {
                            if (ret.size() > 0) {
                                this.throwParserExceptionInternal(ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT, path, null, ret, null);
                            } else {
                                this.throwParserExceptionInternal(ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT, path, null, ret, null);
                                this.throwParserExceptionInternal(ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT, path, null, ret, null);
                            }
                        }
                        if (!this.nextChar(path, ParsingError.EXPECTED_KEY_VALUE_PAIR_COMMA_OR_OBJECT_END_TAG)) {
                            FlexiJSonObject flexiJSonObject = ret;
                            return flexiJSonObject;
                        }
                        this.skipWhitespace(path, ParsingError.EXPECTED_KEY_VALUE_PAIR_COMMA_OR_OBJECT_END_TAG, Token.WS_BEFORE_KEY);
                        continue block18;
                    }
                    case '}': {
                        KeyValueElement empty;
                        this.setToken(path, Token.END_OF_OBJECT);
                        if (entryIndex == ret.getElements().size() && entryIndex > 0) {
                            empty = new KeyValueElement(ret, path, null, this.createJSonValue());
                            if (beforeElement != null) {
                                empty.setCommentsBeforeKey(beforeElement);
                            }
                            ret.add(empty);
                        } else if (beforeElement != null) {
                            ret.addCommentsInside(beforeElement);
                        }
                        if (entryIndex - lastObjectIndex > 1) {
                            this.throwParserExceptionInternal(ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_OBJECT, path, null, ret, null);
                            this.throwParserExceptionInternal(ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, path, null, ret, null);
                        } else if (entryIndex > 0) {
                            this.throwParserExceptionInternal(ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT, path, null, ret, null);
                        }
                        this.nextAtEndOfToken(path, parent);
                        FlexiJSonObject flexiJSonObject = ret;
                        return flexiJSonObject;
                    }
                }
                if (this.parseKeyValuePair(path, ret)) {
                    lastObjectIndex = entryIndex;
                }
                if (beforeElement != null && beforeElement.size() > 0) {
                    ret.last().addCommentsBeforeKey(beforeElement, false);
                }
                switch (this.currentChar(path)) {
                    case ',': {
                        ++entryIndex;
                        this.setToken(path, Token.COMMA);
                        if (!this.nextChar(path, ParsingError.EXPECTED_KEY_VALUE_PAIR_COMMA_OR_OBJECT_END_TAG)) {
                            FlexiJSonObject flexiJSonObject = ret;
                            return flexiJSonObject;
                        }
                        this.skipWhitespace(path, ParsingError.EXPECTED_KEY_VALUE_PAIR_COMMA_OR_OBJECT_END_TAG, Token.WS_BEFORE_KEY);
                        continue block18;
                    }
                    case '}': {
                        this.setToken(path, Token.END_OF_OBJECT);
                        this.nextAtEndOfToken(path, parent);
                        FlexiJSonObject flexiJSonObject = ret;
                        return flexiJSonObject;
                    }
                }
                this.throwParserExceptionInternal(ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, path, null, ret, null);
            }
        }
        finally {
            this.container = parent;
        }
    }

    protected FlexiJSonNode parseValue(Object path) throws FlexiParserException {
        FlexiJSonNode value;
        FlexiJSonComments commentsBeforeValue = this.readComment(path, this.container, Token.WS_BEFORE_VALUE);
        this.setToken(path, Token.VALUE);
        switch (this.currentChar(path)) {
            case '{': {
                value = this.parseObject(path);
                break;
            }
            case '[': {
                value = this.parseArray(path);
                break;
            }
            case '\u2404': {
                return commentsBeforeValue;
            }
            default: {
                Object token = this.readToken(path, Token.VALUE);
                if (token instanceof FlexiJSonNode) {
                    value = (FlexiJSonNode)token;
                    break;
                }
                if (token == null) {
                    if (this.isUndefined.isFinished()) {
                        value = this.createJSonValue();
                        break;
                    }
                    value = this.createJSonValue((String)null);
                    break;
                }
                if (token instanceof Boolean) {
                    value = this.createJSonValue((Boolean)token);
                    break;
                }
                if (token instanceof Number) {
                    value = this.createJSonValue((Number)token);
                    break;
                }
                value = this.createJSonValue((String)token);
                if (this.stringQuoting == StringQuoting.NONE) {
                    this.throwParserExceptionInternal(ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES, path, null, this.container, value);
                    break;
                }
                if (this.stringQuoting != StringQuoting.SINGLE) break;
                this.throwParserExceptionInternal(ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES, path, null, this.container, value);
            }
        }
        value.addCommentsBefore(commentsBeforeValue);
        this.skipWhitespace(path, null, Token.WS_AFTER_VALUE);
        value.addCommentsAfter(this.readComment(path, this.container, Token.WS_AFTER_VALUE));
        return value;
    }

    protected FlexiJSonComments readComment(Object path, FlexiJSonNode ret, Token wsToken) throws FlexiParserException {
        if (!this.isParseInlineCommentEnabled() && !this.isParseLineCommentEnabled()) {
            return null;
        }
        FlexiJSonComments comments = null;
        if (this.currentChar(path) == '/') {
            int start = this.index - 1;
            if (this.lookahead(path) == '/' && this.isParseLineCommentEnabled()) {
                this.throwParserExceptionInternal(ParsingError.ERROR_LINE_COMMENT, path, null, this.container, null);
                this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                this.setToken(path, Token.COMMENT_LINE);
                this.sb.setLength(0);
                while (true) {
                    this.nextAtEndOfToken(path, this.container);
                    switch (this.currentChar(path)) {
                        case '\u2404': {
                            this.onComment(path, ret, this.sb.toString());
                            if (comments == null) {
                                comments = this.createCommentsContainer();
                            }
                            comments.add(this.createComment(this.cleanComment(this.sb.toString()), FlexiComment.Type.LINE, FlexiMapperTags.UNKNOWN, start, this.index, path));
                            return comments;
                        }
                        case '\n': 
                        case '\r': {
                            this.onComment(path, ret, this.sb.toString());
                            if (comments == null) {
                                comments = this.createCommentsContainer();
                            }
                            comments.add(this.createComment(this.cleanComment(this.sb.toString()), FlexiComment.Type.LINE, FlexiMapperTags.UNKNOWN, start, this.index - 1, path));
                            if (this.container instanceof FlexiJSonObject) {
                                this.skipWhitespace(path, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, wsToken);
                            } else if (this.container instanceof FlexiJSonArray) {
                                this.skipWhitespace(path, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG, wsToken);
                            } else {
                                this.skipWhitespace(path, null, wsToken);
                            }
                            comments.addAll(this.readComment(path, ret, wsToken));
                            return comments;
                        }
                    }
                    this.sb.append(this.currentChar(path));
                }
            }
            if (this.lookahead(path) == '*' && this.isParseInlineCommentEnabled()) {
                start = this.index - 1;
                this.throwParserExceptionInternal(ParsingError.ERROR_INLINE_COMMENT, path, null, this.container, null);
                this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                this.setToken(path, Token.COMMENT_INLINE);
                this.sb.setLength(0);
                while (true) {
                    this.nextAtEndOfToken(path, this.container);
                    if (this.currentChar(path) == '\u2404') {
                        this.throwParserExceptionInternal(ParsingError.EXPECTED_ANY_CHARACTER_OR_COMMENT_CLOSE_TAGS, path, null, this.container, null);
                        this.onComment(path, ret, this.sb.toString());
                        if (comments == null) {
                            comments = this.createCommentsContainer();
                        }
                        comments.add(this.createComment(this.cleanComment(this.sb.toString()), FlexiComment.Type.INLINE, FlexiMapperTags.UNKNOWN, start, this.index, path));
                        return comments;
                    }
                    if (this.currentChar(path) == '*' && this.lookahead(path) == '/') {
                        this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                        int end = this.index;
                        this.nextAtEndOfToken(path, this.container);
                        this.onComment(path, ret, this.sb.toString());
                        if (comments == null) {
                            comments = this.createCommentsContainer();
                        }
                        comments.add(this.createComment(this.cleanComment(this.sb.toString()), FlexiComment.Type.INLINE, FlexiMapperTags.UNKNOWN, start, end, path));
                        if (this.container instanceof FlexiJSonObject) {
                            this.skipWhitespace(path, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, wsToken);
                        } else if (this.container instanceof FlexiJSonArray) {
                            this.skipWhitespace(path, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG, wsToken);
                        } else {
                            this.skipWhitespace(path, null, wsToken);
                        }
                        comments.addAll(this.readComment(path, ret, wsToken));
                        return comments;
                    }
                    if (this.currentChar(path) == '\r') {
                        StringBuilder tmp = new StringBuilder();
                        tmp.append(this.currentChar(path));
                        this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                        if (this.currentChar(path) == '\n') {
                            tmp.append(this.currentChar(path));
                            this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                        }
                        while (true) {
                            if (this.isEndOfStreamReached()) {
                                this.throwParserExceptionInternal(ParsingError.EXPECTED_ANY_CHARACTER, path, null, this.container, null);
                            }
                            if (!Character.isWhitespace(this.currentChar(path))) break;
                            tmp.append(this.currentChar(path));
                            this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                        }
                        if (this.currentChar(path) == '*') {
                            tmp.append(this.currentChar(path));
                            if (Character.isWhitespace(this.lookahead(path))) {
                                this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                            } else if (this.lookahead(path) == '/') {
                                this.nextChar(path, ParsingError.EXPECTED_ANY_CHARACTER);
                                int end = this.index;
                                this.nextAtEndOfToken(path, this.container);
                                this.onComment(path, ret, this.sb.toString());
                                if (comments == null) {
                                    comments = this.createCommentsContainer();
                                }
                                comments.add(this.createComment(this.cleanComment(this.sb.toString()), FlexiComment.Type.INLINE, FlexiMapperTags.UNKNOWN, start, end, path));
                                if (this.container instanceof FlexiJSonObject) {
                                    this.skipWhitespace(path, ParsingError.EXPECTED_COMMA_OR_OBJECT_END_TAG, wsToken);
                                } else if (this.container instanceof FlexiJSonArray) {
                                    this.skipWhitespace(path, ParsingError.EXPECTED_COMMA_OR_ARRAY_END_TAG, wsToken);
                                } else {
                                    this.skipWhitespace(path, null, wsToken);
                                }
                                comments.addAll(this.readComment(path, ret, wsToken));
                                return comments;
                            }
                            if (this.sb.length() <= 0) continue;
                            this.sb.append("\r\n");
                            continue;
                        }
                        this.sb.append((CharSequence)tmp);
                        this.sb.append(this.currentChar(path));
                        tmp = null;
                        continue;
                    }
                    this.sb.append(this.currentChar(path));
                }
            }
        }
        return comments;
    }

    protected FlexiCommentJsonNode createComment(String comment, FlexiComment.Type type, FlexiMapperTags tag, int startindex, int endIndex, Object path) {
        return new FlexiComment(comment, type, tag);
    }

    protected FlexiJSonComments createCommentsContainer() {
        return new FlexiJSonComments();
    }

    protected String cleanComment(String string) {
        string = string.trim();
        string = string.replaceAll("\\s*[\r\n]{1,2}\\s*", "\r\n");
        return string;
    }

    public boolean isParseLineCommentEnabled() {
        return true;
    }

    public boolean isParseInlineCommentEnabled() {
        return true;
    }

    protected int readNextChar() throws IOException {
        if (this.aheadBuffer != null) {
            this.buffer[0] = this.aheadBuffer[0];
            this.aheadBuffer = null;
            return this.buffer[0] == '\u2404' ? -1 : 1;
        }
        return this.reader.read(this.buffer);
    }

    public FlexiJSONParser addExtension(FlexiJSONParserExtension parser) {
        if (this.tokenParserExtensions == null) {
            this.tokenParserExtensions = new LinkedList();
        }
        this.tokenParserExtensions.add(parser);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readToken(Object path, Token type) throws FlexiParserException {
        this.isNumber.reset();
        this.isNull.reset();
        this.isTrue.reset();
        this.isFalse.reset();
        this.isUndefined.reset();
        if (this.tokenParserExtensions != null) {
            for (FlexiJSONParserExtension sp : this.tokenParserExtensions) {
                sp.reset();
            }
        }
        this.sb.setLength(0);
        this.lastNonWhitespaceIndex = 0;
        boolean escaped = false;
        char c = this.currentChar(path);
        if (c == '\"') {
            this.stringQuoting = StringQuoting.DOUBLE;
            if (!this.nextChar(path, ParsingError.EXPECTED_STRING_OR_DOUBLE_QUOTE)) {
                return this.assignFinalType(path, type);
            }
        } else if (c == '\'') {
            this.stringQuoting = StringQuoting.SINGLE;
            this.throwParserExceptionInternal(ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES, path, null, this.container, null);
            if (!this.nextChar(path, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE)) {
                return this.assignFinalType(path, type);
            }
        } else {
            this.stringQuoting = StringQuoting.NONE;
        }
        boolean inline = this.isParseInlineCommentEnabled();
        boolean line = this.isParseLineCommentEnabled();
        block31: while (true) {
            block65: {
                int i;
                block64: {
                    c = this.currentChar(path);
                    if (this.stringQuoting == StringQuoting.NONE && c == '/' && (this.lookahead(path) == '/' && line || this.lookahead(path) == '*' && inline)) {
                        return this.assignFinalType(path, type);
                    }
                    if (this.stringQuoting == StringQuoting.DOUBLE && c == '\"') {
                        try {
                            Object object = this.assignFinalType(path, type);
                            return object;
                        }
                        finally {
                            this.nextChar(path, null);
                        }
                    }
                    if (this.stringQuoting == StringQuoting.SINGLE && c == '\'') {
                        try {
                            Object object = this.assignFinalType(path, type);
                            return object;
                        }
                        finally {
                            this.nextChar(path, null);
                        }
                    }
                    if (this.stringQuoting == StringQuoting.NONE) {
                        if (this.container instanceof FlexiJSonObject) {
                            if (type == Token.KEY && (c == ':' || c == ',' || c == '}')) {
                                return this.assignFinalType(path, type);
                            }
                            if (type == Token.VALUE && (c == ',' || c == '}')) {
                                return this.assignFinalType(path, type);
                            }
                        } else if (this.container instanceof FlexiJSonArray && (c == ',' || c == ']')) {
                            return this.assignFinalType(path, type);
                        }
                    } else if (!(this.stringQuoting != StringQuoting.DOUBLE && this.stringQuoting != StringQuoting.SINGLE || c != '\r' && c != '\n')) {
                        this.throwParserExceptionInternal(ParsingError.ERROR_NEWLINE_IN_TOKEN, path, null, this.container, null);
                    }
                    if (this.stringQuoting != StringQuoting.DOUBLE && this.stringQuoting != StringQuoting.SINGLE) break block64;
                    if (c != '\\') break block65;
                    escaped = true;
                    if (!this.nextChar(path, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER)) {
                        this.appendC('\\');
                        return this.assignFinalType(path, type);
                    }
                    while ((c = this.currentChar(path)) == '\\') {
                        boolean bl = escaped = !escaped;
                        if (!escaped) {
                            this.appendC(c);
                            if (this.nextChar(path, this.stringQuoting == StringQuoting.SINGLE ? ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE : ParsingError.EXPECTED_STRING_OR_DOUBLE_QUOTE)) continue;
                            this.appendC('\\');
                            return this.assignFinalType(path, type);
                        }
                        if (this.nextChar(path, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER)) continue;
                        this.appendC('\\');
                        return this.assignFinalType(path, type);
                    }
                    if (!escaped) continue;
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case '/': {
                            break block65;
                        }
                        case 'r': {
                            c = '\r';
                            break block65;
                        }
                        case 'n': {
                            c = '\n';
                            break block65;
                        }
                        case 't': {
                            c = '\t';
                            break block65;
                        }
                        case 'f': {
                            c = '\f';
                            break block65;
                        }
                        case 'b': {
                            c = '\b';
                            break block65;
                        }
                        case 'u': {
                            this.sb2.setLength(0);
                            block33: for (i = 0; i < 4; ++i) {
                                if (!this.nextChar(path, ParsingError.EXPECTED_UNICODE_SEQUENCE)) {
                                    c = this.sb2.length() == 0 ? (char)'\u0000' : (char)Integer.parseInt(this.sb2.toString(), 16);
                                    this.appendC(c);
                                    return this.assignFinalType(path, type);
                                }
                                c = this.currentChar(path);
                                if (!Character.isDigit(c)) {
                                    switch (c) {
                                        case 'A': 
                                        case 'B': 
                                        case 'C': 
                                        case 'D': 
                                        case 'E': 
                                        case 'F': 
                                        case 'a': 
                                        case 'b': 
                                        case 'c': 
                                        case 'd': 
                                        case 'e': 
                                        case 'f': {
                                            break;
                                        }
                                        default: {
                                            this.throwParserExceptionInternal(ParsingError.EXPECTED_UNICODE_SEQUENCE, path, null, this.container, null);
                                            break block33;
                                        }
                                    }
                                }
                                if (this.sb2.length() <= 0 && c == 48) continue;
                                this.sb2.append(c);
                            }
                            c = this.sb2.length() == 0 ? (char)'\u0000' : (char)Integer.parseInt(this.sb2.toString(), 16);
                            break block65;
                        }
                        default: {
                            this.throwParserExceptionInternal(ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER, path, null, this.container, null);
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    if (!this.nextChar(path, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER)) {
                        this.appendC('\\');
                        return this.assignFinalType(path, type);
                    }
                    while ((c = this.currentChar(path)) == '\\') {
                        boolean bl = escaped = !escaped;
                        if (!escaped) {
                            this.appendC(c);
                            if (this.nextChar(path, null)) continue;
                            return this.assignFinalType(path, type);
                        }
                        if (this.nextChar(path, ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER)) continue;
                        this.appendC('\\');
                        return this.assignFinalType(path, type);
                    }
                    if (!escaped) continue;
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case ',': 
                        case ']': 
                        case '}': {
                            break;
                        }
                        case ':': {
                            if (type == Token.KEY) break;
                            this.throwParserExceptionInternal(ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER, path, null, this.container, null);
                            break;
                        }
                        case 'u': {
                            this.sb2.setLength(0);
                            block35: for (i = 0; i < 4; ++i) {
                                if (!this.nextChar(path, ParsingError.EXPECTED_UNICODE_SEQUENCE)) {
                                    c = this.sb2.length() == 0 ? (char)'\u0000' : (char)Integer.parseInt(this.sb2.toString(), 16);
                                    this.appendC(c);
                                    return this.assignFinalType(path, type);
                                }
                                c = this.currentChar(path);
                                if (!Character.isDigit(c)) {
                                    switch (c) {
                                        case 'A': 
                                        case 'B': 
                                        case 'C': 
                                        case 'D': 
                                        case 'E': 
                                        case 'a': 
                                        case 'b': 
                                        case 'c': 
                                        case 'd': 
                                        case 'e': {
                                            break;
                                        }
                                        default: {
                                            this.throwParserExceptionInternal(ParsingError.EXPECTED_UNICODE_SEQUENCE, path, null, this.container, null);
                                            break block35;
                                        }
                                    }
                                }
                                if (this.sb2.length() <= 0 && c == 48) continue;
                                this.sb2.append(c);
                            }
                            if (this.sb2.length() == 0) {
                                c = '\u0000';
                                break;
                            }
                            c = (char)Integer.parseInt(this.sb2.toString(), 16);
                            break;
                        }
                        default: {
                            this.throwParserExceptionInternal(ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER, path, null, this.container, null);
                            this.appendC('\\');
                            continue block31;
                        }
                    }
                }
            }
            this.appendC(c);
            switch (this.stringQuoting) {
                case SINGLE: {
                    if (this.nextChar(path, ParsingError.EXPECTED_STRING_OR_SINGLE_QUOTE)) continue block31;
                    return this.assignFinalType(path, type);
                }
                case DOUBLE: {
                    if (this.nextChar(path, ParsingError.EXPECTED_STRING_OR_DOUBLE_QUOTE)) continue block31;
                    return this.assignFinalType(path, type);
                }
            }
            if (!this.nextChar(path, null)) break;
        }
        return this.assignFinalType(path, type);
    }

    public FlexiJSONParser setDebug(StringBuilder debug) {
        this.debug = debug;
        return this;
    }

    public FlexiJSONParser setIgnoreIssues(Object ... issues) {
        this.ignoreIssues = new HashSet();
        return this.addIgnoreIssues(issues);
    }

    public FlexiJSONParser addIgnoreIssues(Object ... issues) {
        for (Object i : issues) {
            if (i instanceof ParsingError) {
                this.ignoreIssues.add((ParsingError)((Object)i));
                continue;
            }
            if (i instanceof Set) {
                this.ignoreIssues.addAll((Set)i);
                continue;
            }
            throw new IllegalArgumentException("Type " + CompiledType.create(i.getClass()) + " is not supported");
        }
        return this;
    }

    public FlexiJSONParser setIgnoreIssues(ParsingError ... ignoreIssues) {
        return this.setIgnoreIssues(new HashSet<ParsingError>(Arrays.asList(ignoreIssues)));
    }

    public void setToken(Object path, Token token) throws FlexiParserException {
        this.token = token;
    }

    protected boolean skipWhitespace(Object path, ParsingError expectedContentAfterWhitespace, Token token) throws FlexiParserException {
        block2: {
            do {
                if (expectedContentAfterWhitespace != null && this.isEndOfStreamReached()) {
                    this.throwParserExceptionInternal(expectedContentAfterWhitespace, path, null, this.container, null);
                }
                if (!Character.isWhitespace(this.currentChar(path))) break block2;
                if (token == null) continue;
                this.setToken(path, token);
                token = null;
            } while (this.nextChar(path, expectedContentAfterWhitespace));
            return false;
        }
        return this.buffer[0] != '\u2404';
    }

    protected boolean skipWhitespaceToChar(Object path, ParsingError expectedContentAfterWhitespace, Token token, char nextNonWhitespace) throws FlexiParserException {
        this.skipWhitespace(path, expectedContentAfterWhitespace, token);
        if (this.currentChar(path) != nextNonWhitespace) {
            this.throwParserExceptionInternal(expectedContentAfterWhitespace, path, null, this.container, null);
        }
        return this.buffer[0] == nextNonWhitespace;
    }

    private void throwParserExceptionInternal(ParsingError error, Object path, Throwable cause, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
        this.throwParserException(error, path, cause, parent, value);
    }

    protected void throwParserException(ParsingError error, Object path, Throwable cause, FlexiJSonNode parent, FlexiJSonNode value) throws FlexiParserException {
        if (this.getIgnoreIssues().contains((Object)error)) {
            return;
        }
        String json = "";
        if (this.debug != null) {
            json = "[...]" + this.debug.toString().substring(Math.max(0, this.debug.length() - 100)) + " ";
        }
        json = json + error.name() + ": " + error.description + " at index " + this.index;
        throw new FlexiParserException(this.index, path, json, cause);
    }

    public String toString() {
        if (this.debug != null) {
            return this.debug.toString() + "| " + (this.isEndOfStreamReached() ? "<END>" : "'" + this.currentChar(null) + "'");
        }
        return "" + (this.isEndOfStreamReached() ? "<END>" : "'" + this.currentChar(null) + "'");
    }

    public FlexiJSONParser debug() {
        this.debug = new StringBuilder();
        return this;
    }

    public FlexiJSONParser ignoreIssues(HashSet<ParsingError> ignoreListEnsureCorrectValues) {
        this.setIgnoreIssues(ignoreListEnsureCorrectValues);
        return this;
    }

    public FlexiJSONParser breakAtEndOfObject() {
        this.setBreakAtEndOfObject(true);
        return this;
    }

    public boolean isBreakAtEndOfObject() {
        return this.breakAtEndOfObject;
    }

    public void setBreakAtEndOfObject(boolean breakAtEndOfObject) {
        this.breakAtEndOfObject = breakAtEndOfObject;
    }

    public FlexiJSONParser enableComments() {
        return this.addIgnoreIssues(IGNORE_LIST_COMMENTS);
    }

    public FlexiJSONParser enableExtraCommas() {
        return this.addIgnoreIssues(IGNORE_LIST_EXTRA_COMMAS);
    }

    public FlexiJSONParser enableUndefinedValues() {
        return this.addIgnoreIssues(new Object[]{ParsingError.ERROR_VALUE_INSTEAD_OF_UNDEFINED_EXPECTED});
    }

    public FlexiJSONParser enableNaNValues() {
        return this.addIgnoreIssues(new Object[]{ParsingError.ERROR_NUMBER_NAN});
    }

    public FlexiJSONParser enableInfinityValues() {
        return this.addIgnoreIssues(new Object[]{ParsingError.ERROR_NUMBER_INFINITY});
    }

    static {
        ParsingError.values();
        for (ParsingError e : ParsingError.values()) {
            IGNORE_LIST_ALL.add(e);
        }
        IGNORE_LIST_COMMENTS.add(ParsingError.ERROR_INLINE_COMMENT);
        IGNORE_LIST_COMMENTS.add(ParsingError.ERROR_LINE_COMMENT);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_LEADING_COMMA_IN_ARRAY);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_LEADING_COMMA_IN_OBJECT);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_ARRAY);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY);
        IGNORE_LIST_EXTRA_COMMAS.add(ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_OBJECT);
        IGNORE_LIST_JS.add(ParsingError.ERROR_KEY_IS_BOOLEAN);
        IGNORE_LIST_JS.add(ParsingError.EXPECTED_VALID_ESCAPE_CHARACTER);
        IGNORE_LIST_JS.add(ParsingError.ERROR_KEY_IS_NULL);
        IGNORE_LIST_JS.add(ParsingError.ERROR_KEY_IS_NUMBER);
        IGNORE_LIST_JS.add(ParsingError.ERROR_KEY_IS_BOOLEAN);
        IGNORE_LIST_JS.add(ParsingError.ERROR_KEY_IS_UNDEFINED);
        IGNORE_LIST_JS.add(ParsingError.ERROR_KEY_WITH_SINGLE_QUOTES);
        IGNORE_LIST_JS.add(ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        IGNORE_LIST_JS.add(ParsingError.ERROR_NUMBER_NAN);
        IGNORE_LIST_JS.add(ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES);
        IGNORE_LIST_JS.add(ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        IGNORE_LIST_JS.add(ParsingError.ERROR_STRING_VALUE_WITHOUT_QUOTES);
        IGNORE_LIST_JS.add(ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_KEY_WITHOUT_QUOTES);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_INLINE_COMMENT);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_KEY_IS_NUMBER);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_KEY_WITH_SINGLE_QUOTES);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_LEADING_COMMA_IN_ARRAY);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_LEADING_COMMA_IN_OBJECT);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_LEADING_DECIMAL_POINT);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_LINE_COMMENT);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_ARRAY);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_MULTIPLE_LEADING_COMMA_IN_OBJECT);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_ARRAY);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_MULTIPLE_SUBSEQUENT_COMMAS_IN_OBJECT);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_ARRAY);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_MULTIPLE_TRAILING_COMMA_IN_OBJECT);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_NUMBER_INFINITY);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_NUMBER_NAN);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_NUMBERFORMAT_BINARY);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_NUMBERFORMAT_HEXADECIMAL);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_NUMBERFORMAT_LEADING_PLUS);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_NUMBERFORMAT_OCTAL);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_STRING_TOKEN_WITH_SINGLE_QUOTES);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_STRING_TOKEN_WITHOUT_QUOTES);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_STRING_VALUE_WITH_SINGLE_QUOTES);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_TRAILING_COMMA_IN_ARRAY);
        IGNORE_LIST_ENSURE_CORRECT_VALUES.add(ParsingError.ERROR_TRAILING_COMMA_IN_OBJECT);
        CHAR_ARRAY_FALSE = "false".toCharArray();
        CHAR_ARRAY_NAN = "NaN".toCharArray();
        CHAR_ARRAY_UNDEFINED = "undefined".toCharArray();
        CHAR_ARRAY_NULL = "null".toCharArray();
        CHAR_ARRAY_TRUE = "true".toCharArray();
        DEDUPEMAP = new WeakHashMap();
    }

    public static enum StringQuoting {
        NONE,
        DOUBLE,
        SINGLE;

    }

    public static enum Token {
        ASSIGN,
        COMMA,
        COMMENT_INLINE,
        COMMENT_LINE,
        END_OF_ARRAY,
        END_OF_OBJECT,
        KEY,
        START_OF_ARRAY,
        START_OF_OBJECT,
        VALUE,
        VALUE_BOOLEAN,
        VALUE_NULL,
        VALUE_NUMBER,
        VALUE_STRING,
        WS_AFTER_ASSIGN,
        WS_AFTER_KEY,
        WS_AFTER_VALUE,
        WS_BEFORE_KEY,
        WS_BEFORE_VALUE;

    }

    public class StringParser {
        private final char[] expected;
        private int index;
        private boolean invalid;

        public StringParser(char[] e) {
            this.expected = e;
        }

        public boolean check(char c) {
            if (this.invalid) {
                return false;
            }
            if (this.index < this.expected.length && this.expected[this.index] == c) {
                return true;
            }
            return this.isFinished() && Character.isWhitespace(c);
        }

        public boolean isFinished() {
            return !this.invalid && this.index >= this.expected.length;
        }

        public void reset() {
            this.index = 0;
            this.invalid = false;
        }

        public boolean validate(char c) {
            if (this.check(c)) {
                ++this.index;
                return true;
            }
            this.invalid = true;
            return false;
        }

        public Object getValue(String string, Object path) {
            return null;
        }
    }

    public class NumberParser {
        private static final char ZERO = '0';
        private static final char MINUS = '-';
        private static final char PLUS = '+';
        private boolean bin;
        private int digitsStartIndex;
        protected boolean firstIsZero;
        private boolean hasDigit;
        private boolean hasPoint;
        private boolean hasPot;
        private boolean hex;
        protected int index = 0;
        private StringParser Infinity;
        private boolean invalid;
        private boolean leadingMinus;
        private boolean leadingPlus;
        private StringParser NaN;
        private boolean oct;
        private int trailingWhitespace;

        public NumberParser() {
            this.NaN = new StringParser("NaN".toCharArray());
            this.Infinity = new StringParser("Infinity".toCharArray());
        }

        public boolean check(char c) {
            if (this.invalid) {
                return false;
            }
            if (this.index == 0) {
                if (c == '+') {
                    return true;
                }
                if (c == '-') {
                    return true;
                }
            }
            if (Character.isWhitespace(c)) {
                if (this.hasDigit) {
                    if (this.trailingWhitespace < 0) {
                        this.trailingWhitespace = this.index;
                    }
                    return true;
                }
                return true;
            }
            if (this.trailingWhitespace >= 0) {
                return false;
            }
            if (this.NaN.check(c)) {
                return true;
            }
            if (this.Infinity.check(c)) {
                return true;
            }
            int localStartIndex = this.digitsStartIndex;
            if (localStartIndex < 0) {
                localStartIndex = this.index;
            }
            if (!this.hasPoint && (localStartIndex != this.index || c != '0') && this.index == localStartIndex + 1 && this.firstIsZero) {
                if (c == 'x') {
                    return true;
                }
                if (c == 'b') {
                    return true;
                }
            }
            if (Character.isDigit(c)) {
                if (this.oct && (c == '8' || c == '9')) {
                    return false;
                }
                return !this.bin || c == '0' || c == '1';
            }
            if (this.hex) {
                switch (c) {
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': {
                        return true;
                    }
                }
            }
            if (c == '.') {
                if (!this.hasPoint) {
                    if (this.hex || this.bin) {
                        return false;
                    }
                    return !this.oct || this.index <= this.digitsStartIndex + 1;
                }
                return false;
            }
            if (this.hasPoint && !this.hasPot && (c == 'E' || c == 'e')) {
                return !this.oct && !this.hex && !this.bin;
            }
            return this.hasPot && (c == '+' || c == '-');
        }

        protected Number parseSmallestFixedNumberType(String string, int radix, boolean leadingMinus) {
            if (leadingMinus) {
                string = "-" + string;
            }
            try {
                short num = Short.parseShort(string, radix);
                return num;
            }
            catch (NumberFormatException e) {
                try {
                    int num = Integer.parseInt(string, radix);
                    return num;
                }
                catch (NumberFormatException e2) {
                    long num = Long.parseLong(string, radix);
                    return num;
                }
            }
        }

        protected Number parseSmalltestFloatNumberType(String string, boolean leadingMinus) {
            float check;
            double num = Double.parseDouble(string);
            if (leadingMinus) {
                num = -num;
            }
            if ((double)(check = (float)num) == num && Float.toString(check).length() >= string.length()) {
                return Float.valueOf(check);
            }
            return num;
        }

        public Object getValue(String string, Object path) throws FlexiParserException {
            if ("0".equals(string)) {
                return 0;
            }
            if (this.leadingPlus) {
                FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_NUMBERFORMAT_LEADING_PLUS, path, null, FlexiJSONParser.this.container, null);
            }
            if (this.NaN.isFinished()) {
                FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_NUMBER_NAN, path, null, FlexiJSONParser.this.container, null);
                return Double.NaN;
            }
            if (this.Infinity.isFinished()) {
                FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_NUMBER_INFINITY, path, null, FlexiJSONParser.this.container, null);
                if (this.leadingMinus) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (this.bin) {
                FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_NUMBERFORMAT_BINARY, path, null, FlexiJSONParser.this.container, null);
                return this.parseSmallestFixedNumberType(string.substring(this.digitsStartIndex + 2, this.trailingWhitespace >= 0 ? this.trailingWhitespace : string.length()), 2, this.leadingMinus);
            }
            if (this.oct) {
                if ((this.trailingWhitespace >= 0 ? this.trailingWhitespace : string.length()) - this.digitsStartIndex > 1) {
                    FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_NUMBERFORMAT_OCTAL, path, null, FlexiJSONParser.this.container, null);
                    return this.parseSmallestFixedNumberType(string.substring(this.digitsStartIndex + 1, this.trailingWhitespace >= 0 ? this.trailingWhitespace : string.length()), 8, this.leadingMinus);
                }
            } else if (this.hex) {
                FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_NUMBERFORMAT_HEXADECIMAL, path, null, FlexiJSONParser.this.container, null);
                return this.parseSmallestFixedNumberType(string.substring(this.digitsStartIndex + 2, this.trailingWhitespace >= 0 ? this.trailingWhitespace : string.length()), 16, this.leadingMinus);
            }
            if (this.hasPoint) {
                String trimmed = string.substring(this.digitsStartIndex, this.trailingWhitespace >= 0 ? this.trailingWhitespace : string.length());
                if (trimmed.charAt(0) == '.') {
                    FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_LEADING_DECIMAL_POINT, path, null, FlexiJSONParser.this.container, null);
                }
                if (trimmed.charAt(trimmed.length() - 1) == '.') {
                    FlexiJSONParser.this.throwParserExceptionInternal(ParsingError.ERROR_TRAILING_DECIMAL_POINT, path, null, FlexiJSONParser.this.container, null);
                }
                return this.parseSmalltestFloatNumberType(trimmed, this.leadingMinus);
            }
            return this.parseSmallestFixedNumberType(string.substring(this.digitsStartIndex, this.trailingWhitespace >= 0 ? this.trailingWhitespace : string.length()), 10, this.leadingMinus);
        }

        public boolean isFinished() {
            if (this.NaN.isFinished()) {
                return true;
            }
            if (this.Infinity.isFinished()) {
                return true;
            }
            return !this.invalid && this.hasDigit;
        }

        public void reset() {
            this.leadingPlus = false;
            this.leadingMinus = false;
            this.hex = false;
            this.oct = false;
            this.bin = false;
            this.hasPoint = false;
            this.hasDigit = false;
            this.trailingWhitespace = -1;
            this.hasPot = false;
            this.NaN.reset();
            this.Infinity.reset();
            this.firstIsZero = false;
            this.index = 0;
            this.invalid = false;
            this.digitsStartIndex = -1;
        }

        public boolean validate(char c) {
            if (this.invalid) {
                return false;
            }
            try {
                if (this.index == 0) {
                    if (c == '+') {
                        this.leadingPlus = true;
                        boolean bl = true;
                        return bl;
                    }
                    if (c == '-') {
                        this.leadingMinus = true;
                        boolean bl = true;
                        return bl;
                    }
                }
                if (Character.isWhitespace(c)) {
                    if (this.hasDigit) {
                        if (this.trailingWhitespace < 0) {
                            this.trailingWhitespace = this.index;
                        }
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                if (this.trailingWhitespace >= 0) {
                    this.invalid = true;
                    boolean bl = false;
                    return bl;
                }
                if (this.NaN.validate(c)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.Infinity.validate(c)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.digitsStartIndex < 0) {
                    this.digitsStartIndex = this.index;
                }
                if (!this.hasPoint) {
                    if (this.digitsStartIndex == this.index && c == '0') {
                        this.firstIsZero = true;
                        this.oct = true;
                    } else if (this.index == this.digitsStartIndex + 1 && this.firstIsZero) {
                        if (c == 'x') {
                            this.hex = true;
                            this.oct = false;
                            boolean bl = true;
                            return bl;
                        }
                        if (c == 'b') {
                            this.bin = true;
                            this.oct = false;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                if (Character.isDigit(c)) {
                    if (this.oct && (c == '8' || c == '9')) {
                        this.invalid = true;
                        boolean bl = false;
                        return bl;
                    }
                    if (this.bin && c != '0' && c != '1') {
                        this.invalid = true;
                        boolean bl = false;
                        return bl;
                    }
                    this.hasDigit = true;
                    boolean bl = true;
                    return bl;
                }
                if (this.hex) {
                    switch (c) {
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': {
                            this.hasDigit = true;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                if (c == '.') {
                    if (!this.hasPoint) {
                        this.hasPoint = true;
                        if (this.hex || this.bin) {
                            this.invalid = true;
                            boolean bl = false;
                            return bl;
                        }
                        if (this.oct && this.index > this.digitsStartIndex + 1) {
                            this.invalid = true;
                            boolean bl = false;
                            return bl;
                        }
                        this.oct = false;
                        boolean bl = true;
                        return bl;
                    }
                    this.invalid = true;
                    boolean bl = false;
                    return bl;
                }
                if (this.hasPoint && !this.hasPot && (c == 'E' || c == 'e')) {
                    if (this.oct || this.hex || this.bin) {
                        this.invalid = true;
                        boolean bl = false;
                        return bl;
                    }
                    this.hasPot = true;
                    boolean bl = true;
                    return bl;
                }
                if (this.hasPot && (c == '+' || c == '-')) {
                    boolean bl = true;
                    return bl;
                }
                this.invalid = true;
                boolean bl = false;
                return bl;
            }
            finally {
                ++this.index;
            }
        }
    }
}

